/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.Maps;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.Collections;
import java.util.HashMap;

public class RecordTypeBuilder {
    private boolean isEmpty = true;
    private final JSTypeRegistry registry;
    private final HashMap<String, RecordProperty> properties = Maps.newHashMap();

    public RecordTypeBuilder(JSTypeRegistry jSTypeRegistry) {
        this.registry = jSTypeRegistry;
    }

    public RecordTypeBuilder addProperty(String string, JSType jSType, Node node) {
        this.isEmpty = false;
        if (this.properties.containsKey(string)) {
            return null;
        }
        this.properties.put(string, new RecordProperty(jSType, node));
        return this;
    }

    public JSType build() {
        if (this.isEmpty) {
            return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        }
        return this.registry.createRecordType(Collections.unmodifiableMap(this.properties));
    }

    static class RecordProperty {
        private final JSType type;
        private final Node propertyNode;

        RecordProperty(JSType jSType, Node node) {
            this.type = jSType;
            this.propertyNode = node;
        }

        public JSType getType() {
            return this.type;
        }

        public Node getPropertyNode() {
            return this.propertyNode;
        }
    }
}

