/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

class CheckGlobalNames
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CheckLevel level;
    private GlobalNamespace namespace = null;
    static final DiagnosticType UNDEFINED_NAME_WARNING = DiagnosticType.warning("JSC_UNDEFINED_NAME", "{0} is never defined");
    static final DiagnosticType NAME_DEFINED_LATE_WARNING = DiagnosticType.warning("JSC_NAME_DEFINED_LATE", "{0} defined before its owner. {1} is defined at {2}:{3}");
    static final DiagnosticType STRICT_MODULE_DEP_QNAME = DiagnosticType.disabled("JSC_STRICT_MODULE_DEP_QNAME", "module {0} cannot reference {2}, defined in module {1}");

    CheckGlobalNames(AbstractCompiler compiler, CheckLevel level) {
        this.compiler = compiler;
        this.level = level;
    }

    CheckGlobalNames injectNamespace(GlobalNamespace namespace) {
        this.namespace = namespace;
        return this;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.namespace == null) {
            this.namespace = new GlobalNamespace(this.compiler, root);
        }
        for (GlobalNamespace.Name name : this.namespace.getNameForest()) {
            this.checkDescendantNames(name, name.globalSets + name.localSets > 0);
        }
    }

    private void checkDescendantNames(GlobalNamespace.Name name, boolean nameIsDefined) {
        if (name.props != null) {
            for (GlobalNamespace.Name prop : name.props) {
                boolean propIsDefined = false;
                if (nameIsDefined) {
                    propIsDefined = !CheckGlobalNames.propertyMustBeInitializedByFullName(prop) || prop.globalSets + prop.localSets > 0;
                }
                this.validateName(prop, propIsDefined);
                this.checkDescendantNames(prop, propIsDefined);
            }
        }
    }

    private void validateName(GlobalNamespace.Name name, boolean isDefined) {
        GlobalNamespace.Ref declaration = name.getDeclaration();
        GlobalNamespace.Name parent = name.parent;
        boolean singleGlobalParentDecl = parent != null && parent.getDeclaration() != null && parent.localSets == 0;
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        for (GlobalNamespace.Ref ref : name.getRefs()) {
            if (!isDefined && !this.isTypedef(ref)) {
                this.reportRefToUndefinedName(name, ref);
                continue;
            }
            if (declaration != null && ref.getModule() != declaration.getModule() && !moduleGraph.dependsOn(ref.getModule(), declaration.getModule())) {
                this.reportBadModuleReference(name, ref);
                continue;
            }
            if (!ref.scope.isGlobal() || !singleGlobalParentDecl || parent.getDeclaration().preOrderIndex <= ref.preOrderIndex) continue;
            this.compiler.report(JSError.make(ref.source.getName(), ref.node, NAME_DEFINED_LATE_WARNING, name.getFullName(), parent.getFullName(), parent.getDeclaration().source.getName(), String.valueOf(parent.getDeclaration().node.getLineno())));
        }
    }

    private boolean isTypedef(GlobalNamespace.Ref ref) {
        JSDocInfo info;
        Node parent = ref.node.getParent();
        return parent.getType() == 130 && (info = ref.node.getJSDocInfo()) != null && info.hasTypedefType();
    }

    private void reportBadModuleReference(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.source.getName(), ref.node, STRICT_MODULE_DEP_QNAME, ref.getModule().getName(), name.getDeclaration().getModule().getName(), name.getFullName()));
    }

    private void reportRefToUndefinedName(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        while (name.parent != null && name.parent.globalSets + name.parent.localSets == 0) {
            name = name.parent;
        }
        this.compiler.report(JSError.make(ref.getSourceName(), ref.node, this.level, UNDEFINED_NAME_WARNING, name.getFullName()));
    }

    private static boolean propertyMustBeInitializedByFullName(GlobalNamespace.Name name) {
        return name.parent != null && name.parent.aliasingGets == 0 && name.parent.type == GlobalNamespace.Name.Type.OBJECTLIT;
    }
}

