/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

final class CheckSideEffects
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType USELESS_CODE_ERROR = DiagnosticType.warning("JSC_USELESS_CODE", "Suspicious code. {0}");
    private final CheckLevel level;

    CheckSideEffects(CheckLevel level) {
        this.level = level;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        boolean isSimpleOp;
        if (n.getType() == 124 || n.getType() == 85) {
            return;
        }
        if (parent == null) {
            return;
        }
        int pt = parent.getType();
        if (pt == 85) {
            Node gramps = parent.getParent();
            if (gramps.getType() == 37 && parent == gramps.getFirstChild() && n == parent.getFirstChild() && parent.getChildCount() == 2 && n.getNext().getType() == 38 && "eval".equals(n.getNext().getString())) {
                return;
            }
            if (n == parent.getLastChild()) {
                for (Node an : parent.getAncestors()) {
                    int ancestorType = an.getType();
                    if (ancestorType == 85) continue;
                    if (ancestorType != 130 && ancestorType != 125) {
                        return;
                    }
                    break;
                }
            }
        } else if (pt != 130 && pt != 125 && (pt != 115 || parent.getChildCount() != 4 || n != parent.getFirstChild() && n != parent.getFirstChild().getNext().getNext())) {
            return;
        }
        if ((isSimpleOp = NodeUtil.isSimpleOperatorType(n.getType())) || !NodeUtil.mayHaveSideEffects(n, t.getCompiler())) {
            if (n.isQualifiedName() && n.getJSDocInfo() != null) {
                return;
            }
            if (NodeUtil.isExpressionNode(n)) {
                return;
            }
            String msg = "This code lacks side-effects. Is there a bug?";
            if (n.getType() == 40) {
                msg = "Is there a missing '+' on the previous line?";
            } else if (isSimpleOp) {
                msg = "The result of the '" + Node.tokenToName(n.getType()) + "' operator is not being used.";
            }
            t.getCompiler().report(t.makeError(n, this.level, USELESS_CODE_ERROR, msg));
        }
    }
}

