/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.regex.Pattern;

class ExportTestFunctions
implements CompilerPass {
    private static final Pattern TEST_FUNCTIONS_NAME_PATTERN = Pattern.compile("^(?:setUpPage|setUp|tearDown|tearDownPage|test.*)$");
    private AbstractCompiler compiler;
    private final String exportSymbolFunction;

    ExportTestFunctions(AbstractCompiler compiler, String exportSymbolFunction) {
        Preconditions.checkNotNull((Object)compiler);
        this.compiler = compiler;
        this.exportSymbolFunction = exportSymbolFunction;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new ExportTestFunctionsNodes());
    }

    private void exportTestFunction(String testFunctionName, Node node, Node scriptNode) {
        Node exportCallTarget = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.exportSymbolFunction, node, testFunctionName);
        Node call = new Node(37, exportCallTarget);
        if (exportCallTarget.getType() == 38) {
            call.putBooleanProp(50, true);
        }
        call.addChildToBack(Node.newString(testFunctionName));
        call.addChildToBack(NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), testFunctionName, node, testFunctionName));
        Node expression = new Node(130, call);
        scriptNode.addChildAfter(expression, node);
        this.compiler.reportCodeChange();
    }

    private boolean isTestFunction(Node n, String functionName) {
        return functionName != null && TEST_FUNCTIONS_NAME_PATTERN.matcher(functionName).matches();
    }

    private class ExportTestFunctionsNodes
    extends NodeTraversal.AbstractPostOrderCallback {
        private ExportTestFunctionsNodes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (parent != null && parent.getType() == 132) {
                String functionName;
                Node functionNode;
                if (NodeUtil.isFunctionDeclaration(n)) {
                    String functionName2 = NodeUtil.getFunctionName(n);
                    if (ExportTestFunctions.this.isTestFunction(n, functionName2)) {
                        ExportTestFunctions.this.exportTestFunction(functionName2, n, parent);
                    }
                } else if (this.isVarDeclaredFunction(n) && ExportTestFunctions.this.isTestFunction(functionNode = n.getFirstChild().getFirstChild(), functionName = NodeUtil.getFunctionName(functionNode))) {
                    ExportTestFunctions.this.exportTestFunction(functionName, n, parent);
                }
            }
        }

        private boolean isVarDeclaredFunction(Node node) {
            if (node.getType() != 118) {
                return false;
            }
            Node grandchild = node.getFirstChild().getFirstChild();
            return grandchild != null && grandchild.getType() == 105;
        }
    }
}

