/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FindExportableNodes;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;

class GenerateExports
implements CompilerPass {
    private static final String PROTOTYPE_PROPERTY = "prototype";
    private final AbstractCompiler compiler;
    private final String exportSymbolFunction;
    private final String exportPropertyFunction;

    GenerateExports(AbstractCompiler compiler, String exportSymbolFunction, String exportPropertyFunction) {
        Preconditions.checkNotNull((Object)compiler);
        Preconditions.checkNotNull((Object)exportSymbolFunction);
        Preconditions.checkNotNull((Object)exportPropertyFunction);
        this.compiler = compiler;
        this.exportSymbolFunction = exportSymbolFunction;
        this.exportPropertyFunction = exportPropertyFunction;
    }

    @Override
    public void process(Node externs, Node root) {
        FindExportableNodes findExportableNodes = new FindExportableNodes(this.compiler);
        NodeTraversal.traverse(this.compiler, root, findExportableNodes);
        LinkedHashMap<String, FindExportableNodes.GenerateNodeContext> exports = findExportableNodes.getExports();
        for (Map.Entry entry : exports.entrySet()) {
            Node insertionPoint;
            Node call;
            String export = (String)entry.getKey();
            FindExportableNodes.GenerateNodeContext context = (FindExportableNodes.GenerateNodeContext)entry.getValue();
            String parent = null;
            String grandparent = null;
            Node node = context.getNode().getFirstChild();
            if (node.getType() == 33) {
                parent = node.getFirstChild().getQualifiedName();
                if (node.getFirstChild().getType() == 33 && this.getPropertyName(node.getFirstChild()).equals(PROTOTYPE_PROPERTY)) {
                    grandparent = node.getFirstChild().getFirstChild().getQualifiedName();
                }
            }
            boolean useExportSymbol = true;
            if (grandparent != null && exports.containsKey(grandparent)) {
                useExportSymbol = false;
            } else if (parent != null && exports.containsKey(parent)) {
                useExportSymbol = false;
            }
            if (useExportSymbol) {
                call = new Node(37, NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.exportSymbolFunction, context.getNode(), export));
                call.addChildToBack(Node.newString(export));
                call.addChildToBack(NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), export, context.getNode(), export));
            } else {
                String property = this.getPropertyName(node);
                call = new Node(37, new Node[]{NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.exportPropertyFunction, context.getNode(), this.exportPropertyFunction), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), parent, context.getNode(), this.exportPropertyFunction), Node.newString(property), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), export, context.getNode(), this.exportPropertyFunction)});
            }
            Node expression = new Node(130, call);
            this.annotate(expression);
            CodingConvention convention = this.compiler.getCodingConvention();
            for (insertionPoint = context.getContextNode().getNext(); insertionPoint != null && NodeUtil.isExprCall(insertionPoint) && convention.getClassesDefinedByCall(insertionPoint.getFirstChild()) != null; insertionPoint = insertionPoint.getNext()) {
            }
            if (insertionPoint == null) {
                context.getScriptNode().addChildToBack(expression);
            } else {
                context.getScriptNode().addChildBefore(expression, insertionPoint);
            }
            this.compiler.reportCodeChange();
        }
    }

    private void annotate(Node node) {
        NodeTraversal.traverse(this.compiler, node, new PrepareAst.PrepareAnnotations(this.compiler));
    }

    private String getPropertyName(Node node) {
        Preconditions.checkArgument((node.getType() == 33 ? 1 : 0) != 0);
        return node.getLastChild().getString();
    }
}

