/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

class NodeIterators {
    private NodeIterators() {
    }

    static class LocalVarMotion
    implements Iterator<Node> {
        private final boolean valueHasSideEffects;
        private final FunctionlessLocalScope iterator;
        private final String varName;
        private Node lookAhead;

        static LocalVarMotion forVar(Node name, Node var, Node block) {
            Preconditions.checkArgument((var.getType() == 118 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)NodeUtil.isStatement(var));
            return new LocalVarMotion(name, new FunctionlessLocalScope(name, var, block));
        }

        static LocalVarMotion forAssign(Node name, Node assign, Node expr, Node block) {
            Preconditions.checkArgument((assign.getType() == 86 ? 1 : 0) != 0);
            Preconditions.checkArgument((expr.getType() == 130 ? 1 : 0) != 0);
            return new LocalVarMotion(name, new FunctionlessLocalScope(assign, expr, block));
        }

        private LocalVarMotion(Node nameNode, FunctionlessLocalScope iterator) {
            Preconditions.checkArgument((nameNode.getType() == 38 ? 1 : 0) != 0);
            Node valueNode = NodeUtil.getAssignedValue(nameNode);
            this.varName = nameNode.getString();
            this.valueHasSideEffects = valueNode != null && NodeUtil.mayHaveSideEffects(valueNode);
            this.iterator = iterator;
            this.advanceLookAhead(true);
        }

        @Override
        public boolean hasNext() {
            return this.lookAhead != null;
        }

        @Override
        public Node next() {
            Node next = this.lookAhead;
            this.advanceLookAhead(false);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        private void advanceLookAhead(boolean atStart) {
            if (!atStart) {
                if (this.lookAhead == null) {
                    return;
                }
                Node curNode = this.iterator.current();
                if (curNode.getType() == 38 && this.varName.equals(curNode.getString())) {
                    this.lookAhead = null;
                    return;
                }
            }
            if (!this.iterator.hasNext()) {
                this.lookAhead = null;
                return;
            }
            Node nextNode = this.iterator.next();
            Node nextParent = this.iterator.currentParent();
            int type = nextNode.getType();
            if (this.valueHasSideEffects && type == 38 && !this.varName.equals(nextNode.getString())) {
                boolean blocked = false;
                if (nextParent == null) {
                    blocked = true;
                } else {
                    boolean isVarDeclaration;
                    boolean assignsName = nextParent.getType() == 86 && nextNode == nextParent.getFirstChild();
                    boolean bl = isVarDeclaration = nextParent.getType() == 118;
                    if (!assignsName && !isVarDeclaration) {
                        blocked = true;
                    }
                }
                if (blocked) {
                    this.lookAhead = null;
                    return;
                }
            }
            if (NodeUtil.nodeTypeMayHaveSideEffects(nextNode) && type != 38 || type == 38 && nextParent.getType() == 120) {
                this.lookAhead = null;
                return;
            }
            this.lookAhead = nextNode;
        }
    }

    static class FunctionlessLocalScope
    implements Iterator<Node> {
        private final Stack<Node> ancestors = new Stack();

        FunctionlessLocalScope(Node ... ancestors) {
            Preconditions.checkArgument((ancestors.length > 0 ? 1 : 0) != 0);
            for (Node n : ancestors) {
                if (n.getType() == 105) break;
                this.ancestors.add(0, n);
            }
        }

        @Override
        public boolean hasNext() {
            return this.ancestors.size() != 1 || this.ancestors.peek().getNext() != null;
        }

        @Override
        public Node next() {
            Node current = this.ancestors.pop();
            if (current.getNext() == null) {
                current = this.ancestors.peek();
                if (current.getType() == 105) {
                    return this.next();
                }
            } else {
                current = current.getNext();
                this.ancestors.push(current);
                if (current.getType() == 105) {
                    return this.next();
                }
                while (current.hasChildren()) {
                    current = current.getFirstChild();
                    this.ancestors.push(current);
                    if (current.getType() != 105) continue;
                    return this.next();
                }
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        protected Node current() {
            return this.ancestors.peek();
        }

        protected Node currentParent() {
            return this.ancestors.size() >= 2 ? (Node)this.ancestors.get(this.ancestors.size() - 2) : null;
        }

        List<Node> currentAncestors() {
            ArrayList list = Lists.newArrayList(this.ancestors);
            Collections.reverse(list);
            return list;
        }
    }
}

