/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.SimpleReference;
import com.google.javascript.rhino.jstype.SimpleSlot;
import com.google.javascript.rhino.jstype.StaticReference;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.StaticSymbolTable;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public final class SymbolTable
implements StaticSymbolTable<Symbol, Reference> {
    private final Map<Node, Symbol> symbols = Maps.newHashMap();
    private final Map<Node, SymbolScope> scopes = Maps.newHashMap();

    SymbolTable() {
    }

    @Override
    public Iterable<Reference> getReferences(Symbol symbol) {
        return Collections.unmodifiableCollection(symbol.references.values());
    }

    @Override
    public Iterable<Symbol> getAllSymbols() {
        return Collections.unmodifiableCollection(this.symbols.values());
    }

    public SymbolScope getScope(Symbol slot) {
        return slot.scope;
    }

    public SymbolScope getEnclosingScope(Node n) {
        Node current = n.getParent();
        if (n.getType() == 38 && n.getParent().getType() == 105) {
            current = current.getParent();
        }
        while (current != null) {
            if (this.scopes.containsKey(current)) {
                return this.scopes.get(current);
            }
            current = current.getParent();
        }
        return null;
    }

    public Symbol getSymbolForScope(SymbolScope scope) {
        Node rootNode = scope.getRootNode();
        if (rootNode.getType() != 105) {
            return null;
        }
        String name = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(rootNode));
        return name == null ? null : scope.getParentScope().getSlot(name);
    }

    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        for (Symbol symbol : this.getAllSymbols()) {
            this.toDebugString(builder, symbol);
        }
        return builder.toString();
    }

    private void toDebugString(StringBuilder builder, Symbol symbol) {
        SymbolScope scope = symbol.scope;
        if (scope.isGlobalScope()) {
            builder.append(String.format("'%s' : in global scope:\n", symbol.getName()));
        } else {
            builder.append(String.format("'%s' : in scope %s:%d\n", symbol.getName(), scope.getRootNode().getSourceFileName(), scope.getRootNode().getLineno()));
        }
        int refCount = 0;
        for (Reference ref : this.getReferences(symbol)) {
            builder.append(String.format("  Ref %d: %s:%d\n", refCount, ref.getNode().getSourceFileName(), ref.getNode().getLineno()));
            ++refCount;
        }
    }

    <S extends StaticSlot<JSType>, R extends StaticReference<JSType>> void addSymbolsFrom(StaticSymbolTable<S, R> otherSymbolTable) {
        for (StaticSlot otherSymbol : otherSymbolTable.getAllSymbols()) {
            SymbolScope myScope = this.createScopeFrom(otherSymbolTable.getScope(otherSymbol));
            StaticReference decl = otherSymbol.getDeclaration();
            Node declNode = decl == null ? null : decl.getNode();
            Symbol mySymbol = null;
            if (declNode != null && declNode.getStaticSourceFile() != null) {
                mySymbol = this.symbols.get(declNode);
                if (mySymbol == null) {
                    mySymbol = new Symbol(otherSymbol.getName(), (JSType)otherSymbol.getType(), otherSymbol.isTypeInferred(), myScope);
                    this.symbols.put(declNode, mySymbol);
                    myScope.ownSymbols.put(mySymbol.getName(), mySymbol);
                    mySymbol.setDeclaration(new Reference(mySymbol, declNode));
                }
            } else {
                mySymbol = myScope.getOwnSlot(otherSymbol.getName());
            }
            if (mySymbol == null) continue;
            for (StaticReference otherRef : otherSymbolTable.getReferences(otherSymbol)) {
                mySymbol.defineReferenceAt(otherRef.getNode());
            }
        }
    }

    void fillNamespaceReferences() {
        for (Symbol symbol : this.getAllSymbols()) {
            for (Reference ref : this.getReferences(symbol)) {
                Node currentNode = ref.getNode();
                while (currentNode.getType() == 33) {
                    Symbol namespace;
                    String name = (currentNode = currentNode.getFirstChild()).getQualifiedName();
                    if (name == null || (namespace = symbol.scope.getSlot(name)) == null) continue;
                    namespace.defineReferenceAt(currentNode);
                }
            }
        }
    }

    private SymbolScope createScopeFrom(StaticScope<JSType> otherScope) {
        Node otherScopeRoot = otherScope.getRootNode();
        SymbolScope myScope = this.scopes.get(otherScopeRoot);
        if (myScope == null) {
            StaticScope<JSType> otherScopeParent = otherScope.getParentScope();
            if (otherScopeParent == null) {
                Preconditions.checkState((boolean)this.scopes.isEmpty(), (Object)"Global scopes found at different roots");
            }
            myScope = new SymbolScope(otherScopeRoot, otherScopeParent == null ? null : this.createScopeFrom(otherScopeParent), otherScope.getTypeOfThis());
            this.scopes.put(otherScopeRoot, myScope);
        }
        return myScope;
    }

    public static final class SymbolScope
    implements StaticScope<JSType> {
        private final Node rootNode;
        private final SymbolScope parent;
        private final JSType typeOfThis;
        private final Map<String, Symbol> ownSymbols = Maps.newHashMap();

        SymbolScope(Node rootNode, @Nullable SymbolScope parent, JSType typeOfThis) {
            this.rootNode = rootNode;
            this.parent = parent;
            this.typeOfThis = typeOfThis;
        }

        @Override
        public Node getRootNode() {
            return this.rootNode;
        }

        public SymbolScope getParentScope() {
            return this.parent;
        }

        public Symbol getSlot(String name) {
            Symbol own = this.getOwnSlot(name);
            if (own != null) {
                return own;
            }
            return this.parent == null ? null : this.parent.getSlot(name);
        }

        public Symbol getOwnSlot(String name) {
            return this.ownSymbols.get(name);
        }

        @Override
        public JSType getTypeOfThis() {
            return this.typeOfThis;
        }

        public boolean isGlobalScope() {
            return this.getParentScope() == null;
        }
    }

    public static final class Reference
    extends SimpleReference<Symbol> {
        Reference(Symbol symbol, Node node) {
            super(symbol, node);
        }
    }

    public static final class Symbol
    extends SimpleSlot {
        private final Map<Node, Reference> references = Maps.newLinkedHashMap();
        private final SymbolScope scope;
        private Reference declaration = null;

        Symbol(String name, JSType type, boolean inferred, SymbolScope scope) {
            super(name, type, inferred);
            this.scope = scope;
        }

        public Reference getDeclaration() {
            return this.declaration;
        }

        void defineReferenceAt(Node n) {
            if (!this.references.containsKey(n)) {
                this.references.put(n, new Reference(this, n));
            }
        }

        void setDeclaration(Reference ref) {
            Preconditions.checkState((this.declaration == null ? 1 : 0) != 0);
            this.declaration = ref;
            this.references.put(ref.getNode(), ref);
        }

        public boolean inGlobalScope() {
            return this.scope.isGlobalScope();
        }

        public boolean inExterns() {
            Node n = this.getDeclarationNode();
            return n == null ? false : n.isFromExterns();
        }

        public Node getDeclarationNode() {
            return this.declaration == null ? null : this.declaration.getNode();
        }

        public String getSourceFileName() {
            Node n = this.getDeclarationNode();
            return n == null ? null : n.getSourceFileName();
        }

        public String toString() {
            Node n = this.getDeclarationNode();
            int lineNo = n == null ? -1 : n.getLineno();
            return this.getName() + "@" + this.getSourceFileName() + ":" + lineNo;
        }
    }
}

