/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Set;
import java.util.TreeSet;

public abstract class ObjectType
extends JSType
implements StaticScope<JSType> {
    private boolean visited;
    private JSDocInfo docInfo = null;
    private boolean unknown = true;

    ObjectType(JSTypeRegistry registry) {
        super(registry);
    }

    @Override
    public Node getRootNode() {
        return null;
    }

    @Override
    public StaticScope<JSType> getParentScope() {
        return this.getImplicitPrototype();
    }

    @Override
    public abstract StaticSlot<JSType> getSlot(String var1);

    @Override
    public StaticSlot<JSType> getOwnSlot(String name) {
        if (this.hasOwnProperty(name)) {
            return this.getSlot(name);
        }
        return null;
    }

    @Override
    public ObjectType getTypeOfThis() {
        return null;
    }

    public JSType getParameterType() {
        return null;
    }

    public JSType getIndexType() {
        return null;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        if (this.docInfo != null) {
            return this.docInfo;
        }
        if (this.getImplicitPrototype() != null) {
            return this.getImplicitPrototype().getJSDocInfo();
        }
        return super.getJSDocInfo();
    }

    public void setJSDocInfo(JSDocInfo info) {
        this.docInfo = info;
    }

    final boolean detectImplicitPrototypeCycle() {
        ObjectType p;
        this.visited = true;
        for (p = this.getImplicitPrototype(); p != null; p = p.getImplicitPrototype()) {
            if (p.visited) {
                return true;
            }
            p.visited = true;
        }
        p = this;
        do {
            p.visited = false;
        } while ((p = p.getImplicitPrototype()) != null);
        return false;
    }

    public abstract String getReferenceName();

    public String getNormalizedReferenceName() {
        int pos;
        String name = this.getReferenceName();
        if (name != null && (pos = name.indexOf("(")) != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    @Override
    public String getDisplayName() {
        return this.getNormalizedReferenceName();
    }

    public static String createDelegateSuffix(String suffix) {
        return "(" + suffix + ")";
    }

    public boolean hasReferenceName() {
        return false;
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isSubtype(this.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN))) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    public abstract FunctionType getConstructor();

    public abstract ObjectType getImplicitPrototype();

    public final boolean defineDeclaredProperty(String propertyName, JSType type, Node propertyNode) {
        boolean result = this.defineProperty(propertyName, type, false, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    public final boolean defineInferredProperty(String propertyName, JSType type, Node propertyNode) {
        if (this.hasProperty(propertyName)) {
            JSType originalType = this.getPropertyType(propertyName);
            type = originalType == null ? type : originalType.getLeastSupertype(type);
        }
        boolean result = this.defineProperty(propertyName, type, true, propertyNode);
        this.registry.registerPropertyOnType(propertyName, this);
        return result;
    }

    abstract boolean defineProperty(String var1, JSType var2, boolean var3, Node var4);

    public boolean removeProperty(String propertyName) {
        return false;
    }

    public Node getPropertyNode(String propertyName) {
        return null;
    }

    public JSDocInfo getOwnPropertyJSDocInfo(String propertyName) {
        return null;
    }

    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        return this.hasProperty(propertyName) ? this.getPropertyType(propertyName) : null;
    }

    public abstract JSType getPropertyType(String var1);

    public abstract boolean hasProperty(String var1);

    public boolean hasOwnProperty(String propertyName) {
        return this.hasProperty(propertyName);
    }

    public Set<String> getOwnPropertyNames() {
        return ImmutableSet.of();
    }

    public abstract boolean isPropertyTypeInferred(String var1);

    public abstract boolean isPropertyTypeDeclared(String var1);

    boolean hasOwnDeclaredProperty(String name) {
        return this.hasOwnProperty(name) && this.isPropertyTypeDeclared(name);
    }

    public boolean isPropertyInExterns(String propertyName) {
        return false;
    }

    public abstract int getPropertiesCount();

    public Set<String> getPropertyNames() {
        TreeSet props = Sets.newTreeSet();
        this.collectPropertyNames(props);
        return props;
    }

    abstract void collectPropertyNames(Set<String> var1);

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    final boolean isImplicitPrototype(ObjectType prototype) {
        for (ObjectType current = this; current != null; current = current.getImplicitPrototype()) {
            if (!current.isEquivalentTo(prototype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    public boolean isUnknownType() {
        if (this.unknown) {
            ObjectType implicitProto = this.getImplicitPrototype();
            if (implicitProto == null || implicitProto.isNativeObjectType()) {
                this.unknown = false;
                for (ObjectType interfaceType : this.getCtorExtendedInterfaces()) {
                    if (!interfaceType.isUnknownType()) continue;
                    this.unknown = true;
                    break;
                }
            } else {
                this.unknown = implicitProto.isUnknownType();
            }
        }
        return this.unknown;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    public boolean hasCachedValues() {
        return !this.unknown;
    }

    public void clearCachedValues() {
        this.unknown = true;
    }

    public boolean isNativeObjectType() {
        return false;
    }

    public static ObjectType cast(JSType type) {
        return type == null ? null : type.toObjectType();
    }

    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return ImmutableSet.of();
    }

    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return ImmutableSet.of();
    }
}

