/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class ExternExportsPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType EXPORTED_FUNCTION_UNKNOWN_PARAMETER_TYPE = DiagnosticType.warning("JSC_EXPORTED_FUNCTION_UNKNOWN_PARAMETER_TYPE", "Unable to determine type of parameter {0} for exported function {1}");
    static final DiagnosticType EXPORTED_FUNCTION_UNKNOWN_RETURN_TYPE = DiagnosticType.warning("JSC_EXPORTED_FUNCTION_UNKNOWN_RETURN_TYPE", "Unable to determine return type for exported function {0}");
    private final List<Export> exports = Lists.newArrayList();
    private final Map<String, Node> definitionMap;
    private final AbstractCompiler compiler;
    private final Node externsRoot;
    private final Map<String, String> mappedPaths;
    private final Set<String> alreadyExportedPaths;
    private List<String> exportSymbolFunctionNames;
    private List<String> exportPropertyFunctionNames;

    ExternExportsPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.definitionMap = Maps.newHashMap();
        this.externsRoot = new Node(125);
        this.externsRoot.setIsSyntheticBlock(true);
        this.alreadyExportedPaths = Sets.newHashSet();
        this.mappedPaths = Maps.newHashMap();
        this.initExportMethods();
    }

    private void initExportMethods() {
        this.exportSymbolFunctionNames = Lists.newArrayList();
        this.exportPropertyFunctionNames = Lists.newArrayList();
        CodingConvention convention = this.compiler.getCodingConvention();
        this.exportSymbolFunctionNames.add(convention.getExportSymbolFunction());
        this.exportPropertyFunctionNames.add(convention.getExportPropertyFunction());
        this.exportSymbolFunctionNames.add("google_exportSymbol");
        this.exportPropertyFunctionNames.add("google_exportProperty");
    }

    @Override
    public void process(Node externs, Node root) {
        new NodeTraversal(this.compiler, this).traverse(root);
        TreeSet<Export> sorted = new TreeSet<Export>(new Comparator<Export>(){

            @Override
            public int compare(Export e1, Export e2) {
                return e1.getExportedPath().compareTo(e2.getExportedPath());
            }
        });
        sorted.addAll(this.exports);
        for (Export export : sorted) {
            export.generateExterns();
        }
    }

    public String getGeneratedExterns() {
        CodePrinter.Builder builder = new CodePrinter.Builder(this.externsRoot).setPrettyPrint(true).setOutputTypes(true);
        return builder.build();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 33: 
            case 38: {
                String name = n.getQualifiedName();
                if (name == null) {
                    return;
                }
                if (parent.getType() == 86 || parent.getType() == 118) {
                    this.definitionMap.put(n.getQualifiedName(), parent);
                }
                if (parent.getType() != 37) {
                    return;
                }
                if (this.exportPropertyFunctionNames.contains(n.getQualifiedName())) {
                    this.handlePropertyExport(parent);
                }
                if (!this.exportSymbolFunctionNames.contains(n.getQualifiedName())) break;
                this.handleSymbolExport(parent);
            }
        }
    }

    private void handleSymbolExport(Node parent) {
        if (parent.getChildCount() != 3) {
            return;
        }
        Node thisNode = parent.getFirstChild();
        Node nameArg = thisNode.getNext();
        Node valueArg = nameArg.getNext();
        if (nameArg.getType() != 40) {
            return;
        }
        this.exports.add(new SymbolExport(nameArg.getString(), valueArg));
    }

    private void handlePropertyExport(Node parent) {
        if (parent.getChildCount() != 4) {
            return;
        }
        Node thisNode = parent.getFirstChild();
        Node objectArg = thisNode.getNext();
        Node nameArg = objectArg.getNext();
        Node valueArg = nameArg.getNext();
        if (objectArg.getQualifiedName() == null) {
            return;
        }
        if (nameArg.getType() != 40) {
            return;
        }
        this.exports.add(new PropertyExport(objectArg.getQualifiedName(), nameArg.getString(), valueArg));
    }

    private class PropertyExport
    extends Export {
        private final String exportPath;

        public PropertyExport(String exportPath, String symbolName, Node value) {
            super(symbolName, value);
            this.exportPath = exportPath;
        }

        @Override
        String getExportedPath() {
            ArrayList pieces = Lists.newArrayList((Object[])this.exportPath.split("\\."));
            for (int i = pieces.size(); i > 0; --i) {
                String cPath = Joiner.on((String)".").join(Iterables.limit((Iterable)pieces, (int)i));
                if (!ExternExportsPass.this.mappedPaths.containsKey(cPath)) continue;
                String newPath = (String)ExternExportsPass.this.mappedPaths.get(cPath);
                if (i < pieces.size()) {
                    newPath = newPath + "." + Joiner.on((String)".").join(Iterables.skip((Iterable)pieces, (int)i));
                }
                return newPath + "." + this.symbolName;
            }
            return this.exportPath + "." + this.symbolName;
        }
    }

    private class SymbolExport
    extends Export {
        public SymbolExport(String symbolName, Node value) {
            super(symbolName, value);
            String qualifiedName = value.getQualifiedName();
            if (qualifiedName != null) {
                ExternExportsPass.this.mappedPaths.put(qualifiedName, symbolName);
            }
        }

        @Override
        String getExportedPath() {
            return this.symbolName;
        }
    }

    private abstract class Export {
        protected final String symbolName;
        protected final Node value;

        Export(String symbolName, Node value) {
            this.symbolName = symbolName;
            this.value = value;
        }

        void generateExterns() {
            this.appendExtern(this.getExportedPath(), this.getFunctionValue(this.value));
        }

        abstract String getExportedPath();

        protected void appendExtern(String path, Node functionToExport) {
            List<String> pathPrefixes = this.computePathPrefixes(path);
            for (int i = 0; i < pathPrefixes.size(); ++i) {
                boolean skipPathPrefix;
                String pathPrefix = pathPrefixes.get(i);
                boolean isCompletePathPrefix = i == pathPrefixes.size() - 1;
                boolean bl = skipPathPrefix = pathPrefix.endsWith(".prototype") || ExternExportsPass.this.alreadyExportedPaths.contains(pathPrefix) && !isCompletePathPrefix;
                if (skipPathPrefix) continue;
                Node initializer = isCompletePathPrefix && functionToExport != null ? this.createExternFunction(functionToExport) : new Node(64);
                this.appendPathDefinition(pathPrefix, initializer);
            }
        }

        private List<String> computePathPrefixes(String path) {
            ArrayList pieces = Lists.newArrayList((Object[])path.split("\\."));
            ArrayList pathPrefixes = Lists.newArrayList();
            for (int i = 0; i < pieces.size(); ++i) {
                pathPrefixes.add(Joiner.on((String)".").join(Iterables.limit((Iterable)pieces, (int)(i + 1))));
            }
            return pathPrefixes;
        }

        private void appendPathDefinition(String path, Node initializer) {
            Node pathDefinition;
            if (!path.contains(".")) {
                pathDefinition = NodeUtil.newVarNode(path, initializer);
            } else {
                Node qualifiedPath = NodeUtil.newQualifiedNameNode(ExternExportsPass.this.compiler.getCodingConvention(), path, -1, -1);
                pathDefinition = NodeUtil.newExpr(new Node(86, qualifiedPath, initializer));
            }
            ExternExportsPass.this.externsRoot.addChildToBack(pathDefinition);
            ExternExportsPass.this.alreadyExportedPaths.add(path);
        }

        private Node createExternFunction(Node exportedFunction) {
            LinkedList externParameters = Lists.newLinkedList();
            for (Node param : NodeUtil.getFunctionParameters(exportedFunction).children()) {
                externParameters.add(param.cloneNode());
            }
            Node externFunction = NodeUtil.newFunctionNode("", externParameters, new Node(125), -1, -1);
            this.checkForFunctionsWithUnknownTypes(exportedFunction);
            externFunction.setJSType(exportedFunction.getJSType());
            return externFunction;
        }

        private void checkForFunctionsWithUnknownTypes(Node function) {
            Preconditions.checkArgument((boolean)NodeUtil.isFunction(function));
            FunctionType functionType = JSType.toMaybeFunctionType(function.getJSType());
            if (functionType == null) {
                return;
            }
            JSDocInfo functionJSDocInfo = functionType.getJSDocInfo();
            JSType returnType = functionType.getReturnType();
            if (!functionType.isConstructor() && (returnType == null || returnType.isUnknownType())) {
                this.reportUnknownReturnType(function);
            }
            Node astParameterIterator = NodeUtil.getFunctionParameters(function).getFirstChild();
            Node typeParameterIterator = functionType.getParametersNode().getFirstChild();
            while (astParameterIterator != null) {
                JSType parameterType = typeParameterIterator.getJSType();
                if (parameterType == null || parameterType.isUnknownType()) {
                    this.reportUnknownParameterType(function, astParameterIterator);
                }
                astParameterIterator = astParameterIterator.getNext();
                typeParameterIterator = typeParameterIterator.getNext();
            }
        }

        private void reportUnknownParameterType(Node function, Node parameter) {
            ExternExportsPass.this.compiler.report(JSError.make(NodeUtil.getSourceName(function), parameter, CheckLevel.WARNING, EXPORTED_FUNCTION_UNKNOWN_PARAMETER_TYPE, NodeUtil.getFunctionName(function), parameter.getString()));
        }

        private void reportUnknownReturnType(Node function) {
            ExternExportsPass.this.compiler.report(JSError.make(NodeUtil.getSourceName(function), function, CheckLevel.WARNING, EXPORTED_FUNCTION_UNKNOWN_RETURN_TYPE, NodeUtil.getFunctionName(function)));
        }

        protected Node getFunctionValue(Node qualifiedNameNode) {
            Node definition;
            String qualifiedName = this.value.getQualifiedName();
            if (qualifiedName == null) {
                return null;
            }
            Node definitionParent = (Node)ExternExportsPass.this.definitionMap.get(qualifiedName);
            if (definitionParent == null) {
                return null;
            }
            switch (definitionParent.getType()) {
                case 86: {
                    definition = definitionParent.getLastChild();
                    break;
                }
                case 118: {
                    definition = definitionParent.getLastChild().getLastChild();
                    break;
                }
                default: {
                    return null;
                }
            }
            if (definition.getType() != 105) {
                return null;
            }
            return definition;
        }
    }
}

