/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class FunctionArgumentInjector {
    static final String THIS_MARKER = "this";

    private FunctionArgumentInjector() {
    }

    static Node inject(AbstractCompiler compiler, Node node, Node parent, Map<String, Node> replacements) {
        return FunctionArgumentInjector.inject(compiler, node, parent, replacements, true);
    }

    static Node inject(AbstractCompiler compiler, Node node, Node parent, Map<String, Node> replacements, boolean replaceThis) {
        Node replacementTemplate;
        if (node.getType() == 38) {
            replacementTemplate = replacements.get(node.getString());
            if (replacementTemplate != null) {
                Preconditions.checkState((parent.getType() != 105 || parent.getType() != 118 || parent.getType() != 120 ? 1 : 0) != 0);
                Node replacement = replacementTemplate.cloneTree();
                parent.replaceChild(node, replacement);
                return replacement;
            }
        } else if (replaceThis && node.getType() == 42) {
            replacementTemplate = replacements.get(THIS_MARKER);
            Preconditions.checkNotNull((Object)replacementTemplate);
            if (replacementTemplate.getType() != 42) {
                Node replacement = replacementTemplate.cloneTree();
                parent.replaceChild(node, replacement);
                if (NodeUtil.mayHaveSideEffects(replacementTemplate, compiler)) {
                    replacements.remove(THIS_MARKER);
                }
                return replacement;
            }
        } else if (node.getType() == 105) {
            replaceThis = false;
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            c = FunctionArgumentInjector.inject(compiler, c, node, replacements, replaceThis);
        }
        return node;
    }

    static LinkedHashMap<String, Node> getFunctionCallParameterMap(Node fnNode, Node callNode, Supplier<String> safeNameIdSupplier) {
        LinkedHashMap argMap = Maps.newLinkedHashMap();
        Node cArg = callNode.getFirstChild().getNext();
        if (cArg != null && NodeUtil.isFunctionObjectCall(callNode)) {
            argMap.put(THIS_MARKER, cArg);
            cArg = cArg.getNext();
        } else {
            Preconditions.checkState((!NodeUtil.isFunctionObjectApply(callNode) ? 1 : 0) != 0);
            argMap.put(THIS_MARKER, NodeUtil.newUndefinedNode(callNode));
        }
        for (Node fnArg : NodeUtil.getFunctionParameters(fnNode).children()) {
            if (cArg != null) {
                argMap.put(fnArg.getString(), cArg);
                cArg = cArg.getNext();
                continue;
            }
            Node srcLocation = callNode;
            argMap.put(fnArg.getString(), NodeUtil.newUndefinedNode(srcLocation));
        }
        boolean anonArg = false;
        while (cArg != null) {
            String uniquePlaceholder = FunctionArgumentInjector.getUniqueAnonymousParameterName(safeNameIdSupplier);
            argMap.put(uniquePlaceholder, cArg);
            cArg = cArg.getNext();
        }
        return argMap;
    }

    private static String getUniqueAnonymousParameterName(Supplier<String> safeNameIdSupplier) {
        return "JSCompiler_inline_anon_param_" + (String)safeNameIdSupplier.get();
    }

    static Set<String> findModifiedParameters(Node fnNode) {
        Set<String> names = FunctionArgumentInjector.getFunctionParameterSet(fnNode);
        HashSet unsafeNames = Sets.newHashSet();
        return FunctionArgumentInjector.findModifiedParameters(fnNode.getLastChild(), null, names, unsafeNames, false);
    }

    private static Set<String> findModifiedParameters(Node n, Node parent, Set<String> names, Set<String> unsafe, boolean inInnerFunction) {
        Preconditions.checkArgument((unsafe != null ? 1 : 0) != 0);
        if (n.getType() == 38) {
            if (names.contains(n.getString()) && (inInnerFunction || FunctionArgumentInjector.canNameValueChange(n, parent))) {
                unsafe.add(n.getString());
            }
        } else if (n.getType() == 105) {
            inInnerFunction = true;
        }
        for (Node c : n.children()) {
            FunctionArgumentInjector.findModifiedParameters(c, n, names, unsafe, inInnerFunction);
        }
        return unsafe;
    }

    private static boolean canNameValueChange(Node n, Node parent) {
        int type = parent.getType();
        return type == 118 || type == 102 || type == 103 || NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n;
    }

    static void maybeAddTempsForCallArguments(Node fnNode, Map<String, Node> argMap, Set<String> namesNeedingTemps, CodingConvention convention) {
        if (argMap.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((fnNode.getType() == 105 ? 1 : 0) != 0);
        Node block = fnNode.getLastChild();
        Set<String> parameters = argMap.keySet();
        Set<String> namesAfterSideEffects = FunctionArgumentInjector.findParametersReferencedAfterSideEffect(parameters, block);
        for (Map.Entry<String, Node> entry : argMap.entrySet()) {
            String argName = entry.getKey();
            if (namesNeedingTemps.contains(argName)) continue;
            Node cArg = entry.getValue();
            boolean safe = true;
            int references = NodeUtil.getNameReferenceCount(block, argName);
            if (NodeUtil.mayEffectMutableState(cArg) && references > 0) {
                safe = false;
            } else if (NodeUtil.mayHaveSideEffects(cArg)) {
                safe = false;
            } else if (NodeUtil.canBeSideEffected(cArg) && namesAfterSideEffects.contains(argName)) {
                safe = false;
            } else if (references > 1) {
                switch (cArg.getType()) {
                    case 38: {
                        String name = cArg.getString();
                        safe = !convention.isExported(name);
                        break;
                    }
                    case 42: {
                        safe = true;
                        break;
                    }
                    case 40: {
                        safe = cArg.getString().length() < 2;
                        break;
                    }
                    default: {
                        safe = NodeUtil.isImmutableValue(cArg);
                    }
                }
            }
            if (safe) continue;
            namesNeedingTemps.add(argName);
        }
    }

    private static Set<String> findParametersReferencedAfterSideEffect(Set<String> parameters, Node root) {
        HashSet locals = Sets.newHashSet(parameters);
        FunctionArgumentInjector.gatherLocalNames(root, locals);
        ReferencedAfterSideEffect collector = new ReferencedAfterSideEffect(parameters, locals);
        NodeUtil.visitPostOrder(root, collector, collector);
        return collector.getResults();
    }

    private static void gatherLocalNames(Node n, Set<String> names) {
        if (n.getType() == 105) {
            if (NodeUtil.isFunctionDeclaration(n)) {
                names.add(n.getFirstChild().getString());
            }
            return;
        }
        if (n.getType() == 38) {
            switch (n.getParent().getType()) {
                case 118: 
                case 120: {
                    names.add(n.getString());
                }
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            FunctionArgumentInjector.gatherLocalNames(c, names);
        }
    }

    private static Set<String> getFunctionParameterSet(Node fnNode) {
        HashSet set = Sets.newHashSet();
        for (Node n : NodeUtil.getFunctionParameters(fnNode).children()) {
            set.add(n.getString());
        }
        return set;
    }

    private static class ReferencedAfterSideEffect
    implements NodeUtil.Visitor,
    Predicate<Node> {
        private final Set<String> parameters;
        private final Set<String> locals;
        private boolean sideEffectSeen = false;
        private Set<String> parametersReferenced = Sets.newHashSet();
        private int loopsEntered = 0;

        ReferencedAfterSideEffect(Set<String> parameters, Set<String> locals) {
            this.parameters = parameters;
            this.locals = locals;
        }

        Set<String> getResults() {
            return this.parametersReferenced;
        }

        public boolean apply(Node node) {
            if (NodeUtil.isLoopStructure(node)) {
                ++this.loopsEntered;
            }
            return !this.sideEffectSeen || this.parameters.size() != this.parametersReferenced.size();
        }

        boolean inLoop() {
            return this.loopsEntered != 0;
        }

        @Override
        public void visit(Node n) {
            if (NodeUtil.isLoopStructure(n)) {
                --this.loopsEntered;
                if (!this.inLoop() && !this.sideEffectSeen) {
                    this.parametersReferenced.clear();
                }
            }
            if (!this.sideEffectSeen && this.hasNonLocalSideEffect(n)) {
                this.sideEffectSeen = true;
            }
            if (this.inLoop() || this.sideEffectSeen) {
                if (n.getType() == 38) {
                    String name = n.getString();
                    if (this.parameters.contains(name)) {
                        this.parametersReferenced.add(name);
                    }
                } else if (n.getType() == 42) {
                    this.parametersReferenced.add(FunctionArgumentInjector.THIS_MARKER);
                }
            }
        }

        private boolean hasNonLocalSideEffect(Node n) {
            boolean sideEffect = false;
            int type = n.getType();
            if (NodeUtil.isAssignmentOp(n) || type == 102 || type == 103) {
                Node lhs = n.getFirstChild();
                if (!this.isLocalName(lhs)) {
                    sideEffect = true;
                }
            } else if (type == 37) {
                sideEffect = NodeUtil.functionCallHasSideEffects(n);
            } else if (type == 30) {
                sideEffect = NodeUtil.constructorCallHasSideEffects(n);
            } else if (type == 31) {
                sideEffect = true;
            }
            return sideEffect;
        }

        private boolean isLocalName(Node node) {
            if (NodeUtil.isName(node)) {
                String name = node.getString();
                return this.locals.contains(name);
            }
            return false;
        }
    }
}

