/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.FunctionArgumentInjector;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RenameLabels;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class FunctionToBlockMutator {
    private AbstractCompiler compiler;
    private Supplier<String> safeNameIdSupplier;

    FunctionToBlockMutator(AbstractCompiler compiler, Supplier<String> safeNameIdSupplier) {
        this.compiler = compiler;
        this.safeNameIdSupplier = safeNameIdSupplier;
    }

    Node mutate(String fnName, Node fnNode, Node callNode, String resultName, boolean needsDefaultResult, boolean isCallInLoop) {
        String labelName;
        Node injectableBlock;
        boolean hasArgs;
        Node newFnNode = fnNode.cloneTree();
        this.makeLocalNamesUnique(newFnNode, isCallInLoop);
        this.rewriteFunctionDeclarations(newFnNode.getLastChild());
        Set<String> namesToAlias = FunctionArgumentInjector.findModifiedParameters(newFnNode);
        LinkedHashMap<String, Node> args = FunctionArgumentInjector.getFunctionCallParameterMap(newFnNode, callNode, this.safeNameIdSupplier);
        boolean bl = hasArgs = !args.isEmpty();
        if (hasArgs) {
            FunctionArgumentInjector.maybeAddTempsForCallArguments(newFnNode, args, namesToAlias, this.compiler.getCodingConvention());
        }
        Node newBlock = NodeUtil.getFunctionBody(newFnNode);
        newBlock.detachFromParent();
        if (hasArgs) {
            Node inlineResult = this.aliasAndInlineArguments(newBlock, args, namesToAlias);
            Preconditions.checkState((newBlock == inlineResult ? 1 : 0) != 0);
        }
        if (isCallInLoop) {
            this.fixUnitializedVarDeclarations(newBlock);
        }
        Preconditions.checkState(((injectableBlock = FunctionToBlockMutator.replaceReturns(newBlock, resultName, labelName = this.getLabelNameForFunction(fnName), needsDefaultResult)) != null ? 1 : 0) != 0);
        return injectableBlock;
    }

    private void rewriteFunctionDeclarations(Node n) {
        if (n.getType() == 105) {
            if (NodeUtil.isFunctionDeclaration(n)) {
                Node fnNameNode = n.getFirstChild();
                Node var = new Node(118).copyInformationFrom(n);
                Node name = Node.newString(38, fnNameNode.getString()).copyInformationFrom(fnNameNode);
                fnNameNode.setString("");
                n.getParent().replaceChild(n, var);
                var.addChildToFront(name);
                name.addChildToFront(n);
            }
            return;
        }
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            this.rewriteFunctionDeclarations(c);
            c = next;
        }
    }

    private void fixUnitializedVarDeclarations(Node n) {
        if (NodeUtil.isLoopStructure(n)) {
            return;
        }
        if (NodeUtil.isVar(n)) {
            Node name = n.getFirstChild();
            if (!name.hasChildren()) {
                Node srcLocation = name;
                name.addChildToBack(NodeUtil.newUndefinedNode(srcLocation));
            }
            return;
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.fixUnitializedVarDeclarations(c);
        }
    }

    private void makeLocalNamesUnique(Node fnNode, boolean isCallInLoop) {
        Supplier<String> idSupplier = this.compiler.getUniqueNameIdSupplier();
        NodeTraversal.traverse(this.compiler, fnNode, new MakeDeclaredNamesUnique(new MakeDeclaredNamesUnique.InlineRenamer(idSupplier, "inline_", isCallInLoop)));
        new RenameLabels(this.compiler, new LabelNameSupplier(idSupplier), false).process(null, fnNode);
    }

    private String getLabelNameForFunction(String fnName) {
        String name = fnName == null || fnName.isEmpty() ? "anon" : fnName;
        return "JSCompiler_inline_label_" + name + "_" + (String)this.safeNameIdSupplier.get();
    }

    private String getUniqueThisName() {
        return "JSCompiler_inline_this_" + (String)this.safeNameIdSupplier.get();
    }

    private Node aliasAndInlineArguments(Node fnTemplateRoot, LinkedHashMap<String, Node> argMap, Set<String> namesToAlias) {
        if (namesToAlias == null || namesToAlias.isEmpty()) {
            Node result = FunctionArgumentInjector.inject(this.compiler, fnTemplateRoot, null, argMap);
            Preconditions.checkState((result == fnTemplateRoot ? 1 : 0) != 0);
            return result;
        }
        HashMap newArgMap = Maps.newHashMap(argMap);
        LinkedList newVars = Lists.newLinkedList();
        for (Map.Entry<String, Node> entry : argMap.entrySet()) {
            String name = entry.getKey();
            if (!namesToAlias.contains(name)) continue;
            if (name.equals("this")) {
                boolean referencesThis = NodeUtil.referencesThis(fnTemplateRoot);
                Node value = entry.getValue();
                if (value.getType() == 42 || !referencesThis && !NodeUtil.mayHaveSideEffects(value, this.compiler)) continue;
                String newName = this.getUniqueThisName();
                Node newValue = entry.getValue().cloneTree();
                Node newNode = NodeUtil.newVarNode(newName, newValue).copyInformationFromForTree(newValue);
                newVars.add(0, newNode);
                newArgMap.put("this", Node.newString(38, newName).copyInformationFromForTree(newValue));
                continue;
            }
            Node newValue = entry.getValue().cloneTree();
            Node newNode = NodeUtil.newVarNode(name, newValue).copyInformationFromForTree(newValue);
            newVars.add(0, newNode);
            newArgMap.remove(name);
        }
        Node result = FunctionArgumentInjector.inject(this.compiler, fnTemplateRoot, null, newArgMap);
        Preconditions.checkState((result == fnTemplateRoot ? 1 : 0) != 0);
        for (Node n : newVars) {
            fnTemplateRoot.addChildToFront(n);
        }
        return result;
    }

    private static Node replaceReturns(Node block, String resultName, String labelName, boolean resultMustBeSet) {
        Preconditions.checkNotNull((Object)block);
        Preconditions.checkNotNull((Object)labelName);
        Node root = block;
        boolean hasReturnAtExit = false;
        int returnCount = NodeUtil.getNodeTypeReferenceCount(block, 4, new NodeUtil.MatchShallowStatement());
        if (returnCount > 0) {
            hasReturnAtExit = FunctionToBlockMutator.hasReturnAtExit(block);
            if (hasReturnAtExit) {
                FunctionToBlockMutator.convertLastReturnToStatement(block, resultName);
                --returnCount;
            }
            if (returnCount > 0) {
                FunctionToBlockMutator.replaceReturnWithBreak(block, null, resultName, labelName);
                Node label = new Node(126).copyInformationFrom(block);
                Node name = Node.newString(153, labelName).copyInformationFrom(block);
                label.addChildToFront(name);
                label.addChildToBack(block);
                Node newRoot = new Node(125).copyInformationFrom(block);
                newRoot.addChildrenToBack(label);
                root = newRoot;
            }
        }
        if (resultMustBeSet && !hasReturnAtExit && resultName != null) {
            FunctionToBlockMutator.addDummyAssignment(block, resultName);
        }
        return root;
    }

    private static void addDummyAssignment(Node node, String resultName) {
        Preconditions.checkArgument((node.getType() == 125 ? 1 : 0) != 0);
        Node srcLocation = node;
        Node retVal = NodeUtil.newUndefinedNode(srcLocation);
        Node resultNode = FunctionToBlockMutator.createAssignStatementNode(resultName, retVal);
        resultNode.copyInformationFromForTree(node);
        node.addChildrenToBack(resultNode);
    }

    private static void convertLastReturnToStatement(Node block, String resultName) {
        Node ret = block.getLastChild();
        Preconditions.checkArgument((ret.getType() == 4 ? 1 : 0) != 0);
        Node resultNode = FunctionToBlockMutator.getReplacementReturnStatement(ret, resultName);
        if (resultNode == null) {
            block.removeChild(ret);
        } else {
            resultNode.copyInformationFromForTree(ret);
            block.replaceChild(ret, resultNode);
        }
    }

    private static Node createAssignStatementNode(String name, Node expression) {
        Node nameNode = Node.newString(38, name);
        Node assign = new Node(86, nameNode, expression);
        return NodeUtil.newExpr(assign);
    }

    private static Node getReplacementReturnStatement(Node node, String resultName) {
        Node resultNode = null;
        Node retVal = null;
        if (node.hasChildren()) {
            retVal = node.getFirstChild().cloneTree();
        }
        if (resultName == null) {
            if (retVal != null) {
                resultNode = NodeUtil.newExpr(retVal);
            }
        } else {
            if (retVal == null) {
                Node srcLocation = node;
                retVal = NodeUtil.newUndefinedNode(srcLocation);
            }
            resultNode = FunctionToBlockMutator.createAssignStatementNode(resultName, retVal);
        }
        return resultNode;
    }

    private static boolean hasReturnAtExit(Node block) {
        return block.getLastChild().getType() == 4;
    }

    private static Node replaceReturnWithBreak(Node current, Node parent, String resultName, String labelName) {
        if (current.getType() == 105 || current.getType() == 130) {
            return current;
        }
        if (current.getType() == 4) {
            Preconditions.checkState((boolean)NodeUtil.isStatementBlock(parent));
            Node resultNode = FunctionToBlockMutator.getReplacementReturnStatement(current, resultName);
            Node name = Node.newString(153, labelName);
            Node breakNode = new Node(116, name);
            breakNode.copyInformationFromForTree(current);
            parent.replaceChild(current, breakNode);
            if (resultNode != null) {
                resultNode.copyInformationFromForTree(current);
                parent.addChildBefore(resultNode, breakNode);
            }
            current = breakNode;
        } else {
            for (Node c = current.getFirstChild(); c != null; c = c.getNext()) {
                c = FunctionToBlockMutator.replaceReturnWithBreak(c, current, resultName, labelName);
            }
        }
        return current;
    }

    static class LabelNameSupplier
    implements Supplier<String> {
        final Supplier<String> idSupplier;

        LabelNameSupplier(Supplier<String> idSupplier) {
            this.idSupplier = idSupplier;
        }

        public String get() {
            return "JSCompiler_inline_label_" + (String)this.idSupplier.get();
        }
    }
}

