/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.VariableNameGenerator;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Deque;

class OperaCompoundAssignFix
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private AbstractCompiler compiler;
    private final Deque<VariableNameGenerator> names;

    @Override
    public void enterScope(NodeTraversal t) {
        this.names.push(new VariableNameGenerator(t.getScope()));
    }

    @Override
    public void exitScope(NodeTraversal t) {
        this.names.pop();
    }

    OperaCompoundAssignFix(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.names = Lists.newLinkedList();
    }

    @Override
    public void process(Node externs, Node root) {
        ArrayList code = Lists.newArrayList((Object[])new Node[]{externs, root});
        NodeTraversal.traverseRoots(this.compiler, code, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!NodeUtil.isName(n)) {
            return;
        }
        if (!NodeUtil.isGet(parent)) {
            return;
        }
        boolean nested = false;
        boolean reassign = false;
        Node lastAssign = null;
        Node prevParent = n;
        while (!NodeUtil.isExpressionNode(parent) && !NodeUtil.isStatementBlock(parent)) {
            if (NodeUtil.isAssign(parent) && NodeUtil.isName(parent.getFirstChild()) && parent.getFirstChild().getString().equals(n.getString()) && nested) {
                reassign = true;
                break;
            }
            if (NodeUtil.isAssignmentOp(parent) && parent.getLastChild() == prevParent) {
                if (lastAssign == null) {
                    nested = true;
                }
                lastAssign = parent;
            }
            prevParent = parent;
            parent = parent.getParent();
        }
        if (!reassign || !nested) {
            return;
        }
        this.applyWorkAround(parent, t);
    }

    private void applyWorkAround(Node assign, NodeTraversal t) {
        Preconditions.checkArgument((boolean)NodeUtil.isAssign(assign));
        Node parent = assign.getParent();
        Node comma = new Node(85);
        comma.copyInformationFrom(assign);
        parent.replaceChild(assign, comma);
        String newName = this.names.peek().getNextNewName();
        Node newAssign = new Node(86, Node.newString(38, newName));
        newAssign.copyInformationFromForTree(assign);
        newAssign.addChildToBack(assign.getLastChild().detachFromParent());
        comma.addChildrenToBack(newAssign);
        assign.addChildrenToBack(Node.newString(38, newName).copyInformationFrom(assign));
        comma.addChildrenToBack(assign);
        Node root = t.getScopeRoot();
        Node var = new Node(118, Node.newString(38, newName));
        var.copyInformationFromForTree(assign);
        if (NodeUtil.isStatementBlock(root)) {
            root = this.compiler.getNodeForCodeInsertion(t.getModule());
            root.addChildrenToFront(var);
        } else {
            root.getLastChild().addChildrenToFront(var);
        }
        this.compiler.reportCodeChange();
    }
}

