/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.SimpleReference;
import com.google.javascript.rhino.jstype.SimpleSlot;
import com.google.javascript.rhino.jstype.StaticReference;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.StaticSymbolTable;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class SymbolTable
implements StaticSymbolTable<Symbol, Reference> {
    public static final String GLOBAL_THIS = "*global*";
    private final Table<Node, String, Symbol> symbols = HashBasedTable.create();
    private final Map<Node, SymbolScope> scopes = Maps.newHashMap();
    private final List<JSDocInfo> docInfos = Lists.newArrayList();
    private SymbolScope globalScope = null;
    private final JSTypeRegistry registry;

    SymbolTable(JSTypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Iterable<Reference> getReferences(Symbol symbol) {
        return Collections.unmodifiableCollection(symbol.references.values());
    }

    @Override
    public Iterable<Symbol> getAllSymbols() {
        return Collections.unmodifiableCollection(this.symbols.values());
    }

    public SymbolScope getScope(Symbol slot) {
        return slot.scope;
    }

    public Collection<JSDocInfo> getAllJSDocInfo() {
        return Collections.unmodifiableList(this.docInfos);
    }

    public SymbolScope getEnclosingScope(Node n) {
        Node current = n.getParent();
        if (n.getType() == 38 && n.getParent().getType() == 105) {
            current = current.getParent();
        }
        while (current != null) {
            if (this.scopes.containsKey(current)) {
                return this.scopes.get(current);
            }
            current = current.getParent();
        }
        return null;
    }

    public Symbol getParameterInFunction(Symbol sym, String paramName) {
        Symbol param;
        SymbolScope scope = this.getScopeInFunction(sym);
        if (scope != null && (param = scope.getSlot(paramName)) != null && param.scope == scope) {
            return param;
        }
        return null;
    }

    private SymbolScope getScopeInFunction(Symbol sym) {
        FunctionType type = sym.getFunctionType();
        if (type == null) {
            return null;
        }
        Node functionNode = type.getSource();
        if (functionNode == null) {
            return null;
        }
        return this.scopes.get(functionNode);
    }

    public Symbol getSymbolForScope(SymbolScope scope) {
        if (scope.isPropertyScope()) {
            JSType type = scope.getTypeOfThis();
            if (type != null) {
                if (type.isGlobalThisType()) {
                    return this.globalScope.getSlot(GLOBAL_THIS);
                }
                if (type.isNominalConstructor()) {
                    return this.getSymbolDeclaredBy(type.toMaybeFunctionType());
                }
                if (type.isFunctionPrototypeType()) {
                    return this.getSymbolForInstancesOf(((ObjectType)type).getOwnerFunction());
                }
            }
            return null;
        }
        Node rootNode = scope.getRootNode();
        if (rootNode.getType() != 105) {
            return null;
        }
        String name = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(rootNode));
        return name == null ? null : scope.getParentScope().getSlot(name);
    }

    public Iterable<Symbol> getAllSymbolsForTypeOf(Symbol sym) {
        return this.getAllSymbolsForType(sym.getType());
    }

    public SymbolScope getGlobalScope() {
        return this.globalScope;
    }

    public Symbol getSymbolDeclaredBy(FunctionType fn) {
        Preconditions.checkState((fn.isConstructor() || fn.isInterface() ? 1 : 0) != 0);
        ObjectType instanceType = fn.getInstanceType();
        String name = instanceType.getReferenceName();
        if (name == null || this.globalScope == null) {
            return null;
        }
        Node source = fn.getSource();
        return (source == null ? this.globalScope : this.getEnclosingScope(source)).getSlot(name);
    }

    public Symbol getSymbolForInstancesOf(Symbol sym) {
        FunctionType fn = sym.getFunctionType();
        if (fn != null && fn.isNominalConstructor()) {
            return this.getSymbolForInstancesOf(fn);
        }
        return null;
    }

    public Symbol getSymbolForInstancesOf(FunctionType fn) {
        Preconditions.checkState((fn.isConstructor() || fn.isInterface() ? 1 : 0) != 0);
        ObjectType pType = fn.getPrototype();
        String name = pType.getReferenceName();
        if (name == null || this.globalScope == null) {
            return null;
        }
        Node source = fn.getSource();
        return (source == null ? this.globalScope : this.getEnclosingScope(source)).getSlot(name);
    }

    public List<Symbol> getAllSymbolsForType(JSType type) {
        if (type == null) {
            return ImmutableList.of();
        }
        UnionType unionType = type.toMaybeUnionType();
        if (unionType != null) {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)2);
            for (JSType alt : unionType.getAlternates()) {
                Symbol altSym = this.getOnlySymbolForType(alt);
                if (altSym == null) continue;
                result.add(altSym);
            }
            return result;
        }
        Symbol result = this.getOnlySymbolForType(type);
        return result == null ? ImmutableList.of() : ImmutableList.of((Object)result);
    }

    private Symbol getOnlySymbolForType(JSType type) {
        if (type == null) {
            return null;
        }
        FunctionType fnType = type.toMaybeFunctionType();
        if (fnType != null) {
            return this.globalScope.getSlot("Function");
        }
        ObjectType objType = type.toObjectType();
        if (objType != null) {
            String name = objType.getReferenceName();
            FunctionType ctor = objType.getConstructor();
            Node sourceNode = ctor == null ? null : ctor.getSource();
            SymbolScope scope = sourceNode == null ? this.globalScope : this.getEnclosingScope(sourceNode);
            return scope.getSlot(name == null || !objType.isInstanceType() ? "Object" : name);
        }
        return null;
    }

    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        for (Symbol symbol : this.getAllSymbols()) {
            this.toDebugString(builder, symbol);
        }
        return builder.toString();
    }

    private void toDebugString(StringBuilder builder, Symbol symbol) {
        SymbolScope scope = symbol.scope;
        if (scope.isGlobalScope()) {
            builder.append(String.format("'%s' : in global scope:\n", symbol.getName()));
        } else {
            builder.append(String.format("'%s' : in scope %s:%d\n", symbol.getName(), scope.getRootNode().getSourceFileName(), scope.getRootNode().getLineno()));
        }
        int refCount = 0;
        for (Reference ref : this.getReferences(symbol)) {
            builder.append(String.format("  Ref %d: %s:%d\n", refCount, ref.getNode().getSourceFileName(), ref.getNode().getLineno()));
            ++refCount;
        }
    }

    <S extends StaticScope<JSType>> void addScopes(Collection<S> scopes) {
        for (StaticScope scope : scopes) {
            this.createScopeFrom(scope);
        }
    }

    <S extends StaticSlot<JSType>, R extends StaticReference<JSType>> void addSymbolsFrom(StaticSymbolTable<S, R> otherSymbolTable) {
        for (StaticSlot otherSymbol : otherSymbolTable.getAllSymbols()) {
            String name = otherSymbol.getName();
            SymbolScope myScope = this.createScopeFrom(otherSymbolTable.getScope(otherSymbol));
            StaticReference decl = otherSymbol.getDeclaration();
            Node declNode = decl == null ? null : decl.getNode();
            Symbol mySymbol = null;
            if (declNode != null && declNode.getStaticSourceFile() != null) {
                mySymbol = (Symbol)this.symbols.get((Object)declNode, (Object)name);
                if (mySymbol == null) {
                    mySymbol = this.copySymbolTo(otherSymbol, myScope);
                }
            } else {
                mySymbol = myScope.getOwnSlot(name);
            }
            if (mySymbol == null) continue;
            for (StaticReference otherRef : otherSymbolTable.getReferences(otherSymbol)) {
                mySymbol.defineReferenceAt(otherRef.getNode());
            }
        }
    }

    private Symbol copySymbolTo(StaticSlot<JSType> sym, SymbolScope scope) {
        return this.declareSymbol(sym.getName(), sym.getType(), sym.isTypeInferred(), scope, (Node)Preconditions.checkNotNull((Object)sym.getDeclaration().getNode()), sym.getJSDocInfo());
    }

    private Symbol declareSymbol(String name, JSType type, boolean inferred, SymbolScope scope, Node declNode, JSDocInfo info) {
        Symbol symbol = new Symbol(name, type, inferred, scope);
        symbol.setJSDocInfo(info);
        this.symbols.put((Object)declNode, (Object)name, (Object)symbol);
        Symbol replacedSymbol = scope.ownSymbols.put(name, symbol);
        Preconditions.checkState((replacedSymbol == null ? 1 : 0) != 0);
        symbol.setDeclaration(new Reference(symbol, declNode));
        return symbol;
    }

    private void removeSymbol(Symbol s) {
        SymbolScope scope = this.getScope(s);
        if (scope.ownSymbols.remove(s.getName()) != s) {
            throw new IllegalStateException("Symbol not found in scope " + s);
        }
        if (this.symbols.remove((Object)s.getDeclaration().getNode(), (Object)s.getName()) != s) {
            throw new IllegalStateException("Symbol not found in table " + s);
        }
    }

    void fillNamespaceReferences() {
        for (Symbol symbol : this.getAllSymbols()) {
            for (Reference ref : this.getReferences(symbol)) {
                Node currentNode = ref.getNode();
                while (currentNode.getType() == 33) {
                    Symbol namespace;
                    String name = (currentNode = currentNode.getFirstChild()).getQualifiedName();
                    if (name == null || (namespace = symbol.scope.getSlot(name)) == null) continue;
                    namespace.defineReferenceAt(currentNode);
                }
            }
        }
    }

    void fillPropertySymbols(AbstractCompiler compiler, Node externs, Node root) {
        ArrayList types = Lists.newArrayList();
        ArrayList instances = Lists.newArrayList();
        for (Symbol sym : this.getAllSymbols()) {
            FunctionType t = sym.getFunctionType();
            if (t == null || !t.isNominalConstructor()) continue;
            types.add(sym);
            Symbol instance = this.getSymbolForInstancesOf(t);
            if (instance == null) continue;
            instances.add(instance);
        }
        for (Symbol s : instances) {
            this.createPropertyScopeFor(s);
        }
        for (Symbol s : types) {
            this.createPropertyScopeFor(s);
        }
        new PropertyRefCollector(compiler).process(externs, root);
    }

    void fillJSDocInfo(AbstractCompiler compiler, Node externs, Node root) {
        NodeTraversal.traverseRoots(compiler, Lists.newArrayList((Object[])new Node[]{externs, root}), new JSDocInfoCollector(compiler.getTypeRegistry()));
        for (Symbol sym : this.getAllSymbols()) {
            JSDocInfo info = sym.getJSDocInfo();
            if (info == null) continue;
            for (JSDocInfo.Marker marker : info.getMarkers()) {
                Node paramNode;
                Symbol param;
                SourcePosition<Node> pos = marker.getNameNode();
                if (pos == null || (param = this.getParameterInFunction(sym, (paramNode = pos.getItem()).getString())) == null) continue;
                param.defineReferenceAt(paramNode);
            }
        }
    }

    private void createPropertyScopeFor(Symbol s) {
        Symbol parentSymbol;
        if (s.propertyScope != null) {
            return;
        }
        SymbolScope parentPropertyScope = null;
        ObjectType type = s.getType().toObjectType();
        ObjectType proto = type.getParentScope();
        if (proto != null && proto != type && proto.getConstructor() != null && (parentSymbol = this.getSymbolForInstancesOf(proto.getConstructor())) != null) {
            this.createPropertyScopeFor(parentSymbol);
            parentPropertyScope = parentSymbol.getPropertyScope();
        }
        ObjectType instanceType = type;
        HashSet propNames = type.getOwnPropertyNames();
        if (instanceType.isFunctionPrototypeType()) {
            instanceType = instanceType.getOwnerFunction().getInstanceType();
            HashSet set = Sets.newHashSet(propNames);
            Iterables.addAll((Collection)set, instanceType.getOwnPropertyNames());
            propNames = set;
        }
        s.propertyScope = new SymbolScope(null, parentPropertyScope, type);
        for (String propName : propNames) {
            StaticSlot<JSType> newProp = instanceType.getSlot(propName);
            if (newProp.getDeclaration() == null) continue;
            Symbol oldProp = this.getScope(s).getSlot(s.getName() + "." + propName);
            if (oldProp != null) {
                this.removeSymbol(oldProp);
            }
            Symbol newSym = this.copySymbolTo(newProp, s.propertyScope);
            if (oldProp == null) continue;
            if (newSym.getJSDocInfo() == null) {
                newSym.setJSDocInfo(oldProp.getJSDocInfo());
            }
            newSym.propertyScope = oldProp.propertyScope;
            for (Reference ref : oldProp.references.values()) {
                newSym.defineReferenceAt(ref.getNode());
            }
        }
    }

    void fillThisReferences(AbstractCompiler compiler, Node externs, Node root) {
        new ThisRefCollector(compiler).process(externs, root);
    }

    private SymbolScope createScopeFrom(StaticScope<JSType> otherScope) {
        Node otherScopeRoot = otherScope.getRootNode();
        SymbolScope myScope = this.scopes.get(otherScopeRoot);
        if (myScope == null) {
            StaticScope<JSType> otherScopeParent = otherScope.getParentScope();
            if (otherScopeParent == null) {
                Preconditions.checkState((this.globalScope == null ? 1 : 0) != 0, (Object)"Global scopes found at different roots");
            }
            myScope = new SymbolScope(otherScopeRoot, otherScopeParent == null ? null : this.createScopeFrom(otherScopeParent), otherScope.getTypeOfThis());
            this.scopes.put(otherScopeRoot, myScope);
            if (myScope.isGlobalScope()) {
                this.globalScope = myScope;
            }
        }
        return myScope;
    }

    private class JSDocInfoCollector
    extends NodeTraversal.AbstractPostOrderCallback {
        private final JSTypeRegistry registry;

        private JSDocInfoCollector(JSTypeRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getJSDocInfo() != null) {
                JSDocInfo info = n.getJSDocInfo();
                SymbolTable.this.docInfos.add(info);
                for (Node typeAst : info.getTypeNodes()) {
                    SymbolScope scope = (SymbolScope)SymbolTable.this.scopes.get(t.getScopeRoot());
                    this.visitTypeNode(scope == null ? SymbolTable.this.globalScope : scope, typeAst);
                }
            }
        }

        public void visitTypeNode(SymbolScope scope, Node n) {
            if (n.getType() == 40) {
                Symbol symbol = scope.getSlot(n.getString());
                if (symbol == null) {
                    JSType type = this.registry.getType(n.getString());
                    JSType autobox = type == null ? null : type.autoboxesTo();
                    Symbol symbol2 = symbol = autobox == null ? null : SymbolTable.this.getOnlySymbolForType(autobox);
                }
                if (symbol != null) {
                    symbol.defineReferenceAt(n);
                }
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                this.visitTypeNode(scope, child);
            }
        }
    }

    private class ThisRefCollector
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;

        ThisRefCollector(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{externs, root}), this);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getType() != 42) {
                return;
            }
            Symbol symbol = null;
            if (t.inGlobalScope()) {
                symbol = SymbolTable.this.globalScope.getSlot(SymbolTable.GLOBAL_THIS) == null ? SymbolTable.this.declareSymbol(SymbolTable.GLOBAL_THIS, SymbolTable.this.registry.getNativeType(JSTypeNative.GLOBAL_THIS), false, SymbolTable.this.globalScope, n, null) : SymbolTable.this.globalScope.getSlot(SymbolTable.GLOBAL_THIS);
            } else {
                SymbolScope scope = (SymbolScope)SymbolTable.this.scopes.get(t.getScopeRoot());
                Preconditions.checkNotNull((Object)scope);
                Symbol scopeSymbol = SymbolTable.this.getSymbolForScope(scope);
                if (scopeSymbol != null) {
                    SymbolTable.this.createPropertyScopeFor(scopeSymbol);
                    SymbolScope propScope = scopeSymbol.getPropertyScope();
                    symbol = propScope.getSlot("this");
                    if (symbol == null) {
                        JSType type;
                        symbol = SymbolTable.this.declareSymbol("this", type, (type = n.getJSType()) != null && !type.isUnknownType(), propScope, n, null);
                    }
                }
            }
            if (symbol != null) {
                symbol.defineReferenceAt(n);
            }
        }
    }

    private class PropertyRefCollector
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;

        PropertyRefCollector(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{externs, root}), this);
        }

        private void maybeDefineReference(Node n, Symbol ownerSymbol) {
            Symbol prop;
            String propName = n.getLastChild().getString();
            if (ownerSymbol != null && ownerSymbol.getPropertyScope() != null && (prop = ownerSymbol.getPropertyScope().getSlot(propName)) != null) {
                prop.defineReferenceAt(n);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getType() == 33) {
                JSType owner = n.getFirstChild().getJSType();
                if (owner == null) {
                    return;
                }
                if (owner.isGlobalThisType()) {
                    Symbol sym = SymbolTable.this.globalScope.getSlot(n.getLastChild().getString());
                    if (sym != null) {
                        sym.defineReferenceAt(n);
                    }
                } else if (owner.isNominalConstructor()) {
                    this.maybeDefineReference(n, SymbolTable.this.getSymbolDeclaredBy(owner.toMaybeFunctionType()));
                } else {
                    for (Symbol ctor : SymbolTable.this.getAllSymbolsForType(owner)) {
                        this.maybeDefineReference(n, SymbolTable.this.getSymbolForInstancesOf(ctor));
                    }
                }
            }
        }
    }

    public static final class SymbolScope
    implements StaticScope<JSType> {
        private final Node rootNode;
        private final SymbolScope parent;
        private final JSType typeOfThis;
        private final Map<String, Symbol> ownSymbols = Maps.newHashMap();

        SymbolScope(Node rootNode, @Nullable SymbolScope parent, JSType typeOfThis) {
            this.rootNode = rootNode;
            this.parent = parent;
            this.typeOfThis = typeOfThis;
        }

        @Override
        public Node getRootNode() {
            return this.rootNode;
        }

        public SymbolScope getParentScope() {
            return this.parent;
        }

        public Symbol getSlot(String name) {
            Symbol owner;
            Symbol ancestor;
            Symbol own = this.getOwnSlot(name);
            if (own != null) {
                return own;
            }
            Symbol symbol = ancestor = this.parent == null ? null : this.parent.getSlot(name);
            if (ancestor != null) {
                return ancestor;
            }
            int dot = name.lastIndexOf(46);
            if (dot != -1 && (owner = this.getSlot(name.substring(0, dot))) != null && owner.getPropertyScope() != null) {
                return owner.getPropertyScope().getSlot(name.substring(dot + 1));
            }
            return null;
        }

        public Symbol getOwnSlot(String name) {
            return this.ownSymbols.get(name);
        }

        @Override
        public JSType getTypeOfThis() {
            return this.typeOfThis;
        }

        public boolean isGlobalScope() {
            return this.getParentScope() == null && this.getRootNode() != null;
        }

        public boolean isPropertyScope() {
            return this.getRootNode() == null;
        }

        public boolean isLexicalScope() {
            return this.getRootNode() != null;
        }
    }

    public static final class Reference
    extends SimpleReference<Symbol> {
        Reference(Symbol symbol, Node node) {
            super(symbol, node);
        }
    }

    public static final class Symbol
    extends SimpleSlot {
        private final Map<Node, Reference> references = Maps.newLinkedHashMap();
        private final SymbolScope scope;
        private SymbolScope propertyScope = null;
        private Reference declaration = null;
        private JSDocInfo docInfo = null;

        Symbol(String name, JSType type, boolean inferred, SymbolScope scope) {
            super(name, type, inferred);
            this.scope = scope;
        }

        public Reference getDeclaration() {
            return this.declaration;
        }

        public FunctionType getFunctionType() {
            return JSType.toMaybeFunctionType(this.getType());
        }

        public void defineReferenceAt(Node n) {
            if (!this.references.containsKey(n)) {
                this.references.put(n, new Reference(this, n));
            }
        }

        void setDeclaration(Reference ref) {
            Preconditions.checkState((this.declaration == null ? 1 : 0) != 0);
            this.declaration = ref;
            this.references.put(ref.getNode(), ref);
        }

        public boolean inGlobalScope() {
            return this.scope.isGlobalScope();
        }

        public boolean inExterns() {
            Node n = this.getDeclarationNode();
            return n == null ? false : n.isFromExterns();
        }

        public Node getDeclarationNode() {
            return this.declaration == null ? null : this.declaration.getNode();
        }

        public String getSourceFileName() {
            Node n = this.getDeclarationNode();
            return n == null ? null : n.getSourceFileName();
        }

        public SymbolScope getPropertyScope() {
            return this.propertyScope;
        }

        @Override
        public JSDocInfo getJSDocInfo() {
            return this.docInfo;
        }

        void setJSDocInfo(JSDocInfo info) {
            this.docInfo = info;
        }

        public String toString() {
            Node n = this.getDeclarationNode();
            int lineNo = n == null ? -1 : n.getLineno();
            return this.getName() + "@" + this.getSourceFileName() + ":" + lineNo;
        }
    }
}

