/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.nio.charset.Charset;
import java.util.TreeSet;

class TypedCodeGenerator
extends CodeGenerator {
    TypedCodeGenerator(CodeConsumer consumer, Charset outputCharset) {
        super(consumer, outputCharset);
    }

    @Override
    void add(Node n, CodeGenerator.Context context) {
        Node parent = n.getParent();
        if (parent != null && (parent.getType() == 125 || parent.getType() == 132)) {
            if (n.getType() == 105) {
                this.add(this.getFunctionAnnotation(n));
            } else if (n.getType() == 130 && n.getFirstChild().getType() == 86) {
                Node rhs = n.getFirstChild().getLastChild();
                this.add(this.getTypeAnnotation(rhs));
            } else if (n.getType() == 118 && n.getFirstChild().getFirstChild() != null && n.getFirstChild().getFirstChild().getType() == 105) {
                this.add(this.getFunctionAnnotation(n.getFirstChild().getFirstChild()));
            }
        }
        super.add(n, context);
    }

    private String getTypeAnnotation(Node node) {
        JSType type = node.getJSType();
        if (type == null) {
            return "";
        }
        if (type.isFunctionType()) {
            return this.getFunctionAnnotation(node);
        }
        if (!(type.isUnknownType() || type.isEmptyType() || type.isVoidType() || type.isFunctionPrototypeType())) {
            return "/** @type {" + node.getJSType() + "} */\n";
        }
        return "";
    }

    private String getFunctionAnnotation(Node fnNode) {
        JSType retType;
        Preconditions.checkState((fnNode.getType() == 105 ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder("/**\n");
        JSType type = fnNode.getJSType();
        if (type == null || type.isUnknownType()) {
            return "";
        }
        FunctionType funType = type.toMaybeFunctionType();
        if (fnNode != null) {
            Node paramNode = NodeUtil.getFunctionParameters(fnNode).getFirstChild();
            for (Node n : funType.getParameters()) {
                if (paramNode == null) break;
                sb.append(" * @param {" + this.getParameterNodeJSDocType(n) + "} ");
                sb.append(paramNode.getString());
                sb.append("\n");
                paramNode = paramNode.getNext();
            }
        }
        if ((retType = funType.getReturnType()) != null && !retType.isUnknownType() && !retType.isEmptyType()) {
            sb.append(" * @return {" + retType + "}\n");
        }
        if (funType.isConstructor() || funType.isInterface()) {
            ObjectType superInstance;
            FunctionType superConstructor = funType.getSuperClassConstructor();
            if (superConstructor != null && !(superInstance = funType.getSuperClassConstructor().getInstanceType()).toString().equals("Object")) {
                sb.append(" * @extends {" + superInstance + "}\n");
            }
            if (funType.isInterface()) {
                for (ObjectType interfaceType : funType.getExtendedInterfaces()) {
                    sb.append(" * @extends {" + interfaceType + "}\n");
                }
            }
            TreeSet interfaces = Sets.newTreeSet();
            for (ObjectType objectType : funType.getImplementedInterfaces()) {
                interfaces.add(objectType.toString());
            }
            for (String string : interfaces) {
                sb.append(" * @implements {" + string + "}\n");
            }
            if (funType.isConstructor()) {
                sb.append(" * @constructor\n");
            } else if (funType.isInterface()) {
                sb.append(" * @interface\n");
            }
        }
        if (fnNode != null && fnNode.getBooleanProp(47)) {
            sb.append(" * @javadispatch\n");
        }
        sb.append(" */\n");
        return sb.toString();
    }

    private String getParameterNodeJSDocType(Node parameterNode) {
        JSType parameterType = parameterNode.getJSType();
        String typeString = parameterType.isUnknownType() ? "*" : (parameterNode.isOptionalArg() ? parameterType.restrictByNotNullOrUndefined() + "=" : (parameterNode.isVarArgs() ? "..." + parameterType.restrictByNotNullOrUndefined() : parameterType.toString()));
        return typeString;
    }
}

