/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class VariableReferenceCheck
implements HotSwapCompilerPass {
    static final DiagnosticType UNDECLARED_REFERENCE = DiagnosticType.warning("JSC_REFERENCE_BEFORE_DECLARE", "Variable referenced before declaration: {0}");
    static final DiagnosticType REDECLARED_VARIABLE = DiagnosticType.warning("JSC_REDECLARED_VARIABLE", "Redeclared variable: {0}");
    static final DiagnosticType AMBIGUOUS_FUNCTION_DECL = DiagnosticType.disabled("AMBIGUOUS_FUNCTION_DECL", "Ambiguous use of a named function: {0}.");
    private final AbstractCompiler compiler;
    private final CheckLevel checkLevel;
    private final Set<ReferenceCollectingCallback.BasicBlock> blocksWithDeclarations = Sets.newHashSet();

    public VariableReferenceCheck(AbstractCompiler compiler, CheckLevel checkLevel) {
        this.compiler = compiler;
        this.checkLevel = checkLevel;
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, new ReferenceCheckingBehavior());
        callback.process(externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, new ReferenceCheckingBehavior());
        callback.hotSwapScript(scriptRoot, originalRoot);
    }

    private class ReferenceCheckingBehavior
    implements ReferenceCollectingCallback.Behavior {
        private ReferenceCheckingBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceCollectingCallback.ReferenceMap referenceMap) {
            Iterator<Scope.Var> it = t.getScope().getVars();
            while (it.hasNext()) {
                Scope.Var v = it.next();
                this.checkVar(t, v, referenceMap.getReferences((Scope.Var)v).references);
            }
        }

        private void checkVar(NodeTraversal t, Scope.Var v, List<ReferenceCollectingCallback.Reference> references) {
            VariableReferenceCheck.this.blocksWithDeclarations.clear();
            boolean isDeclaredInScope = false;
            boolean isUnhoistedNamedFunction = false;
            ReferenceCollectingCallback.Reference hoistedFn = null;
            for (ReferenceCollectingCallback.Reference reference : references) {
                if (reference.isHoistedFunction()) {
                    VariableReferenceCheck.this.blocksWithDeclarations.add(reference.getBasicBlock());
                    isDeclaredInScope = true;
                    hoistedFn = reference;
                    break;
                }
                if (!NodeUtil.isFunctionDeclaration(reference.getNode().getParent())) continue;
                isUnhoistedNamedFunction = true;
            }
            for (ReferenceCollectingCallback.Reference reference : references) {
                String filename;
                if (reference == hoistedFn) continue;
                ReferenceCollectingCallback.BasicBlock basicBlock = reference.getBasicBlock();
                boolean isDeclaration = reference.isDeclaration();
                boolean allowDupe = SyntacticScopeCreator.hasDuplicateDeclarationSuppression(reference.getNode(), v);
                if (isDeclaration && !allowDupe) {
                    for (ReferenceCollectingCallback.BasicBlock declaredBlock : VariableReferenceCheck.this.blocksWithDeclarations) {
                        if (!declaredBlock.provablyExecutesBefore(basicBlock)) continue;
                        filename = NodeUtil.getSourceName(reference.getNode());
                        VariableReferenceCheck.this.compiler.report(JSError.make(filename, reference.getNode(), VariableReferenceCheck.this.checkLevel, REDECLARED_VARIABLE, v.name));
                        break;
                    }
                }
                if (isUnhoistedNamedFunction && !isDeclaration && isDeclaredInScope) {
                    for (ReferenceCollectingCallback.BasicBlock declaredBlock : VariableReferenceCheck.this.blocksWithDeclarations) {
                        if (declaredBlock.provablyExecutesBefore(basicBlock)) continue;
                        filename = NodeUtil.getSourceName(reference.getNode());
                        VariableReferenceCheck.this.compiler.report(JSError.make(filename, reference.getNode(), AMBIGUOUS_FUNCTION_DECL, v.name));
                        break;
                    }
                }
                if (!(isDeclaration || isDeclaredInScope || reference.getNode().isFromExterns())) {
                    Node grandparent = reference.getGrandparent();
                    if (grandparent.getType() == 38 && grandparent.getString() == v.name) continue;
                    if (reference.getScope() == v.scope) {
                        String filename2 = NodeUtil.getSourceName(reference.getNode());
                        VariableReferenceCheck.this.compiler.report(JSError.make(filename2, reference.getNode(), VariableReferenceCheck.this.checkLevel, UNDECLARED_REFERENCE, v.name));
                    }
                }
                if (!isDeclaration) continue;
                VariableReferenceCheck.this.blocksWithDeclarations.add(basicBlock);
                isDeclaredInScope = true;
            }
        }
    }
}

