/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

abstract class JsMessageVisitor
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final String MSG_FUNCTION_NAME = "goog.getMsg";
    static final DiagnosticType MESSAGE_HAS_NO_DESCRIPTION = DiagnosticType.warning("JSC_MSG_HAS_NO_DESCRIPTION", "Message {0} has no description. Add @desc JsDoc tag.");
    static final DiagnosticType MESSAGE_HAS_NO_TEXT = DiagnosticType.warning("JSC_MSG_HAS_NO_TEXT", "Message value of {0} is just an empty string. Empty messages are forbidden.");
    static final DiagnosticType MESSAGE_TREE_MALFORMED = DiagnosticType.error("JSC_MSG_TREE_MALFORMED", "Message parse tree malformed. {0}");
    static final DiagnosticType MESSAGE_HAS_NO_VALUE = DiagnosticType.error("JSC_MSG_HAS_NO_VALUE", "message node {0} has no value");
    static final DiagnosticType MESSAGE_DUPLICATE_KEY = DiagnosticType.error("JSC_MSG_KEY_DUPLICATED", "duplicate message variable name found for {0}, initial definition {1}:{2}");
    static final DiagnosticType MESSAGE_NODE_IS_ORPHANED = DiagnosticType.warning("JSC_MSG_ORPHANED_NODE", "goog.getMsg() function could be used only with MSG_* property or variable");
    static final DiagnosticType MESSAGE_NOT_INITIALIZED_USING_NEW_SYNTAX = DiagnosticType.error("JSC_MSG_NOT_INITIALIZED_USING_NEW_SYNTAX", "message not initialized using goog.getMsg");
    private static final String PH_JS_PREFIX = "{$";
    private static final String PH_JS_SUFFIX = "}";
    static final String MSG_PREFIX = "MSG_";
    private static final Pattern MSG_UNNAMED_PATTERN = Pattern.compile("MSG_UNNAMED_\\d+");
    private static final Pattern CAMELCASE_PATTERN = Pattern.compile("[a-z][a-zA-Z\\d]*[_\\d]*");
    static final String HIDDEN_DESC_PREFIX = "@hidden";
    private static final String DESC_SUFFIX = "_HELP";
    private final boolean needToCheckDuplications;
    private final JsMessage.Style style;
    private final JsMessage.IdGenerator idGenerator;
    final AbstractCompiler compiler;
    private final Map<String, MessageLocation> messageNames = Maps.newHashMap();
    private final Map<Node, String> googMsgNodes = Maps.newHashMap();
    private final CheckLevel checkLevel;

    JsMessageVisitor(AbstractCompiler compiler, boolean needToCheckDuplications, JsMessage.Style style, JsMessage.IdGenerator idGenerator) {
        this.compiler = compiler;
        this.needToCheckDuplications = needToCheckDuplications;
        this.style = style;
        this.idGenerator = idGenerator;
        this.checkLevel = style == JsMessage.Style.CLOSURE ? CheckLevel.ERROR : CheckLevel.WARNING;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (Map.Entry<Node, String> msgNode : this.googMsgNodes.entrySet()) {
            this.compiler.report(JSError.make(msgNode.getValue(), msgNode.getKey(), this.checkLevel, MESSAGE_NODE_IS_ORPHANED, new String[0]));
        }
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        boolean isNewStyleMessage;
        Node msgNodeParent;
        Node msgNode;
        boolean isVar;
        String messageKey;
        switch (node.getType()) {
            case 38: {
                if (parent == null || !parent.isVar()) {
                    return;
                }
                messageKey = node.getString();
                isVar = true;
                msgNode = node.getFirstChild();
                msgNodeParent = node;
                break;
            }
            case 86: {
                isVar = false;
                Node getProp = node.getFirstChild();
                if (getProp.getType() != 33) {
                    return;
                }
                Node propNode = getProp.getLastChild();
                messageKey = propNode.getString();
                msgNode = node.getLastChild();
                msgNodeParent = node;
                break;
            }
            case 37: {
                if (MSG_FUNCTION_NAME.equals(node.getFirstChild().getQualifiedName())) {
                    this.googMsgNodes.put(node, traversal.getSourceName());
                }
                return;
            }
            default: {
                return;
            }
        }
        boolean bl = isNewStyleMessage = msgNode != null && msgNode.isCall();
        if (!this.isMessageName(messageKey, isNewStyleMessage)) {
            return;
        }
        if (msgNode == null) {
            this.compiler.report(traversal.makeError(node, MESSAGE_HAS_NO_VALUE, messageKey));
            return;
        }
        if (isNewStyleMessage) {
            this.googMsgNodes.remove(msgNode);
        } else if (this.style != JsMessage.Style.LEGACY) {
            this.compiler.report(traversal.makeError(node, this.checkLevel, MESSAGE_NOT_INITIALIZED_USING_NEW_SYNTAX, new String[0]));
        }
        boolean isUnnamedMsg = JsMessageVisitor.isUnnamedMessageName(messageKey);
        JsMessage.Builder builder = new JsMessage.Builder(isUnnamedMsg ? null : messageKey);
        builder.setSourceName(traversal.getSourceName());
        try {
            if (isVar) {
                this.extractMessageFromVariable(builder, node, parent, parent.getParent());
            } else {
                this.extractMessageFromProperty(builder, node.getFirstChild(), node);
            }
        }
        catch (MalformedException ex) {
            this.compiler.report(traversal.makeError(ex.getNode(), MESSAGE_TREE_MALFORMED, ex.getMessage()));
            return;
        }
        JsMessage extractedMessage = builder.build(this.idGenerator);
        if (this.needToCheckDuplications && !isUnnamedMsg && !extractedMessage.isExternal()) {
            this.checkIfMessageDuplicated(traversal.getSourceName(), messageKey, msgNode);
        }
        if (extractedMessage.isEmpty()) {
            this.compiler.report(traversal.makeError(node, MESSAGE_HAS_NO_TEXT, messageKey));
        }
        String desc = extractedMessage.getDesc();
        if (isNewStyleMessage && (desc == null || desc.trim().isEmpty()) && !extractedMessage.isExternal()) {
            this.compiler.report(traversal.makeError(node, MESSAGE_HAS_NO_DESCRIPTION, messageKey));
        }
        JsMessageDefinition msgDefinition = new JsMessageDefinition(node, msgNode, msgNodeParent);
        this.processJsMessage(extractedMessage, msgDefinition);
    }

    private void checkIfMessageDuplicated(String sourceName, String msgName, Node msgNode) {
        if (this.messageNames.containsKey(msgName)) {
            MessageLocation location = this.messageNames.get(msgName);
            this.compiler.report(JSError.make(sourceName, msgNode, MESSAGE_DUPLICATE_KEY, msgName, location.sourceName, Integer.toString(location.lineNo)));
        } else {
            MessageLocation location = new MessageLocation(sourceName, msgNode.getLineno());
            this.messageNames.put(msgName, location);
        }
    }

    private void extractMessageFromVariable(JsMessage.Builder builder, Node nameNode, Node parentNode, @Nullable Node grandParentNode) throws MalformedException {
        Node valueNode = nameNode.getFirstChild();
        switch (valueNode.getType()) {
            case 21: 
            case 40: {
                this.maybeInitMetaDataFromJsDocOrHelpVar(builder, parentNode, grandParentNode);
                builder.appendStringPart(JsMessageVisitor.extractStringFromStringExprNode(valueNode));
                break;
            }
            case 105: {
                this.maybeInitMetaDataFromJsDocOrHelpVar(builder, parentNode, grandParentNode);
                this.extractFromFunctionNode(builder, valueNode);
                break;
            }
            case 37: {
                this.maybeInitMetaDataFromJsDoc(builder, parentNode);
                this.extractFromCallNode(builder, valueNode);
                break;
            }
            default: {
                throw new MalformedException("Cannot parse value of message " + builder.getKey(), valueNode);
            }
        }
    }

    private void extractMessageFromProperty(JsMessage.Builder builder, Node getPropNode, Node assignNode) throws MalformedException {
        Node callNode = getPropNode.getNext();
        this.maybeInitMetaDataFromJsDoc(builder, assignNode);
        this.extractFromCallNode(builder, callNode);
    }

    private void maybeInitMetaDataFromJsDocOrHelpVar(JsMessage.Builder builder, Node varNode, @Nullable Node parentOfVarNode) throws MalformedException {
        if (this.maybeInitMetaDataFromJsDoc(builder, varNode)) {
            return;
        }
        if (parentOfVarNode != null && this.maybeInitMetaDataFromHelpVar(builder, parentOfVarNode.getChildBefore(varNode))) {
            return;
        }
        this.maybeInitMetaDataFromHelpVar(builder, varNode.getNext());
    }

    private boolean maybeInitMetaDataFromHelpVar(JsMessage.Builder builder, @Nullable Node sibling) throws MalformedException {
        Node nameNode;
        String name;
        if (sibling != null && sibling.isVar() && (name = (nameNode = sibling.getFirstChild()).getString()).equals(builder.getKey() + DESC_SUFFIX)) {
            Node valueNode = nameNode.getFirstChild();
            String desc = JsMessageVisitor.extractStringFromStringExprNode(valueNode);
            if (desc.startsWith(HIDDEN_DESC_PREFIX)) {
                builder.setDesc(desc.substring(HIDDEN_DESC_PREFIX.length()).trim());
                builder.setIsHidden(true);
            } else {
                builder.setDesc(desc);
            }
            return true;
        }
        return false;
    }

    private boolean maybeInitMetaDataFromJsDoc(JsMessage.Builder builder, Node node) {
        boolean messageHasDesc = false;
        JSDocInfo info = node.getJSDocInfo();
        if (info != null) {
            String desc = info.getDescription();
            if (desc != null) {
                builder.setDesc(desc);
                messageHasDesc = true;
            }
            if (info.isHidden()) {
                builder.setIsHidden(true);
            }
            if (info.getMeaning() != null) {
                builder.setMeaning(info.getMeaning());
            }
        }
        return messageHasDesc;
    }

    private static String extractStringFromStringExprNode(Node node) throws MalformedException {
        switch (node.getType()) {
            case 40: {
                return node.getString();
            }
            case 21: {
                StringBuilder sb = new StringBuilder();
                for (Node child : node.children()) {
                    sb.append(JsMessageVisitor.extractStringFromStringExprNode(child));
                }
                return sb.toString();
            }
        }
        throw new MalformedException("STRING or ADD node expected; found: " + JsMessageVisitor.getReadableTokenName(node), node);
    }

    private void extractFromFunctionNode(JsMessage.Builder builder, Node node) throws MalformedException {
        HashSet phNames = Sets.newHashSet();
        block5: for (Node fnChild : node.children()) {
            switch (fnChild.getType()) {
                case 38: {
                    break;
                }
                case 83: {
                    for (Node argumentNode : fnChild.children()) {
                        if (!argumentNode.isName()) continue;
                        String phName = argumentNode.getString();
                        if (phNames.contains(phName)) {
                            throw new MalformedException("Duplicate placeholder name: " + phName, argumentNode);
                        }
                        phNames.add(phName);
                    }
                    continue block5;
                }
                case 125: {
                    Node returnNode = fnChild.getFirstChild();
                    if (returnNode.getType() != 4) {
                        throw new MalformedException("RETURN node expected; found: " + JsMessageVisitor.getReadableTokenName(returnNode), returnNode);
                    }
                    for (Node child : returnNode.children()) {
                        this.extractFromReturnDescendant(builder, child);
                    }
                    for (String phName : builder.getPlaceholders()) {
                        if (phNames.contains(phName)) continue;
                        throw new MalformedException("Unrecognized message placeholder referenced: " + phName, returnNode);
                    }
                    continue block5;
                }
                default: {
                    throw new MalformedException("NAME, LP, or BLOCK node expected; found: " + JsMessageVisitor.getReadableTokenName(node), fnChild);
                }
            }
        }
    }

    private void extractFromReturnDescendant(JsMessage.Builder builder, Node node) throws MalformedException {
        switch (node.getType()) {
            case 40: {
                builder.appendStringPart(node.getString());
                break;
            }
            case 38: {
                builder.appendPlaceholderReference(node.getString());
                break;
            }
            case 21: {
                for (Node child : node.children()) {
                    this.extractFromReturnDescendant(builder, child);
                }
                break;
            }
            default: {
                throw new MalformedException("STRING, NAME, or ADD node expected; found: " + JsMessageVisitor.getReadableTokenName(node), node);
            }
        }
    }

    private void extractFromCallNode(JsMessage.Builder builder, Node node) throws MalformedException {
        if (node.getType() != 37) {
            throw new MalformedException("Message must be initialized using goog.getMsg function.", node);
        }
        Node fnNameNode = node.getFirstChild();
        if (!MSG_FUNCTION_NAME.equals(fnNameNode.getQualifiedName())) {
            throw new MalformedException("Message initialized using unrecognized function. Please use goog.getMsg() instead.", fnNameNode);
        }
        Node stringLiteralNode = fnNameNode.getNext();
        if (stringLiteralNode == null) {
            throw new MalformedException("Message string literal expected", stringLiteralNode);
        }
        this.parseMessageTextNode(builder, stringLiteralNode);
        Node objLitNode = stringLiteralNode.getNext();
        HashSet phNames = Sets.newHashSet();
        if (objLitNode != null) {
            if (objLitNode.getType() != 64) {
                throw new MalformedException("OBJLIT node expected", objLitNode);
            }
            for (Node aNode = objLitNode.getFirstChild(); aNode != null; aNode = aNode.getNext()) {
                if (aNode.getType() != 40) {
                    throw new MalformedException("STRING node expected as OBJLIT key", aNode);
                }
                String phName = aNode.getString();
                if (!JsMessageVisitor.isLowerCamelCaseWithNumericSuffixes(phName)) {
                    throw new MalformedException("Placeholder name not in lowerCamelCase: " + phName, aNode);
                }
                if (phNames.contains(phName)) {
                    throw new MalformedException("Duplicate placeholder name: " + phName, aNode);
                }
                phNames.add(phName);
            }
        }
        Set<String> usedPlaceholders = builder.getPlaceholders();
        for (String phName : usedPlaceholders) {
            if (phNames.contains(phName)) continue;
            throw new MalformedException("Unrecognized message placeholder referenced: " + phName, objLitNode);
        }
        for (String phName : phNames) {
            if (usedPlaceholders.contains(phName)) continue;
            throw new MalformedException("Unused message placeholder: " + phName, objLitNode);
        }
    }

    private void parseMessageTextNode(JsMessage.Builder builder, Node node) throws MalformedException {
        String value = JsMessageVisitor.extractStringFromStringExprNode(node);
        while (true) {
            int phEnd;
            int phBegin;
            if ((phBegin = value.indexOf(PH_JS_PREFIX)) < 0) {
                builder.appendStringPart(value);
                return;
            }
            if (phBegin > 0) {
                builder.appendStringPart(value.substring(0, phBegin));
            }
            if ((phEnd = value.indexOf(PH_JS_SUFFIX, phBegin)) < 0) {
                throw new MalformedException("Placeholder incorrectly formatted in: " + builder.getKey(), node);
            }
            String phName = value.substring(phBegin + PH_JS_PREFIX.length(), phEnd);
            builder.appendPlaceholderReference(phName);
            int nextPos = phEnd + PH_JS_SUFFIX.length();
            if (nextPos >= value.length()) break;
            value = value.substring(nextPos);
        }
    }

    abstract void processJsMessage(JsMessage var1, JsMessageDefinition var2);

    boolean isMessageName(String identifier, boolean isNewStyleMessage) {
        return identifier.startsWith(MSG_PREFIX) && (this.style == JsMessage.Style.CLOSURE || isNewStyleMessage || !identifier.endsWith(DESC_SUFFIX));
    }

    private static boolean isUnnamedMessageName(String identifier) {
        return MSG_UNNAMED_PATTERN.matcher(identifier).matches();
    }

    static boolean isLowerCamelCaseWithNumericSuffixes(String input) {
        return CAMELCASE_PATTERN.matcher(input).matches();
    }

    private static String getReadableTokenName(Node node) {
        return Node.tokenToName(node.getType()).toUpperCase();
    }

    static String toLowerCamelCaseWithNumericSuffixes(String input) {
        int suffixStart = input.length();
        while (suffixStart > 0) {
            int numberStart;
            char ch = '\u0000';
            for (numberStart = suffixStart; numberStart > 0 && Character.isDigit(ch = input.charAt(numberStart - 1)); --numberStart) {
            }
            if (numberStart <= 0 || numberStart >= suffixStart || ch != '_') break;
            suffixStart = numberStart - 1;
        }
        if (suffixStart == input.length()) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, input);
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, input.substring(0, suffixStart)) + input.substring(suffixStart);
    }

    private static class MessageLocation {
        private final String sourceName;
        private final int lineNo;

        private MessageLocation(String sourceName, int lineNo) {
            this.sourceName = sourceName;
            this.lineNo = lineNo;
        }
    }

    static class MalformedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Node node;

        MalformedException(String message, Node node) {
            super(message);
            this.node = node;
        }

        Node getNode() {
            return this.node;
        }
    }
}

