/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsFileParser
extends JsFileLineParser {
    private static Logger logger = Logger.getLogger(JsFileParser.class.getName());
    private static final Pattern GOOG_PROVIDE_REQUIRE_PATTERN = Pattern.compile("(?:^|;)\\s*goog\\.(provide|require)\\s*\\((.*?)\\)");
    private Matcher googMatcher = GOOG_PROVIDE_REQUIRE_PATTERN.matcher("");
    private List<String> provides;
    private List<String> requires;

    public JsFileParser(ErrorManager errorManager) {
        super(errorManager);
    }

    public DependencyInfo parseFile(String filePath, String closureRelativePath) throws IOException {
        return this.parseReader(filePath, closureRelativePath, new FileReader(filePath));
    }

    public DependencyInfo parseFile(String filePath, String closureRelativePath, String fileContents) {
        return this.parseReader(filePath, closureRelativePath, new StringReader(fileContents));
    }

    private DependencyInfo parseReader(String filePath, String closureRelativePath, Reader fileContents) {
        this.provides = Lists.newArrayList();
        this.requires = Lists.newArrayList();
        logger.fine("Parsing Source: " + filePath);
        this.doParse(filePath, fileContents);
        SimpleDependencyInfo dependencyInfo = new SimpleDependencyInfo(closureRelativePath, filePath, this.provides, this.requires);
        logger.fine("DepInfo: " + dependencyInfo);
        return dependencyInfo;
    }

    @Override
    protected boolean parseLine(String line) throws JsFileLineParser.ParseException {
        boolean hasProvidesOrRequires = false;
        if (line.indexOf("provide") != -1 || line.indexOf("require") != -1) {
            this.googMatcher.reset(line);
            while (this.googMatcher.find()) {
                hasProvidesOrRequires = true;
                boolean isRequire = this.googMatcher.group(1).charAt(0) == 'r';
                String arg = this.parseJsString(this.googMatcher.group(2));
                if (isRequire) {
                    if ("goog".equals(arg)) continue;
                    this.requires.add(arg);
                    continue;
                }
                this.provides.add(arg);
            }
        }
        return !this.shortcutMode || hasProvidesOrRequires || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)line);
    }
}

