/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;

class PhaseOptimizer
implements CompilerPass {
    @VisibleForTesting
    static final List<String> OPTIMAL_ORDER = ImmutableList.of((Object)"removeUnreachableCode", (Object)"removeUnusedVars", (Object)"foldConstants", (Object)"deadAssignmentsElimination", (Object)"inlineVariables", (Object)"inlineFunctions", (Object)"removeUnusedPrototypeProperties", (Object)"minimizeExitPoints");
    static final int MAX_LOOPS = 100;
    static final String OPTIMIZE_LOOP_ERROR = "Fixed point loop exceeded the maximum number of iterations.";
    private static final Logger logger = Logger.getLogger(PhaseOptimizer.class.getName());
    private final List<CompilerPass> passes = Lists.newArrayList();
    private final AbstractCompiler compiler;
    private final PerformanceTracker tracker;
    private final CodeChangeHandler.RecentChange recentChange = new CodeChangeHandler.RecentChange();
    private boolean loopMutex = false;
    private Tracer currentTracer = null;
    private String currentPassName = null;
    private PassFactory sanityCheck = null;
    private static boolean randomizeLoops = false;
    private static List<List<String>> loopsRun = Lists.newArrayList();
    private final ProgressRange progressRange;

    PhaseOptimizer(AbstractCompiler compiler, PerformanceTracker tracker, ProgressRange progressRange) {
        this.compiler = compiler;
        this.tracker = tracker;
        this.progressRange = progressRange;
        compiler.addChangeHandler(this.recentChange);
    }

    static void randomizeLoops() {
        randomizeLoops = true;
    }

    static List<List<String>> getLoopsRun() {
        return loopsRun;
    }

    static void clearLoopsRun() {
        loopsRun.clear();
    }

    void consume(List<PassFactory> factories) {
        LoopInternal currentLoop = new LoopInternal();
        boolean isCurrentLoopPopulated = false;
        for (PassFactory factory : factories) {
            if (factory.isOneTimePass()) {
                if (isCurrentLoopPopulated) {
                    this.passes.add(currentLoop);
                    currentLoop = new LoopInternal();
                    isCurrentLoopPopulated = false;
                }
                this.addOneTimePass(factory);
                continue;
            }
            ((Loop)currentLoop).addLoopedPass(factory);
            isCurrentLoopPopulated = true;
        }
        if (isCurrentLoopPopulated) {
            this.passes.add(currentLoop);
        }
    }

    void addOneTimePass(PassFactory factory) {
        this.passes.add(new PassFactoryDelegate(this.compiler, factory));
    }

    Loop addFixedPointLoop() {
        LoopInternal loop = new LoopInternal();
        this.passes.add(loop);
        return loop;
    }

    void setSanityCheck(PassFactory sanityCheck) {
        this.sanityCheck = sanityCheck;
    }

    @Override
    public void process(Node externs, Node root) {
        double progress = 0.0;
        double progressStep = 0.0;
        if (this.progressRange != null) {
            progressStep = (this.progressRange.maxValue - this.progressRange.initialValue) / (double)this.passes.size();
            progress = this.progressRange.initialValue;
        }
        for (CompilerPass pass : this.passes) {
            pass.process(externs, root);
            if (this.progressRange != null) {
                this.compiler.setProgress(progress += progressStep);
            }
            if (!this.hasHaltingErrors()) continue;
            return;
        }
    }

    private void startPass(String passName) {
        Preconditions.checkState((this.currentTracer == null && this.currentPassName == null ? 1 : 0) != 0);
        this.currentPassName = passName;
        this.currentTracer = this.newTracer(passName);
    }

    private void endPass(Node externs, Node root) {
        Preconditions.checkState((this.currentTracer != null && this.currentPassName != null ? 1 : 0) != 0);
        String passToCheck = this.currentPassName;
        try {
            this.stopTracer(this.currentTracer, this.currentPassName);
            this.currentPassName = null;
            this.currentTracer = null;
            this.maybeSanityCheck(externs, root);
        }
        catch (Exception e) {
            throw new RuntimeException("Sanity check failed for " + passToCheck, e);
        }
    }

    void maybeSanityCheck(Node externs, Node root) {
        if (this.sanityCheck != null) {
            this.sanityCheck.create(this.compiler).process(externs, root);
        }
    }

    private boolean hasHaltingErrors() {
        return this.compiler.hasHaltingErrors();
    }

    private Tracer newTracer(String passName) {
        String comment = passName + (this.recentChange.hasCodeChanged() ? " on recently changed AST" : "");
        if (this.tracker != null) {
            this.tracker.recordPassStart(passName);
        }
        return new Tracer("JSCompiler", comment);
    }

    private void stopTracer(Tracer t, String passName) {
        long result = t.stop();
        if (this.tracker != null) {
            this.tracker.recordPassStop(passName, result);
        }
    }

    static class ProgressRange {
        public final double initialValue;
        public final double maxValue;

        public ProgressRange(double initialValue, double maxValue) {
            this.initialValue = initialValue;
            this.maxValue = maxValue;
        }
    }

    private class LoopInternal
    extends Loop {
        private final List<NamedPass> myPasses = Lists.newArrayList();
        private final Set<String> myNames = Sets.newHashSet();

        private LoopInternal() {
        }

        @Override
        void addLoopedPass(PassFactory factory) {
            String name = factory.getName();
            Preconditions.checkArgument((!this.myNames.contains(name) ? 1 : 0) != 0, (String)"Already a pass with name '%s' in this loop", (Object[])new Object[]{name});
            this.myNames.add(factory.getName());
            this.myPasses.add(new PassFactoryDelegate(PhaseOptimizer.this.compiler, factory));
        }

        private List<String> getPassOrder() {
            ArrayList order = Lists.newArrayList();
            for (NamedPass pass : this.myPasses) {
                order.add(pass.name);
            }
            return order;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Node externs, Node root) {
            Preconditions.checkState((!PhaseOptimizer.this.loopMutex ? 1 : 0) != 0, (Object)"Nested loops are forbidden");
            PhaseOptimizer.this.loopMutex = true;
            if (randomizeLoops) {
                this.randomizePasses();
            } else {
                this.optimizePasses();
            }
            try {
                int count = 0;
                block3: do {
                    if (count++ > 100) {
                        PhaseOptimizer.this.compiler.throwInternalError(PhaseOptimizer.OPTIMIZE_LOOP_ERROR, null);
                    }
                    PhaseOptimizer.this.recentChange.reset();
                    for (NamedPass pass : this.myPasses) {
                        pass.process(externs, root);
                        if (!PhaseOptimizer.this.hasHaltingErrors()) continue;
                        break block3;
                    }
                } while (PhaseOptimizer.this.recentChange.hasCodeChanged() && !PhaseOptimizer.this.hasHaltingErrors());
                if (randomizeLoops) {
                    loopsRun.add(this.getPassOrder());
                }
            }
            finally {
                PhaseOptimizer.this.loopMutex = false;
            }
        }

        private void randomizePasses() {
            ArrayList mixedupPasses = Lists.newArrayList();
            Random random = new Random();
            while (this.myPasses.size() > 0) {
                mixedupPasses.add(this.myPasses.remove(random.nextInt(this.myPasses.size())));
            }
            this.myPasses.addAll(mixedupPasses);
        }

        private void optimizePasses() {
            ArrayList optimalPasses = Lists.newArrayList();
            block0: for (String passName : OPTIMAL_ORDER) {
                for (NamedPass pass : this.myPasses) {
                    if (!pass.name.equals(passName)) continue;
                    optimalPasses.add(pass);
                    continue block0;
                }
            }
            this.myPasses.removeAll(optimalPasses);
            this.myPasses.addAll(optimalPasses);
        }
    }

    static abstract class Loop
    implements CompilerPass {
        Loop() {
        }

        abstract void addLoopedPass(PassFactory var1);
    }

    private class PassFactoryDelegate
    extends NamedPass {
        private final AbstractCompiler myCompiler;
        private final PassFactory factory;

        private PassFactoryDelegate(AbstractCompiler myCompiler, PassFactory factory) {
            super(factory.getName());
            this.myCompiler = myCompiler;
            this.factory = factory;
        }

        @Override
        void processInternal(Node externs, Node root) {
            this.factory.create(this.myCompiler).process(externs, root);
        }
    }

    private abstract class NamedPass
    implements CompilerPass {
        private final String name;

        NamedPass(String name) {
            this.name = name;
        }

        @Override
        public void process(Node externs, Node root) {
            logger.fine(this.name);
            PhaseOptimizer.this.startPass(this.name);
            this.processInternal(externs, root);
            PhaseOptimizer.this.endPass(externs, root);
        }

        abstract void processInternal(Node var1, Node var2);
    }
}

