/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class WhitelistWarningsGuard
extends WarningsGuard {
    private final Set<String> whiteList;
    private static final Pattern LINE_NUMBER = Pattern.compile(":\\d+");

    public WhitelistWarningsGuard(Set<String> whiteList) {
        this.whiteList = whiteList;
    }

    protected boolean containWarning(String formattedWarning) {
        return this.whiteList.contains(formattedWarning);
    }

    @Override
    public int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_BY_WHITELIST.getValue();
    }

    public static Set<String> loadWhitelistedJsWarnings(File file) {
        return WhitelistWarningsGuard.loadWhitelistedJsWarnings((InputSupplier<InputStreamReader>)Files.newReaderSupplier((File)file, (Charset)Charsets.UTF_8));
    }

    protected static Set<String> loadWhitelistedJsWarnings(InputSupplier<InputStreamReader> supplier) {
        Preconditions.checkNotNull(supplier);
        HashSet<String> result = new HashSet<String>();
        try {
            for (String line : CharStreams.readLines(supplier)) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                result.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String formatWarning(JSError error) {
        return WhitelistWarningsGuard.formatWarning(error, false);
    }

    public static String formatWarning(JSError error, boolean withLineNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append(error.sourceName).append(":");
        if (withLineNumber) {
            sb.append(error.lineNumber);
        }
        String descriptionFirstLine = WhitelistWarningsGuard.getFirstLine(error.description);
        if (!withLineNumber) {
            descriptionFirstLine = LINE_NUMBER.matcher(descriptionFirstLine).replaceAll(":");
        }
        sb.append("  ").append(descriptionFirstLine);
        return sb.toString();
    }

    public static String getFirstLine(String warning) {
        int lineLength = warning.indexOf(10);
        if (lineLength > 0) {
            warning = warning.substring(0, lineLength);
        }
        return warning;
    }
}

