/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.parsing.Annotation;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocToken;
import com.google.javascript.jscomp.parsing.JsDocTokenStream;
import com.google.javascript.jscomp.parsing.NullErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ScriptRuntime;
import com.google.javascript.rhino.head.ErrorReporter;
import com.google.javascript.rhino.head.ast.Comment;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsDocInfoParser {
    private final JsDocTokenStream stream;
    private final JSDocInfoBuilder jsdocBuilder;
    private final StaticSourceFile sourceFile;
    private final Node associatedNode;
    private final ErrorReporter errorReporter;
    private final ErrorReporterParser parser = new ErrorReporterParser();
    private final Node templateNode;
    private JSDocInfo fileOverviewJSDocInfo = null;
    private State state;
    private final Map<String, Annotation> annotationNames;
    private final Set<String> suppressionNames;
    private static final Set<String> modifiesAnnotationKeywords = ImmutableSet.of((Object)"this", (Object)"arguments");
    private Node.FileLevelJsDocBuilder fileLevelJsDocBuilder;
    private static final JsDocToken NO_UNREAD_TOKEN = null;
    private JsDocToken unreadToken = NO_UNREAD_TOKEN;

    void setFileLevelJsDocBuilder(Node.FileLevelJsDocBuilder fileLevelJsDocBuilder) {
        this.fileLevelJsDocBuilder = fileLevelJsDocBuilder;
    }

    void setFileOverviewJSDocInfo(JSDocInfo fileOverviewJSDocInfo) {
        this.fileOverviewJSDocInfo = fileOverviewJSDocInfo;
    }

    JsDocInfoParser(JsDocTokenStream stream, Comment commentNode, Node associatedNode, Config config, ErrorReporter errorReporter) {
        this.stream = stream;
        this.associatedNode = associatedNode;
        this.sourceFile = associatedNode == null ? null : associatedNode.getStaticSourceFile();
        this.jsdocBuilder = new JSDocInfoBuilder(config.parseJsDocDocumentation);
        if (commentNode != null) {
            this.jsdocBuilder.recordOriginalCommentString(commentNode.getValue());
        }
        this.annotationNames = config.annotationNames;
        this.suppressionNames = config.suppressionNames;
        this.errorReporter = errorReporter;
        this.templateNode = this.createTemplateNode();
    }

    private String getSourceName() {
        return this.sourceFile == null ? null : this.sourceFile.getName();
    }

    public static Node parseTypeString(String typeString) {
        Config config = new Config(Sets.newHashSet(), Sets.newHashSet(), false, Config.LanguageMode.ECMASCRIPT3, false);
        JsDocInfoParser parser = new JsDocInfoParser(new JsDocTokenStream(typeString), null, null, config, NullErrorReporter.forNewRhino());
        return parser.parseTopLevelTypeExpression(parser.next());
    }

    boolean parse() {
        this.state = State.SEARCHING_ANNOTATION;
        this.skipEOLs();
        JsDocToken token = this.next();
        ArrayList extendedTypes = Lists.newArrayList();
        if (this.jsdocBuilder.shouldParseDocumentation()) {
            ExtractionInfo blockInfo = this.extractBlockComment(token);
            token = blockInfo.token;
            if (!blockInfo.string.isEmpty()) {
                this.jsdocBuilder.recordBlockDescription(blockInfo.string);
            }
        } else if (token != JsDocToken.ANNOTATION && token != JsDocToken.EOC) {
            this.jsdocBuilder.recordBlockDescription("");
        }
        block53: while (true) {
            switch (token) {
                case ANNOTATION: {
                    if (this.state != State.SEARCHING_ANNOTATION) break;
                    this.state = State.SEARCHING_NEWLINE;
                    int lineno = this.stream.getLineno();
                    int charno = this.stream.getCharno();
                    String annotationName = this.stream.getString();
                    Annotation annotation = this.annotationNames.get(annotationName);
                    if (annotation == null) {
                        this.parser.addParserWarning("msg.bad.jsdoc.tag", annotationName, this.stream.getLineno(), this.stream.getCharno());
                        break;
                    }
                    this.jsdocBuilder.markAnnotation(annotationName, lineno, charno);
                    switch (annotation) {
                        case AUTHOR: {
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                ExtractionInfo authorInfo = this.extractSingleLineBlock();
                                String author = authorInfo.string;
                                if (author.length() == 0) {
                                    this.parser.addParserWarning("msg.jsdoc.authormissing", this.stream.getLineno(), this.stream.getCharno());
                                } else {
                                    this.jsdocBuilder.addAuthor(author);
                                }
                                token = authorInfo.token;
                                continue block53;
                            }
                            token = this.eatTokensUntilEOL(token);
                            continue block53;
                        }
                        case CONSISTENTIDGENERATOR: {
                            if (!this.jsdocBuilder.recordConsistentIdGenerator()) {
                                this.parser.addParserWarning("msg.jsdoc.consistidgen", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case CONSTANT: {
                            if (!this.jsdocBuilder.recordConstancy()) {
                                this.parser.addParserWarning("msg.jsdoc.const", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case CONSTRUCTOR: {
                            if (!this.jsdocBuilder.recordConstructor()) {
                                if (this.jsdocBuilder.isInterfaceRecorded()) {
                                    this.parser.addTypeWarning("msg.jsdoc.interface.constructor", this.stream.getLineno(), this.stream.getCharno());
                                } else {
                                    this.parser.addTypeWarning("msg.jsdoc.incompat.type", this.stream.getLineno(), this.stream.getCharno());
                                }
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case DEPRECATED: {
                            ExtractionInfo reasonInfo;
                            String reason;
                            if (!this.jsdocBuilder.recordDeprecated()) {
                                this.parser.addParserWarning("msg.jsdoc.deprecated", this.stream.getLineno(), this.stream.getCharno());
                            }
                            if ((reason = (reasonInfo = this.extractMultilineTextualBlock(token)).string).length() > 0) {
                                this.jsdocBuilder.recordDeprecationReason(reason);
                            }
                            token = reasonInfo.token;
                            continue block53;
                        }
                        case INTERFACE: {
                            if (!this.jsdocBuilder.recordInterface()) {
                                if (this.jsdocBuilder.isConstructorRecorded()) {
                                    this.parser.addTypeWarning("msg.jsdoc.interface.constructor", this.stream.getLineno(), this.stream.getCharno());
                                } else {
                                    this.parser.addTypeWarning("msg.jsdoc.incompat.type", this.stream.getLineno(), this.stream.getCharno());
                                }
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case DESC: {
                            if (this.jsdocBuilder.isDescriptionRecorded()) {
                                this.parser.addParserWarning("msg.jsdoc.desc.extra", this.stream.getLineno(), this.stream.getCharno());
                                token = this.eatTokensUntilEOL();
                                continue block53;
                            }
                            ExtractionInfo descriptionInfo = this.extractMultilineTextualBlock(token);
                            String description = descriptionInfo.string;
                            this.jsdocBuilder.recordDescription(description);
                            token = descriptionInfo.token;
                            continue block53;
                        }
                        case FILE_OVERVIEW: {
                            String fileOverview = "";
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                ExtractionInfo fileOverviewInfo = this.extractMultilineTextualBlock(token, WhitespaceOption.TRIM);
                                fileOverview = fileOverviewInfo.string;
                                token = fileOverviewInfo.token;
                            } else {
                                token = this.eatTokensUntilEOL(token);
                            }
                            if (this.jsdocBuilder.recordFileOverview(fileOverview) && this.fileOverviewJSDocInfo == null) continue block53;
                            this.parser.addParserWarning("msg.jsdoc.fileoverview.extra", this.stream.getLineno(), this.stream.getCharno());
                            continue block53;
                        }
                        case LICENSE: 
                        case PRESERVE: {
                            ExtractionInfo preserveInfo = this.extractMultilineTextualBlock(token, WhitespaceOption.PRESERVE);
                            String preserve = preserveInfo.string;
                            if (preserve.length() > 0 && this.fileLevelJsDocBuilder != null) {
                                this.fileLevelJsDocBuilder.append(preserve);
                            }
                            token = preserveInfo.token;
                            continue block53;
                        }
                        case ENUM: {
                            token = this.next();
                            lineno = this.stream.getLineno();
                            charno = this.stream.getCharno();
                            JSTypeExpression type = null;
                            if (token != JsDocToken.EOL && token != JsDocToken.EOC) {
                                type = this.createJSTypeExpression(this.parseAndRecordTypeNode(token));
                            }
                            if (type == null) {
                                type = this.createJSTypeExpression(this.newStringNode("number"));
                            }
                            if (!this.jsdocBuilder.recordEnumParameterType(type)) {
                                this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                            }
                            token = this.eatTokensUntilEOL(token);
                            continue block53;
                        }
                        case EXPORT: {
                            if (!this.jsdocBuilder.recordExport()) {
                                this.parser.addParserWarning("msg.jsdoc.export", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case EXTERNS: {
                            if (!this.jsdocBuilder.recordExterns()) {
                                this.parser.addParserWarning("msg.jsdoc.externs", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case JAVA_DISPATCH: {
                            if (!this.jsdocBuilder.recordJavaDispatch()) {
                                this.parser.addParserWarning("msg.jsdoc.javadispatch", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case EXTENDS: 
                        case IMPLEMENTS: {
                            JSTypeExpression type;
                            this.skipEOLs();
                            token = this.next();
                            lineno = this.stream.getLineno();
                            charno = this.stream.getCharno();
                            boolean matchingRc = false;
                            if (token == JsDocToken.LC) {
                                token = this.next();
                                matchingRc = true;
                            }
                            if (token == JsDocToken.STRING) {
                                Node typeNode = this.parseAndRecordTypeNameNode(token, lineno, charno, matchingRc);
                                lineno = this.stream.getLineno();
                                charno = this.stream.getCharno();
                                if ((typeNode = this.wrapNode(306, typeNode)) != null && !matchingRc) {
                                    typeNode.putBooleanProp(41, true);
                                }
                                type = this.createJSTypeExpression(typeNode);
                                if (annotation == Annotation.EXTENDS) {
                                    extendedTypes.add(new ExtendedTypeInfo(type, this.stream.getLineno(), this.stream.getCharno()));
                                } else {
                                    Preconditions.checkState((annotation == Annotation.IMPLEMENTS ? 1 : 0) != 0);
                                    if (!this.jsdocBuilder.recordImplementedInterface(type)) {
                                        this.parser.addTypeWarning("msg.jsdoc.implements.duplicate", lineno, charno);
                                    }
                                }
                                token = this.next();
                                if (matchingRc) {
                                    if (token != JsDocToken.RC) {
                                        this.parser.addTypeWarning("msg.jsdoc.missing.rc", this.stream.getLineno(), this.stream.getCharno());
                                    }
                                } else if (token != JsDocToken.EOL && token != JsDocToken.EOF && token != JsDocToken.EOC) {
                                    this.parser.addTypeWarning("msg.end.annotation.expected", this.stream.getLineno(), this.stream.getCharno());
                                }
                            } else {
                                this.parser.addTypeWarning("msg.no.type.name", lineno, charno);
                            }
                            token = this.eatTokensUntilEOL(token);
                            continue block53;
                        }
                        case HIDDEN: {
                            if (!this.jsdocBuilder.recordHiddenness()) {
                                this.parser.addParserWarning("msg.jsdoc.hidden", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case LENDS: {
                            this.skipEOLs();
                            boolean matchingRc = false;
                            if (this.match(JsDocToken.LC)) {
                                token = this.next();
                                matchingRc = true;
                            }
                            if (this.match(JsDocToken.STRING)) {
                                token = this.next();
                                if (!this.jsdocBuilder.recordLends(this.stream.getString())) {
                                    this.parser.addTypeWarning("msg.jsdoc.lends.incompatible", this.stream.getLineno(), this.stream.getCharno());
                                }
                            } else {
                                this.parser.addTypeWarning("msg.jsdoc.lends.missing", this.stream.getLineno(), this.stream.getCharno());
                            }
                            if (matchingRc && !this.match(JsDocToken.RC)) {
                                this.parser.addTypeWarning("msg.jsdoc.missing.rc", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case MEANING: {
                            ExtractionInfo meaningInfo = this.extractMultilineTextualBlock(token);
                            String meaning = meaningInfo.string;
                            token = meaningInfo.token;
                            if (this.jsdocBuilder.recordMeaning(meaning)) continue block53;
                            this.parser.addParserWarning("msg.jsdoc.meaning.extra", this.stream.getLineno(), this.stream.getCharno());
                            continue block53;
                        }
                        case NO_ALIAS: {
                            if (!this.jsdocBuilder.recordNoAlias()) {
                                this.parser.addParserWarning("msg.jsdoc.noalias", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case NO_COMPILE: {
                            if (!this.jsdocBuilder.recordNoCompile()) {
                                this.parser.addParserWarning("msg.jsdoc.nocompile", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case NO_TYPE_CHECK: {
                            if (!this.jsdocBuilder.recordNoTypeCheck()) {
                                this.parser.addParserWarning("msg.jsdoc.nocheck", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case NOT_IMPLEMENTED: {
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case INHERIT_DOC: 
                        case OVERRIDE: {
                            if (!this.jsdocBuilder.recordOverride()) {
                                this.parser.addTypeWarning("msg.jsdoc.override", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case THROWS: {
                            this.skipEOLs();
                            token = this.next();
                            lineno = this.stream.getLineno();
                            charno = this.stream.getCharno();
                            JSTypeExpression type = null;
                            if (token == JsDocToken.LC && (type = this.createJSTypeExpression(this.parseAndRecordTypeNode(token))) == null) {
                                token = this.eatTokensUntilEOL();
                                continue block53;
                            }
                            token = this.current();
                            this.jsdocBuilder.recordThrowType(type);
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                ExtractionInfo descriptionInfo = this.extractMultilineTextualBlock(token);
                                String description = descriptionInfo.string;
                                if (description.length() > 0) {
                                    this.jsdocBuilder.recordThrowDescription(type, description);
                                }
                                token = descriptionInfo.token;
                                continue block53;
                            }
                            token = this.eatTokensUntilEOL(token);
                            continue block53;
                        }
                        case PARAM: {
                            boolean isBracketedParam;
                            this.skipEOLs();
                            token = this.next();
                            lineno = this.stream.getLineno();
                            charno = this.stream.getCharno();
                            JSTypeExpression type = null;
                            if (token == JsDocToken.LC) {
                                type = this.createJSTypeExpression(this.parseAndRecordParamTypeNode(token));
                                if (type == null) {
                                    token = this.eatTokensUntilEOL();
                                    continue block53;
                                }
                                this.skipEOLs();
                                token = this.next();
                                lineno = this.stream.getLineno();
                                charno = this.stream.getCharno();
                            }
                            String name = null;
                            boolean bl = isBracketedParam = JsDocToken.LB == token;
                            if (isBracketedParam) {
                                token = this.next();
                            }
                            if (JsDocToken.STRING != token) {
                                this.parser.addTypeWarning("msg.missing.variable.name", lineno, charno);
                            } else {
                                name = this.stream.getString();
                                if (isBracketedParam) {
                                    token = this.next();
                                    if (JsDocToken.EQUALS == token && JsDocToken.STRING == (token = this.next())) {
                                        token = this.next();
                                    }
                                    if (JsDocToken.RB != token) {
                                        this.reportTypeSyntaxWarning("msg.jsdoc.missing.rb");
                                    } else if (type != null) {
                                        type = JSTypeExpression.makeOptionalArg(type);
                                    }
                                }
                                if (name.indexOf(46) > -1) {
                                    name = null;
                                } else if (!this.jsdocBuilder.recordParameter(name, type)) {
                                    if (this.jsdocBuilder.hasParameter(name)) {
                                        this.parser.addTypeWarning("msg.dup.variable.name", name, lineno, charno);
                                    } else {
                                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", name, lineno, charno);
                                    }
                                }
                            }
                            if (name == null) {
                                token = this.eatTokensUntilEOL(token);
                                continue block53;
                            }
                            this.jsdocBuilder.markName(name, this.sourceFile, lineno, charno);
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                ExtractionInfo paramDescriptionInfo = this.extractMultilineTextualBlock(token);
                                String paramDescription = paramDescriptionInfo.string;
                                if (paramDescription.length() > 0) {
                                    this.jsdocBuilder.recordParameterDescription(name, paramDescription);
                                }
                                token = paramDescriptionInfo.token;
                                continue block53;
                            }
                            token = this.eatTokensUntilEOL(token);
                            continue block53;
                        }
                        case PRESERVE_TRY: {
                            if (!this.jsdocBuilder.recordPreserveTry()) {
                                this.parser.addParserWarning("msg.jsdoc.preservertry", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case PRIVATE: {
                            if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PRIVATE)) {
                                this.parser.addParserWarning("msg.jsdoc.visibility.private", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case PROTECTED: {
                            if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PROTECTED)) {
                                this.parser.addParserWarning("msg.jsdoc.visibility.protected", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case PUBLIC: {
                            if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PUBLIC)) {
                                this.parser.addParserWarning("msg.jsdoc.visibility.public", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case NO_SHADOW: {
                            if (!this.jsdocBuilder.recordNoShadow()) {
                                this.parser.addParserWarning("msg.jsdoc.noshadow", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case NO_SIDE_EFFECTS: {
                            if (!this.jsdocBuilder.recordNoSideEffects()) {
                                this.parser.addParserWarning("msg.jsdoc.nosideeffects", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case MODIFIES: {
                            token = this.parseModifiesTag(this.next());
                            continue block53;
                        }
                        case IMPLICIT_CAST: {
                            if (!this.jsdocBuilder.recordImplicitCast()) {
                                this.parser.addTypeWarning("msg.jsdoc.implicitcast", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case SEE: {
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                ExtractionInfo referenceInfo = this.extractSingleLineBlock();
                                String reference = referenceInfo.string;
                                if (reference.length() == 0) {
                                    this.parser.addParserWarning("msg.jsdoc.seemissing", this.stream.getLineno(), this.stream.getCharno());
                                } else {
                                    this.jsdocBuilder.addReference(reference);
                                }
                                token = referenceInfo.token;
                                continue block53;
                            }
                            token = this.eatTokensUntilEOL(token);
                            continue block53;
                        }
                        case SUPPRESS: {
                            token = this.parseSuppressTag(this.next());
                            continue block53;
                        }
                        case TEMPLATE: {
                            ExtractionInfo templateInfo = this.extractSingleLineBlock();
                            String templateTypeName = templateInfo.string;
                            if (templateTypeName.length() == 0) {
                                this.parser.addTypeWarning("msg.jsdoc.templatemissing", this.stream.getLineno(), this.stream.getCharno());
                            } else if (!this.jsdocBuilder.recordTemplateTypeName(templateTypeName)) {
                                this.parser.addTypeWarning("msg.jsdoc.template.at.most.once", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = templateInfo.token;
                            continue block53;
                        }
                        case IDGENERATOR: {
                            if (!this.jsdocBuilder.recordIdGenerator()) {
                                this.parser.addParserWarning("msg.jsdoc.idgen", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                        case VERSION: {
                            ExtractionInfo versionInfo = this.extractSingleLineBlock();
                            String version = versionInfo.string;
                            if (version.length() == 0) {
                                this.parser.addParserWarning("msg.jsdoc.versionmissing", this.stream.getLineno(), this.stream.getCharno());
                            } else if (!this.jsdocBuilder.recordVersion(version)) {
                                this.parser.addParserWarning("msg.jsdoc.extraversion", this.stream.getLineno(), this.stream.getCharno());
                            }
                            token = versionInfo.token;
                            continue block53;
                        }
                        case DEFINE: 
                        case RETURN: 
                        case THIS: 
                        case TYPE: 
                        case TYPEDEF: {
                            JSTypeExpression type;
                            lineno = this.stream.getLineno();
                            charno = this.stream.getCharno();
                            Node typeNode = null;
                            if (!this.lookAheadForTypeAnnotation() && annotation == Annotation.RETURN) {
                                typeNode = this.newNode(304);
                            } else {
                                this.skipEOLs();
                                token = this.next();
                                typeNode = this.parseAndRecordTypeNode(token);
                            }
                            if (annotation == Annotation.THIS && (typeNode = this.wrapNode(306, typeNode)) != null && token != JsDocToken.LC) {
                                typeNode.putBooleanProp(41, true);
                            }
                            if ((type = this.createJSTypeExpression(typeNode)) != null) {
                                switch (annotation) {
                                    case DEFINE: {
                                        if (this.jsdocBuilder.recordDefineType(type)) break;
                                        this.parser.addParserWarning("msg.jsdoc.define", lineno, charno);
                                        break;
                                    }
                                    case RETURN: {
                                        if (!this.jsdocBuilder.recordReturnType(type)) {
                                            this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                                            break;
                                        }
                                        if (this.jsdocBuilder.shouldParseDocumentation()) {
                                            ExtractionInfo returnDescriptionInfo = this.extractMultilineTextualBlock(token);
                                            String returnDescription = returnDescriptionInfo.string;
                                            if (returnDescription.length() > 0) {
                                                this.jsdocBuilder.recordReturnDescription(returnDescription);
                                            }
                                            token = returnDescriptionInfo.token;
                                            continue block53;
                                        }
                                        token = this.eatTokensUntilEOL(token);
                                        continue block53;
                                    }
                                    case THIS: {
                                        if (this.jsdocBuilder.recordThisType(type)) break;
                                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                                        break;
                                    }
                                    case TYPE: {
                                        if (this.jsdocBuilder.recordType(type)) break;
                                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                                        break;
                                    }
                                    case TYPEDEF: {
                                        if (this.jsdocBuilder.recordTypedef(type)) break;
                                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                                    }
                                }
                            }
                            token = this.eatTokensUntilEOL();
                            continue block53;
                        }
                    }
                    break;
                }
                case EOC: {
                    if (this.hasParsedFileOverviewDocInfo()) {
                        this.fileOverviewJSDocInfo = this.retrieveAndResetParsedJSDocInfo();
                    }
                    this.checkExtendedTypes(extendedTypes);
                    return true;
                }
                case EOF: {
                    this.jsdocBuilder.build(null);
                    this.parser.addParserWarning("msg.unexpected.eof", this.stream.getLineno(), this.stream.getCharno());
                    this.checkExtendedTypes(extendedTypes);
                    return false;
                }
                case EOL: {
                    if (this.state == State.SEARCHING_NEWLINE) {
                        this.state = State.SEARCHING_ANNOTATION;
                    }
                    token = this.next();
                    continue block53;
                }
                default: {
                    if (token == JsDocToken.STAR && this.state == State.SEARCHING_ANNOTATION) {
                        token = this.next();
                        continue block53;
                    }
                    this.state = State.SEARCHING_NEWLINE;
                    token = this.eatTokensUntilEOL();
                    continue block53;
                }
            }
            token = this.next();
        }
    }

    private void checkExtendedTypes(List<ExtendedTypeInfo> extendedTypes) {
        for (ExtendedTypeInfo typeInfo : extendedTypes) {
            if (this.jsdocBuilder.isInterfaceRecorded()) {
                if (this.jsdocBuilder.recordExtendedInterface(typeInfo.type)) continue;
                this.parser.addParserWarning("msg.jsdoc.extends.duplicate", typeInfo.lineno, typeInfo.charno);
                continue;
            }
            if (this.jsdocBuilder.recordBaseType(typeInfo.type)) continue;
            this.parser.addTypeWarning("msg.jsdoc.incompat.type", typeInfo.lineno, typeInfo.charno);
        }
    }

    private JsDocToken parseSuppressTag(JsDocToken token) {
        if (token == JsDocToken.LC) {
            HashSet<String> suppressions = new HashSet<String>();
            while (true) {
                if (this.match(JsDocToken.STRING)) {
                    String name = this.stream.getString();
                    if (!this.suppressionNames.contains(name)) {
                        this.parser.addParserWarning("msg.jsdoc.suppress.unknown", name, this.stream.getLineno(), this.stream.getCharno());
                    }
                } else {
                    this.parser.addParserWarning("msg.jsdoc.suppress", this.stream.getLineno(), this.stream.getCharno());
                    return token;
                }
                suppressions.add(this.stream.getString());
                token = this.next();
                if (!this.match(JsDocToken.PIPE)) break;
                token = this.next();
            }
            if (!this.match(JsDocToken.RC)) {
                this.parser.addParserWarning("msg.jsdoc.suppress", this.stream.getLineno(), this.stream.getCharno());
            } else {
                token = this.next();
                if (!this.jsdocBuilder.recordSuppressions(suppressions)) {
                    this.parser.addParserWarning("msg.jsdoc.suppress.duplicate", this.stream.getLineno(), this.stream.getCharno());
                }
            }
        }
        return token;
    }

    private JsDocToken parseModifiesTag(JsDocToken token) {
        if (token == JsDocToken.LC) {
            HashSet<String> modifies = new HashSet<String>();
            while (true) {
                if (this.match(JsDocToken.STRING)) {
                    String name = this.stream.getString();
                    if (!modifiesAnnotationKeywords.contains(name) && !this.jsdocBuilder.hasParameter(name)) {
                        this.parser.addParserWarning("msg.jsdoc.modifies.unknown", name, this.stream.getLineno(), this.stream.getCharno());
                    }
                } else {
                    this.parser.addParserWarning("msg.jsdoc.modifies", this.stream.getLineno(), this.stream.getCharno());
                    return token;
                }
                modifies.add(this.stream.getString());
                token = this.next();
                if (!this.match(JsDocToken.PIPE)) break;
                token = this.next();
            }
            if (!this.match(JsDocToken.RC)) {
                this.parser.addParserWarning("msg.jsdoc.modifies", this.stream.getLineno(), this.stream.getCharno());
            } else {
                token = this.next();
                if (!this.jsdocBuilder.recordModifies(modifies)) {
                    this.parser.addParserWarning("msg.jsdoc.modifies.duplicate", this.stream.getLineno(), this.stream.getCharno());
                }
            }
        }
        return token;
    }

    private Node parseAndRecordTypeNode(JsDocToken token) {
        return this.parseAndRecordTypeNode(token, token == JsDocToken.LC);
    }

    private Node parseAndRecordTypeNode(JsDocToken token, boolean matchingLC) {
        return this.parseAndRecordTypeNode(token, this.stream.getLineno(), this.stream.getCharno(), matchingLC, false);
    }

    private Node parseAndRecordTypeNameNode(JsDocToken token, int lineno, int startCharno, boolean matchingLC) {
        return this.parseAndRecordTypeNode(token, lineno, startCharno, matchingLC, true);
    }

    private Node parseAndRecordParamTypeNode(JsDocToken token) {
        Preconditions.checkArgument((token == JsDocToken.LC ? 1 : 0) != 0);
        int lineno = this.stream.getLineno();
        int startCharno = this.stream.getCharno();
        Node typeNode = this.parseParamTypeExpressionAnnotation(token);
        if (typeNode != null) {
            int endLineno = this.stream.getLineno();
            int endCharno = this.stream.getCharno();
            this.jsdocBuilder.markTypeNode(typeNode, lineno, startCharno, endLineno, endCharno, true);
        }
        return typeNode;
    }

    private Node parseAndRecordTypeNode(JsDocToken token, int lineno, int startCharno, boolean matchingLC, boolean onlyParseSimpleNames) {
        Node typeNode = null;
        typeNode = onlyParseSimpleNames ? this.parseTypeNameAnnotation(token) : this.parseTypeExpressionAnnotation(token);
        if (typeNode != null && !matchingLC) {
            typeNode.putBooleanProp(41, true);
        }
        if (typeNode != null) {
            int endLineno = this.stream.getLineno();
            int endCharno = this.stream.getCharno();
            this.jsdocBuilder.markTypeNode(typeNode, lineno, startCharno, endLineno, endCharno, matchingLC);
        }
        return typeNode;
    }

    private String toString(JsDocToken token) {
        switch (token) {
            case ANNOTATION: {
                return "@" + this.stream.getString();
            }
            case BANG: {
                return "!";
            }
            case COMMA: {
                return ",";
            }
            case COLON: {
                return ":";
            }
            case GT: {
                return ">";
            }
            case LB: {
                return "[";
            }
            case LC: {
                return "{";
            }
            case LP: {
                return "(";
            }
            case LT: {
                return ".<";
            }
            case QMARK: {
                return "?";
            }
            case PIPE: {
                return "|";
            }
            case RB: {
                return "]";
            }
            case RC: {
                return "}";
            }
            case RP: {
                return ")";
            }
            case STAR: {
                return "*";
            }
            case ELLIPSIS: {
                return "...";
            }
            case EQUALS: {
                return "=";
            }
            case STRING: {
                return this.stream.getString();
            }
        }
        throw new IllegalStateException(token.toString());
    }

    private JSTypeExpression createJSTypeExpression(Node n) {
        return n == null ? null : new JSTypeExpression(n, this.getSourceName());
    }

    private ExtractionInfo extractSingleLineBlock() {
        this.stream.update();
        int lineno = this.stream.getLineno();
        int charno = this.stream.getCharno() + 1;
        String line = this.stream.getRemainingJSDocLine().trim();
        if (line.length() > 0) {
            this.jsdocBuilder.markText(line, lineno, charno, lineno, charno + line.length());
        }
        return new ExtractionInfo(line, this.next());
    }

    private ExtractionInfo extractMultilineTextualBlock(JsDocToken token) {
        return this.extractMultilineTextualBlock(token, WhitespaceOption.SINGLE_LINE);
    }

    private ExtractionInfo extractMultilineTextualBlock(JsDocToken token, WhitespaceOption option) {
        if (token == JsDocToken.EOC || token == JsDocToken.EOL || token == JsDocToken.EOF) {
            return new ExtractionInfo("", token);
        }
        this.stream.update();
        int startLineno = this.stream.getLineno();
        int startCharno = this.stream.getCharno() + 1;
        String line = this.stream.getRemainingJSDocLine();
        if (option != WhitespaceOption.PRESERVE) {
            line = line.trim();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(line);
        this.state = State.SEARCHING_ANNOTATION;
        token = this.next();
        boolean ignoreStar = false;
        block5: while (true) {
            switch (token) {
                case STAR: {
                    if (!ignoreStar) {
                        if (builder.length() > 0) {
                            builder.append(' ');
                        }
                        builder.append('*');
                    }
                    token = this.next();
                    continue block5;
                }
                case EOL: {
                    if (option != WhitespaceOption.SINGLE_LINE) {
                        builder.append("\n");
                    }
                    ignoreStar = true;
                    token = this.next();
                    continue block5;
                }
                case ANNOTATION: 
                case EOC: 
                case EOF: {
                    if (option == WhitespaceOption.PRESERVE && token == JsDocToken.ANNOTATION) break;
                    String multilineText = builder.toString();
                    if (option != WhitespaceOption.PRESERVE) {
                        multilineText = multilineText.trim();
                    }
                    int endLineno = this.stream.getLineno();
                    int endCharno = this.stream.getCharno();
                    if (multilineText.length() > 0) {
                        this.jsdocBuilder.markText(multilineText, startLineno, startCharno, endLineno, endCharno);
                    }
                    return new ExtractionInfo(multilineText, token);
                }
            }
            ignoreStar = false;
            this.state = State.SEARCHING_ANNOTATION;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(this.toString(token));
            line = this.stream.getRemainingJSDocLine();
            if (option != WhitespaceOption.PRESERVE) {
                line = JsDocInfoParser.trimEnd(line);
            }
            builder.append(line);
            token = this.next();
        }
    }

    private ExtractionInfo extractBlockComment(JsDocToken token) {
        StringBuilder builder = new StringBuilder();
        boolean ignoreStar = true;
        block5: while (true) {
            switch (token) {
                case ANNOTATION: 
                case EOC: 
                case EOF: {
                    return new ExtractionInfo(builder.toString().trim(), token);
                }
                case STAR: {
                    if (!ignoreStar) {
                        if (builder.length() > 0) {
                            builder.append(' ');
                        }
                        builder.append('*');
                    }
                    token = this.next();
                    continue block5;
                }
                case EOL: {
                    ignoreStar = true;
                    builder.append('\n');
                    token = this.next();
                    continue block5;
                }
            }
            if (!ignoreStar && builder.length() > 0) {
                builder.append(' ');
            }
            ignoreStar = false;
            builder.append(this.toString(token));
            String line = this.stream.getRemainingJSDocLine();
            line = JsDocInfoParser.trimEnd(line);
            builder.append(line);
            token = this.next();
        }
    }

    private static String trimEnd(String s) {
        char ch;
        int trimCount;
        for (trimCount = 0; trimCount < s.length() && Character.isWhitespace(ch = s.charAt(s.length() - trimCount - 1)); ++trimCount) {
        }
        if (trimCount == 0) {
            return s;
        }
        return s.substring(0, s.length() - trimCount);
    }

    private Node parseTypeExpressionAnnotation(JsDocToken token) {
        if (token == JsDocToken.LC) {
            this.skipEOLs();
            Node typeNode = this.parseTopLevelTypeExpression(this.next());
            if (typeNode != null) {
                this.skipEOLs();
                if (!this.match(JsDocToken.RC)) {
                    this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
                } else {
                    this.next();
                }
            }
            return typeNode;
        }
        return this.parseTypeExpression(token);
    }

    private Node parseParamTypeExpressionAnnotation(JsDocToken token) {
        Node typeNode;
        Preconditions.checkArgument((token == JsDocToken.LC ? 1 : 0) != 0);
        this.skipEOLs();
        boolean restArg = false;
        token = this.next();
        if (token == JsDocToken.ELLIPSIS) {
            token = this.next();
            if (token == JsDocToken.RC) {
                return this.wrapNode(305, IR.empty());
            }
            restArg = true;
        }
        if ((typeNode = this.parseTopLevelTypeExpression(token)) != null) {
            this.skipEOLs();
            if (restArg) {
                typeNode = this.wrapNode(305, typeNode);
            } else if (this.match(JsDocToken.EQUALS)) {
                this.next();
                this.skipEOLs();
                typeNode = this.wrapNode(307, typeNode);
            }
            if (!this.match(JsDocToken.RC)) {
                this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
            } else {
                this.next();
            }
        }
        return typeNode;
    }

    private Node parseTypeNameAnnotation(JsDocToken token) {
        if (token == JsDocToken.LC) {
            this.skipEOLs();
            Node typeNode = this.parseTypeName(this.next());
            if (typeNode != null) {
                this.skipEOLs();
                if (!this.match(JsDocToken.RC)) {
                    this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
                } else {
                    this.next();
                }
            }
            return typeNode;
        }
        return this.parseTypeName(token);
    }

    private Node parseTopLevelTypeExpression(JsDocToken token) {
        Node typeExpr = this.parseTypeExpression(token);
        if (typeExpr != null && this.match(JsDocToken.PIPE)) {
            this.next();
            if (this.match(JsDocToken.PIPE)) {
                this.next();
            }
            this.skipEOLs();
            token = this.next();
            return this.parseUnionTypeWithAlternate(token, typeExpr);
        }
        return typeExpr;
    }

    private Node parseTypeExpressionList(JsDocToken token) {
        Node typeExpr = this.parseTopLevelTypeExpression(token);
        if (typeExpr == null) {
            return null;
        }
        Node typeList = IR.block();
        typeList.addChildToBack(typeExpr);
        while (this.match(JsDocToken.COMMA)) {
            this.next();
            this.skipEOLs();
            typeExpr = this.parseTopLevelTypeExpression(this.next());
            if (typeExpr == null) {
                return null;
            }
            typeList.addChildToBack(typeExpr);
        }
        return typeList;
    }

    private Node parseTypeExpression(JsDocToken token) {
        if (token == JsDocToken.QMARK) {
            token = this.next();
            if (token == JsDocToken.COMMA || token == JsDocToken.EQUALS || token == JsDocToken.RB || token == JsDocToken.RC || token == JsDocToken.RP || token == JsDocToken.PIPE) {
                this.restoreLookAhead(token);
                return this.newNode(304);
            }
            return this.wrapNode(304, this.parseBasicTypeExpression(token));
        }
        if (token == JsDocToken.BANG) {
            return this.wrapNode(306, this.parseBasicTypeExpression(this.next()));
        }
        Node basicTypeExpr = this.parseBasicTypeExpression(token);
        if (basicTypeExpr != null) {
            if (this.match(JsDocToken.QMARK)) {
                this.next();
                return this.wrapNode(304, basicTypeExpr);
            }
            if (this.match(JsDocToken.BANG)) {
                this.next();
                return this.wrapNode(306, basicTypeExpr);
            }
        }
        return basicTypeExpr;
    }

    private Node parseBasicTypeExpression(JsDocToken token) {
        if (token == JsDocToken.STAR) {
            return this.newNode(302);
        }
        if (token == JsDocToken.LB) {
            this.skipEOLs();
            return this.parseArrayType(this.next());
        }
        if (token == JsDocToken.LC) {
            this.skipEOLs();
            return this.parseRecordType(this.next());
        }
        if (token == JsDocToken.LP) {
            this.skipEOLs();
            return this.parseUnionType(this.next());
        }
        if (token == JsDocToken.STRING) {
            String string = this.stream.getString();
            if ("function".equals(string)) {
                this.skipEOLs();
                return this.parseFunctionType(this.next());
            }
            if ("null".equals(string) || "undefined".equals(string)) {
                return this.newStringNode(string);
            }
            return this.parseTypeName(token);
        }
        this.restoreLookAhead(token);
        return this.reportGenericTypeSyntaxWarning();
    }

    private Node parseTypeName(JsDocToken token) {
        if (token != JsDocToken.STRING) {
            return this.reportGenericTypeSyntaxWarning();
        }
        String typeName = this.stream.getString();
        int lineno = this.stream.getLineno();
        int charno = this.stream.getCharno();
        while (this.match(JsDocToken.EOL) && typeName.charAt(typeName.length() - 1) == '.') {
            this.skipEOLs();
            if (!this.match(JsDocToken.STRING)) continue;
            this.next();
            typeName = typeName + this.stream.getString();
        }
        Node typeNameNode = this.newStringNode(typeName, lineno, charno);
        if (this.match(JsDocToken.LT)) {
            this.next();
            this.skipEOLs();
            Node memberType = this.parseTypeExpressionList(this.next());
            if (memberType != null) {
                typeNameNode.addChildToFront(memberType);
                this.skipEOLs();
                if (!this.match(JsDocToken.GT)) {
                    return this.reportTypeSyntaxWarning("msg.jsdoc.missing.gt");
                }
                this.next();
            }
        }
        return typeNameNode;
    }

    private Node parseFunctionType(JsDocToken token) {
        if (token != JsDocToken.LP) {
            this.restoreLookAhead(token);
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.lp");
        }
        Node functionType = this.newNode(105);
        Node parameters = null;
        this.skipEOLs();
        if (!this.match(JsDocToken.RP)) {
            token = this.next();
            boolean hasParams = true;
            if (token == JsDocToken.STRING) {
                String tokenStr = this.stream.getString();
                boolean isThis = "this".equals(tokenStr);
                boolean isNew = "new".equals(tokenStr);
                if (isThis || isNew) {
                    Node contextType;
                    if (this.match(JsDocToken.COLON)) {
                        this.next();
                        this.skipEOLs();
                        contextType = this.wrapNode(isThis ? 42 : 30, this.parseTypeName(this.next()));
                        if (contextType == null) {
                            return null;
                        }
                    } else {
                        return this.reportTypeSyntaxWarning("msg.jsdoc.missing.colon");
                    }
                    functionType.addChildToFront(contextType);
                    if (this.match(JsDocToken.COMMA)) {
                        this.next();
                        this.skipEOLs();
                        token = this.next();
                    } else {
                        hasParams = false;
                    }
                }
            }
            if (hasParams && (parameters = this.parseParametersType(token)) == null) {
                return null;
            }
        }
        if (parameters != null) {
            functionType.addChildToBack(parameters);
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.RP)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rp");
        }
        this.skipEOLs();
        Node resultType = this.parseResultType(this.next());
        if (resultType == null) {
            return null;
        }
        functionType.addChildToBack(resultType);
        return functionType;
    }

    private Node parseParametersType(JsDocToken token) {
        Node paramsType = this.newNode(83);
        boolean isVarArgs = false;
        Node paramType = null;
        if (token != JsDocToken.RP) {
            do {
                if (paramType != null) {
                    this.next();
                    this.skipEOLs();
                    token = this.next();
                }
                if (token == JsDocToken.ELLIPSIS) {
                    this.skipEOLs();
                    if (this.match(JsDocToken.RP)) {
                        paramType = this.newNode(305);
                    } else {
                        this.skipEOLs();
                        if (!this.match(JsDocToken.LB)) {
                            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.lb");
                        }
                        this.next();
                        this.skipEOLs();
                        paramType = this.wrapNode(305, this.parseTypeExpression(this.next()));
                        this.skipEOLs();
                        if (!this.match(JsDocToken.RB)) {
                            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rb");
                        }
                        this.skipEOLs();
                        this.next();
                    }
                    isVarArgs = true;
                } else {
                    paramType = this.parseTypeExpression(token);
                    if (this.match(JsDocToken.EQUALS)) {
                        this.skipEOLs();
                        this.next();
                        paramType = this.wrapNode(307, paramType);
                    }
                }
                if (paramType == null) {
                    return null;
                }
                paramsType.addChildToBack(paramType);
            } while (!isVarArgs && this.match(JsDocToken.COMMA));
        }
        if (isVarArgs && this.match(JsDocToken.COMMA)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.function.varargs");
        }
        return paramsType;
    }

    private Node parseResultType(JsDocToken token) {
        this.skipEOLs();
        if (!this.match(JsDocToken.COLON)) {
            return this.newNode(124);
        }
        token = this.next();
        this.skipEOLs();
        if (this.match(JsDocToken.STRING) && "void".equals(this.stream.getString())) {
            this.next();
            return this.newNode(122);
        }
        return this.parseTypeExpression(this.next());
    }

    private Node parseUnionType(JsDocToken token) {
        return this.parseUnionTypeWithAlternate(token, null);
    }

    private Node parseUnionTypeWithAlternate(JsDocToken token, Node alternate) {
        Node union = this.newNode(301);
        if (alternate != null) {
            union.addChildToBack(alternate);
        }
        Node expr = null;
        do {
            if (expr != null) {
                boolean isPipe;
                this.skipEOLs();
                token = this.next();
                Preconditions.checkState((token == JsDocToken.PIPE || token == JsDocToken.COMMA ? 1 : 0) != 0);
                boolean bl = isPipe = token == JsDocToken.PIPE;
                if (isPipe && this.match(JsDocToken.PIPE)) {
                    this.next();
                }
                this.skipEOLs();
                token = this.next();
            }
            if ((expr = this.parseTypeExpression(token)) == null) {
                return null;
            }
            union.addChildToBack(expr);
        } while (this.match(JsDocToken.PIPE, JsDocToken.COMMA));
        if (alternate == null) {
            this.skipEOLs();
            if (!this.match(JsDocToken.RP)) {
                return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rp");
            }
            this.next();
        }
        return union;
    }

    private Node parseArrayType(JsDocToken token) {
        Node array = this.newNode(308);
        Node arg = null;
        boolean hasVarArgs = false;
        do {
            if (arg != null) {
                this.next();
                this.skipEOLs();
                token = this.next();
            }
            if (token == JsDocToken.ELLIPSIS) {
                arg = this.wrapNode(305, this.parseTypeExpression(this.next()));
                hasVarArgs = true;
            } else {
                arg = this.parseTypeExpression(token);
            }
            if (arg == null) {
                return null;
            }
            array.addChildToBack(arg);
            if (hasVarArgs) break;
            this.skipEOLs();
        } while (this.match(JsDocToken.COMMA));
        if (!this.match(JsDocToken.RB)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rb");
        }
        this.next();
        return array;
    }

    private Node parseRecordType(JsDocToken token) {
        Node recordType = this.newNode(309);
        Node fieldTypeList = this.parseFieldTypeList(token);
        if (fieldTypeList == null) {
            return this.reportGenericTypeSyntaxWarning();
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.RC)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
        }
        this.next();
        recordType.addChildToBack(fieldTypeList);
        return recordType;
    }

    private Node parseFieldTypeList(JsDocToken token) {
        Node fieldTypeList = this.newNode(308);
        while (true) {
            Node fieldType;
            if ((fieldType = this.parseFieldType(token)) == null) {
                return null;
            }
            fieldTypeList.addChildToBack(fieldType);
            this.skipEOLs();
            if (!this.match(JsDocToken.COMMA)) break;
            this.next();
            this.skipEOLs();
            token = this.next();
        }
        return fieldTypeList;
    }

    private Node parseFieldType(JsDocToken token) {
        Node fieldName = this.parseFieldName(token);
        if (fieldName == null) {
            return null;
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.COLON)) {
            return fieldName;
        }
        this.next();
        this.skipEOLs();
        Node typeExpression = this.parseTypeExpression(this.next());
        if (typeExpression == null) {
            return null;
        }
        Node fieldType = this.newNode(310);
        fieldType.addChildToBack(fieldName);
        fieldType.addChildToBack(typeExpression);
        return fieldType;
    }

    private Node parseFieldName(JsDocToken token) {
        switch (token) {
            case STRING: {
                String string = this.stream.getString();
                return this.newStringNode(string);
            }
        }
        return null;
    }

    private Node wrapNode(int type, Node n) {
        return n == null ? null : new Node(type, n, this.stream.getLineno(), this.stream.getCharno()).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type) {
        return new Node(type, this.stream.getLineno(), this.stream.getCharno()).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(String s) {
        return this.newStringNode(s, this.stream.getLineno(), this.stream.getCharno());
    }

    private Node newStringNode(String s, int lineno, int charno) {
        Node n = Node.newString(s, lineno, charno).clonePropsFrom(this.templateNode);
        n.setLength(s.length());
        return n;
    }

    private Node createTemplateNode() {
        Node templateNode = IR.script(new Node[0]);
        templateNode.setStaticSourceFile(this.associatedNode != null ? this.associatedNode.getStaticSourceFile() : null);
        return templateNode;
    }

    private Node reportTypeSyntaxWarning(String warning) {
        this.parser.addTypeWarning(warning, this.stream.getLineno(), this.stream.getCharno());
        return null;
    }

    private Node reportGenericTypeSyntaxWarning() {
        return this.reportTypeSyntaxWarning("msg.jsdoc.type.syntax");
    }

    private JsDocToken eatTokensUntilEOL() {
        return this.eatTokensUntilEOL(this.next());
    }

    private JsDocToken eatTokensUntilEOL(JsDocToken token) {
        while (true) {
            if (token == JsDocToken.EOL || token == JsDocToken.EOC || token == JsDocToken.EOF) {
                this.state = State.SEARCHING_ANNOTATION;
                return token;
            }
            token = this.next();
        }
    }

    private void restoreLookAhead(JsDocToken token) {
        this.unreadToken = token;
    }

    private boolean match(JsDocToken token) {
        this.unreadToken = this.next();
        return this.unreadToken == token;
    }

    private boolean match(JsDocToken token1, JsDocToken token2) {
        this.unreadToken = this.next();
        return this.unreadToken == token1 || this.unreadToken == token2;
    }

    private JsDocToken next() {
        if (this.unreadToken == NO_UNREAD_TOKEN) {
            return this.stream.getJsDocToken();
        }
        return this.current();
    }

    private JsDocToken current() {
        JsDocToken t = this.unreadToken;
        this.unreadToken = NO_UNREAD_TOKEN;
        return t;
    }

    private void skipEOLs() {
        while (this.match(JsDocToken.EOL)) {
            this.next();
            if (!this.match(JsDocToken.STAR)) continue;
            this.next();
        }
    }

    private boolean hasParsedFileOverviewDocInfo() {
        return this.jsdocBuilder.isPopulatedWithFileOverview();
    }

    boolean hasParsedJSDocInfo() {
        return this.jsdocBuilder.isPopulated();
    }

    JSDocInfo retrieveAndResetParsedJSDocInfo() {
        return this.jsdocBuilder.build(this.associatedNode);
    }

    JSDocInfo getFileOverviewJSDocInfo() {
        return this.fileOverviewJSDocInfo;
    }

    private boolean lookAheadForTypeAnnotation() {
        int c;
        boolean matchedLc = false;
        while ((c = this.stream.getChar()) == 32) {
        }
        if (c == 123) {
            matchedLc = true;
        }
        this.stream.ungetChar(c);
        return matchedLc;
    }

    private static enum WhitespaceOption {
        PRESERVE,
        TRIM,
        SINGLE_LINE;

    }

    private static class ExtendedTypeInfo {
        final JSTypeExpression type;
        final int lineno;
        final int charno;

        public ExtendedTypeInfo(JSTypeExpression type, int lineno, int charno) {
            this.type = type;
            this.lineno = lineno;
            this.charno = charno;
        }
    }

    private static class ExtractionInfo {
        private final String string;
        private final JsDocToken token;

        public ExtractionInfo(String string, JsDocToken token) {
            this.string = string;
            this.token = token;
        }
    }

    private static enum State {
        SEARCHING_ANNOTATION,
        SEARCHING_NEWLINE,
        NEXT_IS_ANNOTATION;

    }

    private class ErrorReporterParser {
        private ErrorReporterParser() {
        }

        void addParserWarning(String messageId, String messageArg, int lineno, int charno) {
            JsDocInfoParser.this.errorReporter.warning(ScriptRuntime.getMessage1(messageId, messageArg), JsDocInfoParser.this.getSourceName(), lineno, null, charno);
        }

        void addParserWarning(String messageId, int lineno, int charno) {
            JsDocInfoParser.this.errorReporter.warning(ScriptRuntime.getMessage0(messageId), JsDocInfoParser.this.getSourceName(), lineno, null, charno);
        }

        void addTypeWarning(String messageId, String messageArg, int lineno, int charno) {
            JsDocInfoParser.this.errorReporter.warning("Bad type annotation. " + ScriptRuntime.getMessage1(messageId, messageArg), JsDocInfoParser.this.getSourceName(), lineno, null, charno);
        }

        void addTypeWarning(String messageId, int lineno, int charno) {
            JsDocInfoParser.this.errorReporter.warning("Bad type annotation. " + ScriptRuntime.getMessage0(messageId), JsDocInfoParser.this.getSourceName(), lineno, null, charno);
        }
    }
}

