/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.StaticScope;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class PrototypeObjectType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final Map<String, ObjectType.Property> properties = Maps.newTreeMap();
    private final boolean nativeType;
    private ObjectType implicitPrototypeFallback;
    private FunctionType ownerFunction = null;
    private boolean prettyPrint = false;
    private static final int MAX_PRETTY_PRINTED_PROPERTIES = 4;

    PrototypeObjectType(JSTypeRegistry registry, String className, ObjectType implicitPrototype) {
        this(registry, className, implicitPrototype, false);
    }

    PrototypeObjectType(JSTypeRegistry registry, String className, ObjectType implicitPrototype, boolean nativeType) {
        super(registry);
        this.className = className;
        this.nativeType = nativeType;
        if (nativeType || implicitPrototype != null) {
            this.setImplicitPrototype(implicitPrototype);
        } else {
            this.setImplicitPrototype(registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
        }
    }

    @Override
    public ObjectType.Property getSlot(String name) {
        ObjectType.Property prop;
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null && (prop = implicitPrototype.getSlot(name)) != null) {
            return prop;
        }
        for (ObjectType interfaceType : this.getCtorExtendedInterfaces()) {
            ObjectType.Property prop2 = interfaceType.getSlot(name);
            if (prop2 == null) continue;
            return prop2;
        }
        return null;
    }

    @Override
    public int getPropertiesCount() {
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype == null) {
            return this.properties.size();
        }
        int localCount = 0;
        for (String property : this.properties.keySet()) {
            if (implicitPrototype.hasProperty(property)) continue;
            ++localCount;
        }
        return implicitPrototype.getPropertiesCount() + localCount;
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.isUnknownType() || this.getSlot(propertyName) != null;
    }

    @Override
    public boolean hasOwnProperty(String propertyName) {
        return this.properties.get(propertyName) != null;
    }

    @Override
    public Set<String> getOwnPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public boolean isPropertyTypeDeclared(String property) {
        ObjectType.Property slot = this.getSlot(property);
        if (slot == null) {
            return false;
        }
        return !slot.isTypeInferred();
    }

    @Override
    void collectPropertyNames(Set<String> props) {
        for (String prop : this.properties.keySet()) {
            props.add(prop);
        }
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            implicitPrototype.collectPropertyNames(props);
        }
    }

    @Override
    public boolean isPropertyTypeInferred(String property) {
        ObjectType.Property slot = this.getSlot(property);
        if (slot == null) {
            return false;
        }
        return slot.isTypeInferred();
    }

    @Override
    public JSType getPropertyType(String property) {
        ObjectType.Property slot = this.getSlot(property);
        if (slot == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return (JSType)slot.getType();
    }

    @Override
    public boolean isPropertyInExterns(String propertyName) {
        ObjectType.Property p = this.properties.get(propertyName);
        if (p != null) {
            return p.isFromExterns();
        }
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            return implicitPrototype.isPropertyInExterns(propertyName);
        }
        return false;
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        if (this.hasOwnDeclaredProperty(name)) {
            return false;
        }
        ObjectType.Property newProp = new ObjectType.Property(name, type, inferred, propertyNode);
        ObjectType.Property oldProp = this.properties.get(name);
        if (oldProp != null) {
            newProp.setJSDocInfo(oldProp.getJSDocInfo());
        }
        this.properties.put(name, newProp);
        return true;
    }

    @Override
    public boolean removeProperty(String name) {
        return this.properties.remove(name) != null;
    }

    @Override
    public Node getPropertyNode(String propertyName) {
        ObjectType.Property p = this.properties.get(propertyName);
        if (p != null) {
            return p.getNode();
        }
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            return implicitPrototype.getPropertyNode(propertyName);
        }
        return null;
    }

    @Override
    public JSDocInfo getOwnPropertyJSDocInfo(String propertyName) {
        ObjectType.Property p = this.properties.get(propertyName);
        if (p != null) {
            return p.getJSDocInfo();
        }
        return null;
    }

    @Override
    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
        if (info != null) {
            ObjectType.Property property;
            if (!this.properties.containsKey(propertyName)) {
                this.defineInferredProperty(propertyName, this.getPropertyType(propertyName), null);
            }
            if ((property = this.properties.get(propertyName)) != null) {
                property.setJSDocInfo(info);
            }
        }
    }

    @Override
    public boolean matchesNumberContext() {
        return this.isNumberObjectType() || this.isDateType() || this.isBooleanObjectType() || this.isStringObjectType() || this.hasOverridenNativeProperty("valueOf");
    }

    @Override
    public boolean matchesStringContext() {
        return this.isTheObjectType() || this.isStringObjectType() || this.isDateType() || this.isRegexpType() || this.isArrayType() || this.isNumberObjectType() || this.isBooleanObjectType() || this.hasOverridenNativeProperty("toString");
    }

    private boolean hasOverridenNativeProperty(String propertyName) {
        if (this.isNativeObjectType()) {
            return false;
        }
        JSType propertyType = this.getPropertyType(propertyName);
        ObjectType nativeType = this.isFunctionType() ? this.registry.getNativeObjectType(JSTypeNative.FUNCTION_PROTOTYPE) : this.registry.getNativeObjectType(JSTypeNative.OBJECT_PROTOTYPE);
        JSType nativePropertyType = nativeType.getPropertyType(propertyName);
        return propertyType != nativePropertyType;
    }

    @Override
    public JSType unboxesTo() {
        if (this.isStringObjectType()) {
            return this.getNativeType(JSTypeNative.STRING_TYPE);
        }
        if (this.isBooleanObjectType()) {
            return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }
        if (this.isNumberObjectType()) {
            return this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }
        return super.unboxesTo();
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public boolean canBeCalled() {
        return this.isRegexpType();
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        if (this.hasReferenceName()) {
            return this.getReferenceName();
        }
        if (this.prettyPrint) {
            this.prettyPrint = false;
            TreeSet propertyNames = Sets.newTreeSet();
            for (ObjectType current = this; current != null && !((ObjectType)current).isNativeObjectType() && propertyNames.size() <= 4; current = ((ObjectType)current).getImplicitPrototype()) {
                propertyNames.addAll(((ObjectType)current).getOwnPropertyNames());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            int i = 0;
            for (String property : propertyNames) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(property);
                sb.append(": ");
                sb.append(this.getPropertyType(property).toStringHelper(forAnnotations));
                if (forAnnotations || ++i != 4) continue;
                sb.append(", ...");
                break;
            }
            sb.append("}");
            this.prettyPrint = true;
            return sb.toString();
        }
        return forAnnotations ? "?" : "{...}";
    }

    void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.implicitPrototypeFallback;
    }

    final void setImplicitPrototype(ObjectType implicitPrototype) {
        Preconditions.checkState((!this.hasCachedValues() ? 1 : 0) != 0);
        this.implicitPrototypeFallback = implicitPrototype;
    }

    @Override
    public String getReferenceName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.ownerFunction != null) {
            return this.ownerFunction.getReferenceName() + ".prototype";
        }
        return null;
    }

    @Override
    public boolean hasReferenceName() {
        return this.className != null || this.ownerFunction != null;
    }

    @Override
    public boolean isSubtype(JSType that) {
        FunctionType thatCtor;
        if (JSType.isSubtypeHelper(this, that)) {
            return true;
        }
        if (that.isUnionType()) {
            return false;
        }
        if (that.isRecordType()) {
            return RecordType.isSubtype(this, that.toMaybeRecordType());
        }
        ObjectType thatObj = that.toObjectType();
        FunctionType functionType = thatCtor = thatObj == null ? null : thatObj.getConstructor();
        if (thatCtor != null && ((JSType)thatCtor).isInterface()) {
            Iterable<ObjectType> thisInterfaces = this.getCtorImplementedInterfaces();
            for (ObjectType thisInterface : thisInterfaces) {
                if (!thisInterface.isSubtype(that)) continue;
                return true;
            }
        }
        if (this.getConstructor() != null && this.getConstructor().isInterface()) {
            for (ObjectType thisInterface : this.getCtorExtendedInterfaces()) {
                if (!thisInterface.isSubtype(that)) continue;
                return true;
            }
        }
        if (this.isUnknownType() || this.implicitPrototypeChainIsUnknown()) {
            return true;
        }
        return this.isImplicitPrototype(thatObj);
    }

    private boolean implicitPrototypeChainIsUnknown() {
        for (ObjectType p = this.getImplicitPrototype(); p != null; p = p.getImplicitPrototype()) {
            if (!p.isUnknownType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCachedValues() {
        return super.hasCachedValues();
    }

    @Override
    public boolean isNativeObjectType() {
        return this.nativeType;
    }

    void setOwnerFunction(FunctionType type) {
        Preconditions.checkState((this.ownerFunction == null || type == null ? 1 : 0) != 0);
        this.ownerFunction = type;
    }

    @Override
    public FunctionType getOwnerFunction() {
        return this.ownerFunction;
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.isFunctionPrototypeType() ? this.getOwnerFunction().getImplementedInterfaces() : ImmutableList.of();
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return this.isFunctionPrototypeType() ? this.getOwnerFunction().getExtendedInterfaces() : ImmutableList.of();
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        this.setResolvedTypeInternal(this);
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            this.implicitPrototypeFallback = (ObjectType)implicitPrototype.resolve(t, scope);
        }
        for (ObjectType.Property prop : this.properties.values()) {
            prop.setType(PrototypeObjectType.safeResolve(prop.getType(), t, scope));
        }
        return this;
    }

    @Override
    public void matchConstraint(ObjectType constraintObj) {
        if (constraintObj.isRecordType()) {
            for (String prop : constraintObj.getOwnPropertyNames()) {
                JSType propType = constraintObj.getPropertyType(prop);
                if (this.isPropertyTypeDeclared(prop)) continue;
                JSType typeToInfer = propType;
                if (!this.hasProperty(prop)) {
                    typeToInfer = this.getNativeType(JSTypeNative.VOID_TYPE).getLeastSupertype(propType);
                }
                this.defineInferredProperty(prop, typeToInfer, null);
            }
        }
    }
}

