/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class TypedScopeCreator
implements ScopeCreator {
    static final String DELEGATE_PROXY_SUFFIX = ObjectType.createDelegateSuffix("Proxy");
    static final DiagnosticType MALFORMED_TYPEDEF = DiagnosticType.warning("JSC_MALFORMED_TYPEDEF", "Typedef for {0} does not have any type information");
    static final DiagnosticType ENUM_INITIALIZER = DiagnosticType.warning("JSC_ENUM_INITIALIZER_NOT_ENUM", "enum initializer must be an object literal or an enum");
    static final DiagnosticType CTOR_INITIALIZER = DiagnosticType.warning("JSC_CTOR_INITIALIZER_NOT_CTOR", "Constructor {0} must be initialized at declaration");
    static final DiagnosticType IFACE_INITIALIZER = DiagnosticType.warning("JSC_IFACE_INITIALIZER_NOT_IFACE", "Interface {0} must be initialized at declaration");
    static final DiagnosticType CONSTRUCTOR_EXPECTED = DiagnosticType.warning("JSC_REFLECT_CONSTRUCTOR_EXPECTED", "Constructor expected as first argument");
    static final DiagnosticType UNKNOWN_LENDS = DiagnosticType.warning("JSC_UNKNOWN_LENDS", "Variable {0} not declared before @lends annotation.");
    static final DiagnosticType LENDS_ON_NON_OBJECT = DiagnosticType.warning("JSC_LENDS_ON_NON_OBJECT", "May only lend properties to object types. {0} has type {1}.");
    private final AbstractCompiler compiler;
    private final ErrorReporter typeParsingErrorReporter;
    private final TypeValidator validator;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private final List<ObjectType> delegateProxyPrototypes = Lists.newArrayList();
    private final Map<String, String> delegateCallingConventions = Maps.newHashMap();
    private final Map<Node, FunctionTypeBuilder.AstFunctionContents> functionAnalysisResults = Maps.newHashMap();

    TypedScopeCreator(AbstractCompiler compiler) {
        this(compiler, compiler.getCodingConvention());
    }

    TypedScopeCreator(AbstractCompiler compiler, CodingConvention codingConvention) {
        this.compiler = compiler;
        this.validator = compiler.getTypeValidator();
        this.codingConvention = codingConvention;
        this.typeRegistry = compiler.getTypeRegistry();
        this.typeParsingErrorReporter = this.typeRegistry.getErrorReporter();
    }

    @Override
    public Scope createScope(Node root, Scope parent) {
        Scope newScope = null;
        AbstractScopeBuilder scopeBuilder = null;
        if (parent == null) {
            new FirstOrderFunctionAnalyzer(this.compiler, this.functionAnalysisResults).process(root.getFirstChild(), root.getLastChild());
            newScope = this.createInitialScope(root);
            GlobalScopeBuilder globalScopeBuilder = new GlobalScopeBuilder(newScope);
            scopeBuilder = globalScopeBuilder;
            NodeTraversal.traverse(this.compiler, root, scopeBuilder);
        } else {
            newScope = new Scope(parent, root);
            LocalScopeBuilder localScopeBuilder = new LocalScopeBuilder(newScope);
            scopeBuilder = localScopeBuilder;
            localScopeBuilder.build();
        }
        scopeBuilder.resolveStubDeclarations();
        scopeBuilder.resolveTypes();
        for (Node functionNode : scopeBuilder.nonExternFunctions) {
            FunctionType fnType;
            ObjectType fnThisType;
            JSType type = functionNode.getJSType();
            if (type == null || !type.isFunctionType() || (fnThisType = (fnType = type.toMaybeFunctionType()).getTypeOfThis()).isUnknownType()) continue;
            Node node = functionNode.getLastChild();
            AbstractScopeBuilder abstractScopeBuilder = scopeBuilder;
            abstractScopeBuilder.getClass();
            NodeTraversal.traverse(this.compiler, node, abstractScopeBuilder.new AbstractScopeBuilder.CollectProperties(fnThisType));
        }
        if (parent == null) {
            this.codingConvention.defineDelegateProxyPrototypeProperties(this.typeRegistry, newScope, this.delegateProxyPrototypes, this.delegateCallingConventions);
        }
        return newScope;
    }

    void patchGlobalScope(Scope globalScope, Node scriptRoot) {
        Preconditions.checkState((boolean)scriptRoot.isScript());
        Preconditions.checkNotNull((Object)globalScope);
        Preconditions.checkState((boolean)globalScope.isGlobal());
        String scriptName = NodeUtil.getSourceName(scriptRoot);
        Preconditions.checkNotNull((Object)scriptName);
        for (Node node : ImmutableList.copyOf(this.functionAnalysisResults.keySet())) {
            if (!scriptName.equals(NodeUtil.getSourceName(node))) continue;
            this.functionAnalysisResults.remove(node);
        }
        new FirstOrderFunctionAnalyzer(this.compiler, this.functionAnalysisResults).process(null, scriptRoot);
        Iterator<Scope.Var> varIter = globalScope.getVars();
        ArrayList varsToRemove = Lists.newArrayList();
        while (varIter.hasNext()) {
            Scope.Var oldVar = varIter.next();
            if (!scriptName.equals(oldVar.getInputName())) continue;
            varsToRemove.add(oldVar);
        }
        for (Scope.Var var : varsToRemove) {
            globalScope.undeclare(var);
            globalScope.getTypeOfThis().removeProperty(var.getName());
        }
        GlobalScopeBuilder scopeBuilder = new GlobalScopeBuilder(globalScope);
        NodeTraversal.traverse(this.compiler, scriptRoot, scopeBuilder);
    }

    @VisibleForTesting
    Scope createInitialScope(Node root) {
        NodeTraversal.traverse(this.compiler, root, new DiscoverEnumsAndTypedefs(this.typeRegistry));
        Scope s = new Scope(root, this.compiler);
        this.declareNativeFunctionType(s, JSTypeNative.ARRAY_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.DATE_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.EVAL_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.FUNCTION_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.RANGE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.REGEXP_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.STRING_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.TYPE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.URI_ERROR_FUNCTION_TYPE);
        this.declareNativeValueType(s, "undefined", JSTypeNative.VOID_TYPE);
        this.declareNativeValueType(s, "ActiveXObject", JSTypeNative.NO_OBJECT_TYPE);
        return s;
    }

    private void declareNativeFunctionType(Scope scope, JSTypeNative tId) {
        FunctionType t = this.typeRegistry.getNativeFunctionType(tId);
        this.declareNativeType(scope, t.getInstanceType().getReferenceName(), t);
        this.declareNativeType(scope, t.getPrototype().getReferenceName(), t.getPrototype());
    }

    private void declareNativeValueType(Scope scope, String name, JSTypeNative tId) {
        this.declareNativeType(scope, name, this.typeRegistry.getNativeType(tId));
    }

    private void declareNativeType(Scope scope, String name, JSType t) {
        scope.declare(name, null, t, null, false);
    }

    private JSType getNativeType(JSTypeNative nativeType) {
        return this.typeRegistry.getNativeType(nativeType);
    }

    private FunctionTypeBuilder.AstFunctionContents getFunctionAnalysisResults(@Nullable Node n) {
        if (n == null) {
            return null;
        }
        return this.functionAnalysisResults.get(n);
    }

    private static class FirstOrderFunctionAnalyzer
    extends NodeTraversal.AbstractScopedCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final Map<Node, FunctionTypeBuilder.AstFunctionContents> data;

        FirstOrderFunctionAnalyzer(AbstractCompiler compiler, Map<Node, FunctionTypeBuilder.AstFunctionContents> outParam) {
            this.compiler = compiler;
            this.data = outParam;
        }

        @Override
        public void process(Node externs, Node root) {
            if (externs == null) {
                NodeTraversal.traverse(this.compiler, root, this);
            } else {
                NodeTraversal.traverseRoots(this.compiler, (List<Node>)ImmutableList.of((Object)externs, (Object)root), this);
            }
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (!t.inGlobalScope()) {
                Node n = t.getScopeRoot();
                this.data.put(n, new FunctionTypeBuilder.AstFunctionContents(n));
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (t.inGlobalScope()) {
                return;
            }
            if (n.isReturn() && n.getFirstChild() != null) {
                this.data.get(t.getScopeRoot()).recordNonEmptyReturn();
            }
            if (t.getScopeDepth() <= 2) {
                return;
            }
            if (n.isName() && NodeUtil.isLValue(n)) {
                Scope ownerScope;
                String name = n.getString();
                Scope scope = t.getScope();
                Scope.Var var = scope.getVar(name);
                if (var != null && scope != (ownerScope = var.getScope()) && ownerScope.isLocal()) {
                    this.data.get(ownerScope.getRootNode()).recordEscapedVarName(name);
                }
            } else if (n.isGetProp() && n.isUnscopedQualifiedName() && NodeUtil.isLValue(n)) {
                Scope ownerScope;
                String name = NodeUtil.getRootOfQualifiedName(n).getString();
                Scope scope = t.getScope();
                Scope.Var var = scope.getVar(name);
                if (var != null && scope != (ownerScope = var.getScope()) && ownerScope.isLocal()) {
                    this.data.get(ownerScope.getRootNode()).recordEscapedQualifiedName(n.getQualifiedName());
                }
            }
        }
    }

    private final class LocalScopeBuilder
    extends AbstractScopeBuilder {
        private LocalScopeBuilder(Scope scope) {
            super(scope);
        }

        void build() {
            NodeTraversal.traverse(TypedScopeCreator.this.compiler, this.scope.getRootNode(), this);
            FunctionTypeBuilder.AstFunctionContents contents = TypedScopeCreator.this.getFunctionAnalysisResults(this.scope.getRootNode());
            if (contents != null) {
                for (String varName : contents.getEscapedVarNames()) {
                    Scope.Var v = this.scope.getVar(varName);
                    Preconditions.checkState((v.getScope() == this.scope ? 1 : 0) != 0);
                    v.markEscaped();
                }
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n == this.scope.getRootNode()) {
                return;
            }
            if (n.isParamList() && parent == this.scope.getRootNode()) {
                this.handleFunctionInputs(parent);
                return;
            }
            super.visit(t, n, parent);
        }

        private void handleFunctionInputs(Node fnNode) {
            Scope.Var fnVar;
            Node fnNameNode = fnNode.getFirstChild();
            String fnName = fnNameNode.getString();
            if (!fnName.isEmpty() && ((fnVar = this.scope.getVar(fnName)) == null || fnVar.getNameNode() != null && fnVar.getInitialValue() != fnNode)) {
                this.defineSlot(fnNameNode, fnNode, fnNode.getJSType(), false);
            }
            this.declareArguments(fnNode);
        }

        private void declareArguments(Node functionNode) {
            Node jsDocParameters;
            Node astParameters = functionNode.getFirstChild().getNext();
            Node body = astParameters.getNext();
            FunctionType functionType = JSType.toMaybeFunctionType(functionNode.getJSType());
            if (functionType != null && (jsDocParameters = functionType.getParametersNode()) != null) {
                Node jsDocParameter = jsDocParameters.getFirstChild();
                for (Node astParameter : astParameters.children()) {
                    if (jsDocParameter != null) {
                        this.defineSlot(astParameter, functionNode, jsDocParameter.getJSType(), false);
                        jsDocParameter = jsDocParameter.getNext();
                        continue;
                    }
                    this.defineSlot(astParameter, functionNode, null, true);
                }
            }
        }
    }

    private final class GlobalScopeBuilder
    extends AbstractScopeBuilder {
        private GlobalScopeBuilder(Scope scope) {
            super(scope);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            super.visit(t, n, parent);
            switch (n.getType()) {
                case 118: {
                    if (!n.hasOneChild()) break;
                    this.checkForTypedef(t, n.getFirstChild(), n.getJSDocInfo());
                }
            }
        }

        @Override
        void maybeDeclareQualifiedName(NodeTraversal t, JSDocInfo info, Node n, Node parent, Node rhsValue) {
            this.checkForTypedef(t, n, info);
            super.maybeDeclareQualifiedName(t, info, n, parent, rhsValue);
        }

        private void checkForTypedef(NodeTraversal t, Node candidate, JSDocInfo info) {
            if (info == null || !info.hasTypedefType()) {
                return;
            }
            String typedef = candidate.getQualifiedName();
            if (typedef == null) {
                return;
            }
            TypedScopeCreator.this.typeRegistry.declareType(typedef, TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            JSType realType = info.getTypedefType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
            if (realType == null) {
                TypedScopeCreator.this.compiler.report(JSError.make(t.getSourceName(), candidate, MALFORMED_TYPEDEF, typedef));
            }
            TypedScopeCreator.this.typeRegistry.overwriteDeclaredType(typedef, realType);
            if (candidate.isGetProp()) {
                this.defineSlot(candidate, candidate.getParent(), TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE), false);
            }
        }
    }

    private static final class StubDeclaration {
        private final Node node;
        private final boolean isExtern;
        private final String ownerName;

        private StubDeclaration(Node node, boolean isExtern, String ownerName) {
            this.node = node;
            this.isExtern = isExtern;
            this.ownerName = ownerName;
        }
    }

    private abstract class AbstractScopeBuilder
    implements NodeTraversal.Callback {
        final Scope scope;
        private final List<DeferredSetType> deferredSetTypes = Lists.newArrayList();
        private final List<Node> nonExternFunctions = Lists.newArrayList();
        private List<Node> lentObjectLiterals = null;
        private final List<StubDeclaration> stubDeclarations = Lists.newArrayList();
        private String sourceName = null;
        private InputId inputId;

        private AbstractScopeBuilder(Scope scope) {
            this.scope = scope;
        }

        void setDeferredType(Node node, JSType type) {
            this.deferredSetTypes.add(new DeferredSetType(node, type));
        }

        void resolveTypes() {
            for (DeferredSetType deferred : this.deferredSetTypes) {
                deferred.resolve(this.scope);
            }
            Iterator<Scope.Var> vars = this.scope.getVars();
            while (vars.hasNext()) {
                vars.next().resolveType(TypedScopeCreator.this.typeParsingErrorReporter);
            }
            TypedScopeCreator.this.typeRegistry.resolveTypesInScope(this.scope);
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            boolean descend;
            this.inputId = t.getInputId();
            if (n.isFunction() || n.isScript()) {
                Preconditions.checkNotNull((Object)this.inputId);
                this.sourceName = NodeUtil.getSourceName(n);
            }
            boolean bl = descend = parent == null || !parent.isFunction() || n == parent.getFirstChild() || parent == this.scope.getRootNode();
            if (descend && NodeUtil.isStatementParent(n)) {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (!NodeUtil.isHoistedFunctionDeclaration(child)) continue;
                    this.defineFunctionLiteral(child, n);
                }
            }
            return descend;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            this.inputId = t.getInputId();
            this.attachLiteralTypes(t, n);
            switch (n.getType()) {
                case 37: {
                    this.checkForClassDefiningCalls(t, n, parent);
                    this.checkForCallingConventionDefiningCalls(n, TypedScopeCreator.this.delegateCallingConventions);
                    break;
                }
                case 105: {
                    if (t.getInput() == null || !t.getInput().isExtern()) {
                        this.nonExternFunctions.add(n);
                    }
                    if (NodeUtil.isHoistedFunctionDeclaration(n)) break;
                    this.defineFunctionLiteral(n, parent);
                    break;
                }
                case 86: {
                    Node firstChild = n.getFirstChild();
                    if (!firstChild.isGetProp() || !firstChild.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(t, n.getJSDocInfo(), firstChild, n, firstChild.getNext());
                    break;
                }
                case 120: {
                    this.defineCatch(n, parent);
                    break;
                }
                case 118: {
                    this.defineVar(n, parent);
                    break;
                }
                case 33: {
                    if (!parent.isExprResult() || !n.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(t, n.getJSDocInfo(), n, parent, null);
                }
            }
            if (n.getParent() != null && NodeUtil.isStatement(n) && this.lentObjectLiterals != null) {
                for (Node objLit : this.lentObjectLiterals) {
                    this.defineObjectLiteral(objLit);
                }
                this.lentObjectLiterals.clear();
            }
        }

        private void attachLiteralTypes(NodeTraversal t, Node n) {
            switch (n.getType()) {
                case 41: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NULL_TYPE));
                    break;
                }
                case 122: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.VOID_TYPE));
                    break;
                }
                case 40: {
                    if (NodeUtil.isObjectLitKey(n, n.getParent())) break;
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.STRING_TYPE));
                    break;
                }
                case 39: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NUMBER_TYPE));
                    break;
                }
                case 43: 
                case 44: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                    break;
                }
                case 47: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.REGEXP_TYPE));
                    break;
                }
                case 64: {
                    JSDocInfo info = n.getJSDocInfo();
                    if (info != null && info.getLendsName() != null) {
                        if (this.lentObjectLiterals == null) {
                            this.lentObjectLiterals = Lists.newArrayList();
                        }
                        this.lentObjectLiterals.add(n);
                        break;
                    }
                    this.defineObjectLiteral(n);
                }
            }
        }

        private void defineObjectLiteral(Node objectLit) {
            JSType type = null;
            JSDocInfo info = objectLit.getJSDocInfo();
            if (info != null && info.getLendsName() != null) {
                String lendsName = info.getLendsName();
                Scope.Var lendsVar = this.scope.getVar(lendsName);
                if (lendsVar == null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, objectLit, UNKNOWN_LENDS, lendsName));
                } else {
                    type = lendsVar.getType();
                    if (type == null) {
                        type = TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                    }
                    if (!type.isSubtype(TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                        TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, objectLit, LENDS_ON_NON_OBJECT, lendsName, type.toString()));
                        type = null;
                    } else {
                        objectLit.setJSType(type);
                    }
                }
            }
            info = NodeUtil.getBestJSDocInfo(objectLit);
            Node lValue = NodeUtil.getBestLValue(objectLit);
            String lValueName = NodeUtil.getBestLValueName(lValue);
            boolean createdEnumType = false;
            if (info != null && info.hasEnumParameterType()) {
                type = this.createEnumTypeFromNodes(objectLit, lValueName, info, lValue);
                createdEnumType = true;
            }
            if (type == null) {
                type = TypedScopeCreator.this.typeRegistry.createAnonymousObjectType();
            }
            this.setDeferredType(objectLit, type);
            this.processObjectLitProperties(objectLit, ObjectType.cast(objectLit.getJSType()), !createdEnumType);
        }

        void processObjectLitProperties(Node objLit, ObjectType objLitType, boolean declareOnOwner) {
            for (Node keyNode = objLit.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
                Node value = keyNode.getFirstChild();
                String memberName = NodeUtil.getObjectLitKeyName(keyNode);
                JSDocInfo info = keyNode.getJSDocInfo();
                JSType valueType = this.getDeclaredType(keyNode.getSourceFileName(), info, keyNode, value);
                JSType keyType = objLitType.isEnumType() ? objLitType.toMaybeEnumType().getElementsType() : NodeUtil.getObjectLitKeyTypeFromValueType(keyNode, valueType);
                String qualifiedName = NodeUtil.getBestLValueName(keyNode);
                if (qualifiedName != null) {
                    boolean inferred = keyType == null;
                    this.defineSlot(keyNode, objLit, qualifiedName, keyType, inferred);
                } else if (keyType != null) {
                    this.setDeferredType(keyNode, keyType);
                }
                if (keyType == null || objLitType == null || !declareOnOwner) continue;
                boolean isExtern = keyNode.isFromExterns();
                objLitType.defineDeclaredProperty(memberName, keyType, keyNode);
            }
        }

        private JSType getDeclaredTypeInAnnotation(String sourceName, Node node, JSDocInfo info) {
            Node objNode;
            JSType jsType = null;
            Node node2 = node.isGetProp() ? node.getFirstChild() : (objNode = NodeUtil.isObjectLitKey(node, node.getParent()) ? node.getParent() : null);
            if (info != null) {
                if (info.hasType()) {
                    jsType = info.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                } else if (FunctionTypeBuilder.isFunctionTypeDeclaration(info)) {
                    String fnName = node.getQualifiedName();
                    jsType = this.createFunctionTypeFromNodes(null, fnName, info, node);
                }
            }
            return jsType;
        }

        void assertDefinitionNode(Node n, int type) {
            Preconditions.checkState((this.sourceName != null ? 1 : 0) != 0);
            Preconditions.checkState((n.getType() == type ? 1 : 0) != 0);
        }

        void defineCatch(Node n, Node parent) {
            this.assertDefinitionNode(n, 120);
            Node catchName = n.getFirstChild();
            this.defineSlot(catchName, n, null);
        }

        void defineVar(Node n, Node parent) {
            this.assertDefinitionNode(n, 118);
            JSDocInfo info = n.getJSDocInfo();
            if (n.hasMoreThanOneChild()) {
                if (info != null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, n, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
                }
                for (Node name : n.children()) {
                    this.defineName(name, n, parent, name.getJSDocInfo());
                }
            } else {
                Node name = n.getFirstChild();
                this.defineName(name, n, parent, info != null ? info : name.getJSDocInfo());
            }
        }

        void defineFunctionLiteral(Node n, Node parent) {
            this.assertDefinitionNode(n, 105);
            Node lValue = NodeUtil.getBestLValue(n);
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            String functionName = NodeUtil.getBestLValueName(lValue);
            FunctionType functionType = this.createFunctionTypeFromNodes(n, functionName, info, lValue);
            this.setDeferredType(n, functionType);
            if (NodeUtil.isFunctionDeclaration(n)) {
                this.defineSlot(n.getFirstChild(), n, functionType);
            }
        }

        private void defineName(Node name, Node var, Node parent, JSDocInfo info) {
            Node value = name.getFirstChild();
            JSType type = this.getDeclaredType(this.sourceName, info, name, value);
            if (type == null) {
                type = name.isFromExterns() ? TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : null;
            }
            this.defineSlot(name, var, type);
        }

        private boolean shouldUseFunctionLiteralType(FunctionType type, JSDocInfo info, Node lValue) {
            if (info != null) {
                return true;
            }
            if (lValue != null && NodeUtil.isObjectLitKey(lValue, lValue.getParent())) {
                return false;
            }
            return this.scope.isGlobal() || !type.isReturnTypeInferred();
        }

        private FunctionType createFunctionTypeFromNodes(@Nullable Node rValue, @Nullable String name, @Nullable JSDocInfo info, @Nullable Node lvalueNode) {
            FunctionType aliasedType;
            Scope.Var var;
            FunctionType functionType = null;
            if (rValue != null && rValue.isQualifiedName() && this.scope.isGlobal() && (var = this.scope.getVar(rValue.getQualifiedName())) != null && var.getType() != null && var.getType().isFunctionType() && ((aliasedType = var.getType().toMaybeFunctionType()).isConstructor() || aliasedType.isInterface()) && !aliasedType.isNativeObjectType()) {
                functionType = aliasedType;
                if (name != null && this.scope.isGlobal()) {
                    TypedScopeCreator.this.typeRegistry.declareType(name, functionType.getInstanceType());
                }
            }
            if (functionType == null) {
                Node fnBlock;
                Node errorRoot = rValue == null ? lvalueNode : rValue;
                boolean isFnLiteral = rValue != null && rValue.isFunction();
                Node fnRoot = isFnLiteral ? rValue : null;
                Node parametersNode = isFnLiteral ? rValue.getFirstChild().getNext() : null;
                Node node = fnBlock = isFnLiteral ? parametersNode.getNext() : null;
                if (info != null && info.hasType()) {
                    JSType type = info.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                    if ((type = type.restrictByNotNullOrUndefined()).isFunctionType()) {
                        functionType = type.toMaybeFunctionType();
                        functionType.setJSDocInfo(info);
                    }
                }
                if (functionType == null) {
                    Node ownerNode = NodeUtil.getBestLValueOwner(lvalueNode);
                    String ownerName = NodeUtil.getBestLValueName(ownerNode);
                    Scope.Var ownerVar = null;
                    String propName = null;
                    ObjectType ownerType = null;
                    if (ownerName != null) {
                        ownerVar = this.scope.getVar(ownerName);
                        if (ownerVar != null) {
                            ownerType = ObjectType.cast(ownerVar.getType());
                        }
                        if (name != null) {
                            propName = name.substring(ownerName.length() + 1);
                        }
                    }
                    FunctionType overriddenPropType = null;
                    if (ownerType != null && propName != null) {
                        overriddenPropType = this.findOverriddenFunction(ownerType, propName);
                    }
                    FunctionTypeBuilder builder = new FunctionTypeBuilder(name, TypedScopeCreator.this.compiler, errorRoot, this.sourceName, this.scope).setContents(TypedScopeCreator.this.getFunctionAnalysisResults(fnRoot)).inferFromOverriddenFunction(overriddenPropType, parametersNode).inferTemplateTypeName(info).inferReturnType(info).inferInheritance(info);
                    boolean searchedForThisType = false;
                    if (ownerType != null && ownerType.isFunctionPrototypeType()) {
                        builder.inferThisType(info, ownerType.getOwnerFunction().getInstanceType());
                        searchedForThisType = true;
                    } else if (ownerNode != null && ownerNode.isThis()) {
                        builder.inferThisType(info, ownerNode.getJSType());
                        searchedForThisType = true;
                    }
                    if (!searchedForThisType) {
                        builder.inferThisType(info);
                    }
                    functionType = builder.inferParameterTypes(parametersNode, info).buildAndRegister();
                }
            }
            return functionType;
        }

        private FunctionType findOverriddenFunction(ObjectType ownerType, String propName) {
            JSType propType = ownerType.getPropertyType(propName);
            if (propType != null && propType.isFunctionType()) {
                return propType.toMaybeFunctionType();
            }
            for (ObjectType iface : ownerType.getCtorImplementedInterfaces()) {
                propType = iface.getPropertyType(propName);
                if (propType == null || !propType.isFunctionType()) continue;
                return propType.toMaybeFunctionType();
            }
            return null;
        }

        private EnumType createEnumTypeFromNodes(Node rValue, String name, JSDocInfo info, Node lValueNode) {
            Scope.Var var;
            Preconditions.checkNotNull((Object)info);
            Preconditions.checkState((boolean)info.hasEnumParameterType());
            EnumType enumType = null;
            if (rValue != null && rValue.isQualifiedName() && (var = this.scope.getVar(rValue.getQualifiedName())) != null && var.getType() instanceof EnumType) {
                enumType = (EnumType)var.getType();
            }
            if (enumType == null) {
                JSType elementsType = info.getEnumParameterType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                enumType = TypedScopeCreator.this.typeRegistry.createEnumType(name, rValue, elementsType);
                if (rValue != null && rValue.isObjectLit()) {
                    for (Node key = rValue.getFirstChild(); key != null; key = key.getNext()) {
                        String keyName = NodeUtil.getStringValue(key);
                        if (keyName == null) {
                            TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, key, TypeCheck.ENUM_NOT_CONSTANT, keyName));
                            continue;
                        }
                        if (!TypedScopeCreator.this.codingConvention.isValidEnumKey(keyName)) {
                            TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, key, TypeCheck.ENUM_NOT_CONSTANT, keyName));
                            continue;
                        }
                        enumType.defineElement(keyName, key);
                    }
                }
            }
            if (name != null && this.scope.isGlobal()) {
                TypedScopeCreator.this.typeRegistry.declareType(name, enumType.getElementsType());
            }
            return enumType;
        }

        private void defineSlot(Node name, Node parent, JSType type) {
            this.defineSlot(name, parent, type, type == null);
        }

        void defineSlot(Node n, Node parent, JSType type, boolean inferred) {
            Preconditions.checkArgument((inferred || type != null ? 1 : 0) != 0);
            if (n.isName()) {
                Preconditions.checkArgument((parent.isFunction() || parent.isVar() || parent.isParamList() || parent.isCatch() ? 1 : 0) != 0);
            } else {
                Preconditions.checkArgument((n.isGetProp() && (parent.isAssign() || parent.isExprResult()) ? 1 : 0) != 0);
            }
            this.defineSlot(n, parent, n.getQualifiedName(), type, inferred);
        }

        void defineSlot(Node n, Node parent, String variableName, JSType type, boolean inferred) {
            Scope globalScope;
            Preconditions.checkArgument((!variableName.isEmpty() ? 1 : 0) != 0);
            boolean isGlobalVar = n.isName() && this.scope.isGlobal();
            boolean shouldDeclareOnGlobalThis = isGlobalVar && (parent.isVar() || parent.isFunction());
            Scope scopeToDeclareIn = this.scope;
            if (n.isGetProp() && !this.scope.isGlobal() && this.isQnameRootedInGlobalScope(n) && !(globalScope = this.scope.getGlobalScope()).isDeclared(variableName, false)) {
                scopeToDeclareIn = this.scope.getGlobalScope();
            }
            boolean isExtern = n.isFromExterns();
            Scope.Var newVar = null;
            CompilerInput input = TypedScopeCreator.this.compiler.getInput(this.inputId);
            if (scopeToDeclareIn.isDeclared(variableName, false)) {
                Scope.Var oldVar = scopeToDeclareIn.getVar(variableName);
                newVar = TypedScopeCreator.this.validator.expectUndeclaredVariable(this.sourceName, input, n, parent, oldVar, variableName, type);
            } else {
                if (!inferred) {
                    this.setDeferredType(n, type);
                }
                newVar = scopeToDeclareIn.declare(variableName, n, type, input, inferred);
                if (type instanceof EnumType) {
                    boolean isValidValue;
                    Node initialValue = newVar.getInitialValue();
                    boolean bl = isValidValue = initialValue != null && (initialValue.isObjectLit() || initialValue.isQualifiedName());
                    if (!isValidValue) {
                        TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, n, ENUM_INITIALIZER, new String[0]));
                    }
                }
            }
            FunctionType fnType = JSType.toMaybeFunctionType(type);
            if (fnType != null && !type.isEmptyType() && (fnType.isConstructor() || fnType.isInterface()) && !fnType.equals(TypedScopeCreator.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE))) {
                FunctionType superClassCtor = fnType.getSuperClassConstructor();
                ObjectType.Property prototypeSlot = fnType.getSlot("prototype");
                prototypeSlot.setNode(n);
                String prototypeName = variableName + ".prototype";
                Scope.Var prototypeVar = scopeToDeclareIn.getVar(prototypeName);
                if (prototypeVar != null && prototypeVar.scope == scopeToDeclareIn) {
                    scopeToDeclareIn.undeclare(prototypeVar);
                }
                scopeToDeclareIn.declare(prototypeName, n, prototypeSlot.getType(), input, superClassCtor == null || superClassCtor.getInstanceType().equals(TypedScopeCreator.this.getNativeType(JSTypeNative.OBJECT_TYPE)));
                if (newVar.getInitialValue() == null && !isExtern && variableName.equals(fnType.getInstanceType().getReferenceName())) {
                    TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, n, fnType.isConstructor() ? CTOR_INITIALIZER : IFACE_INITIALIZER, variableName));
                }
            }
            if (shouldDeclareOnGlobalThis) {
                ObjectType globalThis = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS);
                if (inferred) {
                    globalThis.defineInferredProperty(variableName, type == null ? TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE) : type, n);
                } else {
                    globalThis.defineDeclaredProperty(variableName, type, n);
                }
            }
            if (isGlobalVar && "Window".equals(variableName) && type != null && type.isFunctionType() && type.isConstructor()) {
                FunctionType globalThisCtor = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS).getConstructor();
                globalThisCtor.getInstanceType().clearCachedValues();
                globalThisCtor.getPrototype().clearCachedValues();
                globalThisCtor.setPrototypeBasedOn(type.toMaybeFunctionType().getInstanceType());
            }
        }

        private boolean isQnameRootedInGlobalScope(Node n) {
            Scope scope = this.getQnameRootScope(n);
            return scope != null && scope.isGlobal();
        }

        private Scope getQnameRootScope(Node n) {
            Scope.Var var;
            Node root = NodeUtil.getRootOfQualifiedName(n);
            if (root.isName() && (var = this.scope.getVar(root.getString())) != null) {
                return var.getScope();
            }
            return null;
        }

        private JSType getDeclaredType(String sourceName, JSDocInfo info, Node lValue, @Nullable Node rValue) {
            if (info != null && info.hasType()) {
                return this.getDeclaredTypeInAnnotation(sourceName, lValue, info);
            }
            if (rValue != null && rValue.isFunction() && this.shouldUseFunctionLiteralType(JSType.toMaybeFunctionType(rValue.getJSType()), info, lValue)) {
                return rValue.getJSType();
            }
            if (info != null) {
                if (info.hasEnumParameterType()) {
                    if (rValue != null && rValue.isObjectLit()) {
                        return rValue.getJSType();
                    }
                    return this.createEnumTypeFromNodes(rValue, lValue.getQualifiedName(), info, lValue);
                }
                if (info.isConstructor() || info.isInterface()) {
                    return this.createFunctionTypeFromNodes(rValue, lValue.getQualifiedName(), info, lValue);
                }
                if (info.isConstant()) {
                    Object knownType = null;
                    if (rValue != null) {
                        if (rValue.getJSType() != null && !rValue.getJSType().isUnknownType()) {
                            return rValue.getJSType();
                        }
                        if (rValue.isOr()) {
                            boolean namesMatch;
                            Node firstClause = rValue.getFirstChild();
                            Node secondClause = firstClause.getNext();
                            boolean bl = namesMatch = firstClause.isName() && lValue.isName() && firstClause.getString().equals(lValue.getString());
                            if (namesMatch && secondClause.getJSType() != null && !secondClause.getJSType().isUnknownType()) {
                                return secondClause.getJSType();
                            }
                        }
                    }
                }
            }
            return this.getDeclaredTypeInAnnotation(sourceName, lValue, info);
        }

        private FunctionType getFunctionType(@Nullable Scope.Var v) {
            JSType t = v == null ? null : v.getType();
            ObjectType o = t == null ? null : t.dereference();
            return JSType.toMaybeFunctionType(o);
        }

        private void checkForCallingConventionDefiningCalls(Node n, Map<String, String> delegateCallingConventions) {
            TypedScopeCreator.this.codingConvention.checkForCallingConventionDefiningCalls(n, delegateCallingConventions);
        }

        private void checkForClassDefiningCalls(NodeTraversal t, Node n, Node parent) {
            CodingConvention.ObjectLiteralCast objectLiteralCast;
            CodingConvention.DelegateRelationship delegateRelationship;
            FunctionType functionType;
            ObjectType objectType;
            String singletonGetterClassName;
            CodingConvention.SubclassRelationship relationship = TypedScopeCreator.this.codingConvention.getClassesDefinedByCall(n);
            if (relationship != null) {
                FunctionType superCtor = this.getFunctionType(this.scope.getVar(relationship.superclassName));
                FunctionType subCtor = this.getFunctionType(this.scope.getVar(relationship.subclassName));
                if (superCtor != null && superCtor.isConstructor() && subCtor != null && subCtor.isConstructor()) {
                    ObjectType superClass = superCtor.getInstanceType();
                    ObjectType subClass = subCtor.getInstanceType();
                    superCtor = superClass.getConstructor();
                    subCtor = subClass.getConstructor();
                    if (relationship.type == CodingConvention.SubclassType.INHERITS && !superClass.isEmptyType() && !subClass.isEmptyType()) {
                        TypedScopeCreator.this.validator.expectSuperType(t, n, superClass, subClass);
                    }
                    if (superCtor != null && subCtor != null) {
                        TypedScopeCreator.this.codingConvention.applySubclassRelationship(superCtor, subCtor, relationship.type);
                    }
                }
            }
            if ((singletonGetterClassName = TypedScopeCreator.this.codingConvention.getSingletonGetterClassName(n)) != null && (objectType = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(singletonGetterClassName))) != null && (functionType = objectType.getConstructor()) != null) {
                FunctionType getterType = TypedScopeCreator.this.typeRegistry.createFunctionType((JSType)objectType, new JSType[0]);
                TypedScopeCreator.this.codingConvention.applySingletonGetter(functionType, getterType, objectType);
            }
            if ((delegateRelationship = TypedScopeCreator.this.codingConvention.getDelegateRelationship(n)) != null) {
                this.applyDelegateRelationship(delegateRelationship);
            }
            if ((objectLiteralCast = TypedScopeCreator.this.codingConvention.getObjectLiteralCast(n)) != null) {
                if (objectLiteralCast.diagnosticType == null) {
                    ObjectType type = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(objectLiteralCast.typeName));
                    if (type != null && type.getConstructor() != null) {
                        this.setDeferredType(objectLiteralCast.objectNode, type);
                    } else {
                        TypedScopeCreator.this.compiler.report(JSError.make(t.getSourceName(), n, CONSTRUCTOR_EXPECTED, new String[0]));
                    }
                } else {
                    TypedScopeCreator.this.compiler.report(JSError.make(t.getSourceName(), n, objectLiteralCast.diagnosticType, new String[0]));
                }
            }
        }

        private void applyDelegateRelationship(CodingConvention.DelegateRelationship delegateRelationship) {
            ObjectType delegatorObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegator));
            ObjectType delegateBaseObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegateBase));
            ObjectType delegateSuperObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(TypedScopeCreator.this.codingConvention.getDelegateSuperclassName()));
            if (delegatorObject != null && delegateBaseObject != null && delegateSuperObject != null) {
                FunctionType delegatorCtor = delegatorObject.getConstructor();
                FunctionType delegateBaseCtor = delegateBaseObject.getConstructor();
                FunctionType delegateSuperCtor = delegateSuperObject.getConstructor();
                if (delegatorCtor != null && delegateBaseCtor != null && delegateSuperCtor != null) {
                    FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(TypedScopeCreator.this.typeRegistry);
                    functionParamBuilder.addRequiredParams(TypedScopeCreator.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE));
                    FunctionType findDelegate = TypedScopeCreator.this.typeRegistry.createFunctionType(TypedScopeCreator.this.typeRegistry.createDefaultObjectUnion(delegateBaseObject), functionParamBuilder.build());
                    FunctionType delegateProxy = TypedScopeCreator.this.typeRegistry.createConstructorType(delegateBaseObject.getReferenceName() + DELEGATE_PROXY_SUFFIX, null, null, null);
                    delegateProxy.setPrototypeBasedOn(delegateBaseObject);
                    TypedScopeCreator.this.codingConvention.applyDelegateRelationship(delegateSuperObject, delegateBaseObject, delegatorObject, delegateProxy, findDelegate);
                    TypedScopeCreator.this.delegateProxyPrototypes.add(delegateProxy.getPrototype());
                }
            }
        }

        void maybeDeclareQualifiedName(NodeTraversal t, JSDocInfo info, Node n, Node parent, Node rhsValue) {
            ObjectType ownerType;
            Scope.Var qVar;
            Node ownerNode = n.getFirstChild();
            String ownerName = ownerNode.getQualifiedName();
            String qName = n.getQualifiedName();
            String propName = n.getLastChild().getString();
            Preconditions.checkArgument((qName != null && ownerName != null ? 1 : 0) != 0);
            JSType valueType = this.getDeclaredType(t.getSourceName(), info, n, rhsValue);
            if (valueType == null && rhsValue != null) {
                valueType = rhsValue.getJSType();
            }
            if ("prototype".equals(propName) && (qVar = this.scope.getVar(qName)) != null) {
                ObjectType qVarType = ObjectType.cast(qVar.getType());
                if (qVarType != null && rhsValue != null && rhsValue.isObjectLit()) {
                    TypedScopeCreator.this.typeRegistry.resetImplicitPrototype(rhsValue.getJSType(), qVarType.getImplicitPrototype());
                } else if (!qVar.isTypeInferred()) {
                    return;
                }
                if (qVar.getScope() == this.scope) {
                    this.scope.undeclare(qVar);
                }
            }
            if (valueType == null) {
                if (parent.isExprResult()) {
                    this.stubDeclarations.add(new StubDeclaration(n, t.getInput() != null && t.getInput().isExtern(), ownerName));
                }
                return;
            }
            boolean inferred = this.isQualifiedNameInferred(qName, n, info, rhsValue, valueType);
            if (!inferred) {
                ownerType = this.getObjectSlot(ownerName);
                if (ownerType != null) {
                    boolean isExtern;
                    boolean bl = isExtern = t.getInput() != null && t.getInput().isExtern();
                    if (!(ownerType.hasOwnProperty(propName) && !ownerType.isPropertyTypeInferred(propName) || (!isExtern || ownerType.isNativeObjectType()) && ownerType.isInstanceType())) {
                        ownerType.defineDeclaredProperty(propName, valueType, n);
                    }
                }
                this.defineSlot(n, parent, valueType, inferred);
            } else if (rhsValue != null && rhsValue.isTrue() && (ownerType = JSType.toMaybeFunctionType(this.getObjectSlot(ownerName))) != null) {
                JSType delegateType;
                ObjectType ownerTypeOfThis = ((FunctionType)ownerType).getTypeOfThis();
                String delegateName = TypedScopeCreator.this.codingConvention.getDelegateSuperclassName();
                JSType jSType = delegateType = delegateName == null ? null : TypedScopeCreator.this.typeRegistry.getType(delegateName);
                if (delegateType != null && ownerTypeOfThis.isSubtype(delegateType)) {
                    this.defineSlot(n, parent, TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE), true);
                }
            }
        }

        private boolean isQualifiedNameInferred(String qName, Node n, JSDocInfo info, Node rhsValue, JSType valueType) {
            if (valueType == null) {
                return true;
            }
            boolean inferred = true;
            if (info != null) {
                boolean bl = inferred = !info.hasType() && !info.hasEnumParameterType() && (!info.isConstant() || valueType == null || valueType.isUnknownType()) && !FunctionTypeBuilder.isFunctionTypeDeclaration(info);
            }
            if (inferred && rhsValue != null && rhsValue.isFunction()) {
                if (info != null) {
                    return false;
                }
                if (!this.scope.isDeclared(qName, false) && n.isUnscopedQualifiedName()) {
                    Node current = n.getParent();
                    while (!current.isScript() && !current.isFunction()) {
                        if (NodeUtil.isControlStructure(current)) {
                            return true;
                        }
                        current = current.getParent();
                    }
                    FunctionTypeBuilder.AstFunctionContents contents = TypedScopeCreator.this.getFunctionAnalysisResults(this.scope.getRootNode());
                    if (contents == null || !contents.getEscapedQualifiedNames().contains(qName)) {
                        return false;
                    }
                }
            }
            return inferred;
        }

        private ObjectType getObjectSlot(String slotName) {
            Scope.Var ownerVar = this.scope.getVar(slotName);
            if (ownerVar != null) {
                JSType ownerVarType = ownerVar.getType();
                return ObjectType.cast(ownerVarType == null ? null : ownerVarType.restrictByNotNullOrUndefined());
            }
            return null;
        }

        void resolveStubDeclarations() {
            for (StubDeclaration stub : this.stubDeclarations) {
                Node n = stub.node;
                Node parent = n.getParent();
                String qName = n.getQualifiedName();
                String propName = n.getLastChild().getString();
                String ownerName = stub.ownerName;
                boolean isExtern = stub.isExtern;
                if (this.scope.isDeclared(qName, false)) continue;
                ObjectType ownerType = this.getObjectSlot(ownerName);
                ObjectType unknownType = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
                this.defineSlot(n, parent, unknownType, true);
                if (ownerType != null && (isExtern || ownerType.isFunctionPrototypeType())) {
                    ownerType.defineInferredProperty(propName, unknownType, n);
                    continue;
                }
                TypedScopeCreator.this.typeRegistry.registerPropertyOnType(propName, ownerType == null ? unknownType : ownerType);
            }
        }

        private final class CollectProperties
        extends NodeTraversal.AbstractShallowStatementCallback {
            private final ObjectType thisType;

            CollectProperties(ObjectType thisType) {
                this.thisType = thisType;
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isExprResult()) {
                    Node child = n.getFirstChild();
                    switch (child.getType()) {
                        case 86: {
                            this.maybeCollectMember(t, child.getFirstChild(), child, child.getLastChild());
                            break;
                        }
                        case 33: {
                            this.maybeCollectMember(t, child, child, null);
                        }
                    }
                }
            }

            private void maybeCollectMember(NodeTraversal t, Node member, Node nodeWithJsDocInfo, @Nullable Node value) {
                JSDocInfo info = nodeWithJsDocInfo.getJSDocInfo();
                if (info == null || !member.isGetProp() || !member.getFirstChild().isThis()) {
                    return;
                }
                member.getFirstChild().setJSType(this.thisType);
                JSType jsType = AbstractScopeBuilder.this.getDeclaredType(t.getSourceName(), info, member, value);
                Node name = member.getLastChild();
                if (jsType != null && (name.isName() || name.isString())) {
                    this.thisType.defineDeclaredProperty(name.getString(), jsType, member);
                }
            }
        }
    }

    private static class DiscoverEnumsAndTypedefs
    extends NodeTraversal.AbstractShallowStatementCallback {
        private final JSTypeRegistry registry;

        DiscoverEnumsAndTypedefs(JSTypeRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            Object nameNode = null;
            switch (node.getType()) {
                case 118: {
                    for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                        this.identifyNameNode(child, child.getFirstChild(), NodeUtil.getBestJSDocInfo(child));
                    }
                    break;
                }
                case 130: {
                    Node firstChild = node.getFirstChild();
                    if (firstChild.isAssign()) {
                        this.identifyNameNode(firstChild.getFirstChild(), firstChild.getLastChild(), firstChild.getJSDocInfo());
                        break;
                    }
                    this.identifyNameNode(firstChild, null, firstChild.getJSDocInfo());
                }
            }
        }

        private void identifyNameNode(Node nameNode, Node valueNode, JSDocInfo info) {
            if (nameNode.isQualifiedName() && info != null) {
                if (info.hasEnumParameterType()) {
                    this.registry.identifyNonNullableName(nameNode.getQualifiedName());
                } else if (info.hasTypedefType()) {
                    this.registry.identifyNonNullableName(nameNode.getQualifiedName());
                }
            }
        }
    }

    private class DeferredSetType {
        final Node node;
        final JSType type;

        DeferredSetType(Node node, JSType type) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkNotNull((Object)type);
            this.node = node;
            this.type = type;
            node.setJSType(type);
        }

        void resolve(Scope scope) {
            this.node.setJSType(this.type.resolve(TypedScopeCreator.this.typeParsingErrorReporter, scope));
        }
    }
}

