/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckPathsBetweenNodes;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.MaybeReachingVariableUse;
import com.google.javascript.jscomp.MustBeReachingVariableDef;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.List;

class FlowSensitiveInlineVariables
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private ControlFlowGraph<Node> cfg;
    private List<Candidate> candidates;
    private MustBeReachingVariableDef reachingDef;
    private MaybeReachingVariableUse reachingUses;
    private static final Predicate<Node> SIDE_EFFECT_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node node) {
            if (node == null) {
                return false;
            }
            if (NodeUtil.isCall(node) && NodeUtil.functionCallHasSideEffects(node)) {
                return true;
            }
            if (NodeUtil.isNew(node) && NodeUtil.constructorCallHasSideEffects(node)) {
                return true;
            }
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (ControlFlowGraph.isEnteringNewCfgNode(node2) || !this.apply(node2)) continue;
                return true;
            }
            return false;
        }
    };

    public FlowSensitiveInlineVariables(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        if (nodeTraversal.inGlobalScope()) {
            return;
        }
        ControlFlowAnalysis controlFlowAnalysis = new ControlFlowAnalysis(this.compiler, false, true);
        Preconditions.checkState((boolean)NodeUtil.isFunction(nodeTraversal.getScopeRoot()));
        controlFlowAnalysis.process(null, nodeTraversal.getScopeRoot().getLastChild());
        this.cfg = controlFlowAnalysis.getCfg();
        this.reachingDef = new MustBeReachingVariableDef(this.cfg, nodeTraversal.getScope(), this.compiler);
        this.reachingDef.analyze();
        this.candidates = Lists.newLinkedList();
        new NodeTraversal(this.compiler, new GatherCandiates()).traverse(nodeTraversal.getScopeRoot().getLastChild());
        this.reachingUses = new MaybeReachingVariableUse(this.cfg, nodeTraversal.getScope(), this.compiler);
        this.reachingUses.analyze();
        for (Candidate candidate : this.candidates) {
            if (!candidate.canInline()) continue;
            candidate.inlineVariable();
        }
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
    }

    @Override
    public void process(Node node, Node node2) {
        new NodeTraversal(this.compiler, this).traverse(node2);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
    }

    private static boolean checkRightOf(Node node, Node node2, Predicate<Node> predicate) {
        for (Node node3 = node; node3 != node2; node3 = node3.getParent()) {
            for (Node node4 = node3.getNext(); node4 != null; node4 = node4.getNext()) {
                if (!predicate.apply((Object)node4)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkLeftOf(Node node, Node node2, Predicate<Node> predicate) {
        for (Node node3 = node.getParent(); node3 != node2; node3 = node3.getParent()) {
            for (Node node4 = node3.getParent().getFirstChild(); node4 != node3; node4 = node4.getNext()) {
                if (!predicate.apply((Object)node4)) continue;
                return true;
            }
        }
        return false;
    }

    private class Candidate {
        private final String varName;
        private Node def;
        private final Node defCfgNode;
        private final Node use;
        private final Node useCfgNode;
        private int numUseWithinUseCfgNode;

        Candidate(String string, Node node, Node node2, Node node3) {
            Preconditions.checkArgument((boolean)NodeUtil.isName(node2));
            this.varName = string;
            this.defCfgNode = node;
            this.use = node2;
            this.useCfgNode = node3;
        }

        private boolean canInline() {
            if (NodeUtil.isFunction(this.defCfgNode)) {
                return false;
            }
            this.getDefinition(this.defCfgNode, null);
            this.getNumUseInUseCfgNode(this.useCfgNode, null);
            if (this.def == null) {
                return false;
            }
            if (NodeUtil.isAssign(this.def) && !NodeUtil.isExprAssign(this.def.getParent())) {
                return false;
            }
            if (FlowSensitiveInlineVariables.checkRightOf(this.def, this.defCfgNode, (Predicate<Node>)SIDE_EFFECT_PREDICATE)) {
                return false;
            }
            if (FlowSensitiveInlineVariables.checkLeftOf(this.use, this.useCfgNode, (Predicate<Node>)SIDE_EFFECT_PREDICATE)) {
                return false;
            }
            CheckPathsBetweenNodes checkPathsBetweenNodes = new CheckPathsBetweenNodes(FlowSensitiveInlineVariables.this.cfg, FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(this.defCfgNode), FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(this.useCfgNode), SIDE_EFFECT_PREDICATE, Predicates.alwaysTrue(), false);
            if (checkPathsBetweenNodes.somePathsSatisfyPredicate()) {
                return false;
            }
            if (NodeUtil.mayHaveSideEffects(this.def.getLastChild())) {
                return false;
            }
            if (this.numUseWithinUseCfgNode != 1) {
                return false;
            }
            if (NodeUtil.isWithinLoop(this.use)) {
                return false;
            }
            if (NodeUtil.has(this.def.getLastChild(), new Predicate<Node>(){

                public boolean apply(Node node) {
                    switch (node.getType()) {
                        case 30: 
                        case 33: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 64: {
                            return true;
                        }
                    }
                    return false;
                }
            }, new Predicate<Node>(){

                public boolean apply(Node node) {
                    return !NodeUtil.isFunction(node);
                }
            })) {
                return false;
            }
            Collection<Node> collection = FlowSensitiveInlineVariables.this.reachingUses.getUses(this.varName, this.defCfgNode);
            return collection.size() == 1;
        }

        private void inlineVariable() {
            Node node = this.def.getParent();
            Node node2 = this.use.getParent();
            if (NodeUtil.isAssign(this.def)) {
                Node node3 = this.def.getLastChild();
                node3.detachFromParent();
                Preconditions.checkState((boolean)NodeUtil.isExpressionNode(node));
                while (node.getParent().getType() == 126) {
                    node = node.getParent();
                }
                node.detachFromParent();
                node2.replaceChild(this.use, node3);
            } else if (NodeUtil.isVar(node)) {
                Node node4 = this.def.getLastChild();
                this.def.removeChild(node4);
                node2.replaceChild(this.use, node4);
            } else {
                Preconditions.checkState((boolean)false, (Object)"No other definitions can be inlined.");
            }
            FlowSensitiveInlineVariables.this.compiler.reportCodeChange();
        }

        private void getDefinition(Node node, Node node2) {
            ControlFlowGraph.AbstractCfgNodeTraversalCallback abstractCfgNodeTraversalCallback = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                    switch (node.getType()) {
                        case 38: {
                            if (node.getString().equals(Candidate.this.varName) && node.hasChildren()) {
                                Candidate.this.def = node;
                            }
                            return;
                        }
                        case 86: {
                            Node node3 = node.getFirstChild();
                            if (NodeUtil.isName(node3) && node3.getString().equals(Candidate.this.varName)) {
                                Candidate.this.def = node;
                            }
                            return;
                        }
                    }
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, node, abstractCfgNodeTraversalCallback);
        }

        private void getNumUseInUseCfgNode(Node node, Node node2) {
            ControlFlowGraph.AbstractCfgNodeTraversalCallback abstractCfgNodeTraversalCallback = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                    if (NodeUtil.isName(node) && node.getString().equals(Candidate.this.varName) && (!NodeUtil.isAssign(node2) || node2.getFirstChild() != node)) {
                        Candidate.this.numUseWithinUseCfgNode++;
                    }
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, node, abstractCfgNodeTraversalCallback);
        }
    }

    private class GatherCandiates
    extends NodeTraversal.AbstractShallowCallback {
        private GatherCandiates() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            DiGraph.DiGraphNode diGraphNode = FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(node);
            if (diGraphNode == null) {
                return;
            }
            DataFlowAnalysis.FlowState flowState = (DataFlowAnalysis.FlowState)diGraphNode.getAnnotation();
            MustBeReachingVariableDef.MustDef mustDef = (MustBeReachingVariableDef.MustDef)flowState.getIn();
            final Node node3 = node;
            ControlFlowGraph.AbstractCfgNodeTraversalCallback abstractCfgNodeTraversalCallback = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                    if (NodeUtil.isName(node)) {
                        if (NodeUtil.isAssignmentOp(node2) && node2.getFirstChild() == node || NodeUtil.isVar(node2) || node2.getType() == 102 || node2.getType() == 103 || node2.getType() == 83 || node2.getType() == 120) {
                            return;
                        }
                        String string = node.getString();
                        if (FlowSensitiveInlineVariables.this.compiler.getCodingConvention().isExported(string)) {
                            return;
                        }
                        Node node32 = FlowSensitiveInlineVariables.this.reachingDef.getDef(string, node3);
                        if (node32 != null && !FlowSensitiveInlineVariables.this.reachingDef.dependsOnOuterScopeVars(string, node3)) {
                            FlowSensitiveInlineVariables.this.candidates.add(new Candidate(string, node32, node, node3));
                        }
                    }
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, node3, abstractCfgNodeTraversalCallback);
        }
    }
}

