/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.MessageBundle;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import javax.annotation.Nullable;

class ReplaceMessages
extends JsMessageVisitor {
    private final MessageBundle bundle;
    private final boolean strictReplacement;
    static final DiagnosticType BUNDLE_DOES_NOT_HAVE_THE_MESSAGE = DiagnosticType.error("JSC_BUNDLE_DOES_NOT_HAVE_THE_MESSAGE", "Message with id = {0} cound not be found in replacement bundle");

    ReplaceMessages(AbstractCompiler abstractCompiler, MessageBundle messageBundle, boolean bl, JsMessage.Style style, boolean bl2) {
        super(abstractCompiler, bl, style, messageBundle.idGenerator());
        this.bundle = messageBundle;
        this.strictReplacement = bl2;
    }

    @Override
    protected void processJsMessage(JsMessage jsMessage, JsMessageDefinition jsMessageDefinition) {
        Node node;
        JsMessage jsMessage2 = this.bundle.getMessage(jsMessage.getId());
        if (jsMessage2 == null) {
            if (this.strictReplacement) {
                this.compiler.report(JSError.make(jsMessage.getSourceName(), jsMessageDefinition.getMessageNode(), BUNDLE_DOES_NOT_HAVE_THE_MESSAGE, jsMessage.getId()));
                return;
            }
            jsMessage2 = jsMessage;
        }
        Node node2 = jsMessageDefinition.getMessageNode();
        try {
            node = this.getNewValueNode(jsMessage2, node2);
        }
        catch (JsMessageVisitor.MalformedException malformedException) {
            this.compiler.report(JSError.make(jsMessage.getSourceName(), malformedException.getNode(), MESSAGE_TREE_MALFORMED, malformedException.getMessage()));
            node = node2;
        }
        if (node != node2) {
            jsMessageDefinition.getMessageParentNode().replaceChild(node2, node);
        }
    }

    private Node getNewValueNode(JsMessage jsMessage, Node node) throws JsMessageVisitor.MalformedException {
        switch (node.getType()) {
            case 105: {
                this.updateFunctionNode(jsMessage, node);
                return node;
            }
            case 40: {
                node.setString(jsMessage.toString());
                return node;
            }
            case 21: {
                return Node.newString(jsMessage.toString());
            }
            case 37: {
                return this.replaceCallNode(jsMessage, node);
            }
        }
        throw new JsMessageVisitor.MalformedException("Expected FUNCTION, STRING, or ADD node; found: " + node.getType(), node);
    }

    private void updateFunctionNode(JsMessage jsMessage, Node node) throws JsMessageVisitor.MalformedException {
        this.checkNode(node, 105);
        Node node2 = node.getFirstChild();
        this.checkNode(node2, 38);
        Node node3 = node2.getNext();
        this.checkNode(node3, 83);
        Node node4 = node3.getNext();
        this.checkNode(node4, 125);
        Iterator<CharSequence> iterator = jsMessage.parts().iterator();
        Node node5 = iterator.hasNext() ? this.constructAddOrStringNode(iterator, node3) : Node.newString("");
        Node node6 = new Node(125, new Node(4, node5));
        node.replaceChild(node4, node6);
    }

    private Node constructAddOrStringNode(Iterator<CharSequence> iterator, Node node) throws JsMessageVisitor.MalformedException {
        CharSequence charSequence = iterator.next();
        Node node2 = null;
        if (charSequence instanceof JsMessage.PlaceholderReference) {
            JsMessage.PlaceholderReference placeholderReference = (JsMessage.PlaceholderReference)charSequence;
            for (Node node3 : node.children()) {
                String string;
                if (node3.getType() != 38 || !(string = node3.getString()).equalsIgnoreCase(placeholderReference.getName())) continue;
                node2 = Node.newString(38, string);
            }
            if (node2 == null) {
                throw new JsMessageVisitor.MalformedException("Unrecognized message placeholder referenced: " + placeholderReference.getName(), node);
            }
        } else {
            node2 = Node.newString(((Object)charSequence).toString());
        }
        if (iterator.hasNext()) {
            return new Node(21, node2, this.constructAddOrStringNode(iterator, node));
        }
        return node2;
    }

    private Node replaceCallNode(JsMessage jsMessage, Node node) throws JsMessageVisitor.MalformedException {
        this.checkNode(node, 37);
        Node node2 = node.getFirstChild();
        this.checkNode(node2, 33);
        Node node3 = node2.getNext();
        this.checkStringExprNode(node3);
        Node node4 = node3.getNext();
        return this.constructStringExprNode(jsMessage.parts().iterator(), node4);
    }

    private Node constructStringExprNode(Iterator<CharSequence> iterator, Node node) throws JsMessageVisitor.MalformedException {
        CharSequence charSequence = iterator.next();
        Node node2 = null;
        if (charSequence instanceof JsMessage.PlaceholderReference) {
            JsMessage.PlaceholderReference placeholderReference = (JsMessage.PlaceholderReference)charSequence;
            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                if (!node3.getString().equals(placeholderReference.getName())) continue;
                Node node4 = node3.getFirstChild();
                node2 = node4.cloneTree();
            }
            if (node2 == null) {
                throw new JsMessageVisitor.MalformedException("Unrecognized message placeholder referenced: " + placeholderReference.getName(), node);
            }
        } else {
            node2 = Node.newString(((Object)charSequence).toString());
        }
        if (iterator.hasNext()) {
            return new Node(21, node2, this.constructStringExprNode(iterator, node));
        }
        return node2;
    }

    private void checkNode(@Nullable Node node, int n) throws JsMessageVisitor.MalformedException {
        if (node == null) {
            throw new JsMessageVisitor.MalformedException("Expected node type " + n + "; found: null", node);
        }
        if (node.getType() != n) {
            throw new JsMessageVisitor.MalformedException("Expected node type " + n + "; found: " + node.getType(), node);
        }
    }

    private void checkStringExprNode(@Nullable Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Expected a string; found: null");
        }
        switch (node.getType()) {
            case 40: {
                break;
            }
            case 21: {
                Node node2 = node.getFirstChild();
                this.checkStringExprNode(node2);
                this.checkStringExprNode(node2.getNext());
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected a string; found: " + node.getType());
            }
        }
    }
}

