/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Position;
import com.google.javascript.jscomp.SourceMap2;
import com.google.javascript.jscomp.SourceMapLegacy;
import com.google.javascript.rhino.Node;
import java.io.IOException;

public interface SourceMap {
    public void appendTo(Appendable var1, String var2) throws IOException;

    public void reset();

    public void addMapping(Node var1, Position var2, Position var3);

    public void setWrapperPrefix(String var1);

    public void setStartingPosition(int var1, int var2);

    public static enum DetailLevel implements Predicate<Node>
    {
        ALL{

            public boolean apply(Node node) {
                return true;
            }
        }
        ,
        SYMBOLS{

            public boolean apply(Node node) {
                return NodeUtil.isCall(node) || NodeUtil.isNew(node) || NodeUtil.isFunction(node) || NodeUtil.isName(node) || NodeUtil.isGet(node) || NodeUtil.isString(node) && (node.getParent().getType() == 64 || NodeUtil.isGet(node.getParent()));
            }
        };

    }

    public static enum Format {
        LEGACY{

            @Override
            SourceMap getInstance() {
                return new SourceMapLegacy();
            }
        }
        ,
        EXPERIMENTIAL{

            @Override
            SourceMap getInstance() {
                return new SourceMap2();
            }
        };


        abstract SourceMap getInstance();
    }
}

