/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JsFileLineParser {
    static final DiagnosticType PARSE_WARNING = DiagnosticType.warning("DEPS_PARSE_WARNING", "{0}\n{1}");
    static final DiagnosticType PARSE_ERROR = DiagnosticType.error("DEPS_PARSE_ERROR", "{0}\n{1}");
    boolean shortcutMode = false;
    private static final Pattern STRING_LITERAL_PATTERN = Pattern.compile("\\s*(?:'((?:\\\\'|[^'])*?)'|\"((?:\\\\\"|[^\"])*?)\")\\s*");
    private Matcher valueMatcher = STRING_LITERAL_PATTERN.matcher("");
    String filePath;
    int lineNum;
    ErrorManager errorManager;
    boolean parseSucceeded;

    public JsFileLineParser(ErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public void setShortcutMode(boolean bl) {
        this.shortcutMode = bl;
    }

    public boolean didParseSucceed() {
        return this.parseSucceeded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doParse(String string, Reader reader) {
        this.filePath = string;
        this.parseSucceeded = true;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string2 = null;
        this.lineNum = 0;
        boolean bl = false;
        try {
            while (null != (string2 = bufferedReader.readLine())) {
                ++this.lineNum;
                try {
                    int n;
                    String string3 = string2;
                    if (bl) {
                        n = string3.indexOf("*/");
                        if (n != -1) {
                            string3 = string3.substring(n + 2);
                            bl = false;
                        } else {
                            string3 = "";
                        }
                    }
                    if (!bl) {
                        while (true) {
                            n = string3.indexOf("//");
                            int n2 = string3.indexOf("/*");
                            if (n != -1 && (n2 == -1 || n < n2)) {
                                string3 = string3.substring(0, n);
                                break;
                            }
                            if (n2 == -1) break;
                            int n3 = string3.indexOf("*/", n2 + 2);
                            if (n3 == -1) {
                                string3 = string3.substring(0, n2);
                                bl = true;
                                break;
                            }
                            string3 = string3.substring(0, n2) + string3.substring(n3 + 2);
                        }
                    }
                    if (string3.isEmpty() || this.parseLine(string3) || !this.shortcutMode) continue;
                    return;
                }
                catch (ParseException parseException) {
                    this.errorManager.report(parseException.isFatal() ? CheckLevel.ERROR : CheckLevel.WARNING, JSError.make(string, this.lineNum, 0, parseException.isFatal() ? PARSE_ERROR : PARSE_WARNING, parseException.getMessage(), string2));
                    this.parseSucceeded = this.parseSucceeded && !parseException.isFatal();
                }
            }
            return;
        }
        catch (IOException iOException) {
            this.errorManager.report(CheckLevel.ERROR, JSError.make(string, 0, 0, PARSE_ERROR, "Error reading file: " + string));
            this.parseSucceeded = false;
        }
    }

    abstract boolean parseLine(String var1) throws ParseException;

    String parseJsString(String string) throws ParseException {
        this.valueMatcher.reset(string);
        if (!this.valueMatcher.matches()) {
            throw new ParseException("Syntax error in JS String literal", true);
        }
        return this.valueMatcher.group(1) != null ? this.valueMatcher.group(1) : this.valueMatcher.group(2);
    }

    List<String> parseJsStringArray(String string) throws ParseException {
        ArrayList arrayList = Lists.newArrayList();
        int n = string.indexOf(91);
        int n2 = string.lastIndexOf(93);
        if (n == -1 || n2 == -1) {
            throw new ParseException("Syntax error when parsing JS array", true);
        }
        String string2 = string.substring(n + 1, n2);
        if (!string2.trim().isEmpty()) {
            this.valueMatcher.reset(string2);
            while (true) {
                if (!this.valueMatcher.lookingAt()) {
                    throw new ParseException("Syntax error in JS String literal", true);
                }
                arrayList.add(this.valueMatcher.group(1) != null ? this.valueMatcher.group(1) : this.valueMatcher.group(2));
                if (this.valueMatcher.hitEnd()) break;
                if (string2.charAt(this.valueMatcher.end()) != ',') {
                    throw new ParseException("Missing comma in string array", true);
                }
                this.valueMatcher.region(this.valueMatcher.end() + 1, this.valueMatcher.regionEnd());
            }
        }
        return arrayList;
    }

    static class ParseException
    extends Exception {
        public static final long serialVersionUID = 1L;
        private boolean fatal;

        public ParseException(String string, boolean bl) {
            super(string);
            this.fatal = bl;
        }

        public boolean isFatal() {
            return this.fatal;
        }
    }
}

