/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jsonml;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.jsonml.ErrorLevel;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.JsonMLAst;

public class JsonMLError {
    private final DiagnosticType type;
    public final String description;
    public final String sourceName;
    public final JsonML element;
    public final int lineNumber;
    public final ErrorLevel level;

    private JsonMLError(DiagnosticType diagnosticType, String string, JsonML jsonML, int n, ErrorLevel errorLevel, String ... stringArray) {
        this.type = diagnosticType;
        this.description = diagnosticType.format.format(stringArray);
        this.sourceName = string;
        this.element = jsonML;
        this.lineNumber = n;
        this.level = errorLevel;
    }

    private JsonMLError(String string, DiagnosticType diagnosticType, String string2, JsonML jsonML, int n, ErrorLevel errorLevel) {
        this.type = diagnosticType;
        this.description = string;
        this.sourceName = string2;
        this.element = jsonML;
        this.lineNumber = n;
        this.level = errorLevel;
    }

    public static JsonMLError make(DiagnosticType diagnosticType, String string, JsonML jsonML, int n, ErrorLevel errorLevel, String ... stringArray) {
        return new JsonMLError(diagnosticType, string, jsonML, n, errorLevel, stringArray);
    }

    public static JsonMLError make(JSError jSError, JsonMLAst jsonMLAst) {
        int n = jSError.lineNumber;
        JsonML jsonML = jsonMLAst.getElementPreOrder(n);
        ErrorLevel errorLevel = jSError.level == CheckLevel.ERROR ? ErrorLevel.COMPILATION_ERROR : ErrorLevel.COMPILATION_WARNING;
        return new JsonMLError(jSError.getType(), jSError.sourceName, jsonML, 0, errorLevel, jSError.description);
    }
}

