/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;

final class ArrowType
extends JSType {
    private static final long serialVersionUID = 1L;
    final Node parameters;
    JSType returnType;
    final boolean returnTypeInferred;

    ArrowType(JSTypeRegistry jSTypeRegistry, Node node, JSType jSType) {
        this(jSTypeRegistry, node, jSType, false);
    }

    ArrowType(JSTypeRegistry jSTypeRegistry, Node node, JSType jSType, boolean bl) {
        super(jSTypeRegistry);
        this.parameters = node == null ? jSTypeRegistry.createParametersWithVarArgs(this.getNativeType(JSTypeNative.UNKNOWN_TYPE)) : node;
        this.returnType = jSType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : jSType;
        this.returnTypeInferred = bl;
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        if (!(jSType instanceof ArrowType)) {
            return false;
        }
        ArrowType arrowType = (ArrowType)jSType;
        if (!this.returnType.isSubtype(arrowType.returnType)) {
            return false;
        }
        Node node = this.parameters.getFirstChild();
        Node node2 = arrowType.parameters.getFirstChild();
        while (node != null && node2 != null) {
            JSType jSType2;
            JSType jSType3 = node.getJSType();
            if (!(jSType3 == null || (jSType2 = node2.getJSType()) != null && jSType2.isSubtype(jSType3))) {
                return false;
            }
            boolean bl = node.isVarArgs();
            boolean bl2 = node2.isVarArgs();
            if (!bl) {
                node = node.getNext();
            }
            if (!bl2) {
                node2 = node2.getNext();
            }
            if (!bl || !bl2) continue;
            node = null;
            node2 = null;
        }
        return true;
    }

    boolean hasEqualParameters(ArrowType arrowType) {
        Node node;
        Node node2 = this.parameters.getFirstChild();
        for (node = arrowType.parameters.getFirstChild(); node2 != null && node != null; node2 = node2.getNext(), node = node.getNext()) {
            JSType jSType = node2.getJSType();
            JSType jSType2 = node.getJSType();
            if (!(jSType != null ? jSType2 != null && !jSType.isEquivalentTo(jSType2) : jSType2 != null)) continue;
            return false;
        }
        return node2 == node;
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        if (!(jSType instanceof ArrowType)) {
            return false;
        }
        ArrowType arrowType = (ArrowType)jSType;
        if (!this.returnType.isEquivalentTo(arrowType.returnType) || this.returnTypeInferred != arrowType.returnTypeInferred) {
            return false;
        }
        return this.hasEqualParameters(arrowType);
    }

    @Override
    public int hashCode() {
        int n = 0;
        if (this.returnType != null) {
            n += this.returnType.hashCode();
        }
        if (this.returnTypeInferred) {
            ++n;
        }
        if (this.parameters != null) {
            for (Node node = this.parameters.getFirstChild(); node != null; node = node.getNext()) {
                JSType jSType = node.getJSType();
                if (jSType == null) continue;
                n += jSType.hashCode();
            }
        }
        return n;
    }

    @Override
    public JSType getLeastSupertype(JSType jSType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JSType getGreatestSubtype(JSType jSType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        this.returnType = ArrowType.safeResolve(this.returnType, errorReporter, staticScope);
        if (this.parameters != null) {
            for (Node node = this.parameters.getFirstChild(); node != null; node = node.getNext()) {
                node.setJSType(node.getJSType().resolve(errorReporter, staticScope));
            }
        }
        return this;
    }

    boolean hasUnknownParamsOrReturn() {
        if (this.parameters != null) {
            for (Node node = this.parameters.getFirstChild(); node != null; node = node.getNext()) {
                JSType jSType = node.getJSType();
                if (jSType != null && !jSType.isUnknownType()) continue;
                return true;
            }
        }
        return this.returnType == null || this.returnType.isUnknownType();
    }
}

