/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DefaultCodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ClosureCodingConvention
extends DefaultCodingConvention {
    private static final long serialVersionUID = 1L;
    private static final String TYPEDEF_NAME = "goog.typedef";
    static final DiagnosticType OBJECTLIT_EXPECTED = DiagnosticType.warning("JSC_REFLECT_OBJECTLIT_EXPECTED", "Object literal expected as second argument");
    private final Set<String> propertyTestFunctions = ImmutableSet.of((Object)"goog.isDef", (Object)"goog.isNull", (Object)"goog.isDefAndNotNull", (Object)"goog.isString", (Object)"goog.isNumber", (Object)"goog.isBoolean", (Object[])new String[]{"goog.isFunction", "goog.isArray", "goog.isObject"});

    @Override
    public void applySubclassRelationship(FunctionType functionType, FunctionType functionType2, CodingConvention.SubclassType subclassType) {
        if (subclassType == CodingConvention.SubclassType.INHERITS) {
            functionType2.defineDeclaredProperty("superClass_", functionType.getPrototype(), false, functionType.getSource());
            functionType2.getPrototype().defineDeclaredProperty("constructor", functionType2, false, functionType.getSource());
        }
    }

    @Override
    public CodingConvention.SubclassRelationship getClassesDefinedByCall(Node node) {
        Node node2 = node.getFirstChild();
        CodingConvention.SubclassType subclassType = this.typeofClassDefiningName(node2);
        if (subclassType != null) {
            Node node3 = null;
            Node node4 = node.getLastChild();
            if (node.getChildCount() == 2 && node2.getType() == 33) {
                node3 = node2.getFirstChild();
            } else if (node.getChildCount() == 3) {
                node3 = node2.getNext();
            }
            if (node3 != null && node3.isUnscopedQualifiedName() && node4.isUnscopedQualifiedName()) {
                return new CodingConvention.SubclassRelationship(subclassType, this.stripPrototype(node3), this.stripPrototype(node4));
            }
        }
        return null;
    }

    private CodingConvention.SubclassType typeofClassDefiningName(Node node) {
        String string;
        int n;
        String string2 = null;
        if (node.getType() == 33) {
            string2 = node.getLastChild().getString();
        } else if (node.getType() == 38 && (n = (string = node.getString()).lastIndexOf(36)) != -1) {
            string2 = string.substring(n + 1);
        }
        if (string2 != null) {
            if (string2.equals("inherits")) {
                return CodingConvention.SubclassType.INHERITS;
            }
            if (string2.equals("mixin")) {
                return CodingConvention.SubclassType.MIXIN;
            }
        }
        return null;
    }

    @Override
    public boolean isSuperClassReference(String string) {
        return "superClass_".equals(string);
    }

    private Node stripPrototype(Node node) {
        if (node.getType() == 33 && node.getLastChild().getString().equals("prototype")) {
            return node.getFirstChild();
        }
        return node;
    }

    @Override
    public String extractClassNameIfProvide(Node node, Node node2) {
        return ClosureCodingConvention.extractClassNameIfGoog(node, node2, "goog.provide");
    }

    @Override
    public String extractClassNameIfRequire(Node node, Node node2) {
        return ClosureCodingConvention.extractClassNameIfGoog(node, node2, "goog.require");
    }

    private static String extractClassNameIfGoog(Node node, Node node2, String string) {
        String string2;
        Node node3;
        String string3 = null;
        if (NodeUtil.isExprCall(node2) && (node3 = node.getFirstChild()) != null && node3.getType() == 33 && string.equals(string2 = node3.getQualifiedName())) {
            string3 = node3.getNext().getString();
        }
        return string3;
    }

    @Override
    public String getExportPropertyFunction() {
        return "goog.exportProperty";
    }

    @Override
    public String getExportSymbolFunction() {
        return "goog.exportSymbol";
    }

    @Override
    public List<String> identifyTypeDeclarationCall(Node node) {
        Node node2;
        Node node3 = node.getFirstChild();
        if ("goog.addDependency".equals(node3.getQualifiedName()) && node.getChildCount() >= 3 && (node2 = node3.getNext().getNext()).getType() == 63) {
            ArrayList arrayList = Lists.newArrayList();
            for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                if (node4.getType() != 40) continue;
                arrayList.add(node4.getString());
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public String identifyTypeDefAssign(Node node) {
        Node node2 = node.getFirstChild();
        int n = node.getType();
        if (n == 86) {
            if (TYPEDEF_NAME.equals(node.getLastChild().getQualifiedName())) {
                return node2.getQualifiedName();
            }
        } else if (n == 118 && node2.hasChildren() && TYPEDEF_NAME.equals(node2.getFirstChild().getQualifiedName())) {
            return node2.getString();
        }
        return null;
    }

    @Override
    public String getAbstractMethodName() {
        return "goog.abstractMethod";
    }

    @Override
    public String getSingletonGetterClassName(Node node) {
        Node node2 = node.getFirstChild();
        String string = node2.getQualifiedName();
        if (!"goog.addSingletonGetter".equals(string) && !"goog$addSingletonGetter".equals(string) || node.getChildCount() != 2) {
            return null;
        }
        return node2.getNext().getQualifiedName();
    }

    @Override
    public void applySingletonGetter(FunctionType functionType, FunctionType functionType2, ObjectType objectType) {
        functionType.defineDeclaredProperty("getInstance", functionType2, false, functionType.getSource());
        functionType.defineDeclaredProperty("instance_", objectType, false, functionType.getSource());
    }

    @Override
    public String getGlobalObject() {
        return "goog.global";
    }

    @Override
    public boolean isPropertyTestFunction(Node node) {
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        return this.propertyTestFunctions.contains(node.getFirstChild().getQualifiedName());
    }

    @Override
    public CodingConvention.ObjectLiteralCast getObjectLiteralCast(NodeTraversal nodeTraversal, Node node) {
        Preconditions.checkArgument((node.getType() == 37 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        if (!"goog.reflect.object".equals(node2.getQualifiedName()) || node2.getChildCount() != 2) {
            return null;
        }
        Node node3 = node2.getNext();
        if (!node3.isQualifiedName()) {
            return null;
        }
        Node node4 = node3.getNext();
        if (node4.getType() != 64) {
            nodeTraversal.getCompiler().report(JSError.make(nodeTraversal.getSourceName(), node, OBJECTLIT_EXPECTED, new String[0]));
            return null;
        }
        return new CodingConvention.ObjectLiteralCast(node3.getQualifiedName(), node3.getNext());
    }

    @Override
    public boolean isOptionalParameter(Node node) {
        return false;
    }

    @Override
    public boolean isVarArgsParameter(Node node) {
        return false;
    }

    @Override
    public boolean isPrivate(String string) {
        return false;
    }

    @Override
    public Collection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
        return ImmutableList.of((Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assert"), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertNumber", JSTypeNative.NUMBER_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertString", JSTypeNative.STRING_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertFunction", JSTypeNative.FUNCTION_INSTANCE_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertObject", JSTypeNative.OBJECT_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertArray", JSTypeNative.ARRAY_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertInstanceof", JSTypeNative.OBJECT_TYPE));
    }
}

