/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class CollapseAnonymousFunctions
implements CompilerPass {
    private final AbstractCompiler compiler;

    public CollapseAnonymousFunctions(AbstractCompiler abstractCompiler) {
        Preconditions.checkArgument((boolean)abstractCompiler.getLifeCycleStage().isNormalized());
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new Callback());
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() != 118) {
                return;
            }
            Node node3 = node2.getParent();
            if (node2.getType() != 132 && (node3 == null || node3.getType() != 105 || node2.getType() != 125)) {
                return;
            }
            Preconditions.checkState((boolean)node.hasOneChild());
            Node node4 = node.getFirstChild();
            Node node5 = node4.getFirstChild();
            if (node5 != null && node5.getType() == 105 && !this.isRecursiveFunction(node5)) {
                Node node6 = node5.getFirstChild();
                node6.setString(node4.getString());
                NodeUtil.copyNameAnnotations(node4, node6);
                node4.removeChild(node5);
                node2.replaceChild(node, node5);
                if (!nodeTraversal.inGlobalScope() && NodeUtil.isHoistedFunctionDeclaration(node5)) {
                    node2.addChildToFront(node5.detachFromParent());
                }
                CollapseAnonymousFunctions.this.compiler.reportCodeChange();
            }
        }

        private boolean isRecursiveFunction(Node node) {
            Node node2 = node.getFirstChild();
            if (node2.getString().isEmpty()) {
                return false;
            }
            Node node3 = node2.getNext();
            Node node4 = node3.getNext();
            return this.containsName(node4, node2.getString());
        }

        private boolean containsName(Node node, String string) {
            if (node.getType() == 38 && node.getString().equals(string)) {
                return true;
            }
            for (Node node2 : node.children()) {
                if (!this.containsName(node2, string)) continue;
                return true;
            }
            return false;
        }
    }
}

