/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public class ObjectPropertyStringPreprocess
implements CompilerPass {
    static final String OBJECT_PROPERTY_STRING = "goog.testing.ObjectPropertyString";
    public static final String EXTERN_OBJECT_PROPERTY_STRING = "JSCompiler_ObjectPropertyString";
    static final DiagnosticType INVALID_NUM_ARGUMENTS_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_NUM_ARGS", "goog.testing.ObjectPropertyString instantiated with \"{0}\" arguments, expected 2.");
    static final DiagnosticType QUALIFIED_NAME_EXPECTED_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_QUALIFIED_NAME_EXPECTED", "goog.testing.ObjectPropertyString instantiated with invalid argument, qualified name expected. Was \"{0}\".");
    static final DiagnosticType STRING_LITERAL_EXPECTED_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_STRING_LITERAL_EXPECTED", "goog.testing.ObjectPropertyString instantiated with invalid argument, string literal expected. Was \"{0}\".");
    private final AbstractCompiler compiler;

    ObjectPropertyStringPreprocess(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        node.addChildToBack(new Node(118, Node.newString(38, EXTERN_OBJECT_PROPERTY_STRING)));
        NodeTraversal.traverse(this.compiler, node2, new Callback());
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (ObjectPropertyStringPreprocess.OBJECT_PROPERTY_STRING.equals(node.getQualifiedName())) {
                Node node3 = Node.newString(38, ObjectPropertyStringPreprocess.EXTERN_OBJECT_PROPERTY_STRING);
                node3.copyInformationFrom(node);
                node2.replaceChild(node, node3);
                ObjectPropertyStringPreprocess.this.compiler.reportCodeChange();
                return;
            }
            if (node.getType() != 30) {
                return;
            }
            Node node4 = node.getFirstChild();
            if (!ObjectPropertyStringPreprocess.EXTERN_OBJECT_PROPERTY_STRING.equals(node4.getQualifiedName())) {
                return;
            }
            if (node.getChildCount() != 3) {
                ObjectPropertyStringPreprocess.this.compiler.report(nodeTraversal.makeError(node, INVALID_NUM_ARGUMENTS_ERROR, "" + node.getChildCount()));
                return;
            }
            Node node5 = node4.getNext();
            if (!node5.isQualifiedName()) {
                ObjectPropertyStringPreprocess.this.compiler.report(nodeTraversal.makeError(node5, QUALIFIED_NAME_EXPECTED_ERROR, Token.name(node5.getType())));
                return;
            }
            Node node6 = node5.getNext();
            if (node6.getType() != 40) {
                ObjectPropertyStringPreprocess.this.compiler.report(nodeTraversal.makeError(node6, STRING_LITERAL_EXPECTED_ERROR, Token.name(node6.getType())));
                return;
            }
            Node node7 = NodeUtil.newQualifiedNameNode(ObjectPropertyStringPreprocess.this.compiler.getCodingConvention(), ObjectPropertyStringPreprocess.this.compiler.getCodingConvention().getGlobalObject(), node5.getLineno(), node5.getCharno());
            Node node8 = NodeUtil.newQualifiedNameNode(ObjectPropertyStringPreprocess.this.compiler.getCodingConvention(), node5.getQualifiedName() + "." + node5.getNext().getString(), node6.getLineno(), node6.getCharno());
            node.replaceChild(node5, node7);
            node.replaceChild(node6, node8);
            ObjectPropertyStringPreprocess.this.compiler.reportCodeChange();
        }
    }
}

