/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapSection;
import com.google.debugging.sourcemap.Util;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class SourceMapGeneratorV2
implements SourceMapGenerator {
    private boolean validate = false;
    private static final int UNMAPPED = -1;
    private static final String BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwzyz0123456789+/";
    private List<Mapping> mappings = Lists.newArrayList();
    private LinkedHashMap<String, Integer> sourceFileMap = Maps.newLinkedHashMap();
    private String lastSourceFile = null;
    private int lastSourceFileIndex = -1;
    private Mapping lastMapping;
    private FilePosition offsetPosition = new FilePosition(0, 0);
    private FilePosition prefixPosition = new FilePosition(0, 0);

    @Override
    public void reset() {
        this.mappings.clear();
        this.lastMapping = null;
        this.sourceFileMap.clear();
        this.lastSourceFile = null;
        this.lastSourceFileIndex = -1;
        this.offsetPosition = new FilePosition(0, 0);
        this.prefixPosition = new FilePosition(0, 0);
    }

    @Override
    @VisibleForTesting
    public void validate(boolean bl) {
        this.validate = bl;
    }

    @Override
    public void setWrapperPrefix(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                ++n;
                n2 = 0;
                continue;
            }
            ++n2;
        }
        this.prefixPosition = new FilePosition(n, n2);
    }

    @Override
    public void setStartingPosition(int n, int n2) {
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0);
        this.offsetPosition = new FilePosition(n, n2);
    }

    @Override
    public void addMapping(String string, @Nullable String string2, FilePosition filePosition, FilePosition filePosition2, FilePosition filePosition3) {
        int n;
        int n2;
        Object object;
        if (string == null || filePosition.getLine() < 0) {
            return;
        }
        if (string != this.lastSourceFile) {
            this.lastSourceFile = string;
            object = this.sourceFileMap.get(string);
            if (object != null) {
                this.lastSourceFileIndex = (Integer)object;
            } else {
                this.lastSourceFileIndex = this.sourceFileMap.size();
                this.sourceFileMap.put(string, this.lastSourceFileIndex);
            }
        }
        object = filePosition2;
        FilePosition filePosition4 = filePosition3;
        if (this.offsetPosition.getLine() != 0 || this.offsetPosition.getColumn() != 0) {
            int n3 = this.offsetPosition.getLine();
            n2 = this.offsetPosition.getColumn();
            n = this.offsetPosition.getColumn();
            if (filePosition2.getLine() > 0) {
                n2 = 0;
            }
            if (filePosition3.getLine() > 0) {
                n = 0;
            }
            object = new FilePosition(filePosition2.getLine() + n3, filePosition2.getColumn() + n2);
            filePosition4 = new FilePosition(filePosition3.getLine() + n3, filePosition3.getColumn() + n);
        }
        Mapping mapping = new Mapping();
        mapping.sourceFile = this.lastSourceFileIndex;
        mapping.originalPosition = filePosition;
        mapping.originalName = string2;
        mapping.startPosition = object;
        mapping.endPosition = filePosition4;
        if (this.lastMapping != null) {
            n2 = this.lastMapping.startPosition.getLine();
            n = this.lastMapping.startPosition.getColumn();
            int n4 = mapping.startPosition.getLine();
            int n5 = mapping.startPosition.getColumn();
            Preconditions.checkState((n4 > n2 || n4 == n2 && n5 >= n ? 1 : 0) != 0, (String)"Incorrect source mappings order, previous : (%s,%s)\nnew : (%s,%s)\nnode : %s", (Object[])new Object[]{n2, n, n4, n5});
        }
        this.lastMapping = mapping;
        this.mappings.add(mapping);
    }

    @Override
    public void appendTo(Appendable appendable, String string) throws IOException {
        int n = this.prepMappings();
        appendable.append("{\n");
        SourceMapGeneratorV2.appendFirstField(appendable, "version", "2");
        SourceMapGeneratorV2.appendField(appendable, "file", SourceMapGeneratorV2.escapeString(string));
        SourceMapGeneratorV2.appendField(appendable, "lineCount", String.valueOf(n + 1));
        SourceMapGeneratorV2.appendFieldStart(appendable, "lineMaps");
        appendable.append("[");
        new LineMapper(appendable).appendLineMappings();
        appendable.append("]");
        SourceMapGeneratorV2.appendFieldEnd(appendable);
        SourceMapGeneratorV2.appendFieldStart(appendable, "sources");
        appendable.append("[");
        this.addSourceNameMap(appendable);
        appendable.append("]");
        SourceMapGeneratorV2.appendFieldEnd(appendable);
        SourceMapGeneratorV2.appendFieldStart(appendable, "mappings");
        appendable.append("[");
        new MappingWriter().appendMappings(appendable);
        appendable.append("]");
        SourceMapGeneratorV2.appendFieldEnd(appendable);
        appendable.append("\n}\n");
    }

    private void addSourceNameMap(Appendable appendable) throws IOException {
        int n = 0;
        for (Map.Entry<String, Integer> entry : this.sourceFileMap.entrySet()) {
            String string = entry.getKey();
            if (n != 0) {
                appendable.append(",");
            }
            appendable.append("\"");
            appendable.append(string);
            appendable.append("\"");
            ++n;
        }
    }

    private static String escapeString(String string) {
        return Util.escapeString(string);
    }

    private static void appendFirstField(Appendable appendable, String string, String string2) throws IOException {
        appendable.append("\"");
        appendable.append(string);
        appendable.append("\"");
        appendable.append(":");
        appendable.append(string2);
    }

    private static void appendField(Appendable appendable, String string, String string2) throws IOException {
        appendable.append(",\n");
        appendable.append("\"");
        appendable.append(string);
        appendable.append("\"");
        appendable.append(":");
        appendable.append(string2);
    }

    private static void appendFieldStart(Appendable appendable, String string) throws IOException {
        SourceMapGeneratorV2.appendField(appendable, string, "");
    }

    private static void appendFieldEnd(Appendable appendable) throws IOException {
    }

    private int prepMappings() throws IOException {
        new MappingTraversal().traverse(new UsedMappingCheck());
        int n = 0;
        int n2 = 0;
        for (Mapping mapping : this.mappings) {
            if (!mapping.used) continue;
            mapping.id = n++;
            int n3 = mapping.endPosition.getLine();
            n2 = Math.max(n2, n3);
        }
        return n2 + this.prefixPosition.getLine();
    }

    @Override
    public void writeMetaMap(Appendable appendable, String string, List<SourceMapSection> list) throws IOException {
        appendable.append("{\n");
        SourceMapGeneratorV2.appendFirstField(appendable, "version", "2");
        SourceMapGeneratorV2.appendField(appendable, "file", SourceMapGeneratorV2.escapeString(string));
        SourceMapGeneratorV2.appendFieldStart(appendable, "sections");
        appendable.append("[\n");
        boolean bl = true;
        Long l = new Long(0L);
        for (SourceMapSection sourceMapSection : list) {
            if (bl) {
                bl = false;
            } else {
                appendable.append(",\n");
            }
            appendable.append("{\n");
            SourceMapGeneratorV2.appendFirstField(appendable, "offset", l.toString());
            SourceMapGeneratorV2.appendField(appendable, "file", SourceMapGeneratorV2.escapeString(sourceMapSection.getSectionUrl()));
            appendable.append("\n}");
            l = l + sourceMapSection.getLength();
        }
        appendable.append("\n]");
        SourceMapGeneratorV2.appendFieldEnd(appendable);
        appendable.append("\n}\n");
    }

    private class MappingTraversal {
        private int line;
        private int col;

        MappingTraversal() {
        }

        void traverse(MappingVisitor mappingVisitor) throws IOException {
            ArrayDeque<Mapping> arrayDeque = new ArrayDeque<Mapping>();
            for (Mapping mapping : SourceMapGeneratorV2.this.mappings) {
                Mapping mapping2;
                while (!arrayDeque.isEmpty() && !this.isOverlapped((Mapping)arrayDeque.peek(), mapping)) {
                    mapping2 = (Mapping)arrayDeque.pop();
                    this.maybeVisit(mappingVisitor, mapping2);
                }
                mapping2 = (Mapping)arrayDeque.peek();
                this.maybeVisitParent(mappingVisitor, mapping2, mapping);
                arrayDeque.push(mapping);
            }
            while (!arrayDeque.isEmpty()) {
                Mapping mapping = (Mapping)arrayDeque.pop();
                this.maybeVisit(mappingVisitor, mapping);
            }
        }

        private int getAdjustedLine(FilePosition filePosition) {
            return filePosition.getLine() + SourceMapGeneratorV2.this.prefixPosition.getLine();
        }

        private int getAdjustedCol(FilePosition filePosition) {
            int n = filePosition.getLine();
            int n2 = filePosition.getColumn();
            return n != 0 ? n2 : n2 + SourceMapGeneratorV2.this.prefixPosition.getColumn();
        }

        private boolean isOverlapped(Mapping mapping, Mapping mapping2) {
            int n = mapping.endPosition.getLine();
            int n2 = mapping2.startPosition.getLine();
            int n3 = mapping.endPosition.getColumn();
            int n4 = mapping2.startPosition.getColumn();
            return n == n2 && n3 >= n4 || n > n2;
        }

        private void maybeVisit(MappingVisitor mappingVisitor, Mapping mapping) throws IOException {
            int n = this.getAdjustedLine(mapping.endPosition);
            int n2 = this.getAdjustedCol(mapping.endPosition);
            if (this.line < n || this.line == n && this.col < n2) {
                this.visit(mappingVisitor, mapping, n, n2);
            }
        }

        private void maybeVisitParent(MappingVisitor mappingVisitor, Mapping mapping, Mapping mapping2) throws IOException {
            int n = this.getAdjustedLine(mapping2.startPosition);
            int n2 = this.getAdjustedCol(mapping2.startPosition);
            Preconditions.checkState((this.line < n || this.col <= n2 ? 1 : 0) != 0);
            if (this.line < n || this.line == n && this.col < n2) {
                this.visit(mappingVisitor, mapping, n, n2);
            }
        }

        private void visit(MappingVisitor mappingVisitor, Mapping mapping, int n, int n2) throws IOException {
            Preconditions.checkState((this.line <= n ? 1 : 0) != 0);
            Preconditions.checkState((this.line < n || this.col < n2 ? 1 : 0) != 0);
            if (this.line == n && this.col == n2) {
                Preconditions.checkState((boolean)false);
                return;
            }
            mappingVisitor.visit(mapping, this.line, this.col, n, n2);
            this.line = n;
            this.col = n2;
        }
    }

    private static interface MappingVisitor {
        public void visit(Mapping var1, int var2, int var3, int var4, int var5) throws IOException;
    }

    private class UsedMappingCheck
    implements MappingVisitor {
        private UsedMappingCheck() {
        }

        @Override
        public void visit(Mapping mapping, int n, int n2, int n3, int n4) throws IOException {
            if (mapping != null) {
                mapping.used = true;
            }
        }
    }

    @VisibleForTesting
    public static class LineMapDecoder {
        private static LineEntry decodeLineEntry(String string, int n) {
            return LineMapDecoder.decodeLineEntry(new StringParser(string), n);
        }

        private static LineEntry decodeLineEntry(StringParser stringParser, int n) {
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            int n6 = stringParser.peek();
            while (n6 == 33) {
                ++n5;
                stringParser.next();
                n6 = stringParser.peek();
            }
            n6 = 0;
            int n7 = 0;
            if (n5 == 0) {
                n4 = stringParser.next();
                n3 = LineMapDecoder.addBase64Digit((char)n4, 0);
                n7 = n3 >> 2;
                n6 = n3 & 3;
            } else {
                n4 = stringParser.next();
                n6 = LineMapDecoder.addBase64Digit((char)n4, 0);
                n3 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    n4 = stringParser.next();
                    n3 = LineMapDecoder.addBase64Digit((char)n4, n3);
                }
                n7 = n3;
            }
            ++n7;
            ++n6;
            n4 = 0;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = stringParser.next();
                n4 = LineMapDecoder.addBase64Digit((char)n2, n4);
            }
            n3 = LineMapDecoder.getIdFromRelativeId(n4, n6, n);
            return new LineEntry(n3, n7);
        }

        public static List<Integer> decodeLine(String string) {
            return LineMapDecoder.decodeLine(new StringParser(string));
        }

        private static List<Integer> decodeLine(StringParser stringParser) {
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)512);
            int n = 0;
            while (stringParser.hasNext()) {
                LineEntry lineEntry = LineMapDecoder.decodeLineEntry(stringParser, n);
                n = lineEntry.id;
                for (int i = 0; i < lineEntry.reps; ++i) {
                    arrayList.add(lineEntry.id);
                }
            }
            return arrayList;
        }

        private static int addBase64Digit(char c, int n) {
            return n * 64 + SourceMapGeneratorV2.BASE64_MAP.indexOf(c);
        }

        public static int getIdFromRelativeId(int n, int n2, int n3) {
            int n4 = 1 << n2 * 6;
            return (n >= n4 / 2 ? n - n4 : n) + n3;
        }

        static class StringParser {
            final String content;
            int current = 0;

            StringParser(String string) {
                this.content = string;
            }

            char next() {
                return this.content.charAt(this.current++);
            }

            char peek() {
                return this.content.charAt(this.current);
            }

            boolean hasNext() {
                return this.current < this.content.length() - 1;
            }
        }

        static class LineEntry {
            final int id;
            final int reps;

            public LineEntry(int n, int n2) {
                this.id = n;
                this.reps = n2;
            }
        }
    }

    @VisibleForTesting
    public static class LineMapEncoder {
        public static void encodeEntry(Appendable appendable, int n, int n2, int n3) throws IOException {
            Preconditions.checkState((n3 > 0 ? 1 : 0) != 0);
            int n4 = LineMapEncoder.getRelativeMappingIdLength(n, n2);
            int n5 = LineMapEncoder.getRelativeMappingId(n, n4, n2);
            String string = LineMapEncoder.valueToBase64(n5, n4);
            if (n3 > 16 || n4 > 4) {
                String string2 = LineMapEncoder.valueToBase64(n3 - 1, 1);
                for (int i = 0; i < string2.length(); ++i) {
                    appendable.append('!');
                }
                String string3 = LineMapEncoder.valueToBase64(string.length() - 1, 1);
                appendable.append(string3);
                appendable.append(string2);
            } else {
                int n6 = (n3 - 1 << 2) + (string.length() - 1);
                Preconditions.checkState((n6 < 64 && n6 >= 0 ? 1 : 0) != 0, (String)"prefix (%s) reps(%s) map id size(%s)", (Object[])new Object[]{n6, n3, string.length()});
                appendable.append(LineMapEncoder.valueToBase64(n6, 1));
            }
            appendable.append(string);
        }

        public static int getRelativeMappingId(int n, int n2, int n3) {
            int n4 = 1 << n2 * 6;
            int n5 = n - n3;
            return n5 < 0 ? n5 + n4 : n5;
        }

        public static int getRelativeMappingIdLength(int n, int n2) {
            Preconditions.checkState((n >= 0 || n == -1 ? 1 : 0) != 0);
            int n3 = n - n2;
            int n4 = (n3 < 0 ? Math.abs(n3) - 1 : n3) << 1;
            int n5 = 1;
            for (int i = 64; n4 >= i; i *= 64) {
                ++n5;
            }
            return n5;
        }

        static String valueToBase64(int n, int n2) {
            int n3 = 0;
            char[] cArray = new char[4];
            do {
                int n4 = n & 0x3F;
                cArray[n3++] = SourceMapGeneratorV2.BASE64_MAP.charAt(n4);
            } while ((n >>>= 6) > 0);
            StringBuilder stringBuilder = new StringBuilder(n3);
            while (n2 > n3) {
                stringBuilder.append(SourceMapGeneratorV2.BASE64_MAP.charAt(0));
                --n2;
            }
            while (n3 > 0) {
                stringBuilder.append(cArray[--n3]);
            }
            return stringBuilder.toString();
        }
    }

    private class LineMapper
    implements MappingVisitor {
        private final Appendable out;
        private int lastId = -1;

        LineMapper(Appendable appendable) {
            this.out = appendable;
        }

        @Override
        public void visit(Mapping mapping, int n, int n2, int n3, int n4) throws IOException {
            int n5 = mapping != null ? mapping.id : -1;
            for (int i = n; i <= n3; ++i) {
                if (i == n3) {
                    this.closeEntry(n5, n4 - n2);
                    break;
                }
                this.closeLine(false);
                this.openLine();
                n2 = 0;
            }
        }

        void appendLineMappings() throws IOException {
            this.openLine();
            new MappingTraversal().traverse(this);
            this.closeLine(true);
        }

        private void openLine() throws IOException {
            this.out.append("\"");
            this.lastId = 0;
        }

        private void closeLine(boolean bl) throws IOException {
            if (bl) {
                this.out.append("\"");
            } else {
                this.out.append("\",\n");
            }
        }

        private void closeEntry(int n, int n2) throws IOException {
            if (n2 == 0) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            LineMapEncoder.encodeEntry(stringBuilder, n, this.lastId, n2);
            if (SourceMapGeneratorV2.this.validate) {
                LineMapDecoder.LineEntry lineEntry = LineMapDecoder.decodeLineEntry(stringBuilder.toString(), this.lastId);
                Preconditions.checkState((lineEntry.id == n && lineEntry.reps == n2 ? 1 : 0) != 0, (String)"expected (%s,%s) but got (%s,%s)", (Object[])new Object[]{n, n2, lineEntry.id, lineEntry.reps});
            }
            this.out.append(stringBuilder);
            this.lastId = n;
        }
    }

    private class MappingWriter {
        private int lastLine = 0;
        private String lastLineString = String.valueOf(0);

        private MappingWriter() {
        }

        private void appendMappingTo(Mapping mapping, Appendable appendable) throws IOException {
            appendable.append("[");
            appendable.append(String.valueOf(mapping.sourceFile));
            appendable.append(",");
            int n = mapping.originalPosition.getLine();
            if (n != this.lastLine) {
                this.lastLineString = String.valueOf(n);
            }
            String string = this.lastLineString;
            appendable.append(string);
            appendable.append(",");
            appendable.append(String.valueOf(mapping.originalPosition.getColumn()));
            if (mapping.originalName != null) {
                appendable.append(",");
                appendable.append(SourceMapGeneratorV2.escapeString(mapping.originalName));
            }
            appendable.append("],\n");
        }

        void appendMappings(Appendable appendable) throws IOException {
            for (Mapping mapping : SourceMapGeneratorV2.this.mappings) {
                if (!mapping.used) continue;
                this.appendMappingTo(mapping, appendable);
            }
        }
    }

    static class Mapping {
        int id = -1;
        int sourceFile;
        FilePosition originalPosition;
        FilePosition startPosition;
        FilePosition endPosition;
        String originalName;
        boolean used = false;

        Mapping() {
        }
    }
}

