/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ComposeWarningsGuard
extends WarningsGuard {
    private final Map<WarningsGuard, Integer> orderOfAddition = Maps.newHashMap();
    private int numberOfAdds = 0;
    private final Comparator<WarningsGuard> guardComparator = new Comparator<WarningsGuard>(){

        @Override
        public int compare(WarningsGuard warningsGuard, WarningsGuard warningsGuard2) {
            int n = warningsGuard.getPriority() - warningsGuard2.getPriority();
            if (n != 0) {
                return n;
            }
            return (Integer)ComposeWarningsGuard.this.orderOfAddition.get(warningsGuard2) - (Integer)ComposeWarningsGuard.this.orderOfAddition.get(warningsGuard);
        }
    };
    private final TreeSet<WarningsGuard> guards = new TreeSet<WarningsGuard>(this.guardComparator);

    public ComposeWarningsGuard(List<WarningsGuard> list) {
        this.addGuards(list);
    }

    public ComposeWarningsGuard(WarningsGuard ... warningsGuardArray) {
        this(Lists.newArrayList((Object[])warningsGuardArray));
    }

    void addGuard(WarningsGuard warningsGuard) {
        if (warningsGuard instanceof ComposeWarningsGuard) {
            this.addGuards(((ComposeWarningsGuard)warningsGuard).guards.descendingSet());
        } else {
            ++this.numberOfAdds;
            this.orderOfAddition.put(warningsGuard, this.numberOfAdds);
            this.guards.remove(warningsGuard);
            this.guards.add(warningsGuard);
        }
    }

    private void addGuards(Iterable<WarningsGuard> iterable) {
        for (WarningsGuard warningsGuard : iterable) {
            this.addGuard(warningsGuard);
        }
    }

    @Override
    public CheckLevel level(JSError jSError) {
        for (WarningsGuard warningsGuard : this.guards) {
            CheckLevel checkLevel = warningsGuard.level(jSError);
            if (checkLevel == null) continue;
            return checkLevel;
        }
        return null;
    }

    @Override
    public boolean disables(DiagnosticGroup diagnosticGroup) {
        block0: for (DiagnosticType diagnosticType : diagnosticGroup.getTypes()) {
            DiagnosticGroup diagnosticGroup2 = DiagnosticGroup.forType(diagnosticType);
            for (WarningsGuard warningsGuard : this.guards) {
                if (warningsGuard.disables(diagnosticGroup2)) continue block0;
                if (!warningsGuard.enables(diagnosticGroup2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean enables(DiagnosticGroup diagnosticGroup) {
        for (WarningsGuard warningsGuard : this.guards) {
            if (warningsGuard.enables(diagnosticGroup)) {
                return true;
            }
            if (!warningsGuard.disables(diagnosticGroup)) continue;
            return false;
        }
        return false;
    }

    List<WarningsGuard> getGuards() {
        return Collections.unmodifiableList(Lists.newArrayList(this.guards));
    }
}

