/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class ExploitAssigns
extends AbstractPeepholeOptimization {
    ExploitAssigns() {
    }

    @Override
    Node optimizeSubtree(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNext();
            if (NodeUtil.isExprAssign(node2)) {
                this.collapseAssign(node2.getFirstChild(), node2, node);
            }
            node2 = node3;
        }
        return node;
    }

    private void collapseAssign(Node node, Node node2, Node node3) {
        Node node4 = node.getFirstChild();
        Node node5 = node4.getNext();
        if (this.isCollapsibleValue(node4, true) && this.collapseAssignEqualTo(node2, node3, node4)) {
            this.reportCodeChange();
        } else if (this.isCollapsibleValue(node5, false) && this.collapseAssignEqualTo(node2, node3, node5)) {
            this.reportCodeChange();
        } else if (node5.getType() == 86) {
            this.collapseAssign(node5, node2, node3);
        }
    }

    private boolean isCollapsibleValue(Node node, boolean bl) {
        switch (node.getType()) {
            case 33: {
                return !bl || node.getFirstChild().getType() == 42;
            }
            case 38: {
                return true;
            }
        }
        return NodeUtil.isImmutableValue(node);
    }

    private boolean collapseAssignEqualTo(Node node, Node node2, Node node3) {
        Node node4 = node.getFirstChild();
        Node node5 = node2;
        Node node6 = node.getNext();
        block6: while (node6 != null) {
            switch (node6.getType()) {
                case 4: 
                case 98: 
                case 100: 
                case 101: 
                case 108: 
                case 130: {
                    node5 = node6;
                    node6 = node6.getFirstChild();
                    continue block6;
                }
                case 118: {
                    if (node6.getFirstChild().hasChildren()) {
                        node5 = node6.getFirstChild();
                        node6 = node5.getFirstChild();
                        continue block6;
                    }
                    return false;
                }
                case 33: 
                case 38: {
                    Object object;
                    if (node6.isQualifiedName()) {
                        object = node6.getQualifiedName();
                        if (node3.isQualifiedName() && ((String)object).equals(node3.getQualifiedName())) {
                            if (!this.isSafeReplacement(node6, node4)) {
                                return false;
                            }
                            node2.removeChild(node);
                            node.removeChild(node4);
                            node5.replaceChild(node6, node4);
                            return true;
                        }
                    }
                    return false;
                }
                case 86: {
                    Object object = node6.getFirstChild();
                    if (((Node)object).getType() == 38 || ((Node)object).getType() == 33 && ((Node)object).getFirstChild().getType() == 42) {
                        node5 = node6;
                        node6 = ((Node)object).getNext();
                        continue block6;
                    }
                    return false;
                }
            }
            if (NodeUtil.isImmutableValue(node6) && node6.isEquivalentTo(node3)) {
                node2.removeChild(node);
                node.removeChild(node4);
                node5.replaceChild(node6, node4);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isSafeReplacement(Node node, Node node2) {
        if (node.getType() == 38) {
            return true;
        }
        Preconditions.checkArgument((node.getType() == 33 ? 1 : 0) != 0);
        Node node3 = node.getFirstChild();
        return node3.getType() != 38 || !this.isNameAssignedTo(node3.getString(), node2);
    }

    private boolean isNameAssignedTo(String string, Node node) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (!this.isNameAssignedTo(string, node2)) continue;
            return true;
        }
        return node.getType() == 38 && (node2 = node.getParent()).getType() == 86 && node2.getFirstChild() == node && string.equals(node.getString());
    }
}

