/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeIterators;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class InlineVariables
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Mode mode;
    private final boolean inlineAllStrings;
    private final IdentifyConstants identifyConstants = new IdentifyConstants();

    InlineVariables(AbstractCompiler abstractCompiler, Mode mode, boolean bl) {
        this.compiler = abstractCompiler;
        this.mode = mode;
        this.inlineAllStrings = bl;
    }

    @Override
    public void process(Node node, Node node2) {
        ReferenceCollectingCallback referenceCollectingCallback = new ReferenceCollectingCallback(this.compiler, new InliningBehavior(), this.getFilterForMode());
        referenceCollectingCallback.process(node, node2);
    }

    private Predicate<Scope.Var> getFilterForMode() {
        switch (this.mode) {
            case ALL: {
                return Predicates.alwaysTrue();
            }
            case LOCALS_ONLY: {
                return new IdentifyLocals();
            }
            case CONSTANTS_ONLY: {
                return new IdentifyConstants();
            }
        }
        throw new IllegalStateException();
    }

    private class InliningBehavior
    implements ReferenceCollectingCallback.Behavior {
        private final Set<Scope.Var> staleVars = Sets.newHashSet();
        final Map<Node, AliasCandidate> aliasCandidates = Maps.newHashMap();

        private InliningBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal nodeTraversal, Map<Scope.Var, ReferenceCollectingCallback.ReferenceCollection> map) {
            this.collectAliasCandidates(nodeTraversal, map);
            this.doInlinesForScope(nodeTraversal, map);
        }

        private void collectAliasCandidates(NodeTraversal nodeTraversal, Map<Scope.Var, ReferenceCollectingCallback.ReferenceCollection> map) {
            if (InlineVariables.this.mode != Mode.CONSTANTS_ONLY) {
                Iterator<Scope.Var> iterator = nodeTraversal.getScope().getVars();
                while (iterator.hasNext()) {
                    ReferenceCollectingCallback.Reference reference;
                    Node node;
                    Scope.Var var = iterator.next();
                    ReferenceCollectingCallback.ReferenceCollection referenceCollection = map.get(var);
                    if (referenceCollection == null || referenceCollection.references.size() < 2 || !referenceCollection.isWellDefined() || !referenceCollection.isAssignedOnceInLifetime() || (node = (reference = referenceCollection.getInitializingReference()).getAssignedValue()) == null || node.getType() != 38) continue;
                    this.aliasCandidates.put(node, new AliasCandidate(var, referenceCollection));
                }
            }
        }

        private void doInlinesForScope(NodeTraversal nodeTraversal, Map<Scope.Var, ReferenceCollectingCallback.ReferenceCollection> map) {
            Iterator<Scope.Var> iterator = nodeTraversal.getScope().getVars();
            while (iterator.hasNext()) {
                Scope.Var var = iterator.next();
                ReferenceCollectingCallback.ReferenceCollection referenceCollection = map.get(var);
                if (referenceCollection == null || this.isVarInlineForbidden(var)) continue;
                if (this.isInlineableDeclaredConstant(var, referenceCollection)) {
                    ReferenceCollectingCallback.Reference reference = referenceCollection.getInitializingReferenceForConstants();
                    Node node = reference.getAssignedValue();
                    this.inlineDeclaredConstant(var, node, referenceCollection.references);
                    this.staleVars.add(var);
                    continue;
                }
                if (InlineVariables.this.mode == Mode.CONSTANTS_ONLY) continue;
                this.inlineNonConstants(var, referenceCollection);
            }
        }

        private void inlineNonConstants(Scope.Var var, ReferenceCollectingCallback.ReferenceCollection referenceCollection) {
            Object object;
            ReferenceCollectingCallback.Reference reference;
            int n;
            int n2 = referenceCollection.references.size();
            ReferenceCollectingCallback.Reference reference2 = referenceCollection.references.get(0);
            int n3 = n = reference2 == (reference = referenceCollection.getInitializingReference()) ? 2 : 3;
            if (n2 > 1 && this.isImmutableAndWellDefinedVariable(var, referenceCollection)) {
                if (reference != null) {
                    object = reference.getAssignedValue();
                } else {
                    Node node = reference2.getNameNode();
                    object = NodeUtil.newUndefinedNode(node);
                }
                Preconditions.checkNotNull((Object)object);
                this.inlineWellDefinedVariable(var, (Node)object, referenceCollection.references);
                this.staleVars.add(var);
            } else if (n2 == n) {
                object = referenceCollection.references.get(n - 1);
                if (this.canInline(reference2, reference, (ReferenceCollectingCallback.Reference)object)) {
                    this.inline(var, reference2, reference, (ReferenceCollectingCallback.Reference)object);
                    this.staleVars.add(var);
                }
            } else if (reference2 != reference && n2 == 2 && this.isValidDeclaration(reference2) && this.isValidInitialization(reference)) {
                object = reference.getAssignedValue();
                Preconditions.checkNotNull(object);
                this.inlineWellDefinedVariable(var, (Node)object, referenceCollection.references);
                this.staleVars.add(var);
            }
            if (!this.staleVars.contains(var) && referenceCollection.isWellDefined() && referenceCollection.isAssignedOnceInLifetime()) {
                object = referenceCollection.references;
                for (int i = 1; i < object.size(); ++i) {
                    AliasCandidate aliasCandidate;
                    Node node = object.get(i).getNameNode();
                    if (!this.aliasCandidates.containsKey(node) || this.staleVars.contains((aliasCandidate = this.aliasCandidates.get(node)).alias) || this.isVarInlineForbidden(aliasCandidate.alias)) continue;
                    ReferenceCollectingCallback.Reference reference3 = aliasCandidate.refInfo.getInitializingReference();
                    Node node2 = reference3.getAssignedValue();
                    Preconditions.checkNotNull((Object)node2);
                    this.inlineWellDefinedVariable(aliasCandidate.alias, node2, ((AliasCandidate)aliasCandidate).refInfo.references);
                    this.staleVars.add(aliasCandidate.alias);
                }
            }
        }

        private void blacklistVarReferencesInTree(Node node, Scope scope) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                this.blacklistVarReferencesInTree(node2, scope);
            }
            if (node.getType() == 38) {
                this.staleVars.add(scope.getVar(node.getString()));
            }
        }

        private boolean isVarInlineForbidden(Scope.Var var) {
            return InlineVariables.this.compiler.getCodingConvention().isExported(var.name) || "JSCompiler_renameProperty".equals(var.name) || this.staleVars.contains(var);
        }

        private void inline(Scope.Var var, ReferenceCollectingCallback.Reference reference, ReferenceCollectingCallback.Reference reference2, ReferenceCollectingCallback.Reference reference3) {
            Node node = reference2.getAssignedValue();
            Preconditions.checkState((node != null ? 1 : 0) != 0);
            boolean bl = NodeUtil.isFunctionDeclaration(node);
            this.inlineValue(var, reference3, node.detachFromParent());
            if (reference != reference2) {
                Node node2 = reference2.getGrandparent();
                Preconditions.checkState((node2.getType() == 130 ? 1 : 0) != 0);
                NodeUtil.removeChild(node2.getParent(), node2);
            }
            if (!bl) {
                this.removeDeclaration(reference);
            } else {
                InlineVariables.this.compiler.reportCodeChange();
            }
        }

        private void inlineWellDefinedVariable(Scope.Var var, Node node, List<ReferenceCollectingCallback.Reference> list) {
            ReferenceCollectingCallback.Reference reference = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                this.inlineValue(var, list.get(i), node.cloneTree());
            }
            this.removeDeclaration(reference);
        }

        private void inlineDeclaredConstant(Scope.Var var, Node node, List<ReferenceCollectingCallback.Reference> list) {
            ReferenceCollectingCallback.Reference reference = null;
            for (ReferenceCollectingCallback.Reference reference2 : list) {
                if (reference2.getNameNode() == var.getNameNode()) {
                    reference = reference2;
                    continue;
                }
                this.inlineValue(var, reference2, node.cloneTree());
            }
            this.removeDeclaration(reference);
        }

        private void removeDeclaration(ReferenceCollectingCallback.Reference reference) {
            Node node = reference.getParent();
            node.removeChild(reference.getNameNode());
            if (!node.hasChildren()) {
                Preconditions.checkState((node.getType() == 118 ? 1 : 0) != 0);
                Node node2 = reference.getGrandparent();
                NodeUtil.removeChild(node2, node);
            }
            InlineVariables.this.compiler.reportCodeChange();
        }

        private void inlineValue(Scope.Var var, ReferenceCollectingCallback.Reference reference, Node node) {
            if (reference.isSimpleAssignmentToName()) {
                reference.getGrandparent().replaceChild(reference.getParent(), node);
            } else {
                reference.getParent().replaceChild(reference.getNameNode(), node);
            }
            this.blacklistVarReferencesInTree(node, var.scope);
            InlineVariables.this.compiler.reportCodeChange();
        }

        private boolean isInlineableDeclaredConstant(Scope.Var var, ReferenceCollectingCallback.ReferenceCollection referenceCollection) {
            if (!InlineVariables.this.identifyConstants.apply(var)) {
                return false;
            }
            if (!referenceCollection.isAssignedOnceInLifetime()) {
                return false;
            }
            ReferenceCollectingCallback.Reference reference = referenceCollection.getInitializingReferenceForConstants();
            if (reference == null) {
                return false;
            }
            Node node = reference.getAssignedValue();
            if (node == null) {
                return false;
            }
            if (!NodeUtil.isImmutableValue(node)) {
                return false;
            }
            return node.getType() != 40 || this.isStringWorthInlining(var, referenceCollection.references);
        }

        private boolean isStringWorthInlining(Scope.Var var, List<ReferenceCollectingCallback.Reference> list) {
            if (!InlineVariables.this.inlineAllStrings && !var.isDefine()) {
                int n;
                int n2 = var.getInitialValue().getString().length() + "''".length();
                int n3 = "var xx=;".length() + n2 + 4 * (list.size() - 1);
                return n3 >= (n = (n2 - 1) * (list.size() - 1));
            }
            return true;
        }

        private boolean canInline(ReferenceCollectingCallback.Reference reference, ReferenceCollectingCallback.Reference reference2, ReferenceCollectingCallback.Reference reference3) {
            if (!(this.isValidDeclaration(reference) && this.isValidInitialization(reference2) && this.isValidReference(reference3))) {
                return false;
            }
            if (reference != reference2 && reference2.getGrandparent().getType() != 130) {
                return false;
            }
            if (reference.getBasicBlock() != reference2.getBasicBlock() || reference.getBasicBlock() != reference3.getBasicBlock()) {
                return false;
            }
            Node node = reference2.getAssignedValue();
            Preconditions.checkState((node != null ? 1 : 0) != 0);
            if (node.getType() == 33 && reference3.getParent().getType() == 37 && reference3.getParent().getFirstChild() == reference3.getNameNode()) {
                return false;
            }
            if (node.getType() == 105) {
                CodingConvention.SubclassRelationship subclassRelationship;
                Node node2 = reference3.getParent();
                if (reference3.getParent().getType() == 37 && (subclassRelationship = InlineVariables.this.compiler.getCodingConvention().getClassesDefinedByCall(node2)) != null) {
                    return false;
                }
            }
            return this.canMoveAggressively(node) || this.canMoveModerately(reference2, reference3);
        }

        private boolean canMoveAggressively(Node node) {
            return NodeUtil.isLiteralValue(node, true) || node.getType() == 105;
        }

        private boolean canMoveModerately(ReferenceCollectingCallback.Reference reference, ReferenceCollectingCallback.Reference reference2) {
            NodeIterators.LocalVarMotion localVarMotion;
            if (reference.getParent().getType() == 118) {
                localVarMotion = NodeIterators.LocalVarMotion.forVar(reference.getNameNode(), reference.getParent(), reference.getGrandparent());
            } else if (reference.getParent().getType() == 86) {
                Preconditions.checkState((reference.getGrandparent().getType() == 130 ? 1 : 0) != 0);
                localVarMotion = NodeIterators.LocalVarMotion.forAssign(reference.getNameNode(), reference.getParent(), reference.getGrandparent(), reference.getGrandparent().getParent());
            } else {
                throw new IllegalStateException("Unexpected initialization parent " + reference.getParent().toStringTree());
            }
            Node node = reference2.getNameNode();
            while (localVarMotion.hasNext()) {
                Node node2 = (Node)localVarMotion.next();
                if (node2 != node) continue;
                return true;
            }
            return false;
        }

        private boolean isValidDeclaration(ReferenceCollectingCallback.Reference reference) {
            return reference.getParent().getType() == 118 && reference.getGrandparent().getType() != 115 || NodeUtil.isFunctionDeclaration(reference.getParent());
        }

        private boolean isValidInitialization(ReferenceCollectingCallback.Reference reference) {
            if (reference == null) {
                return false;
            }
            if (reference.isDeclaration()) {
                return NodeUtil.isFunctionDeclaration(reference.getParent()) || reference.getNameNode().getFirstChild() != null;
            }
            Node node = reference.getParent();
            Preconditions.checkState((node.getType() == 86 && node.getFirstChild() == reference.getNameNode() ? 1 : 0) != 0);
            return true;
        }

        private boolean isValidReference(ReferenceCollectingCallback.Reference reference) {
            return !reference.isDeclaration() && !reference.isLvalue();
        }

        private boolean isImmutableAndWellDefinedVariable(Scope.Var var, ReferenceCollectingCallback.ReferenceCollection referenceCollection) {
            Object object;
            List<ReferenceCollectingCallback.Reference> list = referenceCollection.references;
            int n = 1;
            ReferenceCollectingCallback.Reference reference = list.get(0);
            if (!this.isValidDeclaration(reference)) {
                return false;
            }
            boolean bl = referenceCollection.isNeverAssigned();
            if (!bl) {
                boolean bl2;
                ReferenceCollectingCallback.Reference reference2 = referenceCollection.getInitializingReference();
                if (!this.isValidInitialization(reference2)) {
                    return false;
                }
                if (reference != reference2) {
                    Preconditions.checkState((reference2 == list.get(1) ? 1 : 0) != 0);
                    n = 2;
                }
                if (!referenceCollection.isWellDefined()) {
                    return false;
                }
                object = reference2.getAssignedValue();
                Preconditions.checkNotNull((Object)object);
                boolean bl3 = NodeUtil.isImmutableValue((Node)object) && (((Node)object).getType() != 40 || this.isStringWorthInlining(var, referenceCollection.references));
                boolean bl4 = bl2 = ((Node)object).getType() == 42 && !referenceCollection.isEscaped();
                if (!bl3 && !bl2) {
                    return false;
                }
            }
            for (int i = n; i < list.size(); ++i) {
                object = list.get(i);
                if (this.isValidReference((ReferenceCollectingCallback.Reference)object)) continue;
                return false;
            }
            return true;
        }
    }

    private static class AliasCandidate {
        private final Scope.Var alias;
        private final ReferenceCollectingCallback.ReferenceCollection refInfo;

        AliasCandidate(Scope.Var var, ReferenceCollectingCallback.ReferenceCollection referenceCollection) {
            this.alias = var;
            this.refInfo = referenceCollection;
        }
    }

    private class IdentifyLocals
    implements Predicate<Scope.Var> {
        private IdentifyLocals() {
        }

        public boolean apply(Scope.Var var) {
            return var.scope.isLocal();
        }
    }

    private class IdentifyConstants
    implements Predicate<Scope.Var> {
        private IdentifyConstants() {
        }

        public boolean apply(Scope.Var var) {
            return var.isConst();
        }
    }

    static enum Mode {
        CONSTANTS_ONLY,
        LOCALS_ONLY,
        ALL;

    }
}

