/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.FlowScope;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.SimpleSlot;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class LinkedFlowScope
implements FlowScope {
    private final FlatFlowScopeCache cache;
    private final LinkedFlowScope parent;
    private int depth;
    static final int MAX_DEPTH = 250;
    private FlatFlowScopeCache flattened;
    private boolean frozen = false;
    private LinkedFlowSlot lastSlot;

    private LinkedFlowScope(FlatFlowScopeCache flatFlowScopeCache, LinkedFlowScope linkedFlowScope) {
        this.cache = flatFlowScopeCache;
        if (linkedFlowScope == null) {
            this.lastSlot = null;
            this.depth = 0;
            this.parent = flatFlowScopeCache.linkedEquivalent;
        } else {
            this.lastSlot = linkedFlowScope.lastSlot;
            this.depth = linkedFlowScope.depth + 1;
            this.parent = linkedFlowScope;
        }
    }

    LinkedFlowScope(FlatFlowScopeCache flatFlowScopeCache) {
        this(flatFlowScopeCache, null);
    }

    LinkedFlowScope(LinkedFlowScope linkedFlowScope) {
        this(linkedFlowScope.cache, linkedFlowScope);
    }

    private Scope getFunctionScope() {
        return this.cache.functionScope;
    }

    private boolean flowsFromBottom() {
        return this.getFunctionScope().isBottom();
    }

    public static LinkedFlowScope createEntryLattice(Scope scope) {
        return new LinkedFlowScope(new FlatFlowScopeCache(scope));
    }

    @Override
    public void inferSlotType(String string, JSType jSType) {
        Preconditions.checkState((!this.frozen ? 1 : 0) != 0);
        this.lastSlot = new LinkedFlowSlot(string, jSType, this.lastSlot);
        ++this.depth;
        this.cache.dirtySymbols.add(string);
    }

    @Override
    public void inferQualifiedSlot(String string, JSType jSType, JSType jSType2) {
        Scope scope = this.getFunctionScope();
        if (scope.isLocal()) {
            if (scope.getVar(string) == null && !scope.isBottom()) {
                scope.declare(string, null, jSType, null);
            }
            this.inferSlotType(string, jSType2);
        }
    }

    @Override
    public JSType getTypeOfThis() {
        return this.cache.functionScope.getTypeOfThis();
    }

    @Override
    public StaticScope<JSType> getParentScope() {
        return this.getFunctionScope().getParentScope();
    }

    @Override
    public StaticSlot<JSType> getSlot(String string) {
        if (this.cache.dirtySymbols.contains(string)) {
            LinkedFlowSlot linkedFlowSlot = this.lastSlot;
            while (linkedFlowSlot != null) {
                if (linkedFlowSlot.getName().equals(string)) {
                    return linkedFlowSlot;
                }
                linkedFlowSlot = linkedFlowSlot.parent;
            }
        }
        return this.cache.getSlot(string);
    }

    @Override
    public StaticSlot<JSType> getOwnSlot(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FlowScope createChildFlowScope() {
        this.frozen = true;
        if (this.depth > 250) {
            if (this.flattened == null) {
                this.flattened = new FlatFlowScopeCache(this);
            }
            return new LinkedFlowScope(this.flattened);
        }
        return new LinkedFlowScope(this);
    }

    @Override
    public StaticSlot<JSType> findUniqueRefinedSlot(FlowScope flowScope) {
        LinkedFlowSlot linkedFlowSlot = null;
        LinkedFlowScope linkedFlowScope = this;
        while (linkedFlowScope != flowScope) {
            LinkedFlowSlot linkedFlowSlot2 = linkedFlowScope.lastSlot;
            while (linkedFlowSlot2 != null && (linkedFlowScope.parent == null || linkedFlowScope.parent.lastSlot != linkedFlowSlot2)) {
                if (linkedFlowSlot == null) {
                    linkedFlowSlot = linkedFlowSlot2;
                } else if (!linkedFlowSlot2.getName().equals(linkedFlowSlot.getName())) {
                    return null;
                }
                linkedFlowSlot2 = linkedFlowSlot2.parent;
            }
            linkedFlowScope = linkedFlowScope.parent;
        }
        return linkedFlowSlot;
    }

    @Override
    public void completeScope(Scope scope) {
        Iterator<Scope.Var> iterator = scope.getVars();
        while (iterator.hasNext()) {
            JSType jSType;
            Scope.Var var = iterator.next();
            if (!var.isTypeInferred() || (jSType = var.getType()) != null && !jSType.isUnknownType()) continue;
            JSType jSType2 = this.getSlot(var.getName()).getType();
            var.setType(jSType2);
        }
    }

    @Override
    public LinkedFlowScope optimize() {
        LinkedFlowScope linkedFlowScope = this;
        while (linkedFlowScope.parent != null && linkedFlowScope.lastSlot == linkedFlowScope.parent.lastSlot) {
            linkedFlowScope = linkedFlowScope.parent;
        }
        return linkedFlowScope;
    }

    public boolean equals(Object object) {
        if (object instanceof LinkedFlowScope) {
            LinkedFlowScope linkedFlowScope = (LinkedFlowScope)object;
            if (this.optimize() == linkedFlowScope.optimize()) {
                return true;
            }
            if (this.getFunctionScope() != linkedFlowScope.getFunctionScope()) {
                return false;
            }
            if (this.cache == linkedFlowScope.cache) {
                for (String string : this.cache.dirtySymbols) {
                    if (!this.diffSlots(this.getSlot(string), linkedFlowScope.getSlot(string))) continue;
                    return false;
                }
                return true;
            }
            Map<String, StaticSlot<JSType>> map = this.allFlowSlots();
            Map<String, StaticSlot<JSType>> map2 = linkedFlowScope.allFlowSlots();
            for (StaticSlot<JSType> staticSlot : map.values()) {
                if (this.diffSlots(staticSlot, map2.get(staticSlot.getName()))) {
                    return false;
                }
                map2.remove(staticSlot.getName());
            }
            for (StaticSlot<JSType> staticSlot : map2.values()) {
                if (!this.diffSlots(staticSlot, map.get(staticSlot.getName()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean diffSlots(StaticSlot<JSType> staticSlot, StaticSlot<JSType> staticSlot2) {
        boolean bl;
        boolean bl2 = staticSlot == null || staticSlot.getType() == null;
        boolean bl3 = bl = staticSlot2 == null || staticSlot2.getType() == null;
        if (bl2 && bl) {
            return false;
        }
        if (bl2 ^ bl) {
            return true;
        }
        return staticSlot.getType().differsFrom(staticSlot2.getType());
    }

    private Map<String, StaticSlot<JSType>> allFlowSlots() {
        HashMap hashMap = Maps.newHashMap();
        Object object = this.lastSlot;
        while (object != null) {
            if (!hashMap.containsKey(((SimpleSlot)object).getName())) {
                hashMap.put(((SimpleSlot)object).getName(), object);
            }
            object = ((LinkedFlowSlot)object).parent;
        }
        for (String string : this.cache.symbols.keySet()) {
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, this.cache.symbols.get(string));
        }
        return hashMap;
    }

    private static class FlatFlowScopeCache {
        private final Scope functionScope;
        private final LinkedFlowScope linkedEquivalent;
        private Map<String, StaticSlot<JSType>> symbols = Maps.newHashMap();
        final Set<String> dirtySymbols = Sets.newHashSet();

        FlatFlowScopeCache(Scope scope) {
            this.functionScope = scope;
            this.symbols = ImmutableMap.of();
            this.linkedEquivalent = null;
        }

        FlatFlowScopeCache(LinkedFlowScope linkedFlowScope) {
            FlatFlowScopeCache flatFlowScopeCache = linkedFlowScope.cache;
            this.functionScope = flatFlowScopeCache.functionScope;
            this.symbols = linkedFlowScope.allFlowSlots();
            this.linkedEquivalent = linkedFlowScope;
        }

        FlatFlowScopeCache(LinkedFlowScope linkedFlowScope, LinkedFlowScope linkedFlowScope2) {
            this.linkedEquivalent = null;
            this.functionScope = linkedFlowScope.flowsFromBottom() ? linkedFlowScope2.getFunctionScope() : linkedFlowScope.getFunctionScope();
            Map map = linkedFlowScope.allFlowSlots();
            Map map2 = linkedFlowScope2.allFlowSlots();
            this.symbols = map;
            HashSet hashSet = Sets.newHashSet(this.symbols.keySet());
            hashSet.addAll(map2.keySet());
            for (String string : hashSet) {
                JSType jSType;
                StaticSlot<JSType> staticSlot;
                StaticSlot staticSlot2 = (StaticSlot)map.get(string);
                StaticSlot staticSlot3 = (StaticSlot)map2.get(string);
                JSType jSType2 = null;
                if (staticSlot3 == null || staticSlot3.getType() == null) {
                    staticSlot = linkedFlowScope2.getFunctionScope().getSlot(string);
                    JSType jSType3 = jSType = staticSlot == null ? null : staticSlot.getType();
                    if (jSType != null) {
                        jSType2 = ((JSType)staticSlot2.getType()).getLeastSupertype(jSType);
                    }
                } else if (staticSlot2 == null || staticSlot2.getType() == null) {
                    staticSlot = linkedFlowScope.getFunctionScope().getSlot(string);
                    JSType jSType4 = jSType = staticSlot == null ? null : staticSlot.getType();
                    if (jSType == null) {
                        this.symbols.put(string, staticSlot3);
                    } else {
                        jSType2 = ((JSType)staticSlot3.getType()).getLeastSupertype(jSType);
                    }
                } else {
                    jSType2 = ((JSType)staticSlot2.getType()).getLeastSupertype((JSType)staticSlot3.getType());
                }
                if (jSType2 == null) continue;
                this.symbols.put(string, new SimpleSlot(string, jSType2, true));
            }
        }

        public StaticSlot<JSType> getSlot(String string) {
            if (this.symbols.containsKey(string)) {
                return this.symbols.get(string);
            }
            return this.functionScope.getSlot(string);
        }
    }

    private static class LinkedFlowSlot
    extends SimpleSlot {
        final LinkedFlowSlot parent;

        LinkedFlowSlot(String string, JSType jSType, LinkedFlowSlot linkedFlowSlot) {
            super(string, jSType, true);
            this.parent = linkedFlowSlot;
        }
    }

    static class FlowScopeJoinOp
    extends JoinOp.BinaryJoinOp<FlowScope> {
        FlowScopeJoinOp() {
        }

        @Override
        public FlowScope apply(FlowScope flowScope, FlowScope flowScope2) {
            LinkedFlowScope linkedFlowScope = (LinkedFlowScope)flowScope;
            LinkedFlowScope linkedFlowScope2 = (LinkedFlowScope)flowScope2;
            linkedFlowScope.frozen = true;
            linkedFlowScope2.frozen = true;
            if (linkedFlowScope.optimize() == linkedFlowScope2.optimize()) {
                return linkedFlowScope.createChildFlowScope();
            }
            return new LinkedFlowScope(new FlatFlowScopeCache(linkedFlowScope, linkedFlowScope2));
        }
    }
}

