/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NameReferenceGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class OptimizeParameters
implements CompilerPass,
OptimizeCalls.CallGraphCompilerPass {
    private final AbstractCompiler compiler;

    OptimizeParameters(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    OptimizeParameters(AbstractCompiler abstractCompiler, NameReferenceGraph nameReferenceGraph) {
        this(abstractCompiler);
    }

    @Override
    @VisibleForTesting
    public void process(Node node, Node node2) {
        SimpleDefinitionFinder simpleDefinitionFinder = new SimpleDefinitionFinder(this.compiler);
        simpleDefinitionFinder.process(node, node2);
        this.process(node, node2, simpleDefinitionFinder);
    }

    @Override
    public void process(Node node, Node node2, SimpleDefinitionFinder simpleDefinitionFinder) {
        for (DefinitionSite definitionSite : simpleDefinitionFinder.getDefinitionSites()) {
            if (!this.canChangeSignature(definitionSite, simpleDefinitionFinder)) continue;
            this.tryEliminateConstantArgs(definitionSite, simpleDefinitionFinder);
            this.tryEliminateOptionalArgs(definitionSite, simpleDefinitionFinder);
        }
    }

    private boolean canChangeSignature(DefinitionSite definitionSite, SimpleDefinitionFinder simpleDefinitionFinder) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        if (definitionSite.inExterns) {
            return false;
        }
        Node node = definition.getRValue();
        if (node == null || !NodeUtil.isFunction(node) || NodeUtil.isVarArgsFunction(node)) {
            return false;
        }
        if (!SimpleDefinitionFinder.isSimpleFunctionDeclaration(node)) {
            return false;
        }
        if (SimpleDefinitionFinder.maybeExported(this.compiler, definition)) {
            return false;
        }
        Collection<UseSite> collection = simpleDefinitionFinder.getUseSites(definition);
        if (collection.isEmpty()) {
            return false;
        }
        for (UseSite useSite : collection) {
            if (!SimpleDefinitionFinder.isCallOrNewSite(useSite)) {
                return false;
            }
            Node node2 = useSite.node;
            Collection<DefinitionsRemover.Definition> collection2 = simpleDefinitionFinder.getDefinitionsReferencedAt(node2);
            if (collection2.size() > 1) {
                return false;
            }
            Preconditions.checkState((!collection2.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)collection2.contains(definition));
        }
        return true;
    }

    private void tryEliminateOptionalArgs(DefinitionSite definitionSite, SimpleDefinitionFinder simpleDefinitionFinder) {
        int n = -1;
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Collection<UseSite> collection = simpleDefinitionFinder.getUseSites(definition);
        for (UseSite useSite : collection) {
            Preconditions.checkState((boolean)SimpleDefinitionFinder.isCallOrNewSite(useSite));
            Node node = useSite.node.getParent();
            int n2 = node.getChildCount() - 1;
            if (n2 <= n) continue;
            n = n2;
        }
        this.eliminateParamsAfter(definition.getRValue(), n);
    }

    private void tryEliminateConstantArgs(DefinitionSite definitionSite, SimpleDefinitionFinder simpleDefinitionFinder) {
        Node node;
        ArrayList arrayList = Lists.newArrayList();
        boolean bl = true;
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Collection<UseSite> collection = simpleDefinitionFinder.getUseSites(definition);
        for (UseSite useSite : collection) {
            Preconditions.checkState((boolean)SimpleDefinitionFinder.isCallOrNewSite(useSite));
            node = useSite.node.getParent();
            Node node2 = node.getFirstChild();
            if (bl) {
                this.buildParameterList(arrayList, node2);
                bl = false;
                continue;
            }
            this.findConstantParameters(arrayList, node2);
        }
        for (UseSite useSite : collection) {
            Preconditions.checkState((boolean)SimpleDefinitionFinder.isCallOrNewSite(useSite));
            node = useSite.node.getParent();
            this.optimizeCallSite(arrayList, node);
        }
        Node node3 = definition.getRValue();
        if (NodeUtil.isFunction(node3)) {
            this.optimizeFunctionDefinition(arrayList, node3);
        }
    }

    private void findConstantParameters(List<Parameter> list, Node node) {
        int n = 0;
        while ((node = node.getNext()) != null) {
            Node node2;
            if (n >= list.size()) {
                list.add(new Parameter(node, false));
            } else if (list.get(n).shouldRemove() && !this.nodesAreEqual(node, node2 = list.get(n).getArg())) {
                list.get(n).setShouldRemove(false);
            }
            ++n;
        }
        while (n < list.size()) {
            list.get(n).setShouldRemove(false);
            ++n;
        }
    }

    private void buildParameterList(List<Parameter> list, Node node) {
        while ((node = node.getNext()) != null) {
            list.add(new Parameter(node, NodeUtil.isLiteralValue(node, false)));
        }
    }

    private void optimizeFunctionDefinition(List<Parameter> list, Node node) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Node node2;
            if (!list.get(i).shouldRemove() || (node2 = this.eliminateFunctionParamAt(node, i)) == null) continue;
            this.addVariableToFunction(node, node2, list.get(i).getArg());
        }
    }

    private void optimizeCallSite(List<Parameter> list, Node node) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!list.get(i).shouldRemove()) continue;
            this.eliminateCallParamAt(node, i);
        }
    }

    private boolean nodesAreEqual(Node node, Node node2) {
        return NodeUtil.isImmutableValue(node) && NodeUtil.isImmutableValue(node2) && node.isEquivalentTo(node2);
    }

    private void addVariableToFunction(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node), (Object)"Node must be a function.");
        Node node4 = node.getLastChild();
        Preconditions.checkArgument((node4.getType() == 125 ? 1 : 0) != 0, (Object)"Node must be a block.");
        Node node5 = NodeUtil.newVarNode(node2.getQualifiedName(), node3.cloneTree());
        node4.addChildToFront(node5);
        this.compiler.reportCodeChange();
    }

    private boolean eliminateParamsAfter(Node node, int n) {
        Node node2;
        boolean bl = false;
        for (node2 = node.getFirstChild().getNext().getFirstChild(); n != 0 && node2 != null; node2 = node2.getNext(), --n) {
        }
        return this.eliminateParamsAfter(node, node2);
    }

    private boolean eliminateParamsAfter(Node node, Node node2) {
        if (node2 != null) {
            this.eliminateParamsAfter(node, node2.getNext());
            node2.detachFromParent();
            Node node3 = new Node(118, node2).copyInformationFrom(node2);
            node.getLastChild().addChildrenToFront(node3);
            this.compiler.reportCodeChange();
            return true;
        }
        return false;
    }

    private Node eliminateFunctionParamAt(Node node, int n) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node), (Object)"Node must be a function.");
        Node node2 = NodeUtil.getArgumentForFunction(node, n);
        if (node2 != null) {
            node.getFirstChild().getNext().removeChild(node2);
        }
        return node2;
    }

    private Node eliminateCallParamAt(Node node, int n) {
        Preconditions.checkArgument((boolean)NodeUtil.isCallOrNew(node), (Object)"Node must be a call or new.");
        Node node2 = NodeUtil.getArgumentForCallOrNew(node, n);
        if (node2 != null) {
            node.removeChild(node2);
            this.compiler.reportCodeChange();
        }
        return node2;
    }

    private static class Parameter {
        private final Node arg;
        private boolean shouldRemove;

        public Parameter(Node node, boolean bl) {
            this.shouldRemove = bl;
            this.arg = node;
        }

        public Node getArg() {
            return this.arg;
        }

        public boolean shouldRemove() {
            return this.shouldRemove;
        }

        public void setShouldRemove(boolean bl) {
            this.shouldRemove = bl;
        }
    }
}

