/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

class ProcessTweaks
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean stripTweaks;
    private final SortedMap<String, Node> compilerDefaultValueOverrides;
    private static final CharMatcher ID_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.anyOf((CharSequence)"0123456789_."));
    static final DiagnosticType UNKNOWN_TWEAK_WARNING = DiagnosticType.warning("JSC_UNKNOWN_TWEAK_WARNING", "no tweak registered with ID {0}");
    static final DiagnosticType TWEAK_MULTIPLY_REGISTERED_ERROR = DiagnosticType.error("JSC_TWEAK_MULTIPLY_REGISTERED_ERROR", "Tweak {0} has already been registered.");
    static final DiagnosticType NON_LITERAL_TWEAK_ID_ERROR = DiagnosticType.error("JSC_NON_LITERAL_TWEAK_ID_ERROR", "tweak ID must be a string literal");
    static final DiagnosticType INVALID_TWEAK_DEFAULT_VALUE_WARNING = DiagnosticType.warning("JSC_INVALID_TWEAK_DEFAULT_VALUE_WARNING", "tweak {0} registered with {1} must have a default value that is a literal of type {2}");
    static final DiagnosticType NON_GLOBAL_TWEAK_INIT_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_TWEAK_INIT_ERROR", "tweak declaration {0} must occur in the global scope");
    static final DiagnosticType TWEAK_OVERRIDE_AFTER_REGISTERED_ERROR = DiagnosticType.error("JSC_TWEAK_OVERRIDE_AFTER_REGISTERED_ERROR", "Cannot override the default value of tweak {0} after it has been registered");
    static final DiagnosticType TWEAK_WRONG_GETTER_TYPE_WARNING = DiagnosticType.warning("JSC_TWEAK_WRONG_GETTER_TYPE_WARNING", "tweak getter function {0} used for tweak registered using {1}");
    static final DiagnosticType INVALID_TWEAK_ID_ERROR = DiagnosticType.error("JSC_INVALID_TWEAK_ID_ERROR", "tweak ID contains illegal characters. Only letters, numbers, _ and . are allowed");
    private static final Map<String, TweakFunction> TWEAK_FUNCTIONS_MAP = Maps.newHashMap();

    ProcessTweaks(AbstractCompiler abstractCompiler, boolean bl, Map<String, Node> map) {
        this.compiler = abstractCompiler;
        this.stripTweaks = bl;
        this.compilerDefaultValueOverrides = Maps.newTreeMap();
        this.compilerDefaultValueOverrides.putAll(map);
    }

    @Override
    public void process(Node node, Node node2) {
        CollectTweaksResult collectTweaksResult = this.collectTweaks(node2);
        this.applyCompilerDefaultValueOverrides(collectTweaksResult.tweakInfos);
        boolean bl = false;
        if (this.stripTweaks) {
            bl = this.stripAllCalls(collectTweaksResult.tweakInfos);
        } else if (!this.compilerDefaultValueOverrides.isEmpty()) {
            bl = this.replaceGetCompilerOverridesCalls(collectTweaksResult.getOverridesCalls);
        }
        if (bl) {
            this.compiler.reportCodeChange();
        }
    }

    private boolean replaceGetCompilerOverridesCalls(List<TweakFunctionCall> list) {
        for (TweakFunctionCall tweakFunctionCall : list) {
            Node node = tweakFunctionCall.callNode;
            Node node2 = this.createCompilerDefaultValueOverridesVarNode(node);
            node.getParent().replaceChild(node, node2);
        }
        return !list.isEmpty();
    }

    private boolean stripAllCalls(Map<String, TweakInfo> map) {
        for (TweakInfo tweakInfo : map.values()) {
            boolean bl = tweakInfo.isRegistered();
            for (TweakFunctionCall tweakFunctionCall : tweakInfo.functionCalls) {
                Node node;
                Node node2 = tweakFunctionCall.callNode;
                Node node3 = node2.getParent();
                if (tweakFunctionCall.tweakFunc.isGetterFunction()) {
                    if (bl) {
                        node = tweakInfo.getDefaultValueNode().cloneNode();
                    } else {
                        TweakFunction tweakFunction = tweakFunctionCall.tweakFunc.registerFunction;
                        node = tweakFunction.createDefaultValueNode();
                    }
                    node3.replaceChild(node2, node);
                    continue;
                }
                node = new Node(122).copyInformationFrom(node2);
                node.addChildToBack(Node.newNumber(0.0).copyInformationFrom(node2));
                node3.replaceChild(node2, node);
            }
        }
        return !map.isEmpty();
    }

    private Node createCompilerDefaultValueOverridesVarNode(Node node) {
        Node node2 = new Node(64).copyInformationFrom(node);
        for (Map.Entry<String, Node> entry : this.compilerDefaultValueOverrides.entrySet()) {
            Node node3 = Node.newString(entry.getKey()).copyInformationFrom(node);
            Node node4 = entry.getValue().cloneNode().copyInformationFrom(node);
            node3.addChildToBack(node4);
            node2.addChildToBack(node3);
        }
        return node2;
    }

    private void applyCompilerDefaultValueOverrides(Map<String, TweakInfo> map) {
        for (Map.Entry<String, Node> entry : this.compilerDefaultValueOverrides.entrySet()) {
            String string = entry.getKey();
            TweakInfo tweakInfo = map.get(string);
            if (tweakInfo == null) {
                this.compiler.report(JSError.make(UNKNOWN_TWEAK_WARNING, string));
                continue;
            }
            TweakFunction tweakFunction = tweakInfo.registerCall.tweakFunc;
            Node node = entry.getValue();
            if (!tweakFunction.isValidNodeType(node.getType())) {
                this.compiler.report(JSError.make(INVALID_TWEAK_DEFAULT_VALUE_WARNING, string, tweakFunction.getName(), tweakFunction.getExpectedTypeName()));
                continue;
            }
            tweakInfo.defaultValueNode = node;
        }
    }

    private CollectTweaksResult collectTweaks(Node node) {
        CollectTweaks collectTweaks = new CollectTweaks();
        NodeTraversal.traverse(this.compiler, node, collectTweaks);
        Map<String, TweakInfo> map = collectTweaks.allTweaks;
        for (TweakInfo tweakInfo : map.values()) {
            tweakInfo.emitAllWarnings();
        }
        return new CollectTweaksResult(map, collectTweaks.getOverridesCalls);
    }

    static {
        for (TweakFunction tweakFunction : TweakFunction.values()) {
            TWEAK_FUNCTIONS_MAP.put(tweakFunction.getName(), tweakFunction);
        }
    }

    private final class TweakInfo {
        final String tweakId;
        final List<TweakFunctionCall> functionCalls;
        TweakFunctionCall registerCall;
        Node defaultValueNode;

        TweakInfo(String string) {
            this.tweakId = string;
            this.functionCalls = Lists.newArrayList();
        }

        void emitAllWarnings() {
            if (this.isRegistered()) {
                this.emitAllTypeWarnings();
            } else {
                this.emitUnknownTweakErrors();
            }
        }

        void emitAllTypeWarnings() {
            for (TweakFunctionCall tweakFunctionCall : this.functionCalls) {
                Node node = tweakFunctionCall.valueNode;
                TweakFunction tweakFunction = tweakFunctionCall.tweakFunc;
                TweakFunction tweakFunction2 = this.registerCall.tweakFunc;
                if (node != null) {
                    if (tweakFunction2.isValidNodeType(node.getType())) continue;
                    ProcessTweaks.this.compiler.report(JSError.make(tweakFunctionCall.sourceName, node, INVALID_TWEAK_DEFAULT_VALUE_WARNING, this.tweakId, tweakFunction2.getName(), tweakFunction2.getExpectedTypeName()));
                    continue;
                }
                if (!tweakFunction.isGetterFunction() || tweakFunction.isCorrectRegisterFunction(tweakFunction2)) continue;
                ProcessTweaks.this.compiler.report(JSError.make(tweakFunctionCall.sourceName, tweakFunctionCall.callNode, TWEAK_WRONG_GETTER_TYPE_WARNING, tweakFunction.getName(), tweakFunction2.getName()));
            }
        }

        void emitUnknownTweakErrors() {
            for (TweakFunctionCall tweakFunctionCall : this.functionCalls) {
                ProcessTweaks.this.compiler.report(JSError.make(tweakFunctionCall.sourceName, tweakFunctionCall.getIdNode(), UNKNOWN_TWEAK_WARNING, this.tweakId));
            }
        }

        void addRegisterCall(String string, TweakFunction tweakFunction, Node node, Node node2) {
            this.registerCall = new TweakFunctionCall(string, tweakFunction, node, node2);
            this.functionCalls.add(this.registerCall);
        }

        void addOverrideDefaultValueCall(String string, TweakFunction tweakFunction, Node node, Node node2) {
            this.functionCalls.add(new TweakFunctionCall(string, tweakFunction, node, node2));
            this.defaultValueNode = node2;
        }

        void addGetterCall(String string, TweakFunction tweakFunction, Node node) {
            this.functionCalls.add(new TweakFunctionCall(string, tweakFunction, node));
        }

        boolean isRegistered() {
            return this.registerCall != null;
        }

        Node getDefaultValueNode() {
            Preconditions.checkState((boolean)this.isRegistered());
            if (this.defaultValueNode != null) {
                return this.defaultValueNode;
            }
            if (this.registerCall.valueNode != null) {
                return this.registerCall.valueNode;
            }
            return this.registerCall.tweakFunc.createDefaultValueNode();
        }
    }

    private static final class TweakFunctionCall {
        final String sourceName;
        final TweakFunction tweakFunc;
        final Node callNode;
        final Node valueNode;

        TweakFunctionCall(String string, TweakFunction tweakFunction, Node node) {
            this(string, tweakFunction, node, null);
        }

        TweakFunctionCall(String string, TweakFunction tweakFunction, Node node, Node node2) {
            this.sourceName = string;
            this.callNode = node;
            this.tweakFunc = tweakFunction;
            this.valueNode = node2;
        }

        Node getIdNode() {
            return this.callNode.getFirstChild().getNext();
        }
    }

    private final class CollectTweaks
    extends NodeTraversal.AbstractPostOrderCallback {
        final Map<String, TweakInfo> allTweaks = Maps.newHashMap();
        final List<TweakFunctionCall> getOverridesCalls = Lists.newArrayList();

        private CollectTweaks() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() != 37) {
                return;
            }
            String string = node.getFirstChild().getQualifiedName();
            TweakFunction tweakFunction = (TweakFunction)((Object)TWEAK_FUNCTIONS_MAP.get(string));
            if (tweakFunction == null) {
                return;
            }
            if (tweakFunction == TweakFunction.GET_COMPILER_OVERRIDES) {
                this.getOverridesCalls.add(new TweakFunctionCall(nodeTraversal.getSourceName(), tweakFunction, node));
                return;
            }
            Node node3 = node.getFirstChild().getNext();
            if (node3.getType() != 40) {
                ProcessTweaks.this.compiler.report(nodeTraversal.makeError(node3, NON_LITERAL_TWEAK_ID_ERROR, new String[0]));
                return;
            }
            String string2 = node3.getString();
            TweakInfo tweakInfo = this.allTweaks.get(string2);
            if (tweakInfo == null) {
                tweakInfo = new TweakInfo(string2);
                this.allTweaks.put(string2, tweakInfo);
            }
            switch (tweakFunction) {
                case REGISTER_BOOLEAN: 
                case REGISTER_NUMBER: 
                case REGISTER_STRING: {
                    if (!ID_MATCHER.matchesAllOf((CharSequence)string2)) {
                        ProcessTweaks.this.compiler.report(nodeTraversal.makeError(node3, INVALID_TWEAK_ID_ERROR, new String[0]));
                    }
                    if (!nodeTraversal.inGlobalScope()) {
                        ProcessTweaks.this.compiler.report(nodeTraversal.makeError(node, NON_GLOBAL_TWEAK_INIT_ERROR, string2));
                        break;
                    }
                    if (tweakInfo.isRegistered()) {
                        ProcessTweaks.this.compiler.report(nodeTraversal.makeError(node, TWEAK_MULTIPLY_REGISTERED_ERROR, string2));
                        break;
                    }
                    Node node4 = node3.getNext().getNext();
                    tweakInfo.addRegisterCall(nodeTraversal.getSourceName(), tweakFunction, node, node4);
                    break;
                }
                case OVERRIDE_DEFAULT_VALUE: {
                    if (!nodeTraversal.inGlobalScope()) {
                        ProcessTweaks.this.compiler.report(nodeTraversal.makeError(node, NON_GLOBAL_TWEAK_INIT_ERROR, string2));
                        break;
                    }
                    if (tweakInfo.isRegistered()) {
                        ProcessTweaks.this.compiler.report(nodeTraversal.makeError(node, TWEAK_OVERRIDE_AFTER_REGISTERED_ERROR, string2));
                        break;
                    }
                    Node node5 = node3.getNext();
                    tweakInfo.addOverrideDefaultValueCall(nodeTraversal.getSourceName(), tweakFunction, node, node5);
                    break;
                }
                case GET_BOOLEAN: 
                case GET_NUMBER: 
                case GET_STRING: {
                    tweakInfo.addGetterCall(nodeTraversal.getSourceName(), tweakFunction, node);
                }
            }
        }
    }

    private static final class CollectTweaksResult {
        final Map<String, TweakInfo> tweakInfos;
        final List<TweakFunctionCall> getOverridesCalls;

        CollectTweaksResult(Map<String, TweakInfo> map, List<TweakFunctionCall> list) {
            this.tweakInfos = map;
            this.getOverridesCalls = list;
        }
    }

    private static enum TweakFunction {
        REGISTER_BOOLEAN("goog.tweak.registerBoolean", "boolean", 44, 43),
        REGISTER_NUMBER("goog.tweak.registerNumber", "number", 39),
        REGISTER_STRING("goog.tweak.registerString", "string", 40),
        OVERRIDE_DEFAULT_VALUE("goog.tweak.overrideDefaultValue"),
        GET_COMPILER_OVERRIDES("goog.tweak.getCompilerOverrides_"),
        GET_BOOLEAN("goog.tweak.getBoolean", REGISTER_BOOLEAN),
        GET_NUMBER("goog.tweak.getNumber", REGISTER_NUMBER),
        GET_STRING("goog.tweak.getString", REGISTER_STRING);

        final String name;
        final String expectedTypeName;
        final int validNodeTypeA;
        final int validNodeTypeB;
        final TweakFunction registerFunction;

        private TweakFunction(String string2) {
            this(string2, null, -1, -1, null);
        }

        private TweakFunction(String string2, String string3, int n2) {
            this(string2, string3, n2, -1, null);
        }

        private TweakFunction(String string2, String string3, int n2, int n3) {
            this(string2, string3, n2, n3, null);
        }

        private TweakFunction(String string2, TweakFunction tweakFunction) {
            this(string2, null, -1, -1, tweakFunction);
        }

        private TweakFunction(String string2, String string3, int n2, int n3, TweakFunction tweakFunction) {
            this.name = string2;
            this.expectedTypeName = string3;
            this.validNodeTypeA = n2;
            this.validNodeTypeB = n3;
            this.registerFunction = tweakFunction;
        }

        boolean isValidNodeType(int n) {
            return n == this.validNodeTypeA || n == this.validNodeTypeB;
        }

        boolean isCorrectRegisterFunction(TweakFunction tweakFunction) {
            Preconditions.checkNotNull((Object)((Object)tweakFunction));
            return this.registerFunction == tweakFunction;
        }

        boolean isGetterFunction() {
            return this.registerFunction != null;
        }

        String getName() {
            return this.name;
        }

        String getExpectedTypeName() {
            return this.expectedTypeName;
        }

        Node createDefaultValueNode() {
            switch (this) {
                case REGISTER_BOOLEAN: {
                    return new Node(43);
                }
                case REGISTER_NUMBER: {
                    return Node.newNumber(0.0);
                }
                case REGISTER_STRING: {
                    return Node.newString("");
                }
            }
            throw new IllegalStateException();
        }
    }
}

