/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReplaceStrings
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType BAD_REPLACEMENT_CONFIGURATION = DiagnosticType.warning("JSC_BAD_REPLACEMENT_CONFIGURATION", "Bad replacement configuration.");
    private final String DEFAULT_PLACEHOLDER_TOKEN = "`";
    private final String placeholderToken;
    private static final String REPLACE_ONE_MARKER = "?";
    private static final String REPLACE_ALL_MARKER = "*";
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final Map<String, Config> functions = Maps.newHashMap();
    private final Multimap<String, String> methods = HashMultimap.create();
    private final NameGenerator nameGenerator;
    private final Map<String, Result> results = Maps.newLinkedHashMap();

    ReplaceStrings(AbstractCompiler abstractCompiler, String string, List<String> list, Set<String> set) {
        this.compiler = abstractCompiler;
        this.placeholderToken = string.isEmpty() ? "`" : string;
        this.registry = abstractCompiler.getTypeRegistry();
        this.nameGenerator = ReplaceStrings.createNameGenerator(set);
        this.parseConfiguration(list);
    }

    List<Result> getResult() {
        return ImmutableList.copyOf(this.results.values());
    }

    VariableMap getStringMap() {
        HashMap hashMap = Maps.newHashMap();
        for (Result result : this.results.values()) {
            hashMap.put(result.replacement, this.escapeForVariableMap(result.original));
        }
        VariableMap variableMap = new VariableMap(hashMap);
        return variableMap;
    }

    private String escapeForVariableMap(String string) {
        return string.replace("\\", "\\\\").replace("\n", "\\n");
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 30: 
            case 37: {
                JSType jSType;
                Config config;
                Node node3;
                String string;
                Collection collection;
                Object object;
                Node node4 = node.getFirstChild();
                String string2 = node4.getQualifiedName();
                if (string2 != null && (object = this.findMatching(string2)) != null) {
                    this.doSubstitutions(nodeTraversal, (Config)object, node);
                    return;
                }
                if (!NodeUtil.isGet(node4) || ((Node)(object = node4.getLastChild())).getType() != 38 && ((Node)object).getType() != 40 || (collection = this.methods.get((Object)(string = ((Node)object).getString()))) == null || (node3 = node4.getFirstChild()).getJSType() == null || (config = this.findMatchingClass(jSType = node3.getJSType().restrictByNotNullOrUndefined(), collection)) == null) break;
                this.doSubstitutions(nodeTraversal, config, node);
                return;
            }
        }
    }

    private Config findMatching(String string) {
        Config config = this.functions.get(string);
        if (config == null) {
            string = string.replace('$', '.');
            config = this.functions.get(string);
        }
        return config;
    }

    private Config findMatchingClass(JSType jSType, Collection<String> collection) {
        if (!jSType.isNoObjectType() && !jSType.isUnknownType()) {
            for (String string : collection) {
                String string2 = this.getClassFromDeclarationName(string);
                JSType jSType2 = this.registry.getType(string2);
                if (jSType2 == null || !jSType.isSubtype(jSType2)) continue;
                return this.functions.get(string);
            }
        }
        return null;
    }

    private void doSubstitutions(NodeTraversal nodeTraversal, Config config, Node node) {
        Preconditions.checkState((node.getType() == 30 || node.getType() == 37 ? 1 : 0) != 0);
        if (config.parameter != 0) {
            Node node2 = node.getChildAtIndex(config.parameter);
            if (node2 != null) {
                this.replaceExpression(nodeTraversal, node2, node);
            }
        } else {
            Node node3;
            for (Node node4 = node3 = node.getFirstChild().getNext(); node4 != null; node4 = node4.getNext()) {
                node4 = this.replaceExpression(nodeTraversal, node4, node);
            }
        }
    }

    private Node replaceExpression(NodeTraversal nodeTraversal, Node node, Node node2) {
        Node node3;
        String string;
        String string2 = null;
        switch (node.getType()) {
            case 40: {
                string2 = node.getString();
                string = this.getReplacement(string2);
                node3 = Node.newString(string);
                break;
            }
            case 21: {
                StringBuilder stringBuilder = new StringBuilder();
                Node node4 = Node.newString("");
                node3 = this.buildReplacement(node, node4, stringBuilder);
                string2 = stringBuilder.toString();
                string = this.getReplacement(string2);
                node4.setString(string);
                break;
            }
            case 38: {
                Node node5;
                Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
                if (var != null && var.isConst() && (node5 = var.getInitialValue()) != null && node5.getType() == 40) {
                    string2 = node5.getString();
                    string = this.getReplacement(string2);
                    node3 = Node.newString(string);
                    break;
                }
                return node;
            }
            default: {
                return node;
            }
        }
        Preconditions.checkNotNull((Object)string2);
        Preconditions.checkNotNull((Object)string);
        this.recordReplacement(node, string2, string);
        node2.replaceChild(node, node3);
        this.compiler.reportCodeChange();
        return node3;
    }

    private String getReplacement(String string) {
        Result result = this.results.get(string);
        if (result != null) {
            return result.replacement;
        }
        String string2 = this.nameGenerator.generateNextName();
        result = new Result(string, string2);
        this.results.put(string, result);
        return string2;
    }

    private void recordReplacement(Node node, String string, String string2) {
        Result result = this.results.get(string);
        Preconditions.checkState((result != null ? 1 : 0) != 0);
        result.addLocation(node);
    }

    private Node buildReplacement(Node node, Node node2, StringBuilder stringBuilder) {
        switch (node.getType()) {
            case 21: {
                Node node3 = node.getFirstChild();
                Node node4 = node3.getNext();
                node2 = this.buildReplacement(node3, node2, stringBuilder);
                return this.buildReplacement(node4, node2, stringBuilder);
            }
            case 40: {
                stringBuilder.append(node.getString());
                return node2;
            }
        }
        stringBuilder.append(this.placeholderToken);
        node2 = new Node(21, node2, Node.newString(this.placeholderToken));
        return new Node(21, node2, node.cloneTree());
    }

    private String getMethodFromDeclarationName(String string) {
        String[] stringArray = string.split("\\.prototype\\.");
        Preconditions.checkState((stringArray.length == 1 || stringArray.length == 2 ? 1 : 0) != 0);
        if (stringArray.length == 2) {
            return stringArray[1];
        }
        return null;
    }

    private String getClassFromDeclarationName(String string) {
        String[] stringArray = string.split("\\.prototype\\.");
        Preconditions.checkState((stringArray.length == 1 || stringArray.length == 2 ? 1 : 0) != 0);
        if (stringArray.length == 2) {
            return stringArray[0];
        }
        return null;
    }

    private void parseConfiguration(List<String> list) {
        for (String string : list) {
            Config config = this.parseConfiguration(string);
            this.functions.put(config.name, config);
            String string2 = this.getMethodFromDeclarationName(config.name);
            if (string2 == null) continue;
            this.methods.put((Object)string2, (Object)config.name);
        }
    }

    private Config parseConfiguration(String string) {
        String[] stringArray;
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        Preconditions.checkState((n != -1 && n2 != -1 ? 1 : 0) != 0);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        int n3 = 0;
        int n4 = -1;
        for (String string4 : stringArray = string3.split(",")) {
            ++n3;
            if (string4.equals(REPLACE_ALL_MARKER)) {
                Preconditions.checkState((n3 == 1 && stringArray.length == 1 ? 1 : 0) != 0);
                n4 = 0;
                continue;
            }
            if (string4.equals(REPLACE_ONE_MARKER)) {
                Preconditions.checkState((n4 == -1 ? 1 : 0) != 0);
                n4 = n3;
                continue;
            }
            Preconditions.checkState((boolean)string4.isEmpty(), (String)"Unknown marker", (Object[])new Object[]{string4});
        }
        Preconditions.checkState((n4 != -1 ? 1 : 0) != 0);
        return new Config(string2, n4);
    }

    private static NameGenerator createNameGenerator(Set<String> set) {
        char[] cArray = new char[]{};
        return new NameGenerator((Set<String>)ImmutableSet.copyOf(set), "", cArray);
    }

    class Location {
        public final String sourceFile;
        public final int line;
        public final int column;

        Location(String string, int n, int n2) {
            this.sourceFile = string;
            this.line = n;
            this.column = n2;
        }
    }

    class Result {
        public final String original;
        public final String replacement;
        public final List<Location> replacementLocations = Lists.newLinkedList();

        Result(String string, String string2) {
            this.original = string;
            this.replacement = string2;
        }

        void addLocation(Node node) {
            this.replacementLocations.add(new Location((String)node.getProp(16), node.getLineno(), node.getCharno()));
        }
    }

    private class Config {
        final String name;
        final int parameter;
        static final int REPLACE_ALL_VALUE = 0;

        Config(String string, int n) {
            this.name = string;
            this.parameter = n;
        }
    }
}

