/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConcreteType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionPrototypeType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TightenTypes
implements CompilerPass,
ConcreteType.Factory {
    public static final String NON_HALTING_ERROR_MSG = "TightenTypes pass appears to be stuck in an infinite loop.";
    private final AbstractCompiler compiler;
    private final Map<Node, ConcreteType.ConcreteFunctionType> functionFromDeclaration = Maps.newHashMap();
    private final Map<FunctionType, ConcreteType.ConcreteFunctionType> functionFromJSType = Maps.newIdentityHashMap();
    private final Map<ObjectType, ConcreteType.ConcreteInstanceType> instanceFromJSType = Maps.newHashMap();
    private final Map<ConcreteJSTypePair, ConcreteType> typeIntersectionMemos = Maps.newHashMap();
    private ConcreteScope topScope;
    private Set<ConcreteType> allInstantiatedTypes = Sets.newHashSet();

    TightenTypes(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    ConcreteScope getTopScope() {
        return this.topScope;
    }

    @Override
    public JSTypeRegistry getTypeRegistry() {
        return this.compiler.getTypeRegistry();
    }

    @Override
    public void process(Node node, Node node2) {
        boolean bl;
        this.topScope = new ConcreteScope(null);
        this.topScope.initForExternRoot(node);
        this.topScope.initForScopeRoot(node2);
        long l = 1000L;
        long l2 = 0L;
        HashSet hashSet = Sets.newHashSet((Object[])new ConcreteScope[]{this.topScope});
        ArrayList arrayList = Lists.newArrayList((Object[])new ConcreteScope[]{this.topScope});
        do {
            bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                ConcreteScope concreteScope = (ConcreteScope)arrayList.get(i);
                for (Action action : concreteScope.getActions()) {
                    for (Assignment assignment : action.getAssignments(concreteScope)) {
                        if (!assignment.slot.addConcreteType(assignment.type)) continue;
                        bl = true;
                        ConcreteScope concreteScope2 = assignment.slot.getScope();
                        if (concreteScope2 == concreteScope || hashSet.contains(concreteScope2)) continue;
                        hashSet.add(concreteScope2);
                        arrayList.add(concreteScope2);
                    }
                }
            }
            Preconditions.checkState((++l2 != l ? 1 : 0) != 0, (Object)NON_HALTING_ERROR_MSG);
        } while (bl);
    }

    private List<Assignment> getFunctionCallAssignments(ConcreteType concreteType, ConcreteType concreteType2, List<ConcreteType> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (ConcreteType.ConcreteFunctionType concreteFunctionType : concreteType.getFunctions()) {
            arrayList.add(new Assignment((ConcreteSlot)concreteFunctionType.getCallSlot(), concreteFunctionType));
            arrayList.add(new Assignment((ConcreteSlot)concreteFunctionType.getThisSlot(), concreteType2));
            for (int i = 0; i < list.size(); ++i) {
                ConcreteSlot concreteSlot = (ConcreteSlot)concreteFunctionType.getParameterSlot(i);
                if (concreteSlot == null) continue;
                arrayList.add(new Assignment(concreteSlot, list.get(i)));
            }
        }
        return arrayList;
    }

    private ConcreteType createType(Node node, ConcreteScope concreteScope) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkArgument((node.getType() == 38 ? 1 : 0) != 0);
        if (node.getJSType() == null) {
            return ConcreteType.ALL;
        }
        if (node.getFirstChild() != null && node.getFirstChild().getType() == 105) {
            return this.createConcreteFunction(node.getFirstChild(), concreteScope);
        }
        return this.createType(node.getJSType());
    }

    private ConcreteType createType(JSType jSType) {
        if (jSType.isUnknownType() || jSType.isEmptyType()) {
            return ConcreteType.ALL;
        }
        if (jSType.isUnionType()) {
            ConcreteType concreteType = ConcreteType.NONE;
            for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                concreteType = concreteType.unionWith(this.createType(jSType2));
            }
            return concreteType;
        }
        if (jSType.isFunctionType()) {
            if (this.getConcreteFunction((FunctionType)jSType) != null) {
                return this.getConcreteFunction((FunctionType)jSType);
            }
            return ConcreteType.ALL;
        }
        if (jSType.isObject()) {
            return this.createConcreteInstance(jSType.toObjectType());
        }
        return ConcreteType.NONE;
    }

    private ConcreteType createTypeWithSubTypes(JSType jSType) {
        ConcreteType concreteType = ConcreteType.NONE;
        if (jSType instanceof UnionType) {
            for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                concreteType = concreteType.unionWith(this.createTypeWithSubTypes(jSType2));
            }
        } else {
            ObjectType objectType = ObjectType.cast(jSType);
            if (objectType != null && objectType.getConstructor() != null && objectType.getConstructor().isInterface()) {
                Collection<FunctionType> collection = this.getTypeRegistry().getDirectImplementors(objectType);
                for (FunctionType functionType : collection) {
                    concreteType = concreteType.unionWith(this.createTypeWithSubTypes(functionType.getInstanceType()));
                }
            } else {
                concreteType = concreteType.unionWith(this.createUnionWithSubTypes(this.createType(jSType)));
            }
        }
        return concreteType;
    }

    ConcreteType inferConcreteType(ConcreteScope concreteScope, Node node) {
        ConcreteType concreteType;
        Preconditions.checkNotNull((Object)concreteScope);
        Preconditions.checkNotNull((Object)node);
        switch (node.getType()) {
            case 38: {
                StaticSlot<ConcreteType> staticSlot = concreteScope.getSlot(node.getString());
                if (staticSlot != null) {
                    concreteType = staticSlot.getType();
                    break;
                }
                concreteType = ConcreteType.ALL;
                break;
            }
            case 42: {
                concreteType = concreteScope.getTypeOfThis();
                break;
            }
            case 86: {
                concreteType = this.inferConcreteType(concreteScope, node.getLastChild());
                break;
            }
            case 85: {
                concreteType = this.inferConcreteType(concreteScope, node.getLastChild());
                break;
            }
            case 101: {
                concreteType = this.inferConcreteType(concreteScope, node.getLastChild());
                break;
            }
            case 100: {
                concreteType = this.inferConcreteType(concreteScope, node.getFirstChild()).unionWith(this.inferConcreteType(concreteScope, node.getLastChild()));
                break;
            }
            case 98: {
                concreteType = this.inferConcreteType(concreteScope, node.getFirstChild().getNext()).unionWith(this.inferConcreteType(concreteScope, node.getLastChild()));
                break;
            }
            case 33: {
                ConcreteType concreteType2 = this.inferConcreteType(concreteScope, node.getFirstChild());
                if (concreteType2.isAll()) {
                    concreteType = concreteType2;
                    break;
                }
                Node node2 = node.getLastChild();
                String string = node2.getString();
                ConcreteType concreteType3 = concreteType2.getPropertyType(string);
                if ("prototype".equals(string)) {
                    for (ConcreteType.ConcreteFunctionType concreteFunctionType : concreteType2.getFunctions()) {
                        concreteType3 = concreteType3.unionWith(concreteFunctionType.getPrototypeType());
                    }
                } else if (this.compiler.getCodingConvention().isSuperClassReference(string)) {
                    for (ConcreteType.ConcreteFunctionType concreteFunctionType : concreteType2.getSuperclassTypes()) {
                        concreteType3 = concreteType3.unionWith(concreteFunctionType.getPrototypeType());
                    }
                } else if ("call".equals(string)) {
                    concreteType3 = concreteType2;
                }
                concreteType = concreteType3;
                break;
            }
            case 35: {
                concreteType = ConcreteType.ALL;
                break;
            }
            case 37: {
                ConcreteType concreteType4 = this.inferConcreteType(concreteScope, node.getFirstChild());
                if (concreteType4.isAll()) {
                    concreteType = concreteType4;
                    break;
                }
                concreteType = ConcreteType.NONE;
                for (ConcreteType.ConcreteFunctionType concreteFunctionType : concreteType4.getFunctions()) {
                    concreteType = concreteType.unionWith(concreteFunctionType.getReturnSlot().getType());
                }
                break;
            }
            case 30: {
                ConcreteType concreteType5 = this.inferConcreteType(concreteScope, node.getFirstChild());
                if (concreteType5.isAll()) {
                    throw new AssertionError((Object)"Attempted new call on all type!");
                }
                concreteType = ConcreteType.NONE;
                for (ConcreteType.ConcreteInstanceType concreteInstanceType : concreteType5.getFunctionInstanceTypes()) {
                    concreteType = concreteType.unionWith(concreteInstanceType);
                }
                this.allInstantiatedTypes.add(concreteType);
                break;
            }
            case 105: {
                concreteType = this.createConcreteFunction(node, concreteScope);
                break;
            }
            case 64: {
                if (node.getJSType() != null && !node.getJSType().isUnknownType()) {
                    JSType jSType = node.getJSType().restrictByNotNullOrUndefined();
                    ConcreteType.ConcreteInstanceType concreteInstanceType = this.createConcreteInstance(jSType.toObjectType());
                    this.allInstantiatedTypes.add(concreteInstanceType);
                    concreteType = concreteInstanceType;
                    break;
                }
                concreteType = ConcreteType.ALL;
                break;
            }
            case 63: {
                ObjectType objectType = (ObjectType)this.getTypeRegistry().getNativeType(JSTypeNative.ARRAY_TYPE);
                ConcreteType.ConcreteInstanceType concreteInstanceType = this.createConcreteInstance(objectType);
                this.allInstantiatedTypes.add(concreteInstanceType);
                concreteType = concreteInstanceType;
                break;
            }
            default: {
                concreteType = ConcreteType.NONE;
            }
        }
        return this.createTypeIntersection(concreteType, node.getJSType());
    }

    private ConcreteType createTypeIntersection(ConcreteType concreteType, JSType jSType) {
        ConcreteJSTypePair concreteJSTypePair = new ConcreteJSTypePair(concreteType, jSType);
        ConcreteType concreteType2 = this.typeIntersectionMemos.get(concreteJSTypePair);
        if (concreteType2 != null) {
            return concreteType2;
        }
        if (jSType == null || jSType.isUnknownType() || concreteType.isNone()) {
            concreteType2 = concreteType;
        } else if (concreteType.isUnion() || concreteType.isSingleton()) {
            concreteType2 = concreteType.intersectWith(this.createTypeWithSubTypes(jSType));
        } else {
            Preconditions.checkState((boolean)concreteType.isAll());
            concreteType2 = this.createTypeWithSubTypes(jSType);
        }
        concreteType2 = concreteType2.intersectWith(ConcreteType.createForTypes(this.allInstantiatedTypes));
        for (ConcreteType.ConcreteFunctionType concreteType3 : concreteType.getFunctions()) {
            concreteType2 = concreteType2.unionWith(concreteType3);
        }
        for (ConcreteType.ConcreteInstanceType concreteInstanceType : concreteType.getPrototypeTypes()) {
            concreteType2 = concreteType2.unionWith(concreteInstanceType);
        }
        for (ConcreteType.ConcreteInstanceType concreteInstanceType : concreteType.getInstances()) {
            if (concreteInstanceType.instanceType.isInstanceType() || concreteInstanceType.isFunctionPrototype()) continue;
            concreteType2 = concreteType2.unionWith(concreteInstanceType);
        }
        this.typeIntersectionMemos.put(concreteJSTypePair, concreteType2);
        return concreteType2;
    }

    @Override
    public ConcreteType.ConcreteFunctionType createConcreteFunction(Node node, StaticScope<ConcreteType> staticScope) {
        ConcreteType.ConcreteFunctionType concreteFunctionType = this.functionFromDeclaration.get(node);
        if (concreteFunctionType == null) {
            concreteFunctionType = new ConcreteType.ConcreteFunctionType(this, node, staticScope);
            this.functionFromDeclaration.put(node, concreteFunctionType);
            if (node.getJSType() != null) {
                this.functionFromJSType.put((FunctionType)node.getJSType(), concreteFunctionType);
            }
        }
        return concreteFunctionType;
    }

    @Override
    public ConcreteType.ConcreteInstanceType createConcreteInstance(ObjectType objectType) {
        Preconditions.checkArgument((!objectType.isFunctionType() || objectType == this.getTypeRegistry().getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE) ? 1 : 0) != 0);
        ConcreteType.ConcreteInstanceType concreteInstanceType = this.instanceFromJSType.get(objectType);
        if (concreteInstanceType == null) {
            concreteInstanceType = new ConcreteType.ConcreteInstanceType(this, objectType);
            this.instanceFromJSType.put(objectType, concreteInstanceType);
        }
        return concreteInstanceType;
    }

    ConcreteType.ConcreteFunctionType getConcreteFunction(Node node) {
        return this.functionFromDeclaration.get(node);
    }

    @Override
    public ConcreteType.ConcreteFunctionType getConcreteFunction(FunctionType functionType) {
        return this.functionFromJSType.get(functionType);
    }

    @Override
    public ConcreteType.ConcreteInstanceType getConcreteInstance(ObjectType objectType) {
        return this.instanceFromJSType.get(objectType);
    }

    @Override
    public StaticScope<ConcreteType> createFunctionScope(Node node, StaticScope<ConcreteType> staticScope) {
        ConcreteScope concreteScope = new ConcreteScope((ConcreteScope)staticScope);
        concreteScope.declareSlot(":call", node);
        concreteScope.declareSlot(":this", node);
        concreteScope.declareSlot(":return", node);
        for (Node node2 = node.getFirstChild().getNext().getFirstChild(); node2 != null; node2 = node2.getNext()) {
            concreteScope.declareSlot(node2.getString(), node2);
        }
        concreteScope.initForScopeRoot(node.getLastChild());
        return concreteScope;
    }

    @Override
    public StaticScope<ConcreteType> createInstanceScope(ObjectType objectType) {
        Object object;
        ConcreteScope concreteScope = null;
        ObjectType objectType2 = objectType.getImplicitPrototype();
        if (objectType2 != null && !objectType2.isUnknownType()) {
            object = this.createConcreteInstance(objectType2);
            concreteScope = (ConcreteScope)((ConcreteType.ConcreteInstanceType)object).getScope();
        }
        object = new ConcreteScope(concreteScope);
        for (String string : objectType.getOwnPropertyNames()) {
            ((ConcreteScope)object).declareSlot(string, null);
        }
        return object;
    }

    ConcreteType createUnionWithSubTypes(ConcreteType concreteType) {
        Set<ConcreteType> set = null;
        if (concreteType.isInstance()) {
            set = this.getSubTypes(concreteType.toInstance());
        }
        return ConcreteType.createForTypes(set).unionWith(concreteType);
    }

    private Set<ConcreteType> getSubTypes(ConcreteType.ConcreteInstanceType concreteInstanceType) {
        if (concreteInstanceType.getConstructorType() == null) {
            return null;
        }
        HashSet hashSet = Sets.newHashSet();
        this.getSubTypes(concreteInstanceType.getConstructorType().getJSType(), hashSet);
        return hashSet;
    }

    private boolean getSubTypes(FunctionType functionType, Set<ConcreteType> set) {
        if (functionType.getSubTypes() != null) {
            for (FunctionType functionType2 : functionType.getSubTypes()) {
                ConcreteType concreteType = this.createType(functionType2);
                if (concreteType.isFunction() && concreteType.toFunction().getInstanceType() != null) {
                    if (set.contains(concreteType = concreteType.toFunction().getInstanceType())) continue;
                    set.add(concreteType);
                    if (this.getSubTypes(functionType2, set)) continue;
                    return false;
                }
                set.clear();
                set.add(ConcreteType.ALL);
                return false;
            }
        }
        return true;
    }

    static class ConcreteJSTypePair {
        final ConcreteType concrete;
        final JSType jstype;
        final int hashcode;

        ConcreteJSTypePair(ConcreteType concreteType, JSType jSType) {
            this.concrete = concreteType;
            this.jstype = jSType;
            this.hashcode = concreteType.hashCode() + this.getJSTypeHashCode();
        }

        private int getJSTypeHashCode() {
            return this.jstype != null ? this.jstype.hashCode() : 0;
        }

        private boolean equalsJSType(JSType jSType) {
            if (jSType == null || this.jstype == null) {
                return this.jstype == jSType;
            }
            return jSType.equals(this.jstype);
        }

        public boolean equals(Object object) {
            if (object instanceof ConcreteJSTypePair) {
                ConcreteJSTypePair concreteJSTypePair = (ConcreteJSTypePair)object;
                if (concreteJSTypePair.concrete.equals(this.concrete) && this.equalsJSType(concreteJSTypePair.jstype)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    private class CreateScope
    extends NodeTraversal.AbstractShallowCallback {
        private final ConcreteScope scope;
        private final boolean inExterns;

        CreateScope(ConcreteScope concreteScope, boolean bl) {
            this.scope = concreteScope;
            this.inExterns = bl;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Object object;
            Object object2;
            Object object3;
            switch (node.getType()) {
                case 118: {
                    for (object3 = node.getFirstChild(); object3 != null; object3 = ((Node)object3).getNext()) {
                        if (this.inExterns) {
                            this.scope.declareSlot(((Node)object3).getString(), node, TightenTypes.this.createType((Node)object3, this.scope));
                            continue;
                        }
                        this.scope.declareSlot(((Node)object3).getString(), node);
                        if (((Node)object3).getFirstChild() == null) continue;
                        this.addActions(this.createAssignmentActions((Node)object3, ((Node)object3).getFirstChild(), node));
                    }
                    break;
                }
                case 33: {
                    if (!this.inExterns || !((ConcreteType)(object2 = TightenTypes.this.inferConcreteType(TightenTypes.this.getTopScope(), node))).isNone() || (object = (ConcreteScope)TightenTypes.this.inferConcreteType(TightenTypes.this.getTopScope(), node.getFirstChild()).getScope()) == null || ((ConcreteType)(object2 = TightenTypes.this.createType(node.getJSType()))).isNone() || ((ConcreteType)object2).isAll()) break;
                    object2 = TightenTypes.this.createUnionWithSubTypes((ConcreteType)object2);
                    Object object4 = node.getLastChild();
                    ((ConcreteScope)object).declareSlot(((Node)object4).getString(), node, (ConcreteType)object2);
                    break;
                }
                case 105: {
                    if (!NodeUtil.isFunctionDeclaration(node) || node.getJSType().isNoObjectType()) break;
                    object2 = TightenTypes.this.createConcreteFunction(node, this.scope);
                    this.scope.declareSlot(node.getFirstChild().getString(), node, (ConcreteType)object2);
                    if (!this.inExterns || ((ConcreteType.ConcreteFunctionType)object2).getInstanceType() == null) break;
                    TightenTypes.this.allInstantiatedTypes.add(((ConcreteType.ConcreteFunctionType)object2).getInstanceType());
                    break;
                }
                case 86: {
                    Object object4;
                    object2 = node.getFirstChild();
                    if (this.inExterns) {
                        if (((Node)object2).getType() == 33) {
                            object4 = TightenTypes.this.inferConcreteType(TightenTypes.this.getTopScope(), ((Node)object2).getFirstChild());
                            object = (ConcreteScope)((ConcreteType)object4).getScope();
                        } else {
                            object = TightenTypes.this.getTopScope();
                        }
                        if (object == null || ((ConcreteType)(object4 = TightenTypes.this.inferConcreteType(TightenTypes.this.getTopScope(), node))).isNone() || ((ConcreteType)object4).isAll()) break;
                        if (((ConcreteType)object4).isFunction()) {
                            if (((Node)object2).getJSType() == null || !(((Node)object2).getJSType() instanceof FunctionType)) break;
                            ConcreteType concreteType = TightenTypes.this.createType(((FunctionType)((Node)object2).getJSType().restrictByNotNullOrUndefined()).getReturnType());
                            concreteType = TightenTypes.this.createUnionWithSubTypes(concreteType);
                            ConcreteType concreteType2 = ((ConcreteType)object4).toFunction().getReturnSlot().getType().unionWith(concreteType);
                            ((ConcreteScope)((ConcreteType)object4).getScope()).declareSlot(":return", node, concreteType2);
                        }
                        ((ConcreteScope)object).declareSlot(((Node)object2).getLastChild().getString(), node, (ConcreteType)object4);
                        break;
                    }
                    this.addActions(this.createAssignmentActions((Node)object2, node.getLastChild(), node));
                    break;
                }
                case 30: 
                case 37: {
                    Object object4;
                    object = node.getFirstChild();
                    if (((Node)object).getType() == 33) {
                        object4 = ((Node)object).getFirstChild();
                        if ("call".equals(((Node)object4).getNext().getString())) {
                            if (((Node)object4).getType() == 33) {
                                this.addAction(new FunctionCallBuilder((Node)object4, ((Node)object).getNext()).setPropName(((Node)object4).getFirstChild().getNext().getString()).setIsCallFunction().build());
                                break;
                            }
                            this.addAction(new FunctionCallBuilder((Node)object4, ((Node)object).getNext()).setIsCallFunction().build());
                            break;
                        }
                        this.addAction(new FunctionCallBuilder((Node)object4, ((Node)object).getNext()).setPropName(((Node)object4).getNext().getString()).build());
                        break;
                    }
                    this.addAction(new FunctionCallBuilder((Node)object, ((Node)object).getNext()).setIsNewCall(node.getType() == 30).build());
                    break;
                }
                case 38: {
                    if (node2.getType() != 120 || node2.getFirstChild() != node) break;
                    this.scope.declareSlot(node.getString(), node, TightenTypes.this.createUnionWithSubTypes(TightenTypes.this.createType(TightenTypes.this.getTypeRegistry().getType("Error")).toInstance()));
                    break;
                }
                case 4: {
                    if (node.getFirstChild() == null) break;
                    this.addAction(new VariableAssignAction((ConcreteSlot)this.scope.getOwnSlot(":return"), node.getFirstChild()));
                }
            }
            object3 = this.getImplicitActions(node);
            if (object3 != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Action)object2.next();
                    this.addAction((Action)object);
                }
            }
        }

        private void addAction(Action action) {
            Preconditions.checkState((!this.inExterns ? 1 : 0) != 0, (Object)"Unexpected action in externs.");
            this.scope.addAction(action);
        }

        private void addActions(List<Action> list) {
            Preconditions.checkState((!this.inExterns ? 1 : 0) != 0, (Object)"Unexpected action in externs.");
            for (Action action : list) {
                this.scope.addAction(action);
            }
        }

        private List<Action> createAssignmentActions(Node node, Node node2, Node node3) {
            switch (node.getType()) {
                case 38: {
                    ConcreteSlot concreteSlot = (ConcreteSlot)this.scope.getSlot(node.getString());
                    Preconditions.checkState((concreteSlot != null ? 1 : 0) != 0, (String)"Type tightener could not find variable with name %s", (Object[])new Object[]{node.getString()});
                    return Lists.newArrayList((Object[])new Action[]{new VariableAssignAction(concreteSlot, node2)});
                }
                case 33: {
                    Node node4 = node.getFirstChild();
                    return Lists.newArrayList((Object[])new Action[]{new PropertyAssignAction(node4, node2)});
                }
                case 35: {
                    return Lists.newArrayList();
                }
                case 65: {
                    if (node.getFirstChild().getType() == 69) {
                        return Lists.newArrayList();
                    }
                    throw new AssertionError((Object)("Bad LHS for getref: " + node3.toStringTree()));
                }
            }
            throw new AssertionError((Object)("Bad LHS for assignment: " + node3.toStringTree()));
        }

        private ExternFunctionCall createExternFunctionCall(Node node, JSType jSType, FunctionType functionType) {
            ConcreteType concreteType;
            ArrayList arrayList = Lists.newArrayList();
            if (functionType != null) {
                concreteType = TightenTypes.this.createType(jSType);
                for (Node node2 : functionType.getParameters()) {
                    arrayList.add(TightenTypes.this.createType(node2, this.scope));
                }
            } else {
                concreteType = ConcreteType.NONE;
            }
            return new ExternFunctionCall(node, concreteType, arrayList);
        }

        private JSType getJSType(Node node) {
            if (node.getJSType() != null) {
                return node.getJSType();
            }
            return TightenTypes.this.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        private Collection<Action> getImplicitActions(Node node) {
            switch (node.getType()) {
                case 37: {
                    Node node2 = node.getFirstChild();
                    if (this.inExterns || node2.getType() != 33) break;
                    return this.getImplicitActionsFromCall(node, node2.getJSType());
                }
                case 86: {
                    Node node3 = node.getFirstChild();
                    if (this.inExterns || node3.getType() != 33) break;
                    return this.getImplicitActionsFromProp(node3.getFirstChild().getJSType(), node3.getLastChild().getString(), node.getLastChild());
                }
            }
            return null;
        }

        private Collection<Action> getImplicitActionsFromCall(Node node, JSType jSType) {
            Node node2 = node.getFirstChild();
            if (jSType instanceof UnionType) {
                ArrayList arrayList = Lists.newArrayList();
                for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                    arrayList.addAll(this.getImplicitActionsFromCall(node, jSType2));
                }
                return arrayList;
            }
            if (!(jSType instanceof FunctionType)) {
                return Lists.newArrayList();
            }
            ObjectType objectType = ObjectType.cast(this.getJSType(node2.getFirstChild()).restrictByNotNullOrUndefined());
            String string = node2.getLastChild().getString();
            if (objectType != null && objectType.isPropertyInExterns(string) && ((FunctionType)jSType).getParameters() != null) {
                ArrayList arrayList = Lists.newArrayList();
                Iterator<Node> iterator = ((FunctionType)jSType).getParameters().iterator();
                Iterator<Node> iterator2 = node.children().iterator();
                iterator2.next();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    Node node3 = iterator2.next();
                    Node node4 = iterator.next();
                    if (!(node3.getJSType() instanceof FunctionType)) continue;
                    arrayList.addAll(this.getImplicitActionsFromArgument(node3, ((FunctionType)node3.getJSType()).getTypeOfThis(), node4.getJSType()));
                }
                return arrayList;
            }
            return Lists.newArrayList();
        }

        private Collection<Action> getImplicitActionsFromArgument(Node node, ObjectType objectType, JSType jSType) {
            if (jSType instanceof UnionType) {
                ArrayList arrayList = Lists.newArrayList();
                for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                    arrayList.addAll(this.getImplicitActionsFromArgument(node, objectType, jSType2));
                }
                return arrayList;
            }
            if (jSType instanceof FunctionType) {
                return Lists.newArrayList((Object[])new Action[]{this.createExternFunctionCall(node, objectType, (FunctionType)jSType)});
            }
            return Lists.newArrayList((Object[])new Action[]{this.createExternFunctionCall(node, objectType, null)});
        }

        private Collection<Action> getImplicitActionsFromProp(JSType jSType, String string, Node node) {
            ArrayList arrayList = Lists.newArrayList();
            if (jSType instanceof UnionType) {
                boolean bl = false;
                for (JSType jSType2 : ((UnionType)jSType).getAlternates()) {
                    ObjectType objectType = ObjectType.cast(jSType2);
                    if (objectType == null) continue;
                    arrayList.addAll(this.getImplicitActionsFromPropNonUnion(objectType, string, node));
                    if (!objectType.hasProperty(string)) continue;
                    bl = true;
                }
                if (bl) {
                    return arrayList;
                }
            } else {
                ObjectType objectType = ObjectType.cast(jSType);
                if (objectType != null && !objectType.isUnknownType() && objectType.hasProperty(string)) {
                    return this.getImplicitActionsFromPropNonUnion(objectType, string, node);
                }
            }
            for (ObjectType objectType : TightenTypes.this.getTypeRegistry().getEachReferenceTypeWithProperty(string)) {
                arrayList.addAll(this.getImplicitActionsFromPropNonUnion(objectType, string, node));
            }
            return arrayList;
        }

        private Collection<Action> getImplicitActionsFromPropNonUnion(ObjectType objectType, String string, Node node) {
            JSType jSType = objectType.getPropertyType(string).restrictByNotNullOrUndefined();
            if (objectType.isPropertyInExterns(string) && jSType.isFunctionType()) {
                ObjectType objectType2 = objectType;
                if (objectType instanceof FunctionPrototypeType) {
                    objectType2 = ((FunctionPrototypeType)objectType).getOwnerFunction().getInstanceType();
                }
                FunctionType functionType = null;
                if (jSType instanceof FunctionType) {
                    functionType = (FunctionType)jSType;
                }
                ExternFunctionCall externFunctionCall = this.createExternFunctionCall(node, objectType2, functionType);
                return Lists.newArrayList((Object[])new Action[]{externFunctionCall});
            }
            return Lists.newArrayList();
        }
    }

    private class NativeCallFunctionCall
    implements Action {
        private final Node receiver;
        private final String propName;
        private final Node firstArgument;

        NativeCallFunctionCall(Node node, String string, Node node2) {
            this.receiver = node;
            this.propName = string;
            this.firstArgument = node2;
            Preconditions.checkNotNull((Object)node);
        }

        @Override
        public Collection<Assignment> getAssignments(ConcreteScope concreteScope) {
            ConcreteType concreteType = this.firstArgument != null ? TightenTypes.this.inferConcreteType(concreteScope, this.firstArgument) : TightenTypes.this.getTopScope().getTypeOfThis();
            ConcreteType concreteType2 = TightenTypes.this.inferConcreteType(concreteScope, this.receiver);
            if (concreteType2 instanceof ConcreteType.ConcreteInstanceType && ((ConcreteType.ConcreteInstanceType)concreteType2).isFunctionPrototype()) {
                concreteType2 = concreteType.getPropertyType(this.propName);
            }
            ArrayList arrayList = Lists.newArrayList();
            for (Node node = this.firstArgument.getNext(); node != null; node = node.getNext()) {
                arrayList.add(TightenTypes.this.inferConcreteType(concreteScope, node));
            }
            return TightenTypes.this.getFunctionCallAssignments(concreteType2, concreteType, arrayList);
        }
    }

    private class FunctionCall
    implements Action {
        private final boolean isNewCall;
        private final Node receiver;
        private final String propName;
        private final Node firstArgument;

        FunctionCall(boolean bl, Node node, String string, Node node2) {
            this.isNewCall = bl;
            this.receiver = node;
            this.propName = string;
            this.firstArgument = node2;
            Preconditions.checkNotNull((Object)node);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<Assignment> getAssignments(ConcreteScope concreteScope) {
            void var5_9;
            ConcreteType concreteType = ConcreteType.NONE;
            ConcreteType concreteType2 = TightenTypes.this.inferConcreteType(concreteScope, this.receiver);
            if (this.propName != null) {
                concreteType = concreteType2;
                concreteType2 = concreteType.getPropertyType(this.propName);
            }
            if (concreteType2.isAll()) {
                throw new AssertionError((Object)"Found call on all type, which makes tighten types useless.");
            }
            if (this.isNewCall) {
                concreteType = ConcreteType.NONE;
                for (ConcreteType.ConcreteInstanceType object : concreteType2.getFunctionInstanceTypes()) {
                    concreteType = concreteType.unionWith(object);
                }
                boolean bl = TightenTypes.this.allInstantiatedTypes.add(concreteType);
                if (bl) {
                    TightenTypes.this.typeIntersectionMemos.clear();
                }
            }
            ArrayList arrayList = Lists.newArrayList();
            Node node = this.firstArgument;
            while (var5_9 != null) {
                arrayList.add(TightenTypes.this.inferConcreteType(concreteScope, (Node)var5_9));
                Node node2 = var5_9.getNext();
            }
            return TightenTypes.this.getFunctionCallAssignments(concreteType2, concreteType, arrayList);
        }
    }

    private class ExternFunctionCall
    implements Action {
        private Node receiver;
        private ConcreteType thisType;
        private List<ConcreteType> argTypes;

        ExternFunctionCall(Node node, ConcreteType concreteType, List<ConcreteType> list) {
            this.receiver = node;
            this.thisType = concreteType;
            this.argTypes = list;
        }

        @Override
        public Collection<Assignment> getAssignments(ConcreteScope concreteScope) {
            return TightenTypes.this.getFunctionCallAssignments(TightenTypes.this.inferConcreteType(concreteScope, this.receiver), this.thisType, this.argTypes);
        }
    }

    private class FunctionCallBuilder {
        private boolean isNewCall = false;
        private boolean isCallFunction = false;
        private final Node receiver;
        private final Node firstArgument;
        private String propName = null;

        FunctionCallBuilder(Node node, Node node2) {
            this.receiver = node;
            this.firstArgument = node2;
        }

        FunctionCallBuilder setPropName(String string) {
            this.propName = string;
            return this;
        }

        FunctionCallBuilder setIsNewCall(boolean bl) {
            Preconditions.checkState((!this.isCallFunction || !bl ? 1 : 0) != 0, (Object)"A function call cannot be of the form: new Object.call()");
            this.isNewCall = bl;
            return this;
        }

        FunctionCallBuilder setIsCallFunction() {
            Preconditions.checkState((!this.isNewCall ? 1 : 0) != 0, (Object)"A function call cannot be of the form: new Object.call()");
            this.isCallFunction = true;
            return this;
        }

        Action build() {
            if (this.isCallFunction) {
                return new NativeCallFunctionCall(this.receiver, this.propName, this.firstArgument);
            }
            return new FunctionCall(this.isNewCall, this.receiver, this.propName, this.firstArgument);
        }
    }

    private class PropertyAssignAction
    implements Action {
        private final Node receiver;
        private final String propName;
        private final Node expression;

        PropertyAssignAction(Node node, Node node2) {
            this.receiver = node;
            this.propName = node.getNext().getString();
            this.expression = node2;
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkNotNull((Object)this.propName);
            Preconditions.checkNotNull((Object)node2);
        }

        @Override
        public Collection<Assignment> getAssignments(ConcreteScope concreteScope) {
            ConcreteType concreteType = TightenTypes.this.inferConcreteType(concreteScope, this.receiver);
            ConcreteType concreteType2 = TightenTypes.this.inferConcreteType(concreteScope, this.expression);
            ArrayList arrayList = Lists.newArrayList();
            for (StaticSlot<ConcreteType> staticSlot : concreteType.getPropertySlots(this.propName)) {
                arrayList.add(new Assignment((ConcreteSlot)staticSlot, concreteType2));
            }
            return arrayList;
        }
    }

    private class VariableAssignAction
    implements Action {
        private final ConcreteSlot slot;
        private final Node expression;

        VariableAssignAction(ConcreteSlot concreteSlot, Node node) {
            this.slot = concreteSlot;
            this.expression = node;
            Preconditions.checkNotNull((Object)concreteSlot);
            Preconditions.checkNotNull((Object)node);
        }

        @Override
        public Collection<Assignment> getAssignments(ConcreteScope concreteScope) {
            return Lists.newArrayList((Object[])new Assignment[]{new Assignment(this.slot, TightenTypes.this.inferConcreteType(concreteScope, this.expression))});
        }
    }

    private static class Assignment {
        private final ConcreteSlot slot;
        private final ConcreteType type;

        Assignment(ConcreteSlot concreteSlot, ConcreteType concreteType) {
            this.slot = concreteSlot;
            this.type = concreteType;
            Preconditions.checkNotNull((Object)concreteSlot);
            Preconditions.checkNotNull((Object)concreteType);
        }
    }

    private static interface Action {
        public Collection<Assignment> getAssignments(ConcreteScope var1);
    }

    static class ConcreteSlot
    implements StaticSlot<ConcreteType> {
        private final ConcreteScope scope;
        private final String name;
        private ConcreteType type;

        ConcreteSlot(ConcreteScope concreteScope, String string) {
            this.scope = concreteScope;
            this.name = string;
            this.type = ConcreteType.NONE;
        }

        ConcreteScope getScope() {
            return this.scope;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ConcreteType getType() {
            return this.type;
        }

        @Override
        public boolean isTypeInferred() {
            return true;
        }

        boolean addConcreteType(ConcreteType concreteType) {
            ConcreteType concreteType2 = this.type;
            this.type = concreteType2.unionWith(concreteType);
            return !this.type.equals(concreteType2);
        }

        public String toString() {
            return this.getName() + ": " + this.getType();
        }
    }

    class ConcreteScope
    implements StaticScope<ConcreteType> {
        private final ConcreteScope parent;
        private final Map<String, ConcreteSlot> slots;
        private final List<Action> actions;

        ConcreteScope(ConcreteScope concreteScope) {
            this.parent = concreteScope;
            this.slots = Maps.newHashMap();
            this.actions = Lists.newArrayList();
        }

        @Override
        public StaticScope<ConcreteType> getParentScope() {
            return this.parent;
        }

        @Override
        public StaticSlot<ConcreteType> getOwnSlot(String string) {
            return this.slots.get(string);
        }

        @Override
        public StaticSlot<ConcreteType> getSlot(String string) {
            StaticSlot<ConcreteType> staticSlot = this.getOwnSlot(string);
            if (staticSlot != null) {
                return staticSlot;
            }
            if (this.parent != null) {
                return this.parent.getSlot(string);
            }
            return null;
        }

        Collection<ConcreteSlot> getSlots() {
            return this.slots.values();
        }

        @Override
        public ConcreteType getTypeOfThis() {
            ConcreteSlot concreteSlot = this.slots.get(":this");
            return concreteSlot != null ? concreteSlot.getType() : ConcreteType.NONE;
        }

        void declareSlot(String string, Node node) {
            this.slots.put(string, new ConcreteSlot(this, string));
        }

        void declareSlot(String string, Node node, ConcreteType concreteType) {
            ConcreteSlot concreteSlot = new ConcreteSlot(this, string);
            concreteSlot.addConcreteType(concreteType);
            this.slots.put(string, concreteSlot);
        }

        List<Action> getActions() {
            return this.actions;
        }

        void initForScopeRoot(Node node) {
            Preconditions.checkNotNull((Object)node);
            if (node.getType() == 105) {
                node = node.getLastChild();
            }
            Preconditions.checkArgument((node.getType() == 125 ? 1 : 0) != 0);
            NodeTraversal.traverse(TightenTypes.this.compiler, node, new CreateScope(this, false));
        }

        void initForExternRoot(Node node) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkArgument((node.getType() == 125 ? 1 : 0) != 0);
            NodeTraversal.traverse(TightenTypes.this.compiler, node, new CreateScope(this, true));
        }

        void addAction(Action action) {
            this.actions.add(action);
        }

        public String toString() {
            return this.getTypeOfThis().toString() + " " + this.getSlots();
        }
    }
}

