/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.debugging.sourcemap.SourceMapConsumer;
import com.google.debugging.sourcemap.SourceMapConsumerV1;
import com.google.debugging.sourcemap.SourceMapConsumerV2;
import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.SourceMapping;

public class SourceMapConsumerFactory {
    private SourceMapConsumerFactory() {
    }

    public static SourceMapping parse(String string) throws SourceMapParseException {
        SourceMapConsumer sourceMapConsumer = null;
        SourceMapFormat sourceMapFormat = SourceMapConsumerFactory.detectVersion(string);
        sourceMapConsumer = SourceMapConsumerFactory.createForVerion(SourceMapConsumerFactory.detectVersion(string));
        sourceMapConsumer.parse(string);
        return sourceMapConsumer;
    }

    private static SourceMapFormat detectVersion(String string) throws SourceMapParseException {
        if (string.startsWith("/** Begin line maps. **/")) {
            return SourceMapFormat.V1;
        }
        if (string.startsWith("{")) {
            return SourceMapFormat.V2;
        }
        throw new SourceMapParseException("unable to detect source map format");
    }

    private static SourceMapConsumer createForVerion(SourceMapFormat sourceMapFormat) throws SourceMapParseException {
        switch (sourceMapFormat) {
            case V1: {
                return new SourceMapConsumerV1();
            }
            case V2: {
                return new SourceMapConsumerV2();
            }
        }
        throw new SourceMapParseException("unsupported source map format");
    }
}

