/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.debugging.sourcemap.SourceMapConsumer;
import com.google.debugging.sourcemap.SourceMapLineDecoder;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.proto.Mapping;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceMapConsumerV2
implements SourceMapConsumer {
    private Map<Integer, List<Integer>> characterMap = null;
    private JSONArray lineMaps = null;
    private List<Mapping.OriginalMapping> mappings;

    @Override
    public void parse(String string) throws SourceMapParseException {
        try {
            this.parseInternal(string);
        }
        catch (JSONException jSONException) {
            throw new SourceMapParseException("JSON parse exception: " + (Object)((Object)jSONException));
        }
    }

    private void parseInternal(String string) throws JSONException, SourceMapParseException {
        JSONObject jSONObject = new JSONObject(string);
        int n = jSONObject.getInt("version");
        if (n != 2) {
            throw new SourceMapParseException("Unknown version: " + n);
        }
        String string2 = jSONObject.getString("file");
        if (string2.isEmpty()) {
            throw new SourceMapParseException("File entry is missing or empty");
        }
        int n2 = jSONObject.getInt("lineCount");
        this.lineMaps = jSONObject.getJSONArray("lineMaps");
        if (n2 != this.lineMaps.length()) {
            throw new SourceMapParseException("lineMaps length does not match lineCount");
        }
        this.characterMap = Maps.newHashMap();
        JSONArray jSONArray = jSONObject.getJSONArray("sources");
        JSONArray jSONArray2 = jSONObject.has("names") ? jSONObject.getJSONArray("names") : null;
        JSONArray jSONArray3 = jSONObject.getJSONArray("mappings");
        this.mappings = Lists.newArrayListWithCapacity((int)n2);
        for (int i = 0; i < jSONArray3.length(); ++i) {
            JSONArray jSONArray4 = jSONArray3.getJSONArray(i);
            String string3 = jSONArray4.optString(3, "");
            if (jSONArray2 != null) {
                try {
                    int n3 = jSONArray4.getInt(3);
                    string3 = jSONArray2.getString(n3);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            String string4 = jSONArray.getString(jSONArray4.getInt(0));
            int n4 = jSONArray4.getInt(1);
            int n5 = jSONArray4.getInt(2);
            Mapping.OriginalMapping.Builder builder = Mapping.OriginalMapping.newBuilder().setOriginalFile(string4).setLineNumber(n4).setColumnPosition(n5).setIdentifier(string3);
            this.mappings.add(builder.build());
        }
    }

    @Override
    public Mapping.OriginalMapping getMappingForLine(int n, int n2) {
        List<Integer> list;
        --n2;
        if (--n >= this.lineMaps.length()) {
            return null;
        }
        if (!this.characterMap.containsKey(n)) {
            try {
                this.characterMap.put(n, SourceMapLineDecoder.decodeLine(this.lineMaps.getString(n)));
            }
            catch (JSONException jSONException) {
                throw new IllegalStateException("JSON exception when retrieving line map", jSONException);
            }
        }
        if ((list = this.characterMap.get(n)) == null || list.size() <= n2) {
            return null;
        }
        int n3 = list.get(n2);
        Preconditions.checkState((n3 < this.mappings.size() ? 1 : 0) != 0, (Object)"Invalid mapping reference");
        return this.mappings.get(n3);
    }
}

