/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class SourceMapLineDecoder {
    private static final String BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwzyz0123456789+/";

    static List<Integer> decodeLine(String string) {
        return SourceMapLineDecoder.decodeLine(new StringParser(string));
    }

    private SourceMapLineDecoder() {
    }

    private static LineEntry decodeLineEntry(String string, int n) {
        return SourceMapLineDecoder.decodeLineEntry(new StringParser(string), n);
    }

    private static LineEntry decodeLineEntry(StringParser stringParser, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = stringParser.peek();
        while (n6 == 33) {
            ++n5;
            stringParser.next();
            n6 = stringParser.peek();
        }
        n6 = 0;
        int n7 = 0;
        if (n5 == 0) {
            n4 = stringParser.next();
            n3 = SourceMapLineDecoder.addBase64Digit((char)n4, 0);
            n7 = n3 >> 2;
            n6 = n3 & 3;
        } else {
            n4 = stringParser.next();
            n6 = SourceMapLineDecoder.addBase64Digit((char)n4, 0);
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                n4 = stringParser.next();
                n3 = SourceMapLineDecoder.addBase64Digit((char)n4, n3);
            }
            n7 = n3;
        }
        ++n7;
        ++n6;
        n4 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = stringParser.next();
            n4 = SourceMapLineDecoder.addBase64Digit((char)n2, n4);
        }
        n3 = SourceMapLineDecoder.getIdFromRelativeId(n4, n6, n);
        return new LineEntry(n3, n7);
    }

    private static List<Integer> decodeLine(StringParser stringParser) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)512);
        int n = 0;
        do {
            LineEntry lineEntry = SourceMapLineDecoder.decodeLineEntry(stringParser, n);
            n = lineEntry.id;
            for (int i = 0; i < lineEntry.reps; ++i) {
                arrayList.add(lineEntry.id);
            }
        } while (stringParser.hasNext());
        return arrayList;
    }

    private static int addBase64Digit(char c, int n) {
        return n * 64 + BASE64_MAP.indexOf(c);
    }

    private static int getIdFromRelativeId(int n, int n2, int n3) {
        int n4 = 1 << n2 * 6;
        return (n >= n4 / 2 ? n - n4 : n) + n3;
    }

    static class StringParser {
        final String content;
        int current = 0;

        StringParser(String string) {
            this.content = string;
        }

        char next() {
            return this.content.charAt(this.current++);
        }

        char peek() {
            return this.content.charAt(this.current);
        }

        boolean hasNext() {
            return this.current < this.content.length() - 1;
        }
    }

    static class LineEntry {
        final int id;
        final int reps;

        public LineEntry(int n, int n2) {
            this.id = n;
            this.reps = n2;
        }
    }
}

