/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import java.io.IOException;
import java.nio.charset.CharsetEncoder;

class Util {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    Util() {
    }

    static String escapeString(String string) {
        return Util.escapeString(string, '\"', "\\\"", "'", "\\\\", null);
    }

    static String escapeString(String string, char c, String string2, String string3, String string4, CharsetEncoder charsetEncoder) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append(c);
        block10: for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append(string4);
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append(string2);
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append(string3);
                    continue block10;
                }
                case '>': {
                    if (i >= 2 && (string.charAt(i - 1) == '-' && string.charAt(i - 2) == '-' || string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']')) {
                        stringBuilder.append("\\>");
                        continue block10;
                    }
                    stringBuilder.append(c2);
                    continue block10;
                }
                case '<': {
                    if (string.regionMatches(true, i + 1, "/script", 0, "/script".length())) {
                        stringBuilder.append("<\\");
                        continue block10;
                    }
                    if (string.regionMatches(false, i + 1, "!--", 0, "!--".length())) {
                        stringBuilder.append("<\\");
                        continue block10;
                    }
                    stringBuilder.append(c2);
                    continue block10;
                }
                default: {
                    if (charsetEncoder != null) {
                        if (charsetEncoder.canEncode(c2)) {
                            stringBuilder.append(c2);
                            continue block10;
                        }
                        Util.appendCharAsHex(stringBuilder, c2);
                        continue block10;
                    }
                    if (c2 > '\u001f' && c2 <= '\u007f') {
                        stringBuilder.append(c2);
                        continue block10;
                    }
                    Util.appendCharAsHex(stringBuilder, c2);
                }
            }
        }
        stringBuilder.append(c);
        return stringBuilder.toString();
    }

    private static void appendCharAsHex(StringBuilder stringBuilder, char c) {
        try {
            Util.appendHexJavaScriptRepresentation(stringBuilder, c);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void appendHexJavaScriptRepresentation(Appendable appendable, int n) throws IOException {
        if (Character.isSupplementaryCodePoint(n)) {
            char[] cArray = Character.toChars(n);
            Util.appendHexJavaScriptRepresentation(appendable, cArray[0]);
            Util.appendHexJavaScriptRepresentation(appendable, cArray[1]);
            return;
        }
        appendable.append("\\u").append(HEX_CHARS[n >>> 12 & 0xF]).append(HEX_CHARS[n >>> 8 & 0xF]).append(HEX_CHARS[n >>> 4 & 0xF]).append(HEX_CHARS[n & 0xF]);
    }
}

