/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

class AliasStrings
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(AliasStrings.class.getName());
    private static final String STRING_ALIAS_PREFIX = "$$S_";
    private final AbstractCompiler compiler;
    private final JSModuleGraph moduleGraph;
    private Matcher blacklist = null;
    private final Set<String> aliasableStrings;
    private final boolean outputStringUsage;
    private final SortedMap<String, StringInfo> stringInfoMap = Maps.newTreeMap();
    private final Set<String> usedHashedAliases = new LinkedHashSet<String>();
    private final Map<JSModule, Node> moduleVarParentMap = new HashMap<JSModule, Node>();
    long unitTestHashReductionMask = -1L;

    AliasStrings(AbstractCompiler abstractCompiler, JSModuleGraph jSModuleGraph, Set<String> set, String string, boolean bl) {
        this.compiler = abstractCompiler;
        this.moduleGraph = jSModuleGraph;
        this.aliasableStrings = set;
        this.blacklist = string.length() != 0 ? Pattern.compile(string).matcher("") : null;
        this.outputStringUsage = bl;
    }

    @Override
    public void process(Node node, Node node2) {
        logger.info("Aliasing common strings");
        NodeTraversal.traverse(this.compiler, node2, this);
        this.replaceStringsWithAliases();
        this.addAliasDeclarationNodes();
        if (this.outputStringUsage) {
            this.outputStringUsage();
        }
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.getType() == 40 && node2.getType() != 33 && node2.getType() != 47 && !NodeUtil.isObjectLitKey(node, node2)) {
            String string = node.getString();
            if ("undefined".equals(string)) {
                return;
            }
            if (this.blacklist != null && this.blacklist.reset(string).find()) {
                return;
            }
            if (this.aliasableStrings == null || this.aliasableStrings.contains(string)) {
                Node node3;
                StringOccurrence stringOccurrence = new StringOccurrence(node, node2);
                StringInfo stringInfo = this.getOrCreateStringInfo(string);
                stringInfo.occurrences.add(stringOccurrence);
                ++stringInfo.numOccurrences;
                if (nodeTraversal.inGlobalScope() || AliasStrings.isInThrowExpression(node)) {
                    ++stringInfo.numOccurrencesInfrequentlyExecuted;
                }
                JSModule jSModule = nodeTraversal.getModule();
                if (stringInfo.numOccurrences != 1) {
                    if (jSModule != null && stringInfo.moduleToContainDecl != null && jSModule != stringInfo.moduleToContainDecl && !this.moduleGraph.dependsOn(jSModule, stringInfo.moduleToContainDecl)) {
                        jSModule = this.moduleGraph.getDeepestCommonDependency(jSModule, stringInfo.moduleToContainDecl);
                    } else {
                        return;
                    }
                }
                if ((node3 = this.moduleVarParentMap.get(jSModule)) == null) {
                    node3 = this.compiler.getNodeForCodeInsertion(jSModule);
                    this.moduleVarParentMap.put(jSModule, node3);
                }
                stringInfo.moduleToContainDecl = jSModule;
                stringInfo.parentForNewVarDecl = node3;
                stringInfo.siblingToInsertVarDeclBefore = node3.getFirstChild();
            }
        }
    }

    private StringInfo getOrCreateStringInfo(String string) {
        StringInfo stringInfo = (StringInfo)this.stringInfoMap.get(string);
        if (stringInfo == null) {
            stringInfo = new StringInfo(this.stringInfoMap.size());
            this.stringInfoMap.put(string, stringInfo);
        }
        return stringInfo;
    }

    private static boolean isInThrowExpression(Node node) {
        for (Node node2 : node.getAncestors()) {
            switch (node2.getType()) {
                case 49: {
                    return true;
                }
                case 4: 
                case 77: 
                case 105: 
                case 108: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 120: 
                case 125: 
                case 130: 
                case 132: {
                    return false;
                }
            }
        }
        return false;
    }

    private void replaceStringsWithAliases() {
        for (Map.Entry<String, StringInfo> entry : this.stringInfoMap.entrySet()) {
            StringInfo stringInfo;
            String string = entry.getKey();
            if (!AliasStrings.shouldReplaceWithAlias(string, stringInfo = entry.getValue())) continue;
            for (StringOccurrence stringOccurrence : stringInfo.occurrences) {
                this.replaceStringWithAliasName(stringOccurrence, stringInfo.getVariableName(string), stringInfo);
            }
        }
    }

    private void addAliasDeclarationNodes() {
        for (Map.Entry<String, StringInfo> entry : this.stringInfoMap.entrySet()) {
            StringInfo stringInfo = entry.getValue();
            if (!stringInfo.isAliased) continue;
            String string = stringInfo.getVariableName(entry.getKey());
            Node node = Node.newString(40, entry.getKey());
            Node node2 = Node.newString(38, string);
            node2.addChildToBack(node);
            Node node3 = new Node(118);
            node3.addChildToBack(node2);
            if (stringInfo.siblingToInsertVarDeclBefore == null) {
                stringInfo.parentForNewVarDecl.addChildToFront(node3);
            } else {
                stringInfo.parentForNewVarDecl.addChildBefore(node3, stringInfo.siblingToInsertVarDeclBefore);
            }
            this.compiler.reportCodeChange();
        }
    }

    private static boolean shouldReplaceWithAlias(String string, StringInfo stringInfo) {
        int n;
        if (stringInfo.numOccurrences > stringInfo.numOccurrencesInfrequentlyExecuted) {
            return true;
        }
        int n2 = 3;
        int n3 = 2 + string.length();
        int n4 = 6 + n2 + n3 + stringInfo.numOccurrences * n2;
        return n4 < (n = stringInfo.numOccurrences * n3);
    }

    private void replaceStringWithAliasName(StringOccurrence stringOccurrence, String string, StringInfo stringInfo) {
        stringOccurrence.parent.replaceChild(stringOccurrence.node, Node.newString(38, string));
        stringInfo.isAliased = true;
        this.compiler.reportCodeChange();
    }

    private void outputStringUsage() {
        StringBuilder stringBuilder = new StringBuilder("Strings used more than once:\n");
        for (String string : this.stringInfoMap.keySet()) {
            StringInfo stringInfo = (StringInfo)this.stringInfoMap.get(string);
            if (stringInfo.numOccurrences <= 1) continue;
            stringBuilder.append(stringInfo.numOccurrences);
            stringBuilder.append(": ");
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        logger.info(stringBuilder.toString());
    }

    private final class StringInfo {
        final int id;
        boolean isAliased;
        final List<StringOccurrence> occurrences;
        int numOccurrences;
        int numOccurrencesInfrequentlyExecuted;
        JSModule moduleToContainDecl;
        Node parentForNewVarDecl;
        Node siblingToInsertVarDeclBefore;
        String aliasName;

        StringInfo(int n) {
            this.id = n;
            this.occurrences = new ArrayList<StringOccurrence>();
            this.isAliased = false;
        }

        String getVariableName(String string) {
            if (this.aliasName == null) {
                this.aliasName = this.encodeStringAsIdentifier(AliasStrings.STRING_ALIAS_PREFIX, string);
            }
            return this.aliasName;
        }

        String encodeStringAsIdentifier(String string, String string2) {
            int n = string2.length();
            int n2 = Math.min(n, 20);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                if (bl) {
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
                        stringBuilder.append('_');
                    }
                    bl = false;
                }
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append('$');
                stringBuilder.append(Integer.toHexString(c));
                bl = true;
            }
            if (n == n2) {
                return stringBuilder.toString();
            }
            CRC32 cRC32 = new CRC32();
            cRC32.update(string2.getBytes());
            long l = cRC32.getValue() & AliasStrings.this.unitTestHashReductionMask;
            stringBuilder.append('_');
            stringBuilder.append(Long.toHexString(l));
            String string3 = stringBuilder.toString();
            if (!AliasStrings.this.usedHashedAliases.add(string3)) {
                string3 = string3 + "_" + this.id;
            }
            return string3;
        }
    }

    private static final class StringOccurrence {
        final Node node;
        final Node parent;

        StringOccurrence(Node node, Node node2) {
            this.node = node;
            this.parent = node2;
        }
    }
}

