/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NameReferenceGraph;
import com.google.javascript.jscomp.NameReferenceGraphConstruction;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

public class CallGraph
implements CompilerPass {
    private AbstractCompiler compiler;
    private Map<Node, Callsite> callsitesByNode;
    private Map<Node, Function> functionsByNode;
    private boolean computeBackwardGraph;
    private boolean computeForwardGraph;
    private boolean useNameReferenceGraph = false;
    private boolean alreadyRun = false;
    @VisibleForTesting
    public static final String MAIN_FUNCTION_NAME = "{main}";
    private Function mainFunction;

    public CallGraph(AbstractCompiler abstractCompiler, boolean bl, boolean bl2) {
        Preconditions.checkArgument((bl || bl2 ? 1 : 0) != 0);
        this.compiler = abstractCompiler;
        this.computeForwardGraph = bl;
        this.computeBackwardGraph = bl2;
        this.callsitesByNode = Maps.newLinkedHashMap();
        this.functionsByNode = Maps.newLinkedHashMap();
    }

    public CallGraph(AbstractCompiler abstractCompiler) {
        this(abstractCompiler, true, true);
    }

    @Override
    public void process(Node node, Node node2) {
        Preconditions.checkState((!this.alreadyRun ? 1 : 0) != 0);
        DefinitionProvider definitionProvider = this.constructDefinitionProvider(node, node2);
        this.createFunctionsAndCallsites(node2, definitionProvider);
        this.fillInFunctionInformation(definitionProvider);
        this.alreadyRun = true;
    }

    public Function getFunctionForAstNode(Node node) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
        return this.functionsByNode.get(node);
    }

    public Function getMainFunction() {
        return this.mainFunction;
    }

    public Collection<Function> getAllFunctions() {
        return this.functionsByNode.values();
    }

    @VisibleForTesting
    public Function getUniqueFunctionWithName(final String string) {
        Collection collection = Collections2.filter(this.getAllFunctions(), (Predicate)new Predicate<Function>(){

            public boolean apply(Function function) {
                String string2 = function.getName();
                if (string2 != null && string != null) {
                    return string.equals(string2);
                }
                return string == string2;
            }
        });
        if (collection.size() == 1) {
            return (Function)collection.iterator().next();
        }
        throw new IllegalStateException("Found " + collection.size() + " functions with name " + string);
    }

    public Callsite getCallsiteForAstNode(Node node) {
        Preconditions.checkArgument((node.getType() == 37 || node.getType() == 30 ? 1 : 0) != 0);
        return this.callsitesByNode.get(node);
    }

    public Collection<Callsite> getAllCallsites() {
        return this.callsitesByNode.values();
    }

    private void createFunctionsAndCallsites(Node node, final DefinitionProvider definitionProvider) {
        this.mainFunction = this.createFunction(node);
        NodeTraversal.traverse(this.compiler, node, new NodeTraversal.AbstractPostOrderCallback(){

            @Override
            public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                int n = node.getType();
                if (n == 37 || n == 30) {
                    Callsite callsite = CallGraph.this.createCallsite(node);
                    Node node3 = nodeTraversal.getScopeRoot();
                    Function function = (Function)CallGraph.this.functionsByNode.get(node3);
                    if (function == null) {
                        function = CallGraph.this.createFunction(node3);
                    }
                    callsite.containingFunction = function;
                    function.addCallsiteInFunction(callsite);
                    CallGraph.this.connectCallsiteToTargets(callsite, definitionProvider);
                } else if (NodeUtil.isFunction(node) && !CallGraph.this.functionsByNode.containsKey(node)) {
                    CallGraph.this.createFunction(node);
                }
            }
        });
    }

    private Function createFunction(Node node) {
        Function function = new Function(node);
        this.functionsByNode.put(node, function);
        return function;
    }

    private Callsite createCallsite(Node node) {
        Callsite callsite = new Callsite(node);
        this.callsitesByNode.put(node, callsite);
        return callsite;
    }

    private void connectCallsiteToTargets(Callsite callsite, DefinitionProvider definitionProvider) {
        Collection<DefinitionsRemover.Definition> collection = this.lookupDefinitionsForTargetsOfCall(callsite.getAstNode(), definitionProvider);
        if (collection == null) {
            callsite.hasUnknownTarget = true;
        } else {
            for (DefinitionsRemover.Definition definition : collection) {
                if (definition.isExtern()) {
                    callsite.hasExternTarget = true;
                    continue;
                }
                Node node = definition.getRValue();
                if (node != null && NodeUtil.isFunction(node)) {
                    Function function = this.functionsByNode.get(node);
                    if (function == null) {
                        function = this.createFunction(node);
                    }
                    if (this.computeForwardGraph) {
                        callsite.addPossibleTarget(function);
                    }
                    if (!this.computeBackwardGraph) continue;
                    function.addCallsitePossiblyTargetingFunction(callsite);
                    continue;
                }
                callsite.hasUnknownTarget = true;
            }
        }
    }

    private void fillInFunctionInformation(DefinitionProvider definitionProvider) {
        if (this.useNameReferenceGraph) {
            NameReferenceGraph nameReferenceGraph = (NameReferenceGraph)definitionProvider;
            for (Function function : this.getAllFunctions()) {
                String string;
                if (function.isMain() || (string = function.getName()) == null) continue;
                NameReferenceGraph.Name name = nameReferenceGraph.getSymbol(string);
                this.updateFunctionForName(function, name);
            }
        } else {
            SimpleDefinitionFinder simpleDefinitionFinder = (SimpleDefinitionFinder)definitionProvider;
            for (DefinitionSite definitionSite : simpleDefinitionFinder.getDefinitionSites()) {
                DefinitionsRemover.Definition definition = definitionSite.definition;
                Function function = this.lookupFunctionForDefinition(definition);
                if (function == null) continue;
                for (UseSite useSite : simpleDefinitionFinder.getUseSites(definition)) {
                    this.updateFunctionForUse(function, useSite.node);
                }
            }
        }
    }

    private void updateFunctionForName(Function function, NameReferenceGraph.Name name) {
        if (name.isAliased()) {
            function.isAliased = true;
        }
        if (name.exposedToCallOrApply()) {
            function.isExposedToCallOrApply = true;
        }
    }

    private void updateFunctionForUse(Function function, Node node) {
        Node node2 = node.getParent();
        int n = node2.getType();
        if (n != 37 && n != 30 || node2.getFirstChild() != node) {
            if (NodeUtil.isGet(node2)) {
                Node node3;
                if (NodeUtil.isGetProp(node2) && (NodeUtil.isFunctionObjectApply(node3 = node2.getParent()) || NodeUtil.isFunctionObjectCall(node3))) {
                    function.isExposedToCallOrApply = true;
                }
            } else {
                function.isAliased = true;
            }
        }
    }

    private Function lookupFunctionForDefinition(DefinitionsRemover.Definition definition) {
        Node node;
        if (definition != null && !definition.isExtern() && (node = definition.getRValue()) != null && NodeUtil.isFunction(node)) {
            Function function = this.functionsByNode.get(node);
            Preconditions.checkNotNull((Object)function);
            return function;
        }
        return null;
    }

    public DiGraph<Function, Callsite> getForwardDirectedGraph() {
        return this.constructDirectedGraph(true);
    }

    public DiGraph<Function, Callsite> getBackwardDirectedGraph() {
        return this.constructDirectedGraph(false);
    }

    private static void digraphConnect(DiGraph<Function, Callsite> diGraph, Function function, Callsite callsite, Function function2, boolean bl) {
        Function function3;
        Function function4;
        if (bl) {
            function4 = function;
            function3 = function2;
        } else {
            function4 = function2;
            function3 = function;
        }
        diGraph.connect(function4, callsite, function3);
    }

    private DiGraph<Function, Callsite> constructDirectedGraph(boolean bl) {
        LinkedDirectedGraph<Function, Callsite> linkedDirectedGraph = LinkedDirectedGraph.createWithoutAnnotations();
        for (Function function : this.getAllFunctions()) {
            ((Graph)linkedDirectedGraph).createNode(function);
        }
        if (this.computeForwardGraph) {
            for (Function function : this.getAllFunctions()) {
                for (Callsite callsite : function.getCallsitesInFunction()) {
                    for (Function function2 : callsite.getPossibleTargets()) {
                        CallGraph.digraphConnect(linkedDirectedGraph, function, callsite, function2, bl);
                    }
                }
            }
        } else {
            for (Function function : this.getAllFunctions()) {
                for (Callsite callsite : function.getCallsitesPossiblyTargetingFunction()) {
                    Function function3 = callsite.getContainingFunction();
                    CallGraph.digraphConnect(linkedDirectedGraph, function3, callsite, function, bl);
                }
            }
        }
        return linkedDirectedGraph;
    }

    private DefinitionProvider constructDefinitionProvider(Node node, Node node2) {
        if (this.useNameReferenceGraph) {
            NameReferenceGraphConstruction nameReferenceGraphConstruction = new NameReferenceGraphConstruction(this.compiler);
            nameReferenceGraphConstruction.process(node, node2);
            return nameReferenceGraphConstruction.getNameReferenceGraph();
        }
        SimpleDefinitionFinder simpleDefinitionFinder = new SimpleDefinitionFinder(this.compiler);
        simpleDefinitionFinder.process(node, node2);
        return simpleDefinitionFinder;
    }

    private Collection<DefinitionsRemover.Definition> lookupDefinitionsForTargetsOfCall(Node node, DefinitionProvider definitionProvider) {
        Collection<DefinitionsRemover.Definition> collection;
        Preconditions.checkArgument((node.getType() == 37 || node.getType() == 30 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        if ((!this.useNameReferenceGraph || NodeUtil.isGetProp(node2) || NodeUtil.isName(node2)) && (collection = definitionProvider.getDefinitionsReferencedAt(node2)) != null && !collection.isEmpty()) {
            return collection;
        }
        return null;
    }

    public class Callsite {
        private Node astNode;
        private boolean hasUnknownTarget = false;
        private boolean hasExternTarget = false;
        private Function containingFunction = null;
        private Collection<Function> possibleTargets;

        private Callsite(Node node) {
            this.astNode = node;
        }

        public Node getAstNode() {
            return this.astNode;
        }

        public Function getContainingFunction() {
            return this.containingFunction;
        }

        public Collection<Function> getPossibleTargets() {
            if (CallGraph.this.computeForwardGraph) {
                if (this.possibleTargets != null) {
                    return this.possibleTargets;
                }
                return ImmutableList.of();
            }
            throw new UnsupportedOperationException("Cannot call getPossibleTargets() on a Callsite from a non-forward CallGraph");
        }

        private void addPossibleTarget(Function function) {
            Preconditions.checkState((boolean)CallGraph.this.computeForwardGraph);
            if (this.possibleTargets == null) {
                this.possibleTargets = new LinkedList<Function>();
            }
            this.possibleTargets.add(function);
        }

        public boolean hasUnknownTarget() {
            return this.hasUnknownTarget;
        }

        public boolean hasExternTarget() {
            return this.hasExternTarget;
        }
    }

    public class Function {
        private Node astNode;
        private boolean isAliased = false;
        private boolean isExposedToCallOrApply = false;
        private Collection<Callsite> callsitesInFunction;
        private Collection<Callsite> callsitesPossiblyTargetingFunction;

        private Function(Node node) {
            this.astNode = node;
        }

        public boolean isMain() {
            return this == CallGraph.this.mainFunction;
        }

        public Node getAstNode() {
            return this.astNode;
        }

        public Node getBodyNode() {
            if (this.isMain()) {
                return this.astNode;
            }
            return NodeUtil.getFunctionBody(this.astNode);
        }

        public String getName() {
            if (this.isMain()) {
                return CallGraph.MAIN_FUNCTION_NAME;
            }
            return NodeUtil.getFunctionName(this.astNode);
        }

        public Collection<Callsite> getCallsitesInFunction() {
            if (this.callsitesInFunction != null) {
                return this.callsitesInFunction;
            }
            return ImmutableList.of();
        }

        private void addCallsiteInFunction(Callsite callsite) {
            if (this.callsitesInFunction == null) {
                this.callsitesInFunction = new LinkedList<Callsite>();
            }
            this.callsitesInFunction.add(callsite);
        }

        public Collection<Callsite> getCallsitesPossiblyTargetingFunction() {
            if (CallGraph.this.computeBackwardGraph) {
                if (this.callsitesPossiblyTargetingFunction != null) {
                    return this.callsitesPossiblyTargetingFunction;
                }
                return ImmutableList.of();
            }
            throw new UnsupportedOperationException("Cannot call getCallsitesPossiblyTargetingFunction() on a Function from a non-backward CallGraph");
        }

        private void addCallsitePossiblyTargetingFunction(Callsite callsite) {
            Preconditions.checkState((boolean)CallGraph.this.computeBackwardGraph);
            if (this.callsitesPossiblyTargetingFunction == null) {
                this.callsitesPossiblyTargetingFunction = new LinkedList<Callsite>();
            }
            this.callsitesPossiblyTargetingFunction.add(callsite);
        }

        public boolean isAliased() {
            return this.isAliased;
        }

        public boolean isExposedToCallOrApply() {
            return this.isExposedToCallOrApply;
        }
    }
}

