/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.LatticeElement;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

class CheckPropertyOrder
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType UNASSIGNED_PROPERTY = DiagnosticType.error("UNASSIGNED_PROPERTY", "not all control paths assign property {1} in function {0}");
    static final DiagnosticType UNEQUAL_PROPERTIES = DiagnosticType.error("UNEQUAL_PROPERTIES", "different control paths produce different (ordered) property lists: {0} vs. {1}");
    private final AbstractCompiler compiler;
    private final CheckLevel level;
    private final boolean onlyOneError;
    private int errorCount;

    CheckPropertyOrder(AbstractCompiler abstractCompiler, CheckLevel checkLevel) {
        this(abstractCompiler, checkLevel, false);
    }

    CheckPropertyOrder(AbstractCompiler abstractCompiler, CheckLevel checkLevel, boolean bl) {
        this.compiler = abstractCompiler;
        this.level = checkLevel;
        this.onlyOneError = bl;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        Node node3 = null;
        String string = null;
        if (NodeUtil.isFunction(node) && CheckPropertyOrder.isConstructor(node)) {
            node3 = node;
            string = node.getFirstChild().getString();
        } else if (NodeUtil.isAssign(node) && NodeUtil.isFunction(node.getFirstChild().getNext()) && CheckPropertyOrder.isConstructor(node)) {
            node3 = node.getFirstChild().getNext();
            string = node.getFirstChild().getQualifiedName();
        }
        if (node3 != null) {
            FunctionType functionType = (FunctionType)node3.getJSType();
            this.checkConstructor(node3, functionType != null ? functionType.getInstanceType() : null, nodeTraversal.getSourceName(), string);
        }
    }

    private static boolean isConstructor(Node node) {
        return node.getJSDocInfo() != null && node.getJSDocInfo().isConstructor();
    }

    private void checkConstructor(Node node, ObjectType objectType, String string, String string2) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
        ControlFlowAnalysis controlFlowAnalysis = new ControlFlowAnalysis(this.compiler, false, false);
        controlFlowAnalysis.process(null, node.getFirstChild().getNext().getNext());
        ControlFlowGraph<Node> controlFlowGraph = controlFlowAnalysis.getCfg();
        new PropertyOrdersFlowAnalysis(controlFlowAnalysis.getCfg()).analyze();
        Object a = controlFlowAnalysis.getCfg().getImplicitReturn().getAnnotation();
        List<String>[] listArray = ((PropertyOrders)((DataFlowAnalysis.FlowState)a).getIn()).getOrders();
        if (listArray.length == 0) {
            throw new AssertionError((Object)("no paths through constructor " + string2 + "?"));
        }
        if (listArray.length > 1) {
            this.report(string, node, UNEQUAL_PROPERTIES, CheckPropertyOrder.reverse(listArray[0]).toString(), CheckPropertyOrder.reverse(listArray[1]).toString());
        }
        if (objectType != null) {
            for (String string3 : objectType.getOwnPropertyNames()) {
                if (listArray[0].contains(string3)) continue;
                this.report(string, node, UNASSIGNED_PROPERTY, string2, string3);
            }
        }
    }

    private void report(String string, Node node, DiagnosticType diagnosticType, String ... stringArray) {
        if (!this.onlyOneError || ++this.errorCount <= 1) {
            this.compiler.report(JSError.make(string, node, this.level, diagnosticType, stringArray));
        }
    }

    private static <T> List<T> reverse(List<T> list) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList arrayList = Lists.newArrayList(list);
        Collections.reverse(list);
        return arrayList;
    }

    private static class PropertyOrdersFlowAnalysis
    extends DataFlowAnalysis<Node, PropertyOrders> {
        public PropertyOrdersFlowAnalysis(ControlFlowGraph<Node> controlFlowGraph) {
            super(controlFlowGraph, new OrdersJoinOp());
        }

        @Override
        public boolean isForward() {
            return true;
        }

        @Override
        public PropertyOrders createInitialEstimateLattice() {
            return PropertyOrders.EMPTY;
        }

        @Override
        public PropertyOrders createEntryLattice() {
            HashSet hashSet = Sets.newHashSet();
            hashSet.add(new Stack());
            return new PropertyOrders(hashSet);
        }

        @Override
        public PropertyOrders flowThrough(Node node, PropertyOrders propertyOrders) {
            switch (node.getType()) {
                case 105: 
                case 125: 
                case 126: {
                    return propertyOrders;
                }
                case 108: 
                case 113: 
                case 114: {
                    return this.flowThrough(NodeUtil.getConditionExpression(node), propertyOrders);
                }
                case 110: 
                case 119: {
                    return this.flowThrough(node.getFirstChild(), propertyOrders);
                }
                case 115: {
                    if (node.getChildCount() == 4) {
                        Node node2 = node.getFirstChild();
                        Node node3 = node2.getNext();
                        return this.flowThrough(node3, this.flowThrough(node2, propertyOrders));
                    }
                    Node node4 = node.getFirstChild();
                    Node node5 = node4.getNext();
                    return this.flowThrough(node5, this.flowThrough(node4, propertyOrders));
                }
                case 98: {
                    Node node6 = node.getFirstChild();
                    propertyOrders = this.flowThrough(node6, propertyOrders);
                    Node node7 = node6.getNext();
                    Node node8 = node7.getNext();
                    return this.join(this.flowThrough(node7, propertyOrders), this.flowThrough(node8, propertyOrders));
                }
                case 100: 
                case 101: {
                    Node node9 = node.getFirstChild();
                    Node node10 = node9.getNext();
                    propertyOrders = this.flowThrough(node9, propertyOrders);
                    return this.join(propertyOrders, this.flowThrough(node10, propertyOrders));
                }
                case 86: {
                    Node node11 = node.getFirstChild();
                    Node node12 = node11.getNext();
                    if (node11.getType() == 33) {
                        Node node13 = node11.getFirstChild();
                        Node node14 = node13.getNext();
                        if (node13.getType() == 42 && node14.getType() == 40 && node14.getNext() == null) {
                            return this.flowThrough(node12, propertyOrders.copyAndAdd(node14.getString()));
                        }
                    }
                    return this.flowThrough(node12, this.flowThrough(node11, propertyOrders));
                }
            }
            for (node = node.getFirstChild(); node != null; node = node.getNext()) {
                propertyOrders = this.flowThrough(node, propertyOrders);
            }
            return propertyOrders;
        }
    }

    private static class PropertyOrders
    implements LatticeElement {
        public static final PropertyOrders EMPTY = new PropertyOrders(Sets.newHashSet());
        private final Set<List<String>> orders;

        private PropertyOrders(Set<List<String>> set) {
            this.orders = set;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PropertyOrders)) {
                return false;
            }
            return ((Object)this.orders).equals(((PropertyOrders)object).orders);
        }

        /*
         * WARNING - void declaration
         */
        public PropertyOrders copyAndAdd(String string) {
            HashSet hashSet = Sets.newHashSet();
            for (List<String> list : this.orders) {
                void arrayList;
                if (!list.contains(string)) {
                    ArrayList arrayList2 = Lists.newArrayList(list);
                    arrayList2.add(string);
                    ArrayList arrayList3 = arrayList2;
                }
                hashSet.add(arrayList);
            }
            return new PropertyOrders(hashSet);
        }

        public List<String>[] getOrders() {
            int n = Integer.MAX_VALUE;
            for (List<String> object : this.orders) {
                n = Math.min(n, object.size());
            }
            HashSet hashSet = Sets.newHashSet();
            for (List<String> list : this.orders) {
                hashSet.add(list.subList(0, n));
            }
            return hashSet.toArray(new List[hashSet.size()]);
        }

        public String toString() {
            return "{" + Joiner.on((String)", ").join(this.orders) + "}";
        }
    }

    private static class OrdersJoinOp
    extends JoinOp.BinaryJoinOp<PropertyOrders> {
        private OrdersJoinOp() {
        }

        @Override
        public PropertyOrders apply(PropertyOrders propertyOrders, PropertyOrders propertyOrders2) {
            return new PropertyOrders(Sets.newHashSet((Iterable)Sets.union((Set)propertyOrders.orders, (Set)propertyOrders2.orders)));
        }
    }
}

