/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.List;

class CheckRequiresForConstructors
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final CheckLevel level;
    static final DiagnosticType MISSING_REQUIRE_WARNING = DiagnosticType.disabled("JSC_MISSING_REQUIRE_WARNING", "''{0}'' used but not goog.require''d");

    CheckRequiresForConstructors(AbstractCompiler abstractCompiler, CheckLevel checkLevel) {
        this.compiler = abstractCompiler;
        this.codingConvention = abstractCompiler.getCodingConvention();
        this.level = checkLevel;
    }

    @Override
    public void process(Node node, Node node2) {
        CheckRequiresForConstructorsCallback checkRequiresForConstructorsCallback = new CheckRequiresForConstructorsCallback();
        new NodeTraversal(this.compiler, checkRequiresForConstructorsCallback).traverseRoots(node, node2);
    }

    private class CheckRequiresForConstructorsCallback
    implements NodeTraversal.Callback {
        private final List<String> constructors = Lists.newArrayList();
        private final List<String> requires = Lists.newArrayList();
        private final List<Node> newNodes = Lists.newArrayList();

        private CheckRequiresForConstructorsCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return node2 == null || node2.getType() != 132 || !nodeTraversal.getInput().isExtern();
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 86: {
                    JSDocInfo jSDocInfo = (JSDocInfo)node.getProp(29);
                    if (jSDocInfo == null || !jSDocInfo.isConstructor()) break;
                    String string = node.getFirstChild().getQualifiedName();
                    this.constructors.add(string);
                    break;
                }
                case 105: {
                    if (NodeUtil.isFunctionExpression(node)) {
                        if (node2.getType() != 38) break;
                        String string = node2.getString();
                        JSDocInfo jSDocInfo = (JSDocInfo)node2.getProp(29);
                        if (jSDocInfo != null && jSDocInfo.isConstructor()) {
                            this.constructors.add(string);
                            break;
                        }
                        Node node3 = node2.getParent();
                        Preconditions.checkState((node3 != null && node3.getType() == 118 ? 1 : 0) != 0);
                        jSDocInfo = (JSDocInfo)node3.getProp(29);
                        if (jSDocInfo == null || !jSDocInfo.isConstructor()) break;
                        this.constructors.add(string);
                        break;
                    }
                    JSDocInfo jSDocInfo = (JSDocInfo)node.getProp(29);
                    if (jSDocInfo == null || !jSDocInfo.isConstructor()) break;
                    String string = node.getFirstChild().getString();
                    this.constructors.add(string);
                    break;
                }
                case 37: {
                    this.visitCallNode(node, node2);
                    break;
                }
                case 132: {
                    this.visitScriptNode(nodeTraversal);
                    break;
                }
                case 30: {
                    this.visitNewNode(nodeTraversal, node);
                }
            }
        }

        private void visitScriptNode(NodeTraversal nodeTraversal) {
            HashSet hashSet = Sets.newHashSet();
            for (Node node : this.newNodes) {
                String string = node.getFirstChild().getQualifiedName();
                if (this.constructors != null && this.constructors.contains(string) || this.requires != null && this.requires.contains(string) || hashSet.contains(string)) continue;
                CheckRequiresForConstructors.this.compiler.report(nodeTraversal.makeError(node, CheckRequiresForConstructors.this.level, MISSING_REQUIRE_WARNING, string));
                hashSet.add(string);
            }
            this.newNodes.clear();
            this.requires.clear();
            this.constructors.clear();
        }

        private void visitCallNode(Node node, Node node2) {
            String string = CheckRequiresForConstructors.this.codingConvention.extractClassNameIfRequire(node, node2);
            if (string != null) {
                this.requires.add(string);
            }
        }

        private void visitNewNode(NodeTraversal nodeTraversal, Node node) {
            Node node2 = node.getFirstChild();
            String string = node2.getQualifiedName();
            if (string == null || string.isEmpty()) {
                return;
            }
            Node node3 = node2;
            while (node3.hasChildren()) {
                node3 = node3.getFirstChild();
            }
            if (node3.getType() != 38) {
                return;
            }
            String string2 = node3.getString();
            Scope.Var var = nodeTraversal.getScope().getVar(string2);
            if (var == null || var.isLocal() || var.isExtern()) {
                return;
            }
            this.newNodes.add(node);
        }
    }
}

