/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

final class CheckSideEffects
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType USELESS_CODE_ERROR = DiagnosticType.warning("JSC_USELESS_CODE", "Suspicious code. {0}");
    private final CheckLevel level;

    CheckSideEffects(CheckLevel checkLevel) {
        this.level = checkLevel;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        Object object;
        if (node.getType() == 124 || node.getType() == 85) {
            return;
        }
        if (node2 == null) {
            return;
        }
        int n = node2.getType();
        if (n == 85) {
            object = node2.getParent();
            if (((Node)object).getType() == 37 && node2 == ((Node)object).getFirstChild() && node == node2.getFirstChild() && node2.getChildCount() == 2 && node.getNext().getType() == 38 && "eval".equals(node.getNext().getString())) {
                return;
            }
            if (node == node2.getLastChild()) {
                for (Node node3 : node2.getAncestors()) {
                    int n2 = node3.getType();
                    if (n2 == 85) continue;
                    if (n2 != 130 && n2 != 125) {
                        return;
                    }
                    break;
                }
            }
        } else if (n != 130 && n != 125 && (n != 115 || node2.getChildCount() != 4 || node != node2.getFirstChild() && node != node2.getFirstChild().getNext().getNext())) {
            return;
        }
        if (NodeUtil.isSimpleOperatorType(node.getType()) || !NodeUtil.mayHaveSideEffects(node, nodeTraversal.getCompiler())) {
            if (node.isQualifiedName() && node.getJSDocInfo() != null) {
                return;
            }
            if (NodeUtil.isExpressionNode(node)) {
                return;
            }
            object = "This code lacks side-effects. Is there a bug?";
            if (node.getType() == 40) {
                object = "Is there a missing '+' on the previous line?";
            }
            nodeTraversal.getCompiler().report(nodeTraversal.makeError(node, this.level, USELESS_CODE_ERROR, new String[]{object}));
        }
    }
}

