/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.LatticeElement;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

abstract class DataFlowAnalysis<N, L extends LatticeElement> {
    private final ControlFlowGraph<N> cfg;
    final JoinOp<L> joinOp;
    protected final Set<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> orderedWorkSet;
    public static final int MAX_STEPS = 200000;

    DataFlowAnalysis(ControlFlowGraph<N> controlFlowGraph, JoinOp<L> joinOp) {
        this.cfg = controlFlowGraph;
        this.joinOp = joinOp;
        Comparator<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> comparator = this.cfg.getOptionalNodeComparator(this.isForward());
        this.orderedWorkSet = comparator != null ? Sets.newTreeSet(comparator) : Sets.newLinkedHashSet();
    }

    final ControlFlowGraph<N> getCfg() {
        return this.cfg;
    }

    L getExitLatticeElement() {
        DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode = this.getCfg().getImplicitReturn();
        FlowState flowState = (FlowState)diGraphNode.getAnnotation();
        return flowState.getIn();
    }

    protected L join(L l, L l2) {
        return (L)((LatticeElement)this.joinOp.apply(Lists.newArrayList((Object[])new LatticeElement[]{l, l2})));
    }

    abstract boolean isForward();

    abstract L flowThrough(N var1, L var2);

    final void analyze() {
        this.analyze(200000);
    }

    final void analyze(int n) {
        this.initialize();
        int n2 = 0;
        while (!this.orderedWorkSet.isEmpty()) {
            if (n2 > n) {
                throw new MaxIterationsExceededException("Analysis did not terminate after " + n + " iterations");
            }
            DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode = this.orderedWorkSet.iterator().next();
            this.orderedWorkSet.remove(diGraphNode);
            this.joinInputs(diGraphNode);
            if (this.flow(diGraphNode)) {
                List<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> list = this.isForward() ? this.cfg.getDirectedSuccNodes(diGraphNode) : this.cfg.getDirectedPredNodes(diGraphNode);
                for (DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode2 : list) {
                    if (diGraphNode2 == this.cfg.getImplicitReturn()) continue;
                    this.orderedWorkSet.add(diGraphNode2);
                }
            }
            ++n2;
        }
        if (this.isForward()) {
            this.joinInputs(this.getCfg().getImplicitReturn());
        }
    }

    abstract L createInitialEstimateLattice();

    abstract L createEntryLattice();

    protected void initialize() {
        this.orderedWorkSet.clear();
        for (DiGraph.DiGraphNode diGraphNode : this.cfg.getDirectedGraphNodes()) {
            diGraphNode.setAnnotation(new FlowState((LatticeElement)this.createInitialEstimateLattice(), (LatticeElement)this.createInitialEstimateLattice(), null));
            if (diGraphNode == this.cfg.getImplicitReturn()) continue;
            this.orderedWorkSet.add(diGraphNode);
        }
    }

    protected boolean flow(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode) {
        FlowState flowState = (FlowState)diGraphNode.getAnnotation();
        if (this.isForward()) {
            LatticeElement latticeElement = flowState.out;
            flowState.out = this.flowThrough(diGraphNode.getValue(), flowState.in);
            return !latticeElement.equals(flowState.out);
        }
        LatticeElement latticeElement = flowState.in;
        flowState.in = this.flowThrough(diGraphNode.getValue(), flowState.out);
        return !latticeElement.equals(flowState.in);
    }

    protected void joinInputs(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode) {
        FlowState flowState = (FlowState)diGraphNode.getAnnotation();
        if (this.isForward()) {
            if (this.cfg.getEntry() == diGraphNode) {
                flowState.setIn(this.createEntryLattice());
            } else {
                List<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> list = this.cfg.getDirectedPredNodes(diGraphNode);
                if (list.size() == 1) {
                    FlowState flowState2 = (FlowState)list.get(0).getAnnotation();
                    flowState.setIn(flowState2.getOut());
                } else if (list.size() > 1) {
                    ArrayList arrayList = new ArrayList(list.size());
                    for (DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode2 : list) {
                        FlowState flowState3 = (FlowState)diGraphNode2.getAnnotation();
                        arrayList.add(flowState3.getOut());
                    }
                    flowState.setIn((LatticeElement)this.joinOp.apply(arrayList));
                }
            }
        } else {
            List<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> list = this.cfg.getDirectedSuccNodes(diGraphNode);
            if (list.size() == 1) {
                DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode3 = list.get(0);
                if (diGraphNode3 == this.cfg.getImplicitReturn()) {
                    flowState.setOut(this.createEntryLattice());
                } else {
                    FlowState flowState4 = (FlowState)diGraphNode3.getAnnotation();
                    flowState.setOut(flowState4.getIn());
                }
            } else if (list.size() > 1) {
                ArrayList arrayList = new ArrayList(list.size());
                for (DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode4 : list) {
                    FlowState flowState5 = (FlowState)diGraphNode4.getAnnotation();
                    arrayList.add(flowState5.getIn());
                }
                flowState.setOut((LatticeElement)this.joinOp.apply(arrayList));
            }
        }
    }

    static void computeEscaped(final Scope scope, final Set<Scope.Var> set, AbstractCompiler abstractCompiler) {
        NodeTraversal.AbstractPostOrderCallback abstractPostOrderCallback = new NodeTraversal.AbstractPostOrderCallback(){

            @Override
            public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                if (scope == nodeTraversal.getScope() || !NodeUtil.isName(node) || NodeUtil.isFunction(node2)) {
                    return;
                }
                String string = node.getString();
                Scope.Var var = nodeTraversal.getScope().getVar(string);
                if (var != null && var.scope == scope) {
                    set.add(scope.getVar(string));
                }
            }
        };
        NodeTraversal nodeTraversal = new NodeTraversal(abstractCompiler, abstractPostOrderCallback);
        nodeTraversal.traverseAtScope(scope);
        Iterator<Scope.Var> iterator = scope.getVars();
        while (iterator.hasNext()) {
            Scope.Var var = iterator.next();
            if (var.getParentNode().getType() != 120 && !abstractCompiler.getCodingConvention().isExported(var.getName())) continue;
            set.add(var);
        }
    }

    static class BranchedFlowState<L extends LatticeElement>
    implements Annotation {
        private L in;
        private List<L> out;

        private BranchedFlowState(L l, List<L> list) {
            Preconditions.checkNotNull(l);
            Preconditions.checkNotNull(list);
            this.in = l;
            this.out = list;
        }

        L getIn() {
            return this.in;
        }

        void setIn(L l) {
            Preconditions.checkNotNull(l);
            this.in = l;
        }

        List<L> getOut() {
            return this.out;
        }

        void setOut(List<L> list) {
            Preconditions.checkNotNull(list);
            for (LatticeElement latticeElement : list) {
                Preconditions.checkNotNull((Object)latticeElement);
            }
            this.out = list;
        }

        public String toString() {
            return String.format("IN: %s OUT: %s", this.in, this.out);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.in, this.out});
        }

        /* synthetic */ BranchedFlowState(LatticeElement latticeElement, List list, 1 var3_3) {
            this(latticeElement, list);
        }
    }

    static abstract class BranchedForwardDataFlowAnalysis<N, L extends LatticeElement>
    extends DataFlowAnalysis<N, L> {
        @Override
        protected void initialize() {
            this.orderedWorkSet.clear();
            for (DiGraph.DiGraphNode diGraphNode : this.getCfg().getDirectedGraphNodes()) {
                int n = this.getCfg().getOutEdges(diGraphNode.getValue()).size();
                ArrayList arrayList = Lists.newArrayList();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.createInitialEstimateLattice());
                }
                diGraphNode.setAnnotation(new BranchedFlowState((LatticeElement)this.createInitialEstimateLattice(), arrayList, null));
                if (diGraphNode == this.getCfg().getImplicitReturn()) continue;
                this.orderedWorkSet.add(diGraphNode);
            }
        }

        BranchedForwardDataFlowAnalysis(ControlFlowGraph<N> controlFlowGraph, JoinOp<L> joinOp) {
            super(controlFlowGraph, joinOp);
        }

        @Override
        L getExitLatticeElement() {
            DiGraph.DiGraphNode diGraphNode = this.getCfg().getImplicitReturn();
            BranchedFlowState branchedFlowState = (BranchedFlowState)diGraphNode.getAnnotation();
            return branchedFlowState.getIn();
        }

        @Override
        final boolean isForward() {
            return true;
        }

        abstract List<L> branchedFlowThrough(N var1, L var2);

        @Override
        protected final boolean flow(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode) {
            BranchedFlowState branchedFlowState = (BranchedFlowState)diGraphNode.getAnnotation();
            List list = branchedFlowState.out;
            branchedFlowState.out = this.branchedFlowThrough(diGraphNode.getValue(), branchedFlowState.in);
            Preconditions.checkState((list.size() == branchedFlowState.out.size() ? 1 : 0) != 0);
            for (int i = 0; i < list.size(); ++i) {
                if (((LatticeElement)list.get(i)).equals(branchedFlowState.out.get(i))) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void joinInputs(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode) {
            BranchedFlowState branchedFlowState = (BranchedFlowState)diGraphNode.getAnnotation();
            List<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> list = this.getCfg().getDirectedPredNodes(diGraphNode);
            ArrayList<LatticeElement> arrayList = new ArrayList<LatticeElement>(list.size());
            for (DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> diGraphNode2 : list) {
                BranchedFlowState branchedFlowState2 = (BranchedFlowState)diGraphNode2.getAnnotation();
                LatticeElement latticeElement = (LatticeElement)branchedFlowState2.out.get(this.getCfg().getDirectedSuccNodes(diGraphNode2).indexOf(diGraphNode));
                arrayList.add(latticeElement);
            }
            if (this.getCfg().getEntry() == diGraphNode) {
                branchedFlowState.setIn(this.createEntryLattice());
            } else if (!arrayList.isEmpty()) {
                branchedFlowState.setIn((LatticeElement)this.joinOp.apply(arrayList));
            }
        }
    }

    static class MaxIterationsExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        MaxIterationsExceededException(String string) {
            super(string);
        }
    }

    static class FlowState<L extends LatticeElement>
    implements Annotation {
        private L in;
        private L out;

        private FlowState(L l, L l2) {
            Preconditions.checkNotNull(l);
            Preconditions.checkNotNull(l2);
            this.in = l;
            this.out = l2;
        }

        L getIn() {
            return this.in;
        }

        void setIn(L l) {
            Preconditions.checkNotNull(l);
            this.in = l;
        }

        L getOut() {
            return this.out;
        }

        void setOut(L l) {
            Preconditions.checkNotNull(l);
            this.out = l;
        }

        public String toString() {
            return String.format("IN: %s OUT: %s", this.in, this.out);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.in, this.out});
        }

        /* synthetic */ FlowState(LatticeElement latticeElement, LatticeElement latticeElement2, 1 var3_3) {
            this(latticeElement, latticeElement2);
        }
    }
}

